/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.paos;

import com.sun.identity.liberty.ws.paos.PAOSException;
import com.sun.identity.liberty.ws.paos.PAOSUtils;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PAOSRequest {
    private String responseConsumerURL;
    private String service;
    private String messageID;
    private Boolean mustUnderstand;
    private String actor;

    public PAOSRequest(String responseConsumerURL, String service, String messageID, Boolean mustUnderstand, String actor) throws PAOSException {
        this.responseConsumerURL = responseConsumerURL;
        this.service = service;
        this.messageID = messageID;
        this.mustUnderstand = mustUnderstand;
        this.actor = actor;
        this.validateData();
    }

    public PAOSRequest(Element element) throws PAOSException {
        this.parseElement(element);
    }

    public PAOSRequest(String xmlString) throws PAOSException {
        Document xmlDocument = XMLUtils.toDOMDocument((String)xmlString, (Debug)PAOSUtils.debug);
        if (xmlDocument == null) {
            throw new PAOSException(PAOSUtils.bundle.getString("errorPAOSRequestElement"));
        }
        this.parseElement(xmlDocument.getDocumentElement());
    }

    public String getResponseConsumerURL() {
        return this.responseConsumerURL;
    }

    public void setResponseConsumerURL(String responseConsumerURL) {
        this.responseConsumerURL = responseConsumerURL;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public Boolean isMustUnderstand() {
        return this.mustUnderstand;
    }

    public void setMustUnderstand(Boolean mustUnderstand) {
        this.mustUnderstand = mustUnderstand;
    }

    public String getActor() {
        return this.actor;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public String toXMLString() throws PAOSException {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws PAOSException {
        this.validateData();
        StringBuffer xml = new StringBuffer(300);
        xml.append("<");
        if (includeNSPrefix) {
            xml.append("paos").append(":");
        }
        xml.append("Request");
        if (declareNS) {
            xml.append(" xmlns:").append("paos").append("=\"").append("urn:liberty:paos:2003-08").append("\" xmlns:").append("soap-env").append("=\"").append("http://schemas.xmlsoap.org/soap/envelope/").append("\"");
        }
        xml.append(" ").append("responseConsumerURL").append("=\"").append(this.responseConsumerURL).append("\"").append(" ").append("service").append("=\"").append(this.service).append("\"");
        if (this.messageID != null) {
            xml.append(" ").append("messageID").append("=\"").append(this.messageID).append("\"");
        }
        xml.append(" ").append("soap-env").append(":").append("mustUnderstand").append("=\"").append(this.mustUnderstand.toString()).append("\"").append(" ").append("soap-env").append(":").append("actor").append("=\"").append(this.actor).append("\"></");
        if (includeNSPrefix) {
            xml.append("paos").append(":");
        }
        xml.append("Request").append(">");
        return xml.toString();
    }

    private void parseElement(Element element) throws PAOSException {
        if (element == null) {
            if (PAOSUtils.debug.messageEnabled()) {
                PAOSUtils.debug.message("PAOSRequest.parseElement: Input is null.");
            }
            throw new PAOSException(PAOSUtils.bundle.getString("nullInput"));
        }
        String localName = element.getLocalName();
        if (!"Request".equals(localName)) {
            if (PAOSUtils.debug.messageEnabled()) {
                PAOSUtils.debug.message("PAOSRequest.parseElement: element local name should be Request");
            }
            throw new PAOSException(PAOSUtils.bundle.getString("invalidPAOSRequest"));
        }
        String namespaceURI = element.getNamespaceURI();
        if (!"urn:liberty:paos:2003-08".equals(namespaceURI)) {
            if (PAOSUtils.debug.messageEnabled()) {
                PAOSUtils.debug.message("PAOSRequest.parseElement: element namespace should be urn:liberty:paos:2003-08");
            }
            throw new PAOSException(PAOSUtils.bundle.getString("invalidPAOSNamesapce"));
        }
        this.responseConsumerURL = XMLUtils.getNodeAttributeValue((Node)element, (String)"responseConsumerURL");
        this.service = XMLUtils.getNodeAttributeValue((Node)element, (String)"service");
        this.messageID = XMLUtils.getNodeAttributeValue((Node)element, (String)"messageID");
        String str = XMLUtils.getNodeAttributeValueNS((Node)element, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"mustUnderstand");
        try {
            this.mustUnderstand = Utils.StringToBoolean(str);
        }
        catch (Exception ex) {
            throw new PAOSException(PAOSUtils.bundle.getString("invalidValueMustUnderstand"));
        }
        this.actor = XMLUtils.getNodeAttributeValueNS((Node)element, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"actor");
        this.validateData();
    }

    private void validateData() throws PAOSException {
        if (this.responseConsumerURL == null) {
            if (PAOSUtils.debug.messageEnabled()) {
                PAOSUtils.debug.message("PAOSRequest.validateData: responseConsumerURL is missing in the paos:Request");
            }
            throw new PAOSException(PAOSUtils.bundle.getString("missingResponseConsumerURLPAOSRequest"));
        }
        if (this.service == null) {
            if (PAOSUtils.debug.messageEnabled()) {
                PAOSUtils.debug.message("PAOSRequest.validateData: service is missing in the paos:Request");
            }
            throw new PAOSException(PAOSUtils.bundle.getString("missingServicePAOSRequest"));
        }
        if (this.mustUnderstand == null) {
            if (PAOSUtils.debug.messageEnabled()) {
                PAOSUtils.debug.message("PAOSRequest.validateData: mustUnderstand is missing in the paos:Request");
            }
            throw new PAOSException(PAOSUtils.bundle.getString("missingMustUnderstandPAOSRequest"));
        }
        if (this.actor == null) {
            if (PAOSUtils.debug.messageEnabled()) {
                PAOSUtils.debug.message("PAOSRequest.validateData: actor is missing in the paos:Request");
            }
            throw new PAOSException(PAOSUtils.bundle.getString("missingActorPAOSRequest"));
        }
    }
}

