/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.paos;

import com.sun.identity.liberty.ws.paos.PAOSException;
import com.sun.identity.liberty.ws.paos.PAOSUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class PAOSHeader {
    private String paosHeaderStr = null;
    private ArrayList versionList = new ArrayList();
    private ArrayList extensionList = new ArrayList();
    private static final String PAOS_HEADER = "PAOS";
    private HashMap servicesAndOptions = new HashMap();

    public PAOSHeader(HttpServletRequest req) throws PAOSException {
        this.paosHeaderStr = req.getHeader(PAOS_HEADER);
        if (PAOSUtils.debug.messageEnabled()) {
            PAOSUtils.debug.message("PAOSHeader.PAOSHeader: PAOS Header = " + this.paosHeaderStr);
        }
        if (this.paosHeaderStr == null) {
            PAOSUtils.debug.error("PAOSHeader:PAOSHeader: No POAS header.");
            throw new PAOSException("There is no PAOS header.");
        }
        this.paosHeaderStr = this.paosHeaderStr.trim();
        this.parse();
    }

    public PAOSHeader(String paosHeaderString) throws PAOSException {
        if (this.paosHeaderStr == null) {
            PAOSUtils.debug.error("PAOSHeader:PAOSHeader: No POAS header.");
            throw new PAOSException("There is no PAOS header.");
        }
        this.paosHeaderStr = this.paosHeaderStr.trim();
        this.parse();
    }

    private void parse() throws PAOSException {
        if (this.paosHeaderStr.length() == 0) {
            PAOSUtils.debug.error("PAOSHeader:PAOSHeader: Null POAS header.");
            throw new PAOSException("PAOS header value is empty");
        }
        StringTokenizer st1 = new StringTokenizer(this.paosHeaderStr, ";");
        int n = st1.countTokens();
        String versExts = st1.nextToken().trim();
        int indexOfExt = versExts.indexOf("ext=");
        String vers = null;
        vers = indexOfExt < 0 ? versExts : versExts.substring(0, indexOfExt).trim();
        String versions = null;
        versions = vers.startsWith("ver=") ? vers.substring(4).trim() : vers;
        StringTokenizer st3 = new StringTokenizer(versions, ",");
        while (st3.hasMoreTokens()) {
            this.versionList.add(this.trimQuotes(st3.nextToken().trim()));
        }
        if (indexOfExt >= 0) {
            String extensions = versExts.substring(indexOfExt + 4).trim();
            StringTokenizer st4 = new StringTokenizer(extensions, ",");
            while (st4.hasMoreTokens()) {
                this.extensionList.add(this.trimQuotes(st4.nextToken().trim()));
            }
        }
        String servAndOpt = null;
        StringTokenizer st5 = null;
        String serv = null;
        HashSet<String> optSet = null;
        while (st1.hasMoreTokens()) {
            servAndOpt = st1.nextToken();
            st5 = new StringTokenizer(servAndOpt, ",");
            if (st5.hasMoreTokens()) {
                serv = this.trimQuotes(st5.nextToken().trim());
            }
            if (st5.hasMoreTokens()) {
                optSet = new HashSet<String>();
                while (st5.hasMoreTokens()) {
                    optSet.add(this.trimQuotes(st5.nextToken().trim()));
                }
            }
            this.servicesAndOptions.put(serv, optSet);
            optSet = null;
        }
    }

    private String trimQuotes(String inStr) {
        if (inStr.startsWith("\"") && inStr.endsWith("\"") || inStr.startsWith("'") && inStr.endsWith("'")) {
            return inStr.substring(1, inStr.length() - 1);
        }
        return inStr;
    }

    public Iterator getVersions() {
        return this.versionList.iterator();
    }

    public Iterator getExtensions() {
        return this.extensionList.iterator();
    }

    public HashMap getServicesAndOptions() {
        return this.servicesAndOptions;
    }
}

