/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp.plugin;

import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.interfaces.ResourceIDMapper;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.encode.URLEncDec;

public class IDPPResourceIDMapper
implements ResourceIDMapper {
    public String getResourceID(String providerID, String userID) {
        if (userID == null) {
            IDPPUtils.debug.error("IDPPResourceIDMapper.getResourceID:null userID");
            return null;
        }
        if (providerID == null || providerID.length() == 0) {
            IDPPUtils.debug.error("IDPPResourceIDMapper.getResourceID:null providerID.");
            return null;
        }
        byte[] byteResult = SAMLUtils.stringToByteArray(userID);
        String result = null;
        try {
            result = Base64.encode((byte[])byteResult).trim();
        }
        catch (Exception e) {
            IDPPUtils.debug.error("IDPPResourceIDMapper.getResourceID:", (Throwable)e);
            return null;
        }
        String urlEncoded = null;
        urlEncoded = providerID.endsWith("/") ? providerID + URLEncDec.encode((String)result) : providerID + "/" + URLEncDec.encode((String)result);
        return urlEncoded;
    }

    public String getUserID(String providerID, String resourceID) {
        return this.getUserID(providerID, resourceID, null);
    }

    public String getUserID(String providerID, String resourceID, Message message) {
        String result = null;
        if (resourceID == null || providerID == null || providerID.length() == 0) {
            IDPPUtils.debug.error("IDPPResourceIDMapper.getUserID:resourceID or providerID is null");
            return null;
        }
        if (!resourceID.startsWith(providerID)) {
            IDPPUtils.debug.error("IDPPResourceIDMapper.getUserID:resourceID does not startsWith providerID:" + providerID);
            return null;
        }
        String urlDecoded = null;
        urlDecoded = providerID.endsWith("/") ? URLEncDec.decode((String)resourceID.substring(providerID.length())) : URLEncDec.decode((String)resourceID.substring((providerID + "/").length()));
        try {
            result = SAMLUtils.byteArrayToString(Base64.decode((String)urlDecoded));
        }
        catch (Exception e) {
            IDPPUtils.debug.error("IDPPResourceIDMapper.getUserID:", (Throwable)e);
            return null;
        }
        return result;
    }
}

