/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp.container;

import com.sun.identity.liberty.ws.common.jaxb.xmlsig.ObjectFactory;
import com.sun.identity.liberty.ws.common.jaxb.xmlsig.X509DataElement;
import com.sun.identity.liberty.ws.common.jaxb.xmlsig.X509DataType;
import com.sun.identity.liberty.ws.idpp.common.IDPPException;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.container.IDPPBaseContainer;
import com.sun.identity.liberty.ws.idpp.jaxb.PPElement;
import com.sun.identity.liberty.ws.idpp.jaxb.SignKeyElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;

public class IDPPSignKey
extends IDPPBaseContainer {
    public IDPPSignKey() {
        IDPPUtils.debug.message("IDPPSignKey:constructor:init.");
    }

    public Object getContainerObject(Map userMap) throws IDPPException {
        IDPPUtils.debug.message("IDPPSignKey:getContainerObject:Init");
        try {
            PPElement ppType = IDPPUtils.getIDPPFactory().createPPElement();
            SignKeyElement signKey = IDPPUtils.getIDPPFactory().createSignKeyElement();
            byte[][] certBytes = (byte[][])userMap.get(this.getAttributeMapper().getDSAttribute("SignKey").toLowerCase());
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPSignKey.getContainerObject: SignKey Value" + certBytes);
            }
            ObjectFactory of = new ObjectFactory();
            X509DataElement x509DataType = of.createX509DataElement();
            X509DataType.X509Certificate cert = of.createX509DataTypeX509Certificate(certBytes[0]);
            x509DataType.getX509IssuerSerialOrX509SKIOrX509SubjectName().add(cert);
            signKey.getContent().add(x509DataType);
            ppType.setSignKey(signKey);
            return ppType;
        }
        catch (JAXBException je) {
            IDPPUtils.debug.error("IDPPContainers:getInformalName: JAXB failure", (Throwable)je);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    public Set getContainerAttributes() {
        IDPPUtils.debug.message("IDPPSignKey:getContainerAttributes:Init");
        HashSet<String> set = new HashSet<String>();
        set.add("SignKey");
        return this.getMapperAttributeSet(set);
    }

    public Set getContainerAttributesForSelect(String select) {
        return this.getContainerAttributes();
    }

    public Map getDataMapForSelect(String select, List data) throws IDPPException {
        IDPPUtils.debug.message("IDPPSignKey:getDataMapForSelect:Init");
        Object dataElement = null;
        if (data != null && !data.isEmpty()) {
            dataElement = data.get(0);
        }
        HashMap<String, byte[][]> map = new HashMap<String, byte[][]>();
        if (dataElement == null) {
            map.put(this.getAttributeMapper().getDSAttribute("SignKey"), null);
            return map;
        }
        if (dataElement instanceof SignKeyElement) {
            byte[] certBytes = null;
            SignKeyElement signKey = dataElement;
            List contents = signKey.getContent();
            if (contents == null || contents.size() == 0) {
                return this.getAttributeMap("SignKey", null, map);
            }
            Iterator iter = contents.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj instanceof X509DataElement) {
                    X509DataElement x509Data = (X509DataElement)obj;
                    List certs = x509Data.getX509IssuerSerialOrX509SKIOrX509SubjectName();
                    if (certs == null || certs.size() == 0) {
                        IDPPUtils.debug.error("IDPPSignKey.getDataMapForSelect:Unsupported data. certs are null");
                        return null;
                    }
                    Object certObj = certs.get(0);
                    if (certObj instanceof X509DataType.X509Certificate) {
                        X509DataType.X509Certificate cert = (X509DataType.X509Certificate)certObj;
                        certBytes = cert.getValue();
                        break;
                    }
                    IDPPUtils.debug.error("IDPPSignKey.getDataMapForSelect:Unsupported data. not x509 certificate");
                    return null;
                }
                IDPPUtils.debug.error("IDPPSignKey.getDataMapForSelect:not x509data element");
            }
            byte[][] attributeByte = new byte[1][certBytes.length];
            for (int i = 0; i < certBytes.length; ++i) {
                attributeByte[0][i] = certBytes[i];
            }
            map.put(this.getAttributeMapper().getDSAttribute("SignKey"), attributeByte);
            return map;
        }
        throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
    }

    public boolean hasBinaryAttributes() {
        return true;
    }
}

