/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp.container;

import com.sun.identity.liberty.ws.idpp.common.IDPPException;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.container.IDPPBaseContainer;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTString;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTURI;
import com.sun.identity.liberty.ws.idpp.jaxb.MsgContactElement;
import com.sun.identity.liberty.ws.idpp.jaxb.PPElement;
import com.sun.identity.shared.datastruct.CollectionHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;

public class IDPPMsgContact
extends IDPPBaseContainer {
    public IDPPMsgContact() {
        IDPPUtils.debug.message("IDPPMsgContact:constructor:init.");
    }

    public Object getContainerObject(Map userMap) throws IDPPException {
        IDPPUtils.debug.message("IDPPMsgContact:getContainerObject:Init");
        try {
            PPElement ppType = IDPPUtils.getIDPPFactory().createPPElement();
            Set msgContacts = (Set)userMap.get(this.getAttributeMapper().getDSAttribute("MsgContact").toLowerCase());
            if (msgContacts == null || msgContacts.isEmpty()) {
                throw new IDPPException(IDPPUtils.bundle.getString("nullValues"));
            }
            Iterator iter = msgContacts.iterator();
            while (iter.hasNext()) {
                String msgContact = (String)iter.next();
                MsgContactElement mce = this.parseEntry(msgContact, userMap);
                if (mce == null) continue;
                ppType.getMsgContact().add(mce);
            }
            return ppType;
        }
        catch (JAXBException je) {
            IDPPUtils.debug.error("IDPPMsgContact:getContainerObject: JAXB failure", (Throwable)je);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    private MsgContactElement parseEntry(String entry, Map userMap) throws JAXBException {
        if (entry == null || entry.length() == 0) {
            return null;
        }
        if (entry.indexOf("|") == -1) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPMsgContact.parsEntry: Invalid Entry " + entry);
            }
            return null;
        }
        MsgContactElement mse = IDPPUtils.getIDPPFactory().createMsgContactElement();
        StringTokenizer st = new StringTokenizer(entry, "|");
        while (st.hasMoreTokens()) {
            StringTokenizer tokenizer;
            String token = st.nextToken();
            if (token.indexOf("=") == -1 || (tokenizer = new StringTokenizer(token, "=")).countTokens() != 2) continue;
            String attribute = tokenizer.nextToken();
            String value = null;
            String mappedAttribute = this.getAttributeMapper().getDSAttribute(attribute);
            value = mappedAttribute == null || mappedAttribute.equals(attribute) ? tokenizer.nextToken() : CollectionHelper.getMapAttr((Map)userMap, (String)mappedAttribute.toLowerCase());
            if (value == null) continue;
            if (attribute.equals("MsgType")) {
                mse.getMsgType().add(this.getDSTURI(value));
                continue;
            }
            if (attribute.equals("Nick")) {
                mse.setNick(this.getDSTString(value));
                continue;
            }
            if (attribute.equals("LComment")) {
                mse.setLComment(this.getDSTString(value));
                continue;
            }
            if (attribute.equals("MsgMethod")) {
                mse.getMsgMethod().add(this.getDSTURI(value));
                continue;
            }
            if (attribute.equals("MsgTechnology")) {
                mse.getMsgTechnology().add(this.getDSTURI(value));
                continue;
            }
            if (attribute.equals("MsgAccount")) {
                mse.setMsgAccount(this.getDSTString(value));
                continue;
            }
            if (attribute.equals("MsgSubAccount")) {
                mse.setMsgSubaccount(this.getDSTString(value));
                continue;
            }
            if (attribute.equals("MsgProvider")) {
                mse.setMsgProvider(this.getDSTString(value));
                continue;
            }
            if (!attribute.equals("id")) continue;
            mse.setId(value);
        }
        return mse;
    }

    public Set getContainerAttributes() {
        IDPPUtils.debug.message("IDPPMsgContact:getContainerAttributes:Init");
        HashSet<String> set = new HashSet<String>();
        set.add("MsgContact");
        return this.getMapperAttributeSet(set);
    }

    public Set getContainerAttributesForSelect(String select) {
        return this.getContainerAttributes();
    }

    public Map getDataMapForSelect(String select, List data) throws IDPPException {
        Iterator iter;
        IDPPUtils.debug.message("IDPPMsgContact:getDataMapForSelect:Init");
        String filter = this.getMsgFilter(select);
        if (filter == null) {
            throw new IDPPException(IDPPUtils.bundle.getString("invalidSelect"));
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPMsgContact.getDataMapForSelect: MsgContact filter: " + filter);
        }
        if (data == null || data.isEmpty()) {
            return this.getDataMap(null, filter);
        }
        if (data != null && !data.isEmpty() && (iter = data.iterator()).hasNext()) {
            Object dataElement = iter.next();
            if (dataElement instanceof MsgContactElement) {
                MsgContactElement mse = (MsgContactElement)dataElement;
                return this.getDataMap(mse, filter);
            }
            throw new IDPPException(IDPPUtils.bundle.getString("invalidElement"));
        }
        return null;
    }

    private Map getDataMap(MsgContactElement mse, String filter) {
        HashMap map = new HashMap();
        Set existingSet = this.getMsgContacts();
        HashSet<String> newSet = new HashSet<String>();
        if (existingSet.isEmpty()) {
            newSet.add(this.modifyEntry(null, mse));
        } else {
            Iterator iter = existingSet.iterator();
            while (iter.hasNext()) {
                String entry = (String)iter.next();
                if (entry.indexOf(filter) != -1) {
                    if (mse == null) continue;
                    entry = this.modifyEntry(entry, mse);
                    newSet.add(entry);
                    continue;
                }
                newSet.add(entry);
            }
        }
        map.put(this.getAttributeMapper().getDSAttribute("MsgContact"), newSet);
        return map;
    }

    private Set getMsgContacts() {
        try {
            HashSet<String> set = new HashSet<String>();
            String attrib = this.getAttributeMapper().getDSAttribute("MsgContact");
            set.add(attrib);
            return (Set)IDPPUtils.getUserAttributes(this.userDN, set).get(attrib);
        }
        catch (IDPPException ie) {
            IDPPUtils.debug.error("IDPPMsgContact.getMsgContacts: Exceptionwhile trying to get existing msg contacts.", (Throwable)ie);
            return new HashSet();
        }
    }

    private String modifyEntry(String entry, MsgContactElement mse) {
        String id;
        DSTURI dstURI;
        StringBuffer sb = new StringBuffer(200);
        DSTString dstString = mse.getNick();
        if (dstString != null) {
            sb.append("Nick").append("=").append(dstString.getValue()).append("|");
        }
        if ((dstString = mse.getLComment()) != null) {
            sb.append("LComment").append("=").append(dstString.getValue()).append("|");
        }
        if ((dstString = mse.getMsgProvider()) != null) {
            sb.append("MsgProvider").append("=").append(dstString.getValue()).append("|");
        }
        if ((dstString = mse.getMsgAccount()) != null) {
            sb.append("MsgAccount").append("=").append(dstString.getValue()).append("|");
        }
        if ((dstString = mse.getMsgSubaccount()) != null) {
            sb.append("MsgSubAccount").append("=").append(dstString.getValue()).append("|");
        }
        if ((dstURI = (DSTURI)mse.getMsgType().get(0)) != null) {
            sb.append("MsgType").append("=").append(dstURI.getValue()).append("|");
        }
        if ((dstURI = (DSTURI)mse.getMsgMethod().get(0)) != null) {
            sb.append("MsgMethod").append("=").append(dstURI.getValue()).append("|");
        }
        if ((dstURI = (DSTURI)mse.getMsgTechnology().get(0)) != null) {
            sb.append("MsgTechnology").append("=").append(dstURI.getValue());
        }
        if ((id = mse.getId()) != null) {
            sb.append("id").append("=").append(id);
        }
        return sb.toString();
    }

    private String getMsgFilter(String select) {
        int index1;
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPMsgContact.getMsgFilter: original Expression = " + select);
        }
        if ((index1 = select.indexOf("\"")) == -1) {
            return null;
        }
        int index2 = (select = select.substring(index1 + 1, select.length())).indexOf("\"");
        if (index2 == -1) {
            return null;
        }
        return select.substring(0, index2);
    }

    public boolean hasBinaryAttributes() {
        return false;
    }
}

