/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp;

import com.sun.identity.liberty.ws.idpp.common.IDPPException;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.plugin.AttributeMapper;
import com.sun.identity.liberty.ws.idpp.plugin.IDPPContainer;
import com.sun.identity.liberty.ws.idpp.plugin.IDPPExtension;
import com.sun.identity.liberty.ws.interfaces.Authorizer;
import com.sun.identity.liberty.ws.interfaces.ResourceIDMapper;
import com.sun.identity.liberty.ws.interfaces.ServiceInstanceUpdate;
import com.sun.identity.plugin.configuration.ConfigurationActionEvent;
import com.sun.identity.plugin.configuration.ConfigurationInstance;
import com.sun.identity.plugin.configuration.ConfigurationListener;
import com.sun.identity.plugin.configuration.ConfigurationManager;
import com.sun.identity.shared.datastruct.CollectionHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class IDPPServiceManager
implements ConfigurationListener {
    private static IDPPServiceManager instance = null;
    private static Authorizer authorizer = null;
    private static final String authorizerKey = "sunIdentityServerPPAuthorizer";
    private static final String defaultAuthorizer = "com.sun.identity.liberty.ws.idpp.plugin.IDPPAuthorizer";
    private static ResourceIDMapper resourceIDMapper = null;
    private static final String resourceMapperKey = "sunIdentityServerPPResourceIDMapper";
    private static final String defaultResourceIDMapper = "com.sun.identity.liberty.ws.idpp.plugin.IDPPResourceIDMapper";
    private static AttributeMapper attributeMapper = null;
    private static final String attributeMapperKey = "sunIdentityServerPPAttributeMapper";
    private static String defaultAttributeMapper = "com.sun.identity.liberty.ws.idpp.plugin.IDPPAttributeMapper";
    private static String nameScheme = null;
    private static final String nameSchemeKey = "sunIdentityServerPPNameScheme";
    private static final String defaultNameScheme = "urn:liberty:idpp:nameScheme:firstlast";
    private static Set supportedContainers = new HashSet();
    private static Map containerExtensions = new HashMap();
    private static Map containerClasses = new HashMap();
    private static final String supportedContainersKey = "sunIdentityServerPPSupportedContainers";
    private static String idppPrefix = null;
    private static final String idppPrefixKey = "sunIdentityServerPPNameSpacePrefix";
    private static final String defaultPrefix = "pp";
    private static ConfigurationInstance ci = null;
    private static Map ppDSMap = null;
    private static final String ppDSMapAttributeKey = "sunIdentityServerPPDSAttributeMapList";
    private static final String queryPolicyEvalKey = "sunIdentityServerPPisQueryPolicyEvalRequired";
    private static final String modifyPolicyEvalKey = "sunIdentityServerPPisModifyPolicyEvalRequired";
    private static boolean isQueryPolicyEval = false;
    private static boolean isModifyPolicyEval = false;
    private static final String providerIDKey = "sunIdentityServerPPProviderID";
    private static String providerID = null;
    private static String extensionPrefix = null;
    private static final String extensionPrefixKey = "sunIdentityServerPPExtensionPrefix";
    private static String defaultExtensionPrefix = "ispp";
    private static Set extensionAttributes = null;
    private static final String extensionAttributesKey = "sunIdentityServerPPExtensionAttributes";
    private static ServiceInstanceUpdate serviceInstanceUpdate = null;
    private static String siuClass = "sunIdentityServerPPServiceInstanceUpdateClass";
    private static String defaultSiuClass = "com.sun.identity.liberty.ws.idpp.plugin.IDPPServiceInstanceUpdate";
    private static String altEndPoint = null;
    private static String altEndPointKey = "sunIdentityServerPPAlternateEndPoint";
    private static boolean isSIUEnabled = false;
    private static String isSIUKey = "sunIdentityServerPPServiceInstanceUpdateEnabled";
    private static Set altSecMechs = null;
    private static String altSecMechsKey = "sunIdentityServerPPAlternateSecurityMechs";

    private static void initializeService() throws IDPPException {
        IDPPUtils.debug.message("IDPPServiceManager:initializeService");
        try {
            Map config = ci.getConfiguration(null, null);
            if (config == null || config.isEmpty()) {
                throw new IDPPException("Configuration is null");
            }
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPServiceManager:initializeService: service config is " + config);
            }
            nameScheme = CollectionHelper.getMapAttr((Map)config, (String)nameSchemeKey, (String)defaultNameScheme);
            Set containers = (Set)config.get(supportedContainersKey);
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPServiceManager:initializeService: containers are " + containers);
            }
            IDPPServiceManager.parseContainers(containers);
            idppPrefix = CollectionHelper.getMapAttr((Map)config, (String)idppPrefixKey, (String)defaultPrefix);
            extensionPrefix = CollectionHelper.getMapAttr((Map)config, (String)extensionPrefixKey, (String)defaultExtensionPrefix);
            extensionAttributes = (Set)config.get(extensionAttributesKey);
            String temp = CollectionHelper.getMapAttr((Map)config, (String)queryPolicyEvalKey);
            if (temp != null) {
                isQueryPolicyEval = Boolean.valueOf(temp);
            }
            if ((temp = CollectionHelper.getMapAttr((Map)config, (String)modifyPolicyEvalKey)) != null) {
                isModifyPolicyEval = Boolean.valueOf(temp);
            }
            providerID = CollectionHelper.getMapAttr((Map)config, (String)providerIDKey);
            IDPPServiceManager.storePPDSMap(config);
            String param = CollectionHelper.getMapAttr((Map)config, (String)authorizerKey, (String)defaultAuthorizer);
            Class<?> authClass = Class.forName(param);
            authorizer = (Authorizer)authClass.newInstance();
            param = CollectionHelper.getMapAttr((Map)config, (String)resourceMapperKey, (String)defaultResourceIDMapper);
            Class<?> rMapper = Class.forName(param);
            resourceIDMapper = (ResourceIDMapper)rMapper.newInstance();
            param = CollectionHelper.getMapAttr((Map)config, (String)attributeMapperKey, (String)defaultAttributeMapper);
            Class<?> aMapper = Class.forName(param);
            attributeMapper = (AttributeMapper)aMapper.newInstance();
            param = CollectionHelper.getMapAttr((Map)config, (String)siuClass, (String)defaultSiuClass);
            Class<?> siUpdateClass = Class.forName(param);
            serviceInstanceUpdate = (ServiceInstanceUpdate)siUpdateClass.newInstance();
            altEndPoint = CollectionHelper.getMapAttr((Map)config, (String)altEndPointKey);
            altSecMechs = (Set)config.get(altSecMechsKey);
            temp = CollectionHelper.getMapAttr((Map)config, (String)isSIUKey);
            if (temp != null) {
                isSIUEnabled = Boolean.valueOf(temp);
            }
        }
        catch (Exception e) {
            IDPPUtils.debug.error("IDPPServiceManager:initializeService:Error while initializing services.", (Throwable)e);
            throw new IDPPException(e);
        }
    }

    private static void storePPDSMap(Map config) {
        IDPPUtils.debug.message("IDPPServiceManager:storePPDSMap:Init");
        ppDSMap = new HashMap();
        Set set = (Set)config.get(ppDSMapAttributeKey);
        if (set == null || set.isEmpty()) {
            IDPPUtils.debug.message("IDPPServiceManager:attribute map is empty");
            return;
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPServiceManager:storePPDSMap: set ofattributes in DS:" + set);
        }
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            String attr = (String)iter.next();
            if (attr.indexOf("=") == -1) {
                if (!IDPPUtils.debug.messageEnabled()) continue;
                IDPPUtils.debug.message("IDPPServiceManager:storePPDSMap:Entry does not have = sign. Ignoring:" + attr);
                continue;
            }
            StringTokenizer st = new StringTokenizer(attr, "=");
            if (st.countTokens() > 2) {
                if (!IDPPUtils.debug.messageEnabled()) continue;
                IDPPUtils.debug.message("IDPPServiceManager:storePPDSMap:Entry is invalid . Ignoring:" + attr);
                continue;
            }
            ppDSMap.put(st.nextToken(), st.nextToken());
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPServiceManager:storePPDSMap: mappedattributes:" + ppDSMap);
        }
    }

    private static void parseContainers(Set containers) {
        if (containers == null || containers.size() == 0) {
            IDPPUtils.debug.error("IDPPServiceManager.parseContainers:Container set is empty");
            return;
        }
        Iterator iter = containers.iterator();
        while (iter.hasNext()) {
            String entry = (String)iter.next();
            String containerToken = null;
            String extensionToken = null;
            String pluginToken = null;
            StringTokenizer tokenizer = null;
            String container = null;
            if (entry.indexOf("|") != -1) {
                tokenizer = new StringTokenizer(entry, "|");
                while (tokenizer.hasMoreTokens()) {
                    String temp = tokenizer.nextToken();
                    if (temp.startsWith("container")) {
                        containerToken = temp;
                        continue;
                    }
                    if (temp.startsWith("extension")) {
                        extensionToken = temp;
                        continue;
                    }
                    if (!temp.startsWith("plugin")) continue;
                    pluginToken = temp;
                }
            } else {
                containerToken = entry;
            }
            if (containerToken.indexOf("=") == -1 || !containerToken.startsWith("container")) {
                if (!IDPPUtils.debug.messageEnabled()) continue;
                IDPPUtils.debug.message("IDPPServiceManager.parseContainers: Invalid entry." + entry);
                continue;
            }
            tokenizer = new StringTokenizer(containerToken, "=");
            if (tokenizer.countTokens() != 2) {
                if (!IDPPUtils.debug.messageEnabled()) continue;
                IDPPUtils.debug.message("IDPPServiceManager.parseContainers: Invalid entry." + entry);
                continue;
            }
            tokenizer.nextToken();
            container = tokenizer.nextToken();
            if ((container == null || container.length() == 0) && IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPServiceManager.parseContainers: Invalid entry." + entry);
            }
            supportedContainers.add(container);
            if (extensionToken != null && extensionToken.length() != 0 && extensionToken.indexOf("=") != -1) {
                tokenizer = new StringTokenizer(extensionToken, "=");
                tokenizer.nextToken();
                try {
                    String ext = tokenizer.nextToken();
                    Class<?> extClass = Class.forName(ext);
                    IDPPExtension containerExtension = (IDPPExtension)extClass.newInstance();
                    containerExtensions.put(container, containerExtension);
                }
                catch (Exception ex) {
                    IDPPUtils.debug.error("IDPPServiceManager.parseContainers:Error instantiating extension class:", (Throwable)ex);
                }
            }
            if (pluginToken == null || pluginToken.length() == 0 || pluginToken.indexOf("=") == -1) continue;
            tokenizer = new StringTokenizer(pluginToken, "=");
            tokenizer.nextToken();
            try {
                String plugin = tokenizer.nextToken();
                Class<?> pluginClass = Class.forName(plugin);
                IDPPContainer containerClass = (IDPPContainer)pluginClass.newInstance();
                containerClasses.put(container, containerClass);
            }
            catch (Exception ex) {
                IDPPUtils.debug.error("IDPPServiceManager.parseContainers:Error instantiating extension class:", (Throwable)ex);
            }
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPServiceManager.parseContainers:supported containers:" + supportedContainers);
            IDPPUtils.debug.message("IDPPServiceManager.parseContainers:container extensions:" + containerExtensions);
            IDPPUtils.debug.message("IDPPServiceManager.parseContainers:container classes:" + containerClasses);
        }
    }

    private IDPPServiceManager() {
    }

    public static IDPPServiceManager getInstance() {
        if (instance == null) {
            instance = new IDPPServiceManager();
        }
        return instance;
    }

    public Authorizer getAuthorizer() {
        return authorizer;
    }

    public ResourceIDMapper getResourceIDMapper() {
        return resourceIDMapper;
    }

    public AttributeMapper getAttributeMapper() {
        return attributeMapper;
    }

    public String getNameScheme() {
        return nameScheme;
    }

    public Set getSupportedContainers() {
        return supportedContainers;
    }

    public Map getContainerExtensions() {
        return containerExtensions;
    }

    public Map getContainerClasses() {
        return containerClasses;
    }

    public String getIDPPPrefix() {
        return idppPrefix;
    }

    public Map getPPDSMap() {
        return ppDSMap;
    }

    public boolean isQueryPolicyEvalRequired() {
        return isQueryPolicyEval;
    }

    public boolean isModifyPolicyEvalRequired() {
        return isModifyPolicyEval;
    }

    public String getProviderID() {
        return providerID;
    }

    public IDPPExtension getContainerExtension(String container) {
        return (IDPPExtension)containerExtensions.get(container);
    }

    public String getPPExtensionPrefix() {
        return extensionPrefix;
    }

    public Set getExtensionAttributes() {
        return extensionAttributes;
    }

    public ServiceInstanceUpdate getServiceInstanceUpdate() {
        return serviceInstanceUpdate;
    }

    public boolean isServiceInstanceUpdateEnabled() {
        return isSIUEnabled;
    }

    public String getAlternateEndPoint() {
        return altEndPoint;
    }

    public Set getAlternateSecurityMechs() {
        return altSecMechs;
    }

    public void configChanged(ConfigurationActionEvent e) {
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPServiceManager:configChanged:");
        }
        try {
            IDPPServiceManager.initializeService();
        }
        catch (IDPPException ie) {
            IDPPUtils.debug.error("IDPPServiceManager:configChanged: Error in updating service configuration.", (Throwable)ie);
        }
    }

    static {
        try {
            ci = ConfigurationManager.getConfigurationInstance("IDPP");
            ci.addListener(new IDPPServiceManager());
            IDPPServiceManager.initializeService();
        }
        catch (Exception e) {
            IDPPUtils.debug.error("IDPPServiceManager:Static init failed", (Throwable)e);
        }
    }
}

