/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RequestedService {
    private List options = null;
    private String serviceType = null;

    public RequestedService(List options, String serviceType) {
        this.options = options;
        this.serviceType = serviceType;
    }

    public RequestedService(Element elem) throws DiscoveryException {
        String nameSpaceURI;
        if (elem == null) {
            DiscoUtils.debug.message("RequestedService(Element): null input.");
            throw new DiscoveryException(DiscoUtils.bundle.getString("nullInput"));
        }
        String nodeName = elem.getLocalName();
        if (nodeName == null || !nodeName.equals("RequestedServiceType") || (nameSpaceURI = elem.getNamespaceURI()) == null || !nameSpaceURI.equals("urn:liberty:disco:2003-08")) {
            DiscoUtils.debug.message("RequestedService(Element): wrong input");
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        NodeList contentnl = elem.getChildNodes();
        int length = contentnl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = contentnl.item(i);
            nodeName = child.getLocalName();
            if (nodeName == null) continue;
            nameSpaceURI = ((Element)child).getNamespaceURI();
            if (nameSpaceURI == null || !nameSpaceURI.equals("urn:liberty:disco:2003-08")) {
                if (DiscoUtils.debug.messageEnabled()) {
                    DiscoUtils.debug.message("RequestedService(Element): invalid namespace for node " + nodeName);
                }
                throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
            }
            if (nodeName.equals("ServiceType")) {
                if (this.serviceType != null) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("RequestedService(Element): Included more than one ServiceType element.");
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
                }
                this.serviceType = XMLUtils.getElementValue((Element)((Element)child));
                if (this.serviceType != null && this.serviceType.length() != 0) continue;
                if (DiscoUtils.debug.messageEnabled()) {
                    DiscoUtils.debug.message("RequestedService(Element): missing ServiceType element value.");
                }
                throw new DiscoveryException(DiscoUtils.bundle.getString("emptyElement"));
            }
            if (nodeName.equals("Options")) {
                if (this.options != null) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("RequestedService(Element): Included more than one Options element.");
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
                }
                this.options = DiscoUtils.parseOptions((Element)child);
                continue;
            }
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("RequestedService(Element): invalid node" + nodeName);
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        if (this.serviceType == null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("RequestedService(Element): missing ServiceType element.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("missingServiceType"));
        }
    }

    public List getOptions() {
        return this.options;
    }

    public void setOptions(List options) {
        this.options = options;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("<RequestedServiceType xmlns=\"").append("urn:liberty:disco:2003-08").append("\"><ServiceType>");
        if (this.serviceType != null) {
            sb.append(this.serviceType);
        }
        sb.append("</ServiceType>");
        if (this.options != null) {
            sb.append("<Options>");
            if (!this.options.isEmpty()) {
                Iterator iter = this.options.iterator();
                String option = null;
                while (iter.hasNext()) {
                    option = (String)iter.next();
                    if (option == null || option.length() == 0) continue;
                    sb.append("<Option>").append(option).append("</Option>");
                }
            }
            sb.append("</Options>");
        }
        sb.append("</RequestedServiceType>");
        return sb.toString();
    }
}

