/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken;
import com.sun.identity.liberty.ws.disco.Description;
import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.disco.Modify;
import com.sun.identity.liberty.ws.disco.ModifyResponse;
import com.sun.identity.liberty.ws.disco.Query;
import com.sun.identity.liberty.ws.disco.QueryResponse;
import com.sun.identity.liberty.ws.disco.RequestedService;
import com.sun.identity.liberty.ws.disco.ResourceID;
import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.disco.ServiceInstance;
import com.sun.identity.liberty.ws.disco.common.DiscoSDKUtils;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.security.SecurityTokenManagerClient;
import com.sun.identity.liberty.ws.soapbinding.Client;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.ProviderHeader;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;

public class DiscoveryClient {
    private String connectTo = null;
    private int clientMech = 0;
    private ResourceID resID = null;
    private EncryptedResourceID encResID = null;
    private String certAlias = null;
    private String providerID = null;
    private boolean clientAuth = false;
    private SecurityAssertion assertion = null;
    private List assertions = null;
    private BinarySecurityToken token = null;
    private ResourceOffering offering = null;
    private boolean processed = true;
    private String soapAction = null;
    private Object session = null;
    private String wsfVersion = Utils.getDefaultWSFVersion();

    public DiscoveryClient(String soapURI, String providerID) {
        this.connectTo = soapURI;
        this.providerID = providerID;
    }

    public DiscoveryClient(SecurityAssertion assertion, String soapURI, String providerID) {
        this.connectTo = soapURI;
        this.clientMech = assertion != null && assertion.isBearer() ? 3 : 2;
        this.assertion = assertion;
        this.providerID = providerID;
    }

    public DiscoveryClient(BinarySecurityToken token, String soapURI, String providerID) {
        this.connectTo = soapURI;
        this.clientMech = 1;
        this.token = token;
        this.providerID = providerID;
    }

    public DiscoveryClient(ResourceOffering resourceOffering, Object session, String providerID) {
        this.offering = resourceOffering;
        this.processed = false;
        this.session = session;
        this.providerID = providerID;
    }

    public DiscoveryClient(ResourceOffering resourceOffering, Object session, String providerID, List assertions) {
        this.offering = resourceOffering;
        this.processed = false;
        this.session = session;
        this.providerID = providerID;
        this.assertions = assertions;
    }

    private void processResourceOffering() throws DiscoveryException {
        ServiceInstance instance = this.offering.getServiceInstance();
        if (!instance.getServiceType().equals("urn:liberty:disco:2003-08")) {
            DiscoSDKUtils.debug.error("DiscoveryClient.processResourceOffering: ServiceType in ResourceOffering is not discovery service type.");
            throw new DiscoveryException(DiscoSDKUtils.bundle.getString("notDiscoServiceType"));
        }
        this.resID = this.offering.getResourceID();
        this.encResID = this.offering.getEncryptedResourceID();
        List descriptions = instance.getDescription();
        Iterator i = descriptions.iterator();
        while (i.hasNext()) {
            Description desc = (Description)i.next();
            this.connectTo = desc.getEndpoint();
            this.soapAction = desc.getSoapAction();
            Iterator j = desc.getSecurityMechID().iterator();
            while (j.hasNext()) {
                String mech = (String)j.next();
                if (mech.equals("urn:liberty:security:2003-08:null:null") || mech.equals("urn:liberty:security:2003-08:TLS:null") || mech.equals("urn:liberty:security:2003-08:ClientTLS:null")) {
                    this.clientMech = 0;
                    DiscoSDKUtils.debug.message("DiscoClient: null");
                    if (mech.equals("urn:liberty:security:2003-08:ClientTLS:null")) {
                        this.clientAuth = true;
                        DiscoSDKUtils.debug.message("DiscoClient: clientAuth on");
                    }
                    return;
                }
                if (mech.equals("urn:liberty:security:2003-08:null:X509") || mech.equals("urn:liberty:security:2003-08:TLS:X509") || mech.equals("urn:liberty:security:2003-08:ClientTLS:X509") || mech.equals("urn:liberty:security:2005-02:null:X509") || mech.equals("urn:liberty:security:2005-02:TLS:X509") || mech.equals("urn:liberty:security:2005-02:ClientTLS:X509")) {
                    this.clientMech = 1;
                    if (mech.equals("urn:liberty:security:2003-08:null:X509") || mech.equals("urn:liberty:security:2003-08:TLS:X509") || mech.equals("urn:liberty:security:2003-08:ClientTLS:X509")) {
                        this.wsfVersion = "1.0";
                    }
                    DiscoSDKUtils.debug.message("DiscoClient: x509");
                    try {
                        SecurityTokenManagerClient stm = new SecurityTokenManagerClient(this.session);
                        stm.setCertAlias(this.certAlias);
                        this.token = stm.getX509CertificateToken();
                        this.token.setWSFVersion(this.wsfVersion);
                    }
                    catch (Exception e) {
                        DiscoSDKUtils.debug.error("DiscoveryClient.processResourceOffering: couldn't generate X509 token: ", (Throwable)e);
                        throw new DiscoveryException(e.getMessage());
                    }
                    if (mech.equals("urn:liberty:security:2003-08:ClientTLS:X509") || mech.equals("urn:liberty:security:2005-02:ClientTLS:X509")) {
                        this.clientAuth = true;
                        DiscoSDKUtils.debug.message("DiscoClient: clientAuth on");
                    }
                    return;
                }
                if (mech.equals("urn:liberty:security:2003-08:null:SAML") || mech.equals("urn:liberty:security:2003-08:TLS:SAML") || mech.equals("urn:liberty:security:2003-08:ClientTLS:SAML") || mech.equals("urn:liberty:security:2005-02:null:SAML") || mech.equals("urn:liberty:security:2005-02:TLS:SAML") || mech.equals("urn:liberty:security:2005-02:ClientTLS:SAML")) {
                    this.clientMech = 2;
                    if (mech.equals("urn:liberty:security:2003-08:null:SAML") || mech.equals("urn:liberty:security:2003-08:TLS:SAML") || mech.equals("urn:liberty:security:2003-08:ClientTLS:SAML")) {
                        this.wsfVersion = "1.0";
                    }
                    DiscoSDKUtils.debug.message("DiscoClient: saml token");
                    List credRefs = desc.getCredentialRef();
                    if (credRefs == null || credRefs.size() == 0) {
                        throw new DiscoveryException(DiscoSDKUtils.bundle.getString("noCredential"));
                    }
                    String credID = (String)credRefs.get(0);
                    if (this.assertions == null) {
                        throw new DiscoveryException(DiscoSDKUtils.bundle.getString("noCredential"));
                    }
                    Iterator iter1 = this.assertions.iterator();
                    while (iter1.hasNext()) {
                        SecurityAssertion sassert = (SecurityAssertion)iter1.next();
                        if (!credID.equals(sassert.getAssertionID())) continue;
                        this.assertion = sassert;
                        break;
                    }
                    if (this.assertion == null) {
                        throw new DiscoveryException(DiscoSDKUtils.bundle.getString("noCredential"));
                    }
                    if (mech.equals("urn:liberty:security:2003-08:ClientTLS:SAML") || mech.equals("urn:liberty:security:2005-02:ClientTLS:SAML")) {
                        this.clientAuth = true;
                        DiscoSDKUtils.debug.message("DiscoClient: clientAuth on");
                    }
                    return;
                }
                if (!mech.equals("urn:liberty:security:2004-04:null:Bearer") && !mech.equals("urn:liberty:security:2004-04:TLS:Bearer") && !mech.equals("urn:liberty:security:2004-04:ClientTLS:Bearer") && !mech.equals("urn:liberty:security:2005-02:null:Bearer") && !mech.equals("urn:liberty:security:2005-02:TLS:Bearer") && !mech.equals("urn:liberty:security:2005-02:ClientTLS:Bearer")) continue;
                this.clientMech = 3;
                if (mech.equals("urn:liberty:security:2004-04:null:Bearer") || mech.equals("urn:liberty:security:2004-04:TLS:Bearer") || mech.equals("urn:liberty:security:2004-04:ClientTLS:Bearer")) {
                    this.wsfVersion = "1.0";
                }
                DiscoSDKUtils.debug.message("DiscoClient: bearer token");
                List credRefs = desc.getCredentialRef();
                if (credRefs == null || credRefs.size() == 0) {
                    throw new DiscoveryException(DiscoSDKUtils.bundle.getString("noCredential"));
                }
                String credID = (String)credRefs.get(0);
                if (credID == null || this.assertions == null) {
                    throw new DiscoveryException(DiscoSDKUtils.bundle.getString("noCredential"));
                }
                Iterator iter2 = this.assertions.iterator();
                while (iter2.hasNext()) {
                    SecurityAssertion sassert = (SecurityAssertion)iter2.next();
                    if (!credID.equals(sassert.getAssertionID())) continue;
                    this.assertion = sassert;
                    break;
                }
                if (this.assertion == null) {
                    throw new DiscoveryException(DiscoSDKUtils.bundle.getString("noCredential"));
                }
                if (mech.equals("urn:liberty:security:2004-04:ClientTLS:Bearer") || mech.equals("urn:liberty:security:2005-02:ClientTLS:Bearer")) {
                    this.clientAuth = true;
                    DiscoSDKUtils.debug.message("DiscoClient: clientAuth on");
                }
                return;
            }
        }
        DiscoSDKUtils.debug.error("DiscoveryClient.processResourceOffering: Couldn't find supported SecurityMechID from ResourceOffering.");
        throw new DiscoveryException(DiscoSDKUtils.bundle.getString("noSupportedSecuMechID"));
    }

    public void setClientCert(String certAlias) {
        this.certAlias = certAlias;
    }

    public void setClientAuthentication(boolean value) {
        this.clientAuth = value;
    }

    public void setResourceID(String resourceID) {
        this.resID = new ResourceID(resourceID);
    }

    public void setResourceID(EncryptedResourceID resourceID) {
        this.encResID = resourceID;
    }

    public void setProviderID(String providerID) {
        this.providerID = providerID;
    }

    public QueryResponse getResourceOffering(List serviceTypes) throws DiscoveryException {
        if (!this.processed) {
            this.processResourceOffering();
            this.processed = true;
        }
        Query query = null;
        Iterator i = serviceTypes.iterator();
        ArrayList<RequestedService> serviceList = new ArrayList<RequestedService>();
        while (i.hasNext()) {
            serviceList.add(new RequestedService(null, (String)i.next()));
        }
        query = this.resID != null ? new Query(this.resID, serviceList) : new Query(this.encResID, serviceList);
        return this.getResourceOffering(query);
    }

    public QueryResponse getResourceOffering(Query query) throws DiscoveryException {
        Message req = this.createRequest();
        req.setSOAPBody(DiscoSDKUtils.parseXML(query.toString()));
        return new QueryResponse(this.getResponse(req));
    }

    private Message createRequest() throws DiscoveryException {
        if (!this.processed) {
            this.processResourceOffering();
            this.processed = true;
        }
        Message req = null;
        ProviderHeader provH = null;
        if (this.providerID != null) {
            try {
                provH = new ProviderHeader(this.providerID);
            }
            catch (SOAPBindingException sbe) {
                throw new DiscoveryException(sbe.getMessage());
            }
        }
        if (this.clientMech == 1) {
            DiscoSDKUtils.debug.message("DiscoveryClient.createRequest: mech=x509");
            try {
                req = new Message(provH, this.token);
            }
            catch (SOAPBindingException sbe) {
                throw new DiscoveryException(sbe.getMessage());
            }
        }
        if (this.clientMech == 2 || this.clientMech == 3) {
            if (DiscoSDKUtils.debug.messageEnabled()) {
                DiscoSDKUtils.debug.message("DiscoveryClient.createRequest: mech=saml or bearer");
            }
            try {
                req = new Message(provH, this.assertion);
            }
            catch (SOAPBindingException sbe) {
                throw new DiscoveryException(sbe.getMessage());
            }
        }
        if (DiscoSDKUtils.debug.messageEnabled()) {
            DiscoSDKUtils.debug.message("DiscoveryClient.createRequest: mech=anon");
        }
        try {
            req = new Message(provH);
        }
        catch (SOAPBindingException sbe) {
            throw new DiscoveryException(sbe.getMessage());
        }
        if (this.clientAuth) {
            req.setClientAuthentication(this.clientAuth);
        }
        req.setWSFVersion(this.wsfVersion);
        return req;
    }

    private Element getResponse(Message req) throws DiscoveryException {
        Message resp = null;
        try {
            resp = Client.sendRequest(req, this.connectTo, this.certAlias, this.soapAction);
        }
        catch (Exception e) {
            DiscoSDKUtils.debug.error("DiscoveryClient.getResponse:", (Throwable)e);
            throw new DiscoveryException(e.getMessage());
        }
        List bodies = resp.getBodies();
        if (bodies.size() != 1) {
            DiscoSDKUtils.debug.error("DiscoveryClient.getResponse: SOAP Response didn't contain one SOAPBody.");
            throw new DiscoveryException(DiscoSDKUtils.bundle.getString("oneBody"));
        }
        return (Element)bodies.iterator().next();
    }

    public ModifyResponse modify(Modify modify) throws DiscoveryException {
        Message req = this.createRequest();
        req.setSOAPBody(DiscoSDKUtils.parseXML(modify.toString()));
        return new ModifyResponse(this.getResponse(req));
    }

    public void setWSFVersion(String wsfVersion) {
        this.wsfVersion = wsfVersion;
    }
}

