/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.authnsvc;

import com.sun.identity.liberty.ws.authnsvc.protocol.SASLResponse;
import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.disco.common.DiscoServiceManager;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.liberty.ws.disco.jaxb.ObjectFactory;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceIDType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceOfferingType;
import com.sun.identity.liberty.ws.disco.jaxb.ServiceInstanceType;
import com.sun.identity.liberty.ws.disco.plugins.jaxb.DiscoEntryElement;
import com.sun.identity.liberty.ws.interfaces.ResourceIDMapper;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AuthnSvcUtils {
    public static ResourceBundle bundle = Locale.getInstallResourceBundle((String)"libAuthnSvc");
    public static Debug debug = Debug.getInstance((String)"libAuthnSvc");

    public static String getString(String key) {
        return bundle.getString(key);
    }

    public static byte[] decodeDataElement(Element dataE) {
        if (dataE == null) {
            return null;
        }
        String value = XMLUtils.getElementValue((Element)dataE);
        if (value == null) {
            return null;
        }
        return Base64.decode((String)value);
    }

    public static boolean setResourceOfferingAndCredentials(SASLResponse saslResp, Message message, String userDN) {
        try {
            DiscoEntryElement discoEntry = DiscoServiceManager.getBootstrappingDiscoEntry();
            ResourceOfferingType offering = discoEntry.getResourceOffering();
            if (!DiscoServiceManager.useImpliedResource()) {
                ServiceInstanceType serviceInstance = offering.getServiceInstance();
                String providerID = serviceInstance.getProviderID();
                ResourceIDMapper idMapper = DiscoServiceManager.getResourceIDMapper(providerID);
                if (idMapper == null) {
                    idMapper = DiscoServiceManager.getDefaultResourceIDMapper();
                }
                ObjectFactory fac = new ObjectFactory();
                ResourceIDType resourceID = fac.createResourceIDType();
                String resourceIDValue = idMapper.getResourceID(providerID, userDN);
                if (debug.messageEnabled()) {
                    debug.message("AuthnSvcUtils.setResourceOfferingAndCredentialsOffering: ResourceID Value:" + resourceIDValue);
                }
                resourceID.setValue(resourceIDValue);
                offering.setResourceID(resourceID);
            }
            ArrayList<DiscoEntryElement> discoEntryList = new ArrayList<DiscoEntryElement>();
            discoEntryList.add(discoEntry);
            Map map = DiscoUtils.checkPolicyAndHandleDirectives(userDN, message, discoEntryList, null, null, null, message.getToken());
            List offerings = (List)map.get("offerings");
            if (offerings.isEmpty()) {
                if (debug.messageEnabled()) {
                    debug.message("AuthnSvcUtils.setResourceOfferingAndCredentialsno ResourceOffering");
                }
                return false;
            }
            ResourceOffering ro = (ResourceOffering)offerings.get(0);
            saslResp.setResourceOffering(ro);
            List assertions = (List)map.get("credentials");
            if (assertions != null && !assertions.isEmpty()) {
                Iterator iter = assertions.iterator();
                ArrayList<Element> credentials = new ArrayList<Element>();
                while (iter.hasNext()) {
                    SecurityAssertion assertion = (SecurityAssertion)iter.next();
                    Document doc = XMLUtils.toDOMDocument((String)assertion.toString(true, true), (Debug)debug);
                    credentials.add(doc.getDocumentElement());
                }
                saslResp.setCredentials(credentials);
            }
            return true;
        }
        catch (Exception ex) {
            debug.error("AuthnSvcUtils.setResourceOfferingAndCredentials:", (Throwable)ex);
            return false;
        }
    }
}

