/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.util;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.services.util.FSSignatureException;
import com.sun.identity.federation.services.util.SignatureProviderSPI;
import com.sun.identity.saml.xmlsig.JKSKeyProvider;
import com.sun.identity.saml.xmlsig.KeyProvider;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.X509Certificate;
import sun.security.provider.Sun;

public class FSSignatureProvider
implements SignatureProviderSPI {
    private KeyProvider keystore = new JKSKeyProvider();
    private static String rsaProviderName = null;

    public void initialize(KeyProvider keyProvider) {
        if (keyProvider == null) {
            FSUtils.debug.error("FSSignatureProvider.initialize: Key Provider is null");
        } else {
            this.keystore = keyProvider;
        }
    }

    public byte[] signBuffer(String data, String certAlias) throws FSSignatureException {
        return this.signBuffer(data, certAlias, "SHA1withRSA");
    }

    public byte[] signBuffer(String data, String certAlias, String algorithm) throws FSSignatureException {
        if (data == null) {
            FSUtils.debug.error("FSSignatureProvider.signBuffer: data to be signed is null.");
            throw new FSSignatureException(FSUtils.bundle.getString("nullInput"));
        }
        if (certAlias == null || certAlias.length() == 0) {
            FSUtils.debug.error("FSSignatureProvider.signBuffer: certAlias is null.");
            throw new FSSignatureException(FSUtils.bundle.getString("nullInput"));
        }
        try {
            int pos;
            PrivateKey privateKey = this.keystore.getPrivateKey(certAlias);
            if (algorithm == null || algorithm.length() == 0) {
                algorithm = "SHA1withRSA";
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSignatureProvider.signBuffer: algorithm is null assigning algorithm= " + algorithm);
                }
            }
            if (!this.isValidAlgorithm(algorithm)) {
                FSUtils.debug.error("FSSignatureProvider.signBuffer: algorithm is invalid ");
                throw new FSSignatureException(FSUtils.bundle.getString("invalidAlgorithm"));
            }
            Provider[] ps = Security.getProviders();
            boolean isAvailable = false;
            for (int i = 0; i < ps.length; ++i) {
                if (!ps[i].getName().equals("SUN")) continue;
                isAvailable = true;
                break;
            }
            if (!isAvailable && (pos = Security.insertProviderAt(new Sun(), 2)) == -1) {
                FSUtils.debug.error("FSSignatureProvider.signBuffer: could not add default provider");
            }
            Signature sig = Signature.getInstance(algorithm);
            if (algorithm.equals("SHA1withRSA")) {
                sig = this.getSignatureWithRSA();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSignatureProvider.signBuffer: " + sig.getProvider().getName());
                }
            } else if (algorithm.equals("SHA1withDSA")) {
                sig = Signature.getInstance(algorithm, "SUN");
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSignatureProvider.signBuffer: " + sig.getProvider().getName());
                }
            }
            sig.initSign(privateKey);
            sig.update(data.getBytes());
            return sig.sign();
        }
        catch (Exception ex) {
            String stackTrace = null;
            ByteArrayOutputStream bop = new ByteArrayOutputStream();
            ex.printStackTrace(new PrintStream(bop));
            stackTrace = bop.toString();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSignatureProvider.signBuffer: " + stackTrace);
            }
            throw new FSSignatureException(ex.getMessage());
        }
    }

    private Signature getSignatureWithRSA() throws NoSuchAlgorithmException, NoSuchProviderException {
        Signature sig = null;
        if (rsaProviderName == null) {
            Provider[] ps = Security.getProviders();
            for (int i = 0; i < ps.length; ++i) {
                try {
                    sig = Signature.getInstance("SHA1withRSA", ps[i]);
                    rsaProviderName = ps[i].getName();
                    break;
                }
                catch (NoSuchAlgorithmException nsa) {
                    continue;
                }
            }
        } else {
            sig = Signature.getInstance("SHA1withRSA", rsaProviderName);
        }
        if (sig == null) {
            throw new NoSuchProviderException();
        }
        return sig;
    }

    public boolean verifySignature(String data, byte[] signature, String algorithm, X509Certificate cert) throws FSSignatureException {
        if (data == null || data.length() == 0) {
            FSUtils.debug.error("FSSignatureProvider.verifySignature: data to be signed is null.");
            throw new FSSignatureException(FSUtils.bundle.getString("nullInput"));
        }
        try {
            int pos;
            if (algorithm == null || algorithm.length() == 0) {
                throw new FSSignatureException(FSUtils.bundle.getString("invalidAlgorithm"));
            }
            if (!this.isValidAlgorithm(algorithm)) {
                throw new FSSignatureException(FSUtils.bundle.getString("invalidAlgorithm"));
            }
            Provider[] ps = Security.getProviders();
            boolean isAvailable = false;
            for (int i = 0; i < ps.length; ++i) {
                if (!ps[i].getName().equals("SUN")) continue;
                isAvailable = true;
                break;
            }
            if (!isAvailable && (pos = Security.insertProviderAt(new Sun(), 2)) == -1) {
                FSUtils.debug.error("FSSignatureProvider.signBuffer: could not add default provider");
            }
            Signature sig = Signature.getInstance(algorithm);
            if (algorithm.equals("SHA1withRSA")) {
                sig = this.getSignatureWithRSA();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSignatureProvider.verifySignature:" + sig.getProvider().getName());
                }
            } else if (algorithm.equals("SHA1withDSA")) {
                sig = Signature.getInstance(algorithm, "SUN");
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSignatureProvider.verifySignature:" + sig.getProvider().getName());
                }
            }
            if (cert != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSignatureProvider.verifySignature: Certificate: " + cert.toString());
                }
                sig.initVerify(cert);
                sig.update(data.getBytes());
                return sig.verify(signature);
            }
            return false;
        }
        catch (Exception ex) {
            String stackTrace = null;
            ByteArrayOutputStream bop = new ByteArrayOutputStream();
            ex.printStackTrace(new PrintStream(bop));
            stackTrace = bop.toString();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSignatureProvider.verifySignature: " + stackTrace);
            }
            throw new FSSignatureException(ex.getMessage());
        }
    }

    public KeyProvider getKeyProvider() {
        return this.keystore;
    }

    private boolean isValidAlgorithm(String algorithm) {
        return algorithm.equals("SHA1withDSA") || algorithm.equals("SHA1withRSA");
    }
}

