/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.util;

import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.IDPDescriptorConfigElement;
import com.sun.identity.federation.message.FSSubject;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.plugin.datastore.DataStoreProvider;
import com.sun.identity.plugin.datastore.DataStoreProviderException;
import com.sun.identity.plugin.datastore.DataStoreProviderManager;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Element;

public class FSAttributeStatementHelper {
    public static AttributeStatement getAutoFedAttributeStatement(String realm, String entityID, FSSubject sub, Object ssoToken) throws FSException {
        IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
        IDPDescriptorConfigElement hostConfig = null;
        try {
            if (metaManager != null) {
                hostConfig = metaManager.getIDPDescriptorConfig(realm, entityID);
            }
        }
        catch (IDFFMetaException fae) {
            FSUtils.debug.error("FSAttributeStatementHelper.getAutoFedAttributeStatement: IDFFMetaException ", (Throwable)((Object)fae));
            throw new FSException((Exception)((Object)fae));
        }
        String autoFedAttr = IDFFMetaUtils.getFirstAttributeValueFromConfig(hostConfig, "autoFederationAttribute");
        if (autoFedAttr == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAttributeStatementHelper.getAutoFed:AttributeStatement: AutoFederate Attribute is null");
            }
            return null;
        }
        ArrayList<Element> values = new ArrayList<Element>();
        try {
            String userID = SessionManager.getProvider().getPrincipalName(ssoToken);
            DataStoreProvider provider = DataStoreProviderManager.getInstance().getDataStoreProvider("IDFF");
            Set vals = provider.getAttribute(userID, autoFedAttr);
            Iterator iter = vals.iterator();
            while (iter.hasNext()) {
                values.add(FSAttributeStatementHelper.getAttributeValue((String)iter.next()));
            }
        }
        catch (SessionException se) {
            FSUtils.debug.error("FSAttributeStatementHelper.getAutoFedAttributeStatement: SessionException ", (Throwable)((Object)se));
            throw new FSException((Exception)((Object)se));
        }
        catch (DataStoreProviderException ie) {
            FSUtils.debug.error("FSAttributeStatementHelper.getAutoFedAttributeStatement: DataStoreProviderException ", (Throwable)((Object)ie));
            throw new FSException((Exception)((Object)ie));
        }
        if (values == null || values.size() == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAtributeStatementHelper.getAuto:FedAttributeStatement. No values for autofed attribute");
            }
            return null;
        }
        try {
            Attribute attribute = new Attribute("AutoFederateAttribute", "urn:oasis:names:tc:SAML:1.0:assertion", values);
            ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
            attributeList.add(attribute);
            return new AttributeStatement(sub, attributeList);
        }
        catch (SAMLException ex) {
            FSUtils.debug.error("FSAttributeStatementHelper.getAutoFedAttributeStatement: SAMLException ", (Throwable)((Object)ex));
            throw new FSException((Exception)((Object)ex));
        }
    }

    private static Element getAttributeValue(String value) throws FSException {
        if (value == null) {
            throw new FSException("nullInputParameter", null);
        }
        StringBuffer sb = new StringBuffer(300);
        sb.append("<").append("saml:").append("AttributeValue").append(" xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"").append(">").append(value).append("</").append("saml:").append("AttributeValue>");
        try {
            return XMLUtils.toDOMDocument((String)sb.toString(), (Debug)FSUtils.debug).getDocumentElement();
        }
        catch (Exception ex) {
            throw new FSException(ex);
        }
    }
}

