/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.termination;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.util.FSServiceUtils;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSTerminationReturnServlet
extends HttpServlet {
    ServletConfig config = null;
    IDFFMetaManager metaManager = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        FSUtils.debug.message("FSTerminationReturnServlet Initializing...");
        this.config = config;
        this.metaManager = FSUtils.getIDFFMetaManager();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetPost(request, response);
    }

    private void doGetPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FSUtils.debug.message("FSTerminationReturnServlet doGetPost...");
        String providerAlias = FSServiceUtils.getMetaAlias(request);
        if (providerAlias == null || providerAlias.length() < 1) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Unable to retrieve alias, Hosted Provider. Cannot process request");
            }
            response.sendError(500, FSUtils.bundle.getString("aliasNotFound"));
            return;
        }
        StringBuffer terminationDone = new StringBuffer();
        BaseConfigType hostedConfig = null;
        try {
            String hostedRole = this.metaManager.getProviderRoleByMetaAlias(providerAlias);
            String hostedEntityId = this.metaManager.getEntityIDByMetaAlias(providerAlias);
            String realm = IDFFMetaUtils.getRealmByMetaAlias(providerAlias);
            if (hostedRole != null && hostedRole.equalsIgnoreCase("IDP")) {
                hostedConfig = this.metaManager.getIDPDescriptorConfig(realm, hostedEntityId);
            } else if (hostedRole != null && hostedRole.equalsIgnoreCase("SP")) {
                hostedConfig = this.metaManager.getSPDescriptorConfig(realm, hostedEntityId);
            }
            if (hostedRole == null || hostedConfig == null) {
                throw new IDFFMetaException((String)null);
            }
        }
        catch (IDFFMetaException e) {
            FSUtils.debug.error("Failed to get Hosted Provider");
            response.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        terminationDone.append(FSServiceUtils.getTerminationDonePageURL(request, hostedConfig, providerAlias));
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Final Done page URL at local end: " + terminationDone.toString());
        }
        response.sendRedirect(terminationDone.toString());
    }
}

