/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.registration;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.key.KeyUtil;
import com.sun.identity.federation.message.FSNameRegistrationRequest;
import com.sun.identity.federation.message.FSNameRegistrationResponse;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.message.common.IDPProvidedNameIdentifier;
import com.sun.identity.federation.message.common.OldProvidedNameIdentifier;
import com.sun.identity.federation.message.common.SPProvidedNameIdentifier;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.plugins.FederationSPAdapter;
import com.sun.identity.federation.services.FSSOAPService;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.registration.FSRegistrationManager;
import com.sun.identity.federation.services.util.FSNameIdentifierHelper;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.liberty.ws.meta.jaxb.ProviderDescriptorType;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.encode.URLEncDec;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FSNameRegistrationHandler {
    protected HttpServletResponse response = null;
    protected HttpServletRequest request = null;
    protected HashMap regisMap = new HashMap();
    protected FSNameRegistrationResponse regisResponse = null;
    protected FSNameRegistrationRequest regisRequest = null;
    protected Object ssoToken = null;
    protected String userID = null;
    protected FSAccountFedInfo acctInfo = null;
    protected FSAccountFedInfo newAcctInfo = null;
    protected FSAccountFedInfoKey newAcctKey = null;
    protected FSAccountFedInfoKey oldAcctKey = null;
    protected ProviderDescriptorType remoteDescriptor = null;
    protected ProviderDescriptorType hostedDescriptor = null;
    protected BaseConfigType hostedConfig = null;
    protected String metaAlias = null;
    protected String relayState = "";
    protected FSAccountManager managerInst = null;
    protected static String REGISTRATION_DONE_URL = null;
    protected static final String RELAY_STATE = "RELAYSTATE";
    protected HashMap returnMap = new HashMap();
    protected static String returnURL = "";
    protected static String regisSource = "";
    protected String remoteEntityId = "";
    protected String realm = "";
    protected String hostedEntityId = "";
    protected String hostedProviderRole = null;

    public FSNameRegistrationHandler() {
        FSUtils.debug.message("FSNameRegistrationHandler Constructor...");
    }

    protected void setRegistrationURL() {
        REGISTRATION_DONE_URL = FSServiceUtils.getRegistrationDonePageURL(this.request, this.hostedConfig, this.metaAlias);
    }

    public void setHostedDescriptor(ProviderDescriptorType hostedDescriptor) {
        FSUtils.debug.message("Entered FSNameRegistrationHandler::setHostedDescriptor");
        this.hostedDescriptor = hostedDescriptor;
    }

    public void setHostedDescriptorConfig(BaseConfigType hostedConfig) {
        this.hostedConfig = hostedConfig;
    }

    public void setHostedEntityId(String hostedId) {
        this.hostedEntityId = hostedId;
    }

    public void setHostedProviderRole(String hostedRole) {
        this.hostedProviderRole = hostedRole;
    }

    public void setMetaAlias(String metaAlias) {
        this.metaAlias = metaAlias;
        try {
            this.managerInst = FSAccountManager.getInstance(metaAlias);
        }
        catch (FSAccountMgmtException e) {
            FSUtils.debug.error("FSNameRegistrationHandler " + FSUtils.bundle.getString("federation-failed-account-instance"));
            this.managerInst = null;
        }
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setRemoteEntityId(String remoteId) {
        this.remoteEntityId = remoteId;
    }

    public void setRemoteDescriptor(ProviderDescriptorType remoteDescriptor) {
        FSUtils.debug.message("Entered FSNameRegistrationHandler::setRemoteDescriptor");
        this.remoteDescriptor = remoteDescriptor;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public void setAccountInfo(FSAccountFedInfo acctInfo) {
        this.acctInfo = acctInfo;
    }

    public boolean setUserDN(FSNameRegistrationRequest regisRequest) {
        try {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("remoteEntityId : " + this.remoteEntityId);
            }
            HashMap<String, FSNameRegistrationRequest> env = new HashMap<String, FSNameRegistrationRequest>();
            env.put("FSNameRegistrationRequest", regisRequest);
            OldProvidedNameIdentifier oldNameIdentifier = regisRequest.getOldProvidedNameIdentifier();
            IDPProvidedNameIdentifier idpNameIdentifier = regisRequest.getIDPProvidedNameIdentifier();
            SPProvidedNameIdentifier spNameIdentifier = regisRequest.getSPProvidedNameIdentifier();
            if (oldNameIdentifier == null) {
                FSUtils.debug.message("oldProvidedNameIdentifier is null :");
                String opaqueHandle = idpNameIdentifier.getName();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("processRegistrationRequest IdPName : " + opaqueHandle);
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Realm : " + this.realm);
                }
                String searchDomain = this.hostedEntityId;
                String nameQualifier = idpNameIdentifier.getNameQualifier();
                if (nameQualifier != null && nameQualifier.length() != 0 && !nameQualifier.equals(this.remoteEntityId)) {
                    searchDomain = nameQualifier;
                }
                FSAccountFedInfoKey acctkey = new FSAccountFedInfoKey(searchDomain, opaqueHandle);
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Search based on:" + this.hostedEntityId + opaqueHandle);
                }
                this.userID = this.managerInst.getUserID(acctkey, this.realm, env);
                if (this.userID == null) {
                    FSUtils.debug.message("UserID is null");
                    return false;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("user id is " + this.userID);
                }
                try {
                    this.acctInfo = this.managerInst.readAccountFedInfo(this.userID, this.remoteEntityId, opaqueHandle);
                }
                catch (FSAccountMgmtException e) {
                    FSUtils.debug.message("Failed to read account information");
                    return false;
                }
                this.newAcctInfo = new FSAccountFedInfo(this.remoteEntityId, (NameIdentifier)idpNameIdentifier, spNameIdentifier, false);
                this.newAcctInfo.setAffiliation(this.acctInfo.getAffiliation());
                this.newAcctKey = new FSAccountFedInfoKey(searchDomain, idpNameIdentifier.getName());
                return true;
            }
            FSUtils.debug.message("oldProvidedNameIdentifier not null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Realm : " + this.realm);
            }
            String opaqueHandle = "";
            String nameQualifier = null;
            boolean isSPEmpty = false;
            String searchDomain = this.hostedEntityId;
            if (spNameIdentifier != null && !spNameIdentifier.equals(oldNameIdentifier)) {
                opaqueHandle = spNameIdentifier.getName();
                nameQualifier = spNameIdentifier.getNameQualifier();
            } else {
                isSPEmpty = true;
                opaqueHandle = idpNameIdentifier.getName();
                nameQualifier = idpNameIdentifier.getNameQualifier();
            }
            if (nameQualifier != null && nameQualifier.length() != 0 && !nameQualifier.equals(this.hostedEntityId)) {
                searchDomain = nameQualifier;
            }
            FSAccountFedInfoKey acctkey = new FSAccountFedInfoKey(searchDomain, opaqueHandle);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Search based on :" + searchDomain + " " + opaqueHandle);
            }
            this.userID = this.managerInst.getUserID(acctkey, this.realm, env);
            if (this.userID == null) {
                FSUtils.debug.message("UserID is null in step 3");
                opaqueHandle = idpNameIdentifier.getName();
                nameQualifier = idpNameIdentifier.getNameQualifier();
                if (nameQualifier != null && nameQualifier.length() != 0 && !nameQualifier.equals(this.hostedEntityId)) {
                    searchDomain = nameQualifier;
                }
                acctkey = new FSAccountFedInfoKey(searchDomain, opaqueHandle);
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Search based on :" + searchDomain + " " + opaqueHandle);
                }
                this.userID = this.managerInst.getUserID(acctkey, this.realm, env);
                if (this.userID == null) {
                    opaqueHandle = idpNameIdentifier.getName();
                    searchDomain = this.hostedEntityId;
                    acctkey = new FSAccountFedInfoKey(searchDomain, opaqueHandle);
                    this.userID = this.managerInst.getUserID(acctkey, this.realm, env);
                    if (this.userID == null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("UserID is null in step 4");
                        }
                        opaqueHandle = oldNameIdentifier.getName();
                        searchDomain = oldNameIdentifier.getNameQualifier();
                        if (searchDomain != null && searchDomain.length() != 0) {
                            acctkey = new FSAccountFedInfoKey(searchDomain, opaqueHandle);
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("Search based on :" + searchDomain + " " + opaqueHandle);
                            }
                            this.userID = this.managerInst.getUserID(acctkey, this.realm, env);
                        }
                    }
                    if (this.userID == null) {
                        return false;
                    }
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Found user : " + this.userID);
                    }
                    this.acctInfo = this.managerInst.readAccountFedInfo(this.userID, searchDomain, opaqueHandle);
                    if (this.acctInfo == null || !this.acctInfo.isFedStatusActive()) {
                        this.acctInfo = this.managerInst.readAccountFedInfo(this.userID, this.remoteEntityId, opaqueHandle);
                    }
                    if (this.acctInfo.isRoleIDP()) {
                        if (isSPEmpty) {
                            this.newAcctInfo = new FSAccountFedInfo(this.remoteEntityId, null, idpNameIdentifier, this.acctInfo.isRoleIDP());
                            this.newAcctInfo.setAffiliation(this.acctInfo.getAffiliation());
                            this.newAcctKey = new FSAccountFedInfoKey(searchDomain, idpNameIdentifier.getName());
                        } else {
                            this.newAcctInfo = new FSAccountFedInfo(this.remoteEntityId, (NameIdentifier)spNameIdentifier, idpNameIdentifier, this.acctInfo.isRoleIDP());
                            this.newAcctInfo.setAffiliation(this.acctInfo.getAffiliation());
                            this.newAcctKey = new FSAccountFedInfoKey(searchDomain, spNameIdentifier.getName());
                        }
                    } else {
                        this.newAcctInfo = new FSAccountFedInfo(this.remoteEntityId, (NameIdentifier)idpNameIdentifier, spNameIdentifier, this.acctInfo.isRoleIDP());
                        this.newAcctInfo.setAffiliation(this.acctInfo.getAffiliation());
                        this.newAcctKey = new FSAccountFedInfoKey(this.hostedEntityId, idpNameIdentifier.getName());
                    }
                } else {
                    this.acctInfo = this.managerInst.readAccountFedInfo(this.userID, searchDomain, opaqueHandle);
                    if (this.acctInfo == null || !this.acctInfo.isFedStatusActive()) {
                        this.acctInfo = this.managerInst.readAccountFedInfo(this.userID, this.remoteEntityId, opaqueHandle);
                    }
                    this.newAcctInfo = new FSAccountFedInfo(this.remoteEntityId, (NameIdentifier)idpNameIdentifier, spNameIdentifier, false);
                    this.newAcctInfo.setAffiliation(this.acctInfo.getAffiliation());
                    this.newAcctKey = new FSAccountFedInfoKey(searchDomain, idpNameIdentifier.getName());
                }
            } else {
                this.acctInfo = this.managerInst.readAccountFedInfo(this.userID, searchDomain, opaqueHandle);
                if (this.acctInfo == null || !this.acctInfo.isFedStatusActive()) {
                    this.acctInfo = this.managerInst.readAccountFedInfo(this.userID, this.remoteEntityId, opaqueHandle);
                }
                if (this.acctInfo.isRoleIDP()) {
                    if (isSPEmpty) {
                        this.newAcctInfo = new FSAccountFedInfo(this.remoteEntityId, null, idpNameIdentifier, this.acctInfo.isRoleIDP());
                        this.newAcctInfo.setAffiliation(this.acctInfo.getAffiliation());
                        this.newAcctKey = new FSAccountFedInfoKey(this.remoteEntityId, idpNameIdentifier.getName());
                    } else {
                        this.newAcctInfo = new FSAccountFedInfo(this.remoteEntityId, (NameIdentifier)spNameIdentifier, idpNameIdentifier, this.acctInfo.isRoleIDP());
                        this.newAcctInfo.setAffiliation(this.acctInfo.getAffiliation());
                        this.newAcctKey = new FSAccountFedInfoKey(this.hostedEntityId, spNameIdentifier.getName());
                    }
                } else {
                    this.newAcctInfo = new FSAccountFedInfo(this.remoteEntityId, (NameIdentifier)idpNameIdentifier, spNameIdentifier, this.acctInfo.isRoleIDP());
                    this.newAcctInfo.setAffiliation(this.acctInfo.getAffiliation());
                    this.newAcctKey = new FSAccountFedInfoKey(this.hostedEntityId, idpNameIdentifier.getName());
                }
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("user id is " + this.userID);
            }
            return true;
        }
        catch (FSAccountMgmtException e) {
            FSUtils.debug.error("In FSNameRegistrationHandler::setUserID: ", (Throwable)((Object)e));
            this.userID = null;
            return false;
        }
    }

    public boolean handleNameRegistration(HttpServletRequest request, HttpServletResponse response, Object ssoToken) {
        regisSource = "STAND_ALONE";
        FSUtils.debug.message("Entered FSNameRegistrationHandler::handleNameRegistration");
        this.request = request;
        this.response = response;
        this.ssoToken = ssoToken;
        this.setRegistrationURL();
        if (this.managerInst == null) {
            FSUtils.debug.error("FSNameRegistrationHandler Account Manager instance is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Account Manager instance");
            }
            this.returnLocallyAtSource(response, false);
            return false;
        }
        try {
            this.userID = SessionManager.getProvider().getPrincipalName(ssoToken);
        }
        catch (SessionException e) {
            FSUtils.debug.error("FSNameRegistrationHandler Constructor::SessionException:", (Throwable)((Object)e));
            LogUtil.error(Level.INFO, "USER_NOT_FOUND", null, ssoToken);
            return false;
        }
        return this.doRemoteRegistration();
    }

    public boolean handleNameRegistration(HttpServletRequest request, HttpServletResponse response, Object ssoToken, HashMap valMap) {
        regisSource = "DuringSSO";
        FSUtils.debug.message("Entered FSNameRegistrationHandler::handleNameRegistration");
        this.request = request;
        this.response = response;
        this.ssoToken = ssoToken;
        this.regisMap = valMap;
        this.setRegistrationURL();
        if (this.managerInst == null) {
            FSUtils.debug.error("FSNameRegistrationHandler Account Manager instance is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Account Manager instance");
            }
            this.returnLocallyAtSource(response, false);
            return false;
        }
        try {
            this.userID = SessionManager.getProvider().getPrincipalName(ssoToken);
        }
        catch (SessionException e) {
            FSUtils.debug.error("FSNameRegistrationHandler Constructor::SessionException", (Throwable)((Object)e));
            LogUtil.error(Level.INFO, "USER_NOT_FOUND", null, ssoToken);
            return false;
        }
        boolean bRemoteStatus = this.doRemoteRegistration();
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Returning cntrol to SIngle Sign On with status " + bRemoteStatus);
        }
        return bRemoteStatus;
    }

    public boolean handleRegistrationAfterFederation(String LRURL, HttpServletResponse response) {
        regisSource = "AfterFederation";
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSNameRegistrationHandler:: handleNameRegistration");
        }
        returnURL = LRURL;
        this.response = response;
        if (this.managerInst == null) {
            FSUtils.debug.error("FSNameRegistrationHandler " + FSUtils.bundle.getString("federation-failed-account-instance"));
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Account Manager instance");
            }
            return false;
        }
        boolean bRemoteStatus = this.doRemoteRegistration();
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Completed registration after federation with status " + bRemoteStatus);
        }
        return bRemoteStatus;
    }

    public boolean processRegistrationResponse(HttpServletRequest request, HttpServletResponse response, FSNameRegistrationResponse regisResponse) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSNameRegistrationHandler::handleRegistrationResponse");
        }
        this.request = request;
        this.response = response;
        this.regisResponse = regisResponse;
        this.setRegistrationURL();
        if (this.managerInst == null) {
            FSUtils.debug.error("FSNameRegistrationHandler Account Manager instance is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Account Manager instance");
            }
            this.returnLocallyAtSource(response, false);
            return false;
        }
        String responseStatus = regisResponse.getStatus().getStatusCode().getValue();
        if (responseStatus.equals("samlp:Success")) {
            FSUtils.debug.message("Name registration Successful");
            this.relayState = regisResponse.getRelayState();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Relay State : " + this.relayState);
            }
            if (this.relayState == null) {
                this.returnLocallyAtSource(response, false);
                return true;
            }
            FSRegistrationManager regisManager = FSRegistrationManager.getInstance(this.metaAlias);
            HashMap valMap = regisManager.getRegistrationMap(this.relayState);
            if (valMap == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Map does not contain request for state = " + this.relayState);
                }
                this.returnLocallyAtSource(response, false);
                return false;
            }
            regisManager.removeRegistrationMapInfo(this.relayState);
            this.regisMap = (HashMap)valMap.get("SSODetails");
            HashMap returnMap = (HashMap)valMap.get("ReturnEntry");
            this.oldAcctKey = (FSAccountFedInfoKey)returnMap.get("OldAccountKey");
            if (this.oldAcctKey != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Get OldAcctKet Name : " + this.oldAcctKey.getName() + "\nGet OldAcctKet Qualifier : " + this.oldAcctKey.getNameSpace());
                }
            } else {
                FSUtils.debug.message("OldAccount Key is null");
            }
            this.newAcctKey = (FSAccountFedInfoKey)returnMap.get("AccountKey");
            if (this.newAcctKey != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Get newAcctKey Name : " + this.newAcctKey.getName() + "Get newAcctKey Qualifier : " + this.newAcctKey.getNameSpace());
                }
            } else {
                FSUtils.debug.message("newAcctKey Key is null");
            }
            this.newAcctInfo = (FSAccountFedInfo)returnMap.get("AccountInfo");
            this.userID = (String)returnMap.get("userID");
            regisSource = (String)returnMap.get("RegisSource");
            returnURL = (String)returnMap.get("RelayState");
            boolean bStatus = this.doCommonRegistration();
            if (bStatus && this.hostedProviderRole != null && this.hostedProviderRole.equalsIgnoreCase("SP")) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("processRegResponse/HTTP, call postRegisterNameIdentifier success");
                }
                this.callPostRegisterNameIdentifierSuccess(request, response, this.userID, null, regisResponse, "http://projectliberty.org/profiles/rni-sp-http");
            }
            this.returnLocallyAtSource(response, bStatus);
            return bStatus;
        }
        if (responseStatus.equals("lib:FederationDoesNotExist")) {
            FSUtils.debug.message("Name registration Failed. Federation does not exist");
            this.returnLocallyAtSource(response, false);
            return false;
        }
        if (responseStatus.equals("lib:Failure")) {
            FSUtils.debug.message("Name registration Failed.");
            this.returnLocallyAtSource(response, false);
            return false;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doRemoteRegistration() {
        FSUtils.debug.message("Entered FSNameRegistrationHandler::doRemoteRegistration");
        try {
            FSNameRegistrationRequest regisRequest;
            try {
                if (this.acctInfo == null) {
                    this.acctInfo = this.managerInst.readAccountFedInfo(this.userID, this.remoteEntityId);
                }
            }
            catch (FSAccountMgmtException e) {
                this.returnLocallyAtSource(this.response, false);
                return false;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::doRemoteRegistration create request start");
            }
            if ((regisRequest = this.createNameRegistrationRequest(this.acctInfo)) == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::Registration request could not be formed");
                }
                this.returnLocallyAtSource(this.response, false);
                return false;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::Registration request formedsuccessfully");
            }
            boolean isSOAPProfile = true;
            if (this.acctInfo.isRoleIDP()) {
                List hostProfiles = this.hostedDescriptor.getRegisterNameIdentifierProtocolProfile();
                if (hostProfiles == null || hostProfiles.isEmpty()) {
                    FSUtils.debug.error("FSNameRegistrationHandler::doRemoteRegistration no registration profile cannot process request");
                    this.returnLocallyAtSource(this.response, false);
                    return false;
                }
                String hostProfile = (String)hostProfiles.iterator().next();
                if (hostProfile.equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-soap") || hostProfile.equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-soap")) {
                    isSOAPProfile = true;
                } else {
                    if (!hostProfile.equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-http") && !hostProfile.equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-http")) {
                        FSUtils.debug.error("FSNameRegistrationHandler::doRemoteRegistration Invalid registration profile cannot process request");
                        this.returnLocallyAtSource(this.response, false);
                        return false;
                    }
                    isSOAPProfile = false;
                }
            } else {
                List remoteProfiles = this.remoteDescriptor.getRegisterNameIdentifierProtocolProfile();
                if (remoteProfiles == null || remoteProfiles.isEmpty()) {
                    FSUtils.debug.error("FSNameRegistrationHandler::doRemoteRegistration no registration profile cannot process request");
                    this.returnLocallyAtSource(this.response, false);
                    return false;
                }
                String remoteProfile = (String)remoteProfiles.iterator().next();
                if (remoteProfile.equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-soap") || remoteProfile.equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-soap")) {
                    isSOAPProfile = true;
                } else {
                    if (!remoteProfile.equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-http") && !remoteProfile.equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-http")) {
                        FSUtils.debug.error("FSNameRegistrationHandler::doRemoteRegistration Invalid registration profile cannot process request");
                        this.returnLocallyAtSource(this.response, false);
                        return false;
                    }
                    isSOAPProfile = false;
                }
            }
            if (isSOAPProfile) {
                FSSOAPService instSOAP = FSSOAPService.getInstance();
                if (instSOAP != null) {
                    FSUtils.debug.message("Signing suceeded. To call bindRegistrationRequest");
                    regisRequest.setID("reg-Sig-ID");
                    SOAPMessage msgRegistration = instSOAP.bind(regisRequest.toXMLString(true, true));
                    if (msgRegistration != null) {
                        SOAPMessage retSOAPMessage = null;
                        try {
                            if (FSServiceUtils.isSigningOn()) {
                                int minorVersion = regisRequest.getMinorVersion();
                                if (minorVersion == 0) {
                                    msgRegistration = this.signRegistrationRequest(msgRegistration, "id", regisRequest.getID());
                                } else if (minorVersion == 2) {
                                    msgRegistration = this.signRegistrationRequest(msgRegistration, "RequestID", regisRequest.getRequestID());
                                } else {
                                    FSUtils.debug.message("invalid minor version.");
                                }
                            }
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("calling sendRegistrationMessage");
                            }
                            retSOAPMessage = instSOAP.sendMessage(msgRegistration, this.remoteDescriptor.getSoapEndpoint());
                        }
                        catch (SOAPException e) {
                            FSUtils.debug.error("Error in sending request ", (Throwable)e);
                            this.returnLocallyAtSource(this.response, false);
                            return false;
                        }
                        catch (Exception ex) {
                            FSUtils.debug.error("Error in sending request:", (Throwable)ex);
                            this.returnLocallyAtSource(this.response, false);
                            return false;
                        }
                        if (retSOAPMessage == null) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("sendRegistrationMessagereturn response is null");
                            }
                            this.returnLocallyAtSource(this.response, false);
                            return false;
                        }
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("callingparseSOAPMessage after return from IDP");
                        }
                        Element elt = instSOAP.parseSOAPMessage(retSOAPMessage);
                        if (FSServiceUtils.isSigningOn() && this.regisResponse != null && !this.verifyResponseSignature(retSOAPMessage, this.acctInfo.isRoleIDP())) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("Response signature verification failed");
                                FSUtils.debug.message("Name registration failed in doRemoteRegistration");
                            }
                            this.returnLocallyAtSource(this.response, false);
                            return false;
                        }
                        FSUtils.debug.message("Response signature verification succeeded");
                        if (elt.getLocalName().equalsIgnoreCase("RegisterNameIdentifierResponse")) {
                            FSNameRegistrationResponse regisResponse = null;
                            try {
                                regisResponse = new FSNameRegistrationResponse(elt);
                            }
                            catch (SAMLException e) {
                                regisResponse = null;
                            }
                            if (regisResponse != null) {
                                String responseStatus = regisResponse.getStatus().getStatusCode().getValue();
                                if (responseStatus.equals("samlp:Success")) {
                                    FSUtils.debug.message("Name registration Successful");
                                    this.oldAcctKey = (FSAccountFedInfoKey)this.returnMap.get("OldAccountKey");
                                    if (this.oldAcctKey != null) {
                                        if (FSUtils.debug.messageEnabled()) {
                                            FSUtils.debug.message("Get OldAcctKet Name : " + this.oldAcctKey.getName() + "\nGet OldAcctKet Qualifier:" + this.oldAcctKey.getNameSpace());
                                        }
                                    } else {
                                        FSUtils.debug.message("OldAccount Key is null");
                                    }
                                    this.newAcctKey = (FSAccountFedInfoKey)this.returnMap.get("AccountKey");
                                    if (this.newAcctKey != null) {
                                        if (FSUtils.debug.messageEnabled()) {
                                            FSUtils.debug.message("Get newAcctKey Name : " + this.newAcctKey.getName() + "\nGet newAcctKey Qualifier:" + this.newAcctKey.getNameSpace());
                                        }
                                    } else {
                                        FSUtils.debug.message("newAcctKey Key is null");
                                    }
                                    this.newAcctInfo = (FSAccountFedInfo)this.returnMap.get("AccountInfo");
                                    this.userID = (String)this.returnMap.get("userID");
                                    regisSource = (String)this.returnMap.get("RegisSource");
                                    returnURL = (String)this.returnMap.get("RelayState");
                                    boolean bStatus = this.doCommonRegistration();
                                    if (FSUtils.debug.messageEnabled()) {
                                        FSUtils.debug.message("doCommonRegistration returns " + bStatus);
                                    }
                                    if (bStatus && this.hostedProviderRole != null && this.hostedProviderRole.equalsIgnoreCase("SP")) {
                                        FSUtils.debug.message("doRemoteRegis");
                                        this.callPostRegisterNameIdentifierSuccess(this.request, this.response, this.userID, regisRequest, regisResponse, "http://projectliberty.org/profiles/rni-sp-soap");
                                    }
                                    this.returnLocallyAtSource(this.response, bStatus);
                                    return bStatus;
                                }
                                if (responseStatus.equals("lib:FederationDoesNotExist")) {
                                    if (FSUtils.debug.messageEnabled()) {
                                        FSUtils.debug.message("Name registration Failed. Federation does not exist");
                                    }
                                    this.returnLocallyAtSource(this.response, false);
                                    return false;
                                }
                                if (responseStatus.equals("lib:Failure")) {
                                    FSUtils.debug.message("Name registration Failed.");
                                    this.returnLocallyAtSource(this.response, false);
                                    return false;
                                }
                            }
                        }
                    }
                }
                this.returnLocallyAtSource(this.response, false);
                return false;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::doRemoteRegistration In Redirect profile");
            }
            FSNameIdentifierHelper nameHelper = new FSNameIdentifierHelper(this.hostedConfig);
            String newId = nameHelper.createNameIdentifier();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Registration Id : " + newId);
            }
            regisRequest.setRelayState(newId);
            HashMap<String, Object> valMap = new HashMap<String, Object>();
            valMap.put("SSODetails", this.regisMap);
            valMap.put("ReturnEntry", this.returnMap);
            if (returnURL != null) {
                valMap.put("RelayState", returnURL);
            }
            FSRegistrationManager registInst = FSRegistrationManager.getInstance(this.metaAlias);
            registInst.setRegistrationMapInfo(newId, valMap);
            Set ketSet = valMap.keySet();
            Iterator iter = ketSet.iterator();
            String key = null;
            String value = null;
            while (iter.hasNext()) {
                key = (String)iter.next();
                value = (String)this.regisMap.get(key);
                if (!FSUtils.debug.messageEnabled()) continue;
                FSUtils.debug.message("Putting in Map Key : " + key + "\nPutting in Map Value : " + value);
            }
            String urlEncodedRequest = regisRequest.toURLEncodedQueryString();
            if (FSServiceUtils.isSigningOn()) {
                String certAlias = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostedConfig, "signingCertAlias");
                if (certAlias == null || certAlias.length() == 0) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSBrowserArtifactConsumerHandler:: signSAMLRequest:couldn't obtain this site's cert alias.");
                    }
                    throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
                }
                urlEncodedRequest = FSSignatureUtil.signAndReturnQueryString(urlEncodedRequest, certAlias);
            }
            StringBuffer redirectURL = new StringBuffer();
            String retURL = this.remoteDescriptor.getRegisterNameIdentifierServiceURL();
            redirectURL.append(retURL);
            if (retURL.indexOf(63) == -1) {
                redirectURL.append('?');
            } else {
                redirectURL.append('&');
            }
            redirectURL.append(urlEncodedRequest);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request to be sent : " + redirectURL.toString());
            }
            this.response.sendRedirect(redirectURL.toString());
            return true;
        }
        catch (IOException e) {
            FSUtils.debug.error("FSNameRegistrationHandler" + FSUtils.bundle.getString("federation-redirection-failed"));
        }
        catch (FSMsgException e) {
            FSUtils.debug.error("FSNameRegistrationHandler::doRemoteRegistration " + FSUtils.bundle.getString("termination-failed-send-remote"));
        }
        catch (SAMLResponderException e) {
            FSUtils.debug.error("FSNameRegistrationHandler::doRemoteRegistration " + FSUtils.bundle.getString("termination-failed-send-remote"));
        }
        this.returnLocallyAtSource(this.response, false);
        return false;
    }

    public void processRegistrationRequest(HttpServletRequest request, HttpServletResponse response, FSNameRegistrationRequest regisRequest) {
        block19: {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Entered FSNameRegistrationHandler::processRegistrationRequest...");
            }
            this.request = request;
            this.response = response;
            this.regisRequest = regisRequest;
            this.relayState = regisRequest.getRelayState();
            this.setRegistrationURL();
            if (this.managerInst == null) {
                FSUtils.debug.error("FSNameRegistrationHandler " + FSUtils.bundle.getString("federation-failed-account-instance"));
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Account Manager instance");
                }
                this.sendRegistrationResponse();
                return;
            }
            boolean bUserStatus = this.setUserDN(regisRequest);
            if (!bUserStatus) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Failed to get UserDN. Invalid Name registration request");
                }
                this.sendRegistrationResponse();
                return;
            }
            boolean retStatus = this.doCommonRegistration();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("doCommonRegistration returns " + retStatus);
            }
            if (retStatus) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationregistration in DS completed successfully");
                }
                try {
                    StatusCode statusCode = new StatusCode("samlp:Success");
                    this.regisResponse = new FSNameRegistrationResponse(null, regisRequest.getRequestID(), new Status(statusCode), this.hostedEntityId, this.relayState);
                    this.regisResponse.setMinorVersion(regisRequest.getMinorVersion());
                    if (this.hostedProviderRole != null && this.hostedProviderRole.equalsIgnoreCase("SP")) {
                        FSUtils.debug.message("processRegistration IDP/HTTP");
                        this.callPostRegisterNameIdentifierSuccess(request, response, this.userID, regisRequest, this.regisResponse, "http://projectliberty.org/profiles/rni-idp-http");
                    }
                    break block19;
                }
                catch (FSMsgException e) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response", (Throwable)((Object)e));
                    }
                    break block19;
                }
                catch (SAMLException e) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response", (Throwable)((Object)e));
                    }
                    break block19;
                }
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationregistration in DS failed");
            }
            try {
                StatusCode statusCode = new StatusCode("lib:Failure");
                this.regisResponse = new FSNameRegistrationResponse(null, regisRequest.getRequestID(), new Status(statusCode), this.hostedEntityId, this.relayState);
                this.regisResponse.setMinorVersion(regisRequest.getMinorVersion());
            }
            catch (FSMsgException e) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response", (Throwable)((Object)e));
                }
            }
            catch (SAMLException e) {
                if (!FSUtils.debug.messageEnabled()) break block19;
                FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response, e");
            }
        }
        this.sendRegistrationResponse();
    }

    public FSNameRegistrationResponse processSOAPRegistrationRequest(HttpServletRequest request, HttpServletResponse response, FSNameRegistrationRequest regisRequest) {
        this.relayState = regisRequest.getRelayState();
        try {
            boolean regisSucceed = false;
            FSNameRegistrationResponse regisResponse = null;
            FSUtils.debug.message("Entered FSNameRegistrationHandler::processRegistrationRequest");
            if (this.managerInst == null) {
                FSUtils.debug.error("FSNameRegistrationHandler Account Manager instance is null");
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Account Manager instance");
                }
                StatusCode statusCode = new StatusCode("lib:Failure");
                try {
                    regisResponse = new FSNameRegistrationResponse(null, regisRequest.getRequestID(), new Status(statusCode), this.hostedEntityId, this.relayState);
                }
                catch (FSMsgException e) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                    }
                    return null;
                }
                regisResponse.setID("reg-Sig-ID");
                regisResponse.setMinorVersion(regisRequest.getMinorVersion());
                return regisResponse;
            }
            FSUtils.debug.message("Begin processRegistrationRequest SOAP profile...");
            if (regisRequest != null) {
                boolean bUserStatus = this.setUserDN(regisRequest);
                if (bUserStatus) {
                    boolean retStatus = this.doCommonRegistration();
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("doCommonRegistration returns " + retStatus);
                    }
                    if (retStatus) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistration:registration in DS completed successfully");
                        }
                        try {
                            StatusCode statusCode = new StatusCode("samlp:Success");
                            regisResponse = new FSNameRegistrationResponse(null, regisRequest.getRequestID(), new Status(statusCode), this.hostedEntityId, this.relayState);
                            regisSucceed = true;
                        }
                        catch (FSMsgException e) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                            }
                            return null;
                        }
                        catch (SAMLException ex) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                            }
                            return null;
                        }
                    } else {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistration: registration in DS failed");
                        }
                        try {
                            StatusCode statusCode = new StatusCode("lib:Failure");
                            regisResponse = new FSNameRegistrationResponse(null, regisRequest.getRequestID(), new Status(statusCode), this.hostedEntityId, this.relayState);
                        }
                        catch (FSMsgException e) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                            }
                            return null;
                        }
                        catch (SAMLException ex) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                            }
                            return null;
                        }
                    }
                } else {
                    FSUtils.debug.message("Failed to get UserDN. Invalid registration request");
                    try {
                        StatusCode statusCode = new StatusCode("lib:FederationDoesNotExist");
                        regisResponse = new FSNameRegistrationResponse(null, regisRequest.getRequestID(), new Status(statusCode), this.hostedEntityId, this.relayState);
                    }
                    catch (FSMsgException e) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                        }
                        return null;
                    }
                    catch (SAMLException ex) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                        }
                        return null;
                    }
                }
            } else {
                FSUtils.debug.error("FSNameRegistrationHandler::processRegistrationRequest name registration request is improper");
                return null;
            }
            regisResponse.setID("reg-Sig-ID");
            regisResponse.setMinorVersion(regisRequest.getMinorVersion());
            if (regisSucceed && this.hostedProviderRole != null && this.hostedProviderRole.equalsIgnoreCase("SP")) {
                this.callPostRegisterNameIdentifierSuccess(request, response, this.userID, regisRequest, regisResponse, "http://projectliberty.org/profiles/rni-idp-soap");
            }
            return regisResponse;
        }
        catch (SAMLException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::SAMLException", (Throwable)((Object)e));
            }
            return null;
        }
    }

    public void returnLocallyAtSource(HttpServletResponse response, boolean isSuccess) {
        block15: {
            if (regisSource.equals("AfterFederation")) {
                try {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("redirecting to Resource : " + returnURL);
                    }
                    response.sendRedirect(returnURL);
                }
                catch (IOException e) {
                    FSUtils.debug.error("Error when redirecting back to resource");
                    return;
                }
            }
            if (regisSource.equals("DuringSSO")) {
                StringBuffer ssoURL = new StringBuffer();
                ssoURL.append(FSServiceUtils.getBaseURL(this.request)).append("/SingleSignOnService").append("/").append("metaAlias").append(FSServiceUtils.getMetaAlias(this.request)).append('?');
                Set ketSet = this.regisMap.keySet();
                Iterator iter = ketSet.iterator();
                String key = null;
                String value = null;
                while (iter.hasNext()) {
                    key = (String)iter.next();
                    value = (String)this.regisMap.get(key);
                    ssoURL.append(key).append('=').append(URLEncDec.encode((String)value)).append('&');
                }
                ssoURL.append("Authn").append('=').append("true").append('&').append("nameregis").append('=').append("true");
                try {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("redirecting to SSO : " + ssoURL.toString());
                    }
                    response.sendRedirect(ssoURL.toString());
                }
                catch (IOException e) {
                    FSUtils.debug.error("Error when redirecting back to SSO service", (Throwable)e);
                    return;
                }
            }
            if (regisSource.equals("STAND_ALONE")) {
                try {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Entered  returnLocallyAtSource with isSuccess set to " + isSuccess);
                    }
                    StringBuffer finalReturnURL = new StringBuffer();
                    finalReturnURL.append(REGISTRATION_DONE_URL);
                    char delimiter = REGISTRATION_DONE_URL.indexOf(63) < 0 ? (char)'?' : '&';
                    finalReturnURL.append(delimiter).append("regisStatus").append('=');
                    if (isSuccess) {
                        finalReturnURL.append("regisSuccess");
                    } else {
                        finalReturnURL.append("regisFailure");
                    }
                    response.sendRedirect(finalReturnURL.toString());
                }
                catch (IOException e) {
                    if (!FSUtils.debug.messageEnabled()) break block15;
                    FSUtils.debug.message("Exception in  returnLocallyAtSource:", (Throwable)e);
                }
            }
        }
    }

    protected SOAPMessage signRegistrationRequest(SOAPMessage msg, String idAttrName, String id) throws SAMLException, FSMsgException {
        FSUtils.debug.message("Entered FSNameRegistrationHandler::signRegistrationRequest");
        String certAlias = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostedConfig, "signingCertAlias");
        if (certAlias == null || certAlias.length() == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::signRegistrationRequest: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSNameRegistrationHandler.signRegistrationRequest Provider's certAlias is found: " + certAlias);
        }
        XMLSignatureManager manager = XMLSignatureManager.getInstance();
        Document doc = (Document)FSServiceUtils.createSOAPDOM(msg);
        String xpath = "//*[local-name()='ProviderID']";
        manager.signXML(doc, certAlias, SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.xmlSigAlgorithm"), idAttrName, id, false, xpath);
        return FSServiceUtils.convertDOMToSOAP(doc);
    }

    protected boolean verifyResponseSignature(SOAPMessage msg, boolean isIDP) {
        FSUtils.debug.message("Entered FSNameRegistrationHandler::verifyResponseSignature");
        try {
            X509Certificate cert = KeyUtil.getVerificationCert(this.remoteDescriptor, this.remoteEntityId, isIDP);
            if (cert == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Registration.verifyResponseSignaturecouldn't obtain this site's cert .");
                }
                throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("NameRegistration.verifyResponseSignature: Provider's cert is found.");
            }
            XMLSignatureManager manager = XMLSignatureManager.getInstance();
            Document doc = (Document)FSServiceUtils.createSOAPDOM(msg);
            return manager.verifyXMLSignature(doc, cert);
        }
        catch (SAMLException e) {
            FSUtils.debug.error("Error in verifying response ", (Throwable)((Object)e));
            return false;
        }
    }

    private FSNameRegistrationRequest createNameRegistrationRequest(FSAccountFedInfo acctInfo) {
        block31: {
            try {
                String affiliationID;
                FSNameRegistrationRequest reqName;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Entered FSNameRegistrationHandler:: createNameRegistrationRequest");
                }
                if ((reqName = new FSNameRegistrationRequest()) == null) break block31;
                reqName.setProviderId(this.hostedEntityId);
                if (acctInfo.isRoleIDP()) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("calling of generateNameIdentifier Role : IdP ? " + acctInfo.isRoleIDP());
                    }
                    NameIdentifier nameIdentifier = this.generateNameIdentifier();
                    if (acctInfo.getAffiliation()) {
                        String affiliationID2 = FSServiceUtils.getAffiliationID(this.realm, this.remoteEntityId);
                        if (affiliationID2 != null) {
                            nameIdentifier.setNameQualifier(affiliationID2);
                        }
                    } else {
                        nameIdentifier.setNameQualifier(this.hostedEntityId);
                    }
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("out of generateNameIdentifier ****\nNew SP nameIdentifier Qualifier: " + nameIdentifier.getNameQualifier() + "\nNew SP nameIdentifier Name :" + nameIdentifier.getName());
                    }
                    SPProvidedNameIdentifier newNameIdenifier = new SPProvidedNameIdentifier(nameIdentifier.getName(), nameIdentifier.getNameQualifier(), nameIdentifier.getFormat());
                    NameIdentifier remoteIdentifier = acctInfo.getRemoteNameIdentifier();
                    NameIdentifier localIdentifier = acctInfo.getLocalNameIdentifier();
                    reqName.setIDPProvidedNameIdentifier(new IDPProvidedNameIdentifier(remoteIdentifier.getName(), remoteIdentifier.getNameQualifier(), remoteIdentifier.getFormat()));
                    reqName.setSPProvidedNameIdentifier(newNameIdenifier);
                    if (localIdentifier != null) {
                        reqName.setOldProvidedNameIdentifier(new OldProvidedNameIdentifier(localIdentifier.getName(), localIdentifier.getNameQualifier(), localIdentifier.getFormat()));
                        try {
                            this.oldAcctKey = new FSAccountFedInfoKey(localIdentifier.getNameQualifier(), localIdentifier.getName());
                        }
                        catch (FSAccountMgmtException e) {
                            this.oldAcctKey = null;
                        }
                    } else {
                        reqName.setOldProvidedNameIdentifier(new OldProvidedNameIdentifier(remoteIdentifier.getName(), remoteIdentifier.getNameQualifier(), remoteIdentifier.getFormat()));
                        try {
                            this.oldAcctKey = new FSAccountFedInfoKey(remoteIdentifier.getNameQualifier(), remoteIdentifier.getName());
                        }
                        catch (FSAccountMgmtException e) {
                            this.oldAcctKey = null;
                        }
                    }
                    try {
                        FSAccountFedInfoKey tmpKey = new FSAccountFedInfoKey(nameIdentifier.getNameQualifier(), nameIdentifier.getName());
                        FSAccountFedInfo tmpInfo = new FSAccountFedInfo(this.remoteEntityId, (NameIdentifier)newNameIdenifier, remoteIdentifier, acctInfo.isRoleIDP());
                        tmpInfo.setAffiliation(acctInfo.getAffiliation());
                        this.returnMap.put("userID", this.userID);
                        this.returnMap.put("OldAccountKey", this.oldAcctKey);
                        if (this.oldAcctKey != null) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("Get OldAcctKet Name : " + this.oldAcctKey.getName() + "\nGet OldAcctKet Qualifier : " + this.oldAcctKey.getNameSpace());
                            }
                        } else {
                            FSUtils.debug.message("OldAccount Key is null");
                        }
                        this.returnMap.put("AccountKey", tmpKey);
                        this.returnMap.put("AccountInfo", tmpInfo);
                        this.returnMap.put("RegisSource", regisSource);
                        this.returnMap.put("RelayState", returnURL);
                    }
                    catch (FSAccountMgmtException e) {
                        return null;
                    }
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("calling of generateNameIdentifier Role : IdP ? " + acctInfo.isRoleIDP());
                }
                NameIdentifier nameIdentifier = this.generateNameIdentifier();
                if (acctInfo.getAffiliation() && (affiliationID = FSServiceUtils.getAffiliationID(this.realm, this.remoteEntityId)) != null) {
                    nameIdentifier.setNameQualifier(affiliationID);
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("New IDP nameIdentifier Name : " + nameIdentifier.getName() + "\nNew IDP nameIdentifier Qualifier :" + nameIdentifier.getNameQualifier() + "out of generateNameIdentifier*****");
                }
                IDPProvidedNameIdentifier newNameIdenifier = new IDPProvidedNameIdentifier(nameIdentifier.getName(), nameIdentifier.getNameQualifier(), nameIdentifier.getFormat());
                NameIdentifier remoteIdentifier = acctInfo.getRemoteNameIdentifier();
                NameIdentifier localIdentifier = acctInfo.getLocalNameIdentifier();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Old IDP nameIdentifier Name : " + localIdentifier.getName() + "\nOld IDP nameIdentifier Qualifier :" + localIdentifier.getNameQualifier());
                }
                FSUtils.debug.message("To set OldProvidedNameIdentifier");
                reqName.setOldProvidedNameIdentifier(new OldProvidedNameIdentifier(localIdentifier.getName(), localIdentifier.getNameQualifier(), localIdentifier.getFormat()));
                FSUtils.debug.message("To set IdpProvidedNameIdentifier");
                reqName.setIDPProvidedNameIdentifier(newNameIdenifier);
                if (remoteIdentifier != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("SP nameIdentifier Name : " + remoteIdentifier.getName() + "SP nameIdentifier Qualifier :" + remoteIdentifier.getNameQualifier());
                    }
                    SPProvidedNameIdentifier spNameIdentifier = new SPProvidedNameIdentifier(remoteIdentifier.getName(), remoteIdentifier.getNameQualifier(), remoteIdentifier.getFormat());
                    reqName.setSPProvidedNameIdentifier(spNameIdentifier);
                }
                try {
                    this.oldAcctKey = new FSAccountFedInfoKey(this.hostedEntityId, localIdentifier.getName());
                    FSAccountFedInfoKey tmpKey = new FSAccountFedInfoKey(nameIdentifier.getNameQualifier(), nameIdentifier.getName());
                    FSAccountFedInfo tmpInfo = new FSAccountFedInfo(this.remoteEntityId, (NameIdentifier)newNameIdenifier, remoteIdentifier, acctInfo.isRoleIDP());
                    this.returnMap.put("userID", this.userID);
                    this.returnMap.put("OldAccountKey", this.oldAcctKey);
                    this.returnMap.put("AccountKey", tmpKey);
                    this.returnMap.put("AccountInfo", tmpInfo);
                    this.returnMap.put("RegisSource", regisSource);
                    this.returnMap.put("RelayState", returnURL);
                    if (this.oldAcctKey != null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Get OldAcctKet Name : " + this.oldAcctKey.getName() + "\nGet OldAcctKet Qualifier: " + this.oldAcctKey.getNameSpace());
                        }
                    } else {
                        FSUtils.debug.message("OldAccount Key is null");
                    }
                }
                catch (FSAccountMgmtException e) {
                    return null;
                }
                reqName.setMinorVersion(FSServiceUtils.getMinorVersion(this.remoteDescriptor.getProtocolSupportEnumeration()));
                return reqName;
            }
            catch (SAMLException e) {
                if (!FSUtils.debug.messageEnabled()) break block31;
                FSUtils.debug.message("got SAMLException:", (Throwable)((Object)e));
            }
        }
        return null;
    }

    private boolean doCommonRegistration() {
        try {
            FSSessionManager sessManager;
            FSSession ssoSession;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("user id is " + this.userID);
                FSUtils.debug.message("To write account fed info to DS");
            }
            if (this.oldAcctKey != null) {
                String oldNameIDValue;
                FSAccountFedInfo oldInfo;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Old Account Key : " + this.oldAcctKey);
                }
                if ((oldInfo = this.managerInst.readAccountFedInfo(this.userID, this.remoteEntityId, oldNameIDValue = this.oldAcctKey.getName())) != null) {
                    this.managerInst.removeAccountFedInfo(this.userID, oldInfo);
                }
                this.managerInst.writeAccountFedInfo(this.userID, this.newAcctKey, this.newAcctInfo, this.oldAcctKey);
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Old Account Key : " + this.oldAcctKey);
                }
                if (this.acctInfo != null) {
                    this.managerInst.removeAccountFedInfo(this.userID, this.acctInfo);
                }
                this.managerInst.writeAccountFedInfo(this.userID, this.newAcctKey, this.newAcctInfo);
            }
            if (this.ssoToken != null && this.hostedProviderRole.equalsIgnoreCase("SP") && (ssoSession = (sessManager = FSSessionManager.getInstance(this.metaAlias)).getSession(this.ssoToken)) != null) {
                ssoSession.setAccountFedInfo(this.newAcctInfo);
            }
            return true;
        }
        catch (FSAccountMgmtException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Error when writing user information:", (Throwable)((Object)e));
            }
            return false;
        }
    }

    private NameIdentifier generateNameIdentifier() {
        try {
            FSUtils.debug.message("Entered FSNameRegistrationHandler::generateNameIdentifier");
            FSNameIdentifierHelper nameHelper = new FSNameIdentifierHelper(this.hostedConfig);
            String handleName = nameHelper.createNameIdentifier();
            if (handleName == null || handleName.trim().length() < 1) {
                FSUtils.debug.error("FSNameIdentifierHelper::createNameIdentifier returned null");
                return null;
            }
            FSUtils.debug.message("To set nameIdentifier");
            NameIdentifier nameIdentifier = new NameIdentifier(handleName, this.remoteEntityId);
            nameIdentifier.setFormat("urn:liberty:iff:nameid:federated");
            FSUtils.debug.message("completed set nameIdentifier");
            return nameIdentifier;
        }
        catch (SAMLException e) {
            String[] data = new String[]{FSUtils.bundle.getString("registration-failed-sp-name-identifier")};
            LogUtil.error(Level.INFO, "REGISTRATION_FAILED_SP_NAME_IDENTIFIER", data);
            return null;
        }
    }

    private void sendRegistrationResponse() {
        StringBuffer redirectURL = new StringBuffer();
        String retURL = this.remoteDescriptor.getRegisterNameIdentifierServiceReturnURL();
        redirectURL.append(retURL);
        if (this.regisResponse != null) {
            String urlEncodedRequest = null;
            try {
                urlEncodedRequest = this.regisResponse.toURLEncodedQueryString();
            }
            catch (FSMsgException e) {
                urlEncodedRequest = null;
            }
            if (urlEncodedRequest != null) {
                if (FSServiceUtils.isSigningOn()) {
                    String certAlias = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostedConfig, "signingCertAlias");
                    if (certAlias == null || certAlias.length() == 0) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSBrowserArtifactConsumerHandler:: signSAMLRequest:couldn't obtain this site's cert alias.");
                        }
                        urlEncodedRequest = null;
                    }
                    if (urlEncodedRequest != null) {
                        urlEncodedRequest = FSSignatureUtil.signAndReturnQueryString(urlEncodedRequest, certAlias);
                    }
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("URLEncodedRequest to be sent : " + urlEncodedRequest);
                }
                if (urlEncodedRequest != null) {
                    if (redirectURL.toString().indexOf(63) == -1) {
                        redirectURL.append('?');
                    } else {
                        redirectURL.append('&');
                    }
                    redirectURL.append(urlEncodedRequest);
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSNameRegistrationHandler::Redirect URL is " + redirectURL.toString());
                    }
                }
            }
        }
        try {
            this.response.sendRedirect(redirectURL.toString());
            return;
        }
        catch (IOException e) {
            FSUtils.debug.error("Error in sending registration response");
            return;
        }
    }

    private void callPostRegisterNameIdentifierSuccess(HttpServletRequest request, HttpServletResponse response, String userID, FSNameRegistrationRequest regRequest, FSNameRegistrationResponse regResponse, String regProfile) {
        FederationSPAdapter spAdapter = FSServiceUtils.getSPAdapter(this.hostedEntityId, this.hostedConfig);
        if (spAdapter != null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("processRegResponse, call postRegisterNameIdentifier success");
            }
            try {
                spAdapter.postRegisterNameIdentifierSuccess(this.hostedEntityId, request, response, userID, regRequest, regResponse, regProfile);
            }
            catch (Exception e) {
                FSUtils.debug.error("postRegisterNameIdentifierSuccess." + regProfile, (Throwable)e);
            }
        }
    }
}

