/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.logout;

import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.key.KeyUtil;
import com.sun.identity.federation.message.FSLogoutNotification;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.plugins.FederationSPAdapter;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.logout.FSLogoutUtil;
import com.sun.identity.federation.services.logout.FSPreLogoutHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.liberty.ws.meta.jaxb.IDPDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.ProviderDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSProcessLogoutServlet
extends HttpServlet {
    private static IDFFMetaManager metaManager = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        FSUtils.debug.message("FSProcessLogoutServlet Initializing...");
        metaManager = FSUtils.getIDFFMetaManager();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetPost(request, response);
    }

    private void doGetPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String sourceCheck;
        FSUtils.debug.message("FSProcessLogoutServlet doGetPost...");
        String providerAlias = request.getParameter("metaAlias");
        if (providerAlias == null || providerAlias.length() == 0) {
            providerAlias = FSServiceUtils.getMetaAlias(request);
        }
        if (providerAlias == null || providerAlias.length() < 1) {
            FSUtils.debug.error("Unable to retrieve alias, Hosted Provider. Cannot process request");
            response.sendError(500, FSUtils.bundle.getString("aliasNotFound"));
            return;
        }
        if (metaManager == null) {
            FSUtils.debug.error("Cannot retrieve hosted descriptor. Cannot process request");
            response.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        String realm = IDFFMetaUtils.getRealmByMetaAlias(providerAlias);
        ProviderDescriptorType hostedProviderDesc = null;
        BaseConfigType hostedConfig = null;
        String hostedRole = null;
        String hostedEntityId = null;
        try {
            hostedRole = metaManager.getProviderRoleByMetaAlias(providerAlias);
            hostedEntityId = metaManager.getEntityIDByMetaAlias(providerAlias);
            if (hostedRole != null) {
                if (hostedRole.equalsIgnoreCase("IDP")) {
                    hostedProviderDesc = metaManager.getIDPDescriptor(realm, hostedEntityId);
                    hostedConfig = metaManager.getIDPDescriptorConfig(realm, hostedEntityId);
                } else if (hostedRole.equalsIgnoreCase("SP")) {
                    hostedProviderDesc = metaManager.getSPDescriptor(realm, hostedEntityId);
                    hostedConfig = metaManager.getSPDescriptorConfig(realm, hostedEntityId);
                }
            }
            if (hostedProviderDesc == null) {
                throw new IDFFMetaException((String)null);
            }
        }
        catch (IDFFMetaException eam) {
            FSUtils.debug.error("Unable to find Hosted Provider. not process request", (Throwable)((Object)eam));
            response.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        String logoutDoneURL = FSServiceUtils.getLogoutDonePageURL(request, hostedConfig, providerAlias);
        String commonErrorPage = FSServiceUtils.getErrorPageURL(request, hostedConfig, providerAlias);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("logoutDoneURL : " + logoutDoneURL + "\ncommonErrorPage : " + commonErrorPage);
        }
        if ((sourceCheck = (String)request.getAttribute("logoutSource")) == null) {
            sourceCheck = request.getParameter("logoutSource");
        }
        Object ssoToken = this.getValidToken(request);
        String userID = null;
        if (ssoToken == null) {
            if (sourceCheck != null) {
                if (sourceCheck.equalsIgnoreCase("local")) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSProcessLogoutServlet, control where Source is local");
                    }
                    FSServiceUtils.returnLocallyAfterOperation(response, logoutDoneURL, false, "logoutSuccess", "noSession");
                    return;
                }
                if (sourceCheck.equalsIgnoreCase("remote")) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Control where Source is remote - not from applink but from other provider");
                    }
                    FSServiceUtils.returnLocallyAfterOperation(response, logoutDoneURL, true, "logoutSuccess", "logoutFailure");
                    return;
                }
                if (sourceCheck.equalsIgnoreCase("logoutGet")) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Control where Source is Http Get action - not from app link ");
                    }
                    FSServiceUtils.returnLocallyAfterOperation(response, logoutDoneURL, true, "logoutSuccess", "logoutFailure");
                    return;
                }
            }
        } else {
            block33: {
                try {
                    userID = SessionManager.getProvider().getPrincipalName(ssoToken);
                }
                catch (SessionException ssoExp) {
                    if (!FSUtils.debug.messageEnabled()) break block33;
                    FSUtils.debug.message("Couldn't get user object:", (Throwable)((Object)ssoExp));
                }
            }
            if (sourceCheck != null) {
                if (sourceCheck.equalsIgnoreCase("local")) {
                    FSUtils.debug.message("Control where Source is local -  from applink");
                    this.doLogoutInitiation(request, response, hostedProviderDesc, hostedConfig, realm, hostedEntityId, hostedRole, providerAlias, ssoToken, logoutDoneURL, sourceCheck);
                    return;
                }
                if (sourceCheck.equalsIgnoreCase("remote")) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Control where Source is remote - not from applink but from other provider. Token valid");
                    }
                    this.doLogoutInitiation(request, response, hostedProviderDesc, hostedConfig, realm, hostedEntityId, hostedRole, providerAlias, ssoToken, logoutDoneURL, sourceCheck);
                    return;
                }
                if (sourceCheck.equalsIgnoreCase("logoutGet")) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Control where Source is Http Get action - not from applink. Initiation will take care in preLogouthandler ");
                    }
                    this.doLogoutInitiation(request, response, hostedProviderDesc, hostedConfig, realm, hostedEntityId, hostedRole, providerAlias, ssoToken, logoutDoneURL, sourceCheck);
                    return;
                }
            }
        }
        FSLogoutNotification logoutObj = null;
        try {
            logoutObj = FSLogoutNotification.parseURLEncodedRequest(request);
        }
        catch (FSMsgException e) {
            FSUtils.debug.message("Bad Logout request. calling showErrorPage");
            FSServiceUtils.showErrorPage(response, commonErrorPage, "logout-request-improper", "logout-failed");
            return;
        }
        if (logoutObj == null) {
            FSUtils.debug.message("Bad Logout request. calling showErrorPage");
            FSServiceUtils.showErrorPage(response, commonErrorPage, "logout-request-improper", "logout-failed");
        } else {
            this.doRequestProcessing(request, response, hostedProviderDesc, hostedConfig, hostedRole, realm, hostedEntityId, providerAlias, logoutObj, commonErrorPage, userID);
        }
    }

    private Object getValidToken(HttpServletRequest request) {
        FSUtils.debug.message("Entered FSProcessLogoutServlet::getValidToken");
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            Object ssoToken = sessionProvider.getSession(request);
            if (ssoToken == null || !sessionProvider.isValid(ssoToken)) {
                FSUtils.debug.message("session is not valid, redirecting for authentication");
                return null;
            }
            return ssoToken;
        }
        catch (SessionException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("SessionException caught: " + (Object)((Object)e));
            }
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRequestProcessing(HttpServletRequest request, HttpServletResponse response, ProviderDescriptorType hostedDescriptor, BaseConfigType hostedConfig, String hostedRole, String realm, String hostedEntityId, String metaAlias, FSLogoutNotification reqLogout, String commonErrorPage, String userID) {
        String errorStatus;
        void var14_17;
        int minorVersion;
        block20: {
            block21: {
                FSUtils.debug.message("Entered FSProcessLogoutServlet::doRequestProcessing");
                minorVersion = reqLogout.getMinorVersion();
                String remoteEntityId = reqLogout.getProviderId();
                ProviderDescriptorType providerDescriptorType = null;
                boolean isIDP = false;
                try {
                    if (hostedRole != null) {
                        if (hostedRole.equalsIgnoreCase("IDP")) {
                            SPDescriptorType sPDescriptorType = metaManager.getSPDescriptor(realm, remoteEntityId);
                        } else if (hostedRole.equalsIgnoreCase("SP")) {
                            IDPDescriptorType iDPDescriptorType = metaManager.getIDPDescriptor(realm, remoteEntityId);
                            isIDP = true;
                        }
                    }
                    if (var14_17 == null) {
                        throw new IDFFMetaException((String)null);
                    }
                }
                catch (IDFFMetaException e) {
                    FSUtils.debug.error("Remote provider metadata not found.");
                    String[] data = new String[]{remoteEntityId, realm};
                    LogUtil.error(Level.INFO, "INVALID_PROVIDER", data);
                    FSLogoutUtil.returnToSource(response, providerDescriptorType, "samlp:Responder", commonErrorPage, minorVersion, hostedConfig, hostedEntityId, userID);
                    return;
                }
                boolean bVerify = true;
                if (FSServiceUtils.isSigningOn()) {
                    try {
                        FSUtils.debug.message("Calling verifyLogoutSignature");
                        bVerify = this.verifyLogoutSignature(request, (ProviderDescriptorType)var14_17, remoteEntityId, isIDP);
                    }
                    catch (FSException e) {
                        FSUtils.debug.error("FSProcessLogoutServlet::doRequestProcessing Signature on Logout request is invalidCannot proceed federation Logout");
                        String[] data = new String[]{userID};
                        LogUtil.error(Level.INFO, "INVALID_SIGNATURE", data);
                        FSLogoutUtil.returnToSource(response, (ProviderDescriptorType)var14_17, "samlp:Requester", commonErrorPage, minorVersion, hostedConfig, hostedEntityId, userID);
                        return;
                    }
                    catch (SAMLException e) {
                        FSUtils.debug.error("FSProcessLogoutServlet::doRequestProcessing(SAML) Signature on Logout request is invalidCannot proceed federation Logout");
                        String[] data = new String[]{userID};
                        LogUtil.error(Level.INFO, "INVALID_SIGNATURE", data);
                        FSLogoutUtil.returnToSource(response, (ProviderDescriptorType)var14_17, "samlp:Requester", commonErrorPage, minorVersion, hostedConfig, hostedEntityId, userID);
                        return;
                    }
                }
                errorStatus = "samlp:Responder";
                if (!bVerify) break block21;
                if (metaManager.isTrustedProvider(realm, hostedEntityId, remoteEntityId)) {
                    Object ssoToken = this.getValidToken(request);
                    if (ssoToken != null) {
                        FSServiceManager instSManager = FSServiceManager.getInstance();
                        if (instSManager != null) {
                            FSUtils.debug.message("FSServiceManager Instance not null");
                            this.callPreSingleLogoutProcess(request, response, hostedRole, hostedConfig, hostedEntityId, userID, reqLogout);
                            FSPreLogoutHandler handlerObj = instSManager.getPreLogoutHandler();
                            if (handlerObj != null) {
                                handlerObj.setLogoutRequest(reqLogout);
                                handlerObj.setHostedDescriptor(hostedDescriptor);
                                handlerObj.setHostedDescriptorConfig(hostedConfig);
                                handlerObj.setRealm(realm);
                                handlerObj.setHostedEntityId(hostedEntityId);
                                handlerObj.setHostedProviderRole(hostedRole);
                                handlerObj.setMetaAlias(metaAlias);
                                handlerObj.setRemoteEntityId(remoteEntityId);
                                handlerObj.setRemoteDescriptor((ProviderDescriptorType)var14_17);
                                handlerObj.processHttpSingleLogoutRequest(request, response, ssoToken);
                                return;
                            }
                            break block20;
                        } else {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSServiceManager Instance null. Cannot continue logout");
                            }
                            String[] data = new String[]{userID};
                            LogUtil.error(Level.INFO, "LOGOUT_FAILED", data);
                            FSLogoutUtil.returnToSource(response, (ProviderDescriptorType)var14_17, "samlp:Responder", commonErrorPage, minorVersion, hostedConfig, hostedEntityId, userID);
                            return;
                        }
                    }
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Invalid session in request processing. Nothing to logout");
                    }
                    if ((userID = FSLogoutUtil.getUserFromRequest(reqLogout, realm, hostedEntityId, hostedRole, hostedConfig, metaAlias)) != null) {
                        FSLogoutUtil.destroyPrincipalSession(userID, metaAlias, reqLogout.getSessionIndex(), request, response);
                        FSLogoutUtil.returnToSource(response, (ProviderDescriptorType)var14_17, "samlp:Responder", commonErrorPage, minorVersion, hostedConfig, hostedEntityId, userID);
                        return;
                    }
                    break block20;
                } else {
                    FSUtils.debug.error("Remote provider not in trusted list");
                }
                break block20;
            }
            FSUtils.debug.error("FSProcessLogoutServlet::doRequestProcesing Signature on Logout request is invalidCannot proceed federation Logout");
            String[] data = new String[]{userID};
            LogUtil.error(Level.INFO, "INVALID_SIGNATURE", data);
            errorStatus = "samlp:Requester";
        }
        FSLogoutUtil.returnToSource(response, (ProviderDescriptorType)var14_17, errorStatus, commonErrorPage, minorVersion, hostedConfig, hostedEntityId, userID);
    }

    private void doLogoutInitiation(HttpServletRequest request, HttpServletResponse response, ProviderDescriptorType hostedDescriptor, BaseConfigType hostedConfig, String realm, String hostedEntityId, String hostedRole, String metaAlias, Object ssoToken, String logoutDoneURL, String sourceCheck) {
        FSUtils.debug.message("FSProcessLogoutServlet::doLogoutInitiation");
        FSServiceManager instSManager = FSServiceManager.getInstance();
        String relayState = request.getParameter("RelayState");
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSProcessLogoutServlet.doLogoutInit: relay=" + relayState);
        }
        if (instSManager != null) {
            FSUtils.debug.message("FSServiceManager Instance not null");
            FSPreLogoutHandler handlerObj = instSManager.getPreLogoutHandler();
            if (handlerObj != null) {
                handlerObj.setHostedDescriptor(hostedDescriptor);
                handlerObj.setHostedDescriptorConfig(hostedConfig);
                handlerObj.setRealm(realm);
                handlerObj.setHostedEntityId(hostedEntityId);
                handlerObj.setHostedProviderRole(hostedRole);
                handlerObj.setMetaAlias(metaAlias);
                handlerObj.setRelayState(relayState);
                handlerObj.handleSingleLogout(request, response, ssoToken, sourceCheck);
                return;
            }
            FSUtils.debug.error("FSPreLogoutHandler is null.Cannot continue logout");
            String[] data = new String[]{logoutDoneURL};
            LogUtil.error(Level.INFO, "LOGOUT_FAILED_INVALID_HANDLER", data);
        } else {
            FSUtils.debug.message("FSServiceManager Instance null. Cannot continue logout");
        }
        FSServiceUtils.returnLocallyAfterOperation(response, logoutDoneURL, false, "logoutSuccess", "logoutFailure");
    }

    private boolean verifyLogoutSignature(HttpServletRequest request, ProviderDescriptorType remoteDescriptor, String remoteEntityId, boolean isIDP) throws SAMLException, FSException {
        FSUtils.debug.message("Entered FSProcessLogoutServlet::verifyLogoutSignature");
        X509Certificate cert = KeyUtil.getVerificationCert(remoteDescriptor, remoteEntityId, isIDP);
        if (cert == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSProcessLogoutServlet.verifyLogoutSignature: couldn't obtain this site's cert.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert"));
        }
        boolean isValidSign = FSSignatureUtil.verifyRequestSignature(request, cert);
        if (!isValidSign) {
            FSUtils.debug.error("Logout request is not properly signed");
            return false;
        }
        FSUtils.debug.message("Logout request is properly signed");
        return true;
    }

    private void callPreSingleLogoutProcess(HttpServletRequest request, HttpServletResponse response, String hostedRole, BaseConfigType hostedConfig, String hostedEntityId, String userID, FSLogoutNotification reqLogout) {
        FederationSPAdapter spAdapter;
        if (hostedRole != null && hostedRole.equalsIgnoreCase("SP") && (spAdapter = FSServiceUtils.getSPAdapter(hostedEntityId, hostedConfig)) != null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSProcessLogoutServlet, call preSingleLogoutProcess");
            }
            try {
                spAdapter.preSingleLogoutProcess(hostedEntityId, request, response, userID, reqLogout, null, "http://projectliberty.org/profiles/slo-idp-http");
            }
            catch (Exception e) {
                FSUtils.debug.error("preSingleLogoutProcess.IDP/HTTP", (Throwable)e);
            }
        }
    }
}

