/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.logout;

import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.message.FSLogoutNotification;
import com.sun.identity.federation.message.FSLogoutResponse;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.FSSessionPartner;
import com.sun.identity.federation.services.logout.FSReturnSessionManager;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.liberty.ws.meta.jaxb.AffiliationDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.ProviderDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.multiprotocol.MultiProtocolUtils;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.common.SAMLResponderException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSLogoutUtil {
    static IDFFMetaManager metaManager = null;

    protected static boolean destroyPrincipalSession(String userID, String metaAlias, String sessionIndex, HttpServletRequest request, HttpServletResponse response) {
        Vector sessionObjList;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered destroyPrincipalSession for user : " + userID + " SessionIndex = " + sessionIndex);
        }
        if ((sessionObjList = FSLogoutUtil.getSessionObjectList(userID, metaAlias, sessionIndex)) == null) {
            return false;
        }
        FSLogoutUtil.invalidateActiveSessionIds(sessionObjList, request, response);
        FSSession session = null;
        if (sessionIndex != null && sessionObjList != null && sessionObjList.size() == 1) {
            session = (FSSession)sessionObjList.elementAt(0);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("To call cleanSessionMap for user : " + userID);
        }
        FSLogoutUtil.cleanSessionMap(userID, metaAlias, session);
        return true;
    }

    protected static boolean destroyLocalSession(Object ssoToken, HttpServletRequest request, HttpServletResponse response) {
        try {
            FSUtils.debug.message("FSLogoutUtil.destroyLocalSession, enter");
            SessionProvider sessionProvider = SessionManager.getProvider();
            if (sessionProvider.isValid(ssoToken)) {
                MultiProtocolUtils.invalidateSession(ssoToken, request, response, "idff");
            }
            FSUtils.debug.message("FSLogoutUtil.destroyLocalSession, deleted");
            return true;
        }
        catch (SessionException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("SessionException in destroyLocalSession", (Throwable)((Object)e));
            }
            return false;
        }
    }

    private static void invalidateActiveSessionIds(Vector sessionObjList, HttpServletRequest request, HttpServletResponse response) {
        FSUtils.debug.message("FSLogoutUtil.invalidateActiveSessionIds, start");
        if (sessionObjList != null && !sessionObjList.isEmpty()) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message(sessionObjList.size() + " Active Session exists");
            }
            SessionProvider sessionProvider = null;
            try {
                sessionProvider = SessionManager.getProvider();
            }
            catch (SessionException se) {
                FSUtils.debug.error("invalidateActiveSessionIds:Couldn't obtain session provider:", (Throwable)((Object)se));
                return;
            }
            for (int i = 0; i < sessionObjList.size(); ++i) {
                String sessionId = ((FSSession)sessionObjList.elementAt(i)).getSessionID();
                if (sessionId == null) continue;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("To Invalidate session : " + sessionId);
                }
                try {
                    Object ssoToken = sessionProvider.getSession(sessionId);
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Destroying token : " + sessionProvider.getPrincipalName(ssoToken));
                    }
                    MultiProtocolUtils.invalidateSession(ssoToken, request, response, "idff");
                    if (!FSUtils.debug.messageEnabled()) continue;
                    FSUtils.debug.message("Completed Destroying token for sessionID :" + sessionId);
                    continue;
                }
                catch (SessionException e) {
                    FSUtils.debug.error("invalidateActiveSessionIds : " + sessionId + " - ", (Throwable)((Object)e));
                }
            }
        } else {
            FSUtils.debug.message("No active Session exists");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Vector getSessionObjectList(String userDn, String metaAlias, String sessionIndex) {
        FSSessionManager sessionMgr;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered getSessionObjectList for user : " + userDn);
        }
        Vector<FSSession> retList = new Vector<FSSession>();
        FSSessionManager fSSessionManager = sessionMgr = FSSessionManager.getInstance(metaAlias);
        synchronized (fSSessionManager) {
            List sessionList = sessionMgr.getSessionList(userDn);
            if (sessionList != null) {
                FSUtils.debug.message("Session list is not null");
                Iterator iter = sessionList.iterator();
                while (iter.hasNext()) {
                    FSSession sessionObj = (FSSession)iter.next();
                    if (sessionIndex != null && sessionIndex.equals(sessionObj.getSessionIndex())) {
                        Vector<FSSession> destroySessObj = new Vector<FSSession>();
                        destroySessObj.addElement(sessionObj);
                        return destroySessObj;
                    }
                    retList.addElement(sessionObj);
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Returning session list with number of elements = " + retList.size());
                }
                return retList;
            }
            FSUtils.debug.message("Session list is null");
            return null;
        }
    }

    public static void cleanSessionMapPartnerList(String userDN, String currentEntityId, String metaAlias, FSSession session) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("In cleanSessionMapPartnerList for user : " + userDN + "and provider : " + currentEntityId);
        }
        FSSessionManager sessionMgr = FSSessionManager.getInstance(metaAlias);
        sessionMgr.removeProvider(userDN, currentEntityId, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean cleanSessionMap(String userDn, String metaAlias, FSSession session) {
        FSSessionManager sessionMgr;
        FSUtils.debug.message("Entered cleanSessionMap");
        FSSessionManager fSSessionManager = sessionMgr = FSSessionManager.getInstance(metaAlias);
        synchronized (fSSessionManager) {
            if (session == null) {
                sessionMgr.removeSessionList(userDn);
            } else {
                sessionMgr.removeSession(userDn, session);
            }
        }
        FSUtils.debug.message("Leaving cleanSessionMap");
        return true;
    }

    protected static Object getValidToken(HttpServletRequest request) {
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            Object ssoToken = sessionProvider.getSession(request);
            if (ssoToken == null || !sessionProvider.isValid(ssoToken)) {
                FSUtils.debug.message("session is not valid,redirecting for authentication");
                return null;
            }
            return ssoToken;
        }
        catch (SessionException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("getValidToken: SessionException caught:", (Throwable)((Object)e));
            }
            return null;
        }
    }

    protected static FSAccountFedInfo getCurrentWorkingAccount(String userID, String entityID, String metaAlias) {
        try {
            FSAccountManager accountInst = FSAccountManager.getInstance(metaAlias);
            if (metaManager != null) {
                block10: {
                    try {
                        String realm = IDFFMetaUtils.getRealmByMetaAlias(metaAlias);
                        Set affiliates = metaManager.getAffiliateEntity(realm, entityID);
                        if (affiliates != null && !affiliates.isEmpty()) {
                            Iterator iter = affiliates.iterator();
                            while (iter.hasNext()) {
                                AffiliationDescriptorType desc = (AffiliationDescriptorType)iter.next();
                                String affiliationID = desc.getAffiliationID();
                                FSAccountFedInfo accountInfo = accountInst.readAccountFedInfo(userID, affiliationID);
                                if (accountInfo == null || !accountInfo.isFedStatusActive()) continue;
                                return accountInfo;
                            }
                        } else if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSLogoutUtil.getCurrentWorkingAccount: No affiliations");
                        }
                    }
                    catch (Exception ex) {
                        if (!FSUtils.debug.messageEnabled()) break block10;
                        FSUtils.debug.message("FSLogoutUtil.getCurrentWorkingAccount. No Affiliation for:" + entityID, (Throwable)ex);
                    }
                }
                FSAccountFedInfo acctInfo = accountInst.readAccountFedInfo(userID, entityID);
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSLogoutUtil::getCurrentWorkingAccount after readAccountFedInfo");
                }
                return acctInfo;
            }
            return null;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSLogoutUtil::getCurrentWorkingAccount readAccountFedInfo failed", (Throwable)e);
            return null;
        }
    }

    protected static HashMap getCurrentProvider(String userID, String metaAlias) {
        return FSLogoutUtil.getCurrentProvider(userID, metaAlias, null);
    }

    public static HashMap getCurrentProvider(String userID, String metaAlias, Object ssoToken) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered getCurrentProvider for user : " + userID);
        }
        HashMap<String, Object> providerMap = new HashMap<String, Object>();
        try {
            FSSessionManager sessionMgr = FSSessionManager.getInstance(metaAlias);
            FSSession session = sessionMgr.getSession(ssoToken);
            if (session != null) {
                List partners = session.getSessionPartners();
                if (partners != null && !partners.isEmpty()) {
                    Iterator iter = partners.iterator();
                    FSSessionPartner sessionPartner = (FSSessionPartner)iter.next();
                    providerMap.put("PartnerSession", sessionPartner);
                    providerMap.put("SessionIndex", session.getSessionIndex());
                    return providerMap;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSLogoutUtil.getCurrentProvider:No more session partners");
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSLogoutUtil.getCurrentProvider:: Exception in getting the current provider", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean liveConnectionsExist(String userID, String metaAlias) {
        FSSessionManager sessionMgr;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered liveConnectionsExist for user : " + userID);
        }
        FSSessionManager fSSessionManager = sessionMgr = FSSessionManager.getInstance(metaAlias);
        synchronized (fSSessionManager) {
            FSUtils.debug.message("About to call getSessionList");
            List sessionList = sessionMgr.getSessionList(userID);
            if (sessionList != null && !sessionList.isEmpty()) {
                FSUtils.debug.message("List is not empty");
                Iterator iSessionIter = sessionList.iterator();
                FSSession sessionObj = null;
                while (iSessionIter.hasNext()) {
                    sessionObj = (FSSession)iSessionIter.next();
                    if (sessionObj.getSessionPartners().isEmpty()) continue;
                    return true;
                }
                return false;
            }
            FSUtils.debug.message("List is  empty");
            return false;
        }
    }

    protected static boolean cleanSessionMapProviders(String userID, Vector sessionList, String metaAlias) {
        if (sessionList != null) {
            for (int i = 0; i < sessionList.size(); ++i) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("cleaning provider " + (String)sessionList.elementAt(i) + " from session map");
                }
                FSLogoutUtil.cleanSessionMapPartnerList(userID, (String)sessionList.elementAt(i), metaAlias, null);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static HashMap getLogoutGETProviders(String userID, String entityId, String sessionIndex, String realm, String metaAlias) {
        try {
            FSSessionManager sessionMgr;
            FSUtils.debug.message("Entered FSLogoutUtil::getLogoutGETProviders");
            HashMap<String, Cloneable> retMap = new HashMap<String, Cloneable>();
            Vector<String> providerVector = new Vector<String>();
            HashMap<String, String> sessionProvider = new HashMap<String, String>();
            providerVector.addElement(entityId);
            sessionProvider.put(entityId, sessionIndex);
            FSSessionManager fSSessionManager = sessionMgr = FSSessionManager.getInstance(metaAlias);
            synchronized (fSSessionManager) {
                FSUtils.debug.message("About to call getSessionList");
                List sessionList = sessionMgr.getSessionList(userID);
                if (sessionList != null && !sessionList.isEmpty()) {
                    FSUtils.debug.message("Session List is not empty");
                    Iterator iSessionIter = sessionList.iterator();
                    while (iSessionIter.hasNext()) {
                        FSSession sessionObj = (FSSession)iSessionIter.next();
                        if (sessionObj.getSessionPartners().isEmpty()) continue;
                        String nSessionIndex = sessionObj.getSessionIndex();
                        List sessionPartners = sessionObj.getSessionPartners();
                        Iterator iPartnerIter = sessionPartners.iterator();
                        while (iPartnerIter.hasNext()) {
                            List profiles;
                            String curEntityId;
                            SPDescriptorType curDesc;
                            FSSessionPartner sessionPartner = (FSSessionPartner)iPartnerIter.next();
                            if (sessionPartner.getIsRoleIDP() || (curDesc = metaManager.getSPDescriptor(realm, curEntityId = sessionPartner.getPartner())) == null || (profiles = curDesc.getSingleLogoutProtocolProfile()) == null || profiles.isEmpty() || !((String)profiles.iterator().next()).equals("http://projectliberty.org/profiles/slo-idp-http-get")) continue;
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("provider " + curEntityId + " Added for GET");
                            }
                            providerVector.addElement(curEntityId);
                            sessionProvider.put(curEntityId, nSessionIndex);
                        }
                    }
                } else if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Session List is  empty, returning current provider from getLogoutGETProviders");
                }
                retMap.put("Provider", providerVector);
                retMap.put("SessionIndex", sessionProvider);
                return retMap;
            }
        }
        catch (IDFFMetaException e) {
            FSUtils.debug.error("IDFFMetaException in function  getLogoutGETProviders", (Throwable)((Object)e));
            return null;
        }
    }

    public static String getUserFromRequest(FSLogoutNotification reqLogout, String realm, String hostedEntityId, String hostedRole, BaseConfigType hostedConfig, String metaAlias) {
        FSAccountManager accountInst = null;
        try {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Realm : " + realm + ", entityID : " + hostedEntityId);
            }
            accountInst = FSAccountManager.getInstance(metaAlias);
        }
        catch (FSAccountMgmtException fe) {
            FSUtils.debug.message("In FSAccountManagementException :: cannot get account manager:" + (Object)((Object)fe));
            return null;
        }
        try {
            String opaqueHandle = reqLogout.getNameIdentifier().getName().trim();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Name : " + opaqueHandle);
            }
            String associatedDomain = reqLogout.getNameIdentifier().getNameQualifier().trim();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Name Qualifier : " + associatedDomain);
            }
            if (associatedDomain == null || associatedDomain.length() == 0 || associatedDomain.equals(reqLogout.getProviderId())) {
                associatedDomain = hostedEntityId;
            }
            FSAccountFedInfoKey acctkey = null;
            acctkey = hostedRole.equalsIgnoreCase("SP") ? new FSAccountFedInfoKey(associatedDomain, opaqueHandle) : new FSAccountFedInfoKey(reqLogout.getProviderId(), opaqueHandle);
            HashMap<String, FSLogoutNotification> env = new HashMap<String, FSLogoutNotification>();
            env.put("FSLogoutNotification", reqLogout);
            String userID = accountInst.getUserID(acctkey, realm, env);
            if (userID == null) {
                acctkey = hostedRole.equalsIgnoreCase("SP") ? new FSAccountFedInfoKey(reqLogout.getProviderId(), opaqueHandle) : new FSAccountFedInfoKey(associatedDomain, opaqueHandle);
                userID = accountInst.getUserID(acctkey, realm, env);
            }
            if (userID == null) {
                FSUtils.debug.message("UserID is null");
                return null;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("user id is " + userID);
            }
            return userID;
        }
        catch (FSAccountMgmtException e) {
            FSUtils.debug.message("In FSAccountMgmtException :: ", (Throwable)((Object)e));
            return null;
        }
    }

    public static void removeTokenFromSession(Object token, String metaAlias) {
        FSSessionManager sessionMgr;
        FSSession currentSession;
        String univId = "";
        String tokenId = "";
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            univId = sessionProvider.getPrincipalName(token);
            tokenId = sessionProvider.getSessionID(token);
        }
        catch (SessionException e) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("SessionException in removeTokenFromSession", (Throwable)((Object)e));
            }
            return;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered removeTokenFromSession for user: " + univId);
        }
        if ((currentSession = (sessionMgr = FSSessionManager.getInstance(metaAlias)).getSession(univId, tokenId)) != null) {
            sessionMgr.removeSession(univId, currentSession);
        }
    }

    private static String buildSignedResponse(String retURL, String bArgStatus, int minorVersion, BaseConfigType hostedConfig, String hostedEntityId, String userID) {
        try {
            String inResponseTo = "";
            String logoutStatus = "";
            String relayState = "";
            FSLogoutResponse responseLogout = new FSLogoutResponse();
            responseLogout.setID("logout-sig-ID");
            if (userID != null) {
                FSReturnSessionManager mngInst = FSReturnSessionManager.getInstance(hostedConfig.getMetaAlias());
                HashMap providerMap = new HashMap();
                if (mngInst != null) {
                    providerMap = mngInst.getUserProviderInfo(userID);
                }
                if (providerMap != null) {
                    inResponseTo = (String)providerMap.get("responseTo");
                    relayState = (String)providerMap.get("RelayState");
                    logoutStatus = (String)providerMap.get("logoutStatus");
                    inResponseTo = (String)providerMap.get("responseTo");
                    mngInst.removeUserProviderInfo(userID);
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Deleted " + userID + " from return list");
                    }
                    responseLogout.setResponseTo(inResponseTo);
                    responseLogout.setRelayState(relayState);
                    responseLogout.setProviderId(hostedEntityId);
                    responseLogout.setStatus(logoutStatus);
                } else {
                    responseLogout.setStatus(bArgStatus);
                    responseLogout.setProviderId(hostedEntityId);
                }
            } else {
                responseLogout.setStatus(bArgStatus);
                responseLogout.setProviderId(hostedEntityId);
            }
            responseLogout.setMinorVersion(minorVersion);
            String urlEncodedResponse = responseLogout.toURLEncodedQueryString();
            if (FSServiceUtils.isSigningOn()) {
                String certAlias = IDFFMetaUtils.getFirstAttributeValueFromConfig(hostedConfig, "signingCertAlias");
                if (certAlias == null || certAlias.length() == 0) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSLogoutUtil::buildSignedResponse:couldn't obtain this site's cert alias.");
                    }
                    throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
                }
                urlEncodedResponse = FSSignatureUtil.signAndReturnQueryString(urlEncodedResponse, certAlias);
            }
            StringBuffer redirectURL = new StringBuffer();
            redirectURL.append(retURL);
            if (retURL.indexOf(63) == -1) {
                redirectURL.append('?');
            } else {
                redirectURL.append('&');
            }
            redirectURL.append(urlEncodedResponse);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutUtil : Response to be sent : " + redirectURL.toString());
            }
            return redirectURL.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static void returnToSource(HttpServletResponse response, ProviderDescriptorType remoteDescriptor, String bLogoutStatus, String commonErrorPage, int minorVersion, BaseConfigType hostedConfig, String hostedEntityId, String userID) {
        try {
            String retURL = null;
            if (remoteDescriptor != null) {
                retURL = remoteDescriptor.getSingleLogoutServiceReturnURL();
                if (retURL == null || retURL.length() < 1) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("returnToSource returns sendErroras source provider is unknown");
                    }
                    FSServiceUtils.showErrorPage(response, commonErrorPage, "logout-failed", "metadata-error-check");
                    return;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("returnToSource returns URL : " + retURL);
                }
                String responseURL = FSLogoutUtil.buildSignedResponse(retURL, bLogoutStatus, minorVersion, hostedConfig, hostedEntityId, userID);
                response.sendRedirect(responseURL);
                return;
            }
            FSUtils.debug.message("Meta Manager instance is null");
            response.sendError(500, FSUtils.bundle.getString("unableToReturnToSource"));
            return;
        }
        catch (IOException exx) {
            FSUtils.debug.error("Redirect/sendError failed. Control halted", (Throwable)exx);
            return;
        }
    }

    protected static void sendErrorPage(HttpServletRequest request, HttpServletResponse response, String providerAlias) {
        try {
            String retURL = "";
            String realm = IDFFMetaUtils.getRealmByMetaAlias(providerAlias);
            if (metaManager != null) {
                String hostedRole = metaManager.getProviderRoleByMetaAlias(providerAlias);
                String hostedEntityId = metaManager.getEntityIDByMetaAlias(providerAlias);
                BaseConfigType hostedConfig = null;
                if (hostedEntityId != null && "IDP".equalsIgnoreCase(hostedRole)) {
                    hostedConfig = metaManager.getIDPDescriptorConfig(realm, hostedEntityId);
                } else if (hostedEntityId != null && "SP".equalsIgnoreCase(hostedRole)) {
                    hostedConfig = metaManager.getSPDescriptorConfig(realm, hostedEntityId);
                }
                retURL = FSServiceUtils.getLogoutDonePageURL(request, hostedConfig, providerAlias);
                if (retURL == null || retURL.length() < 1) {
                    FSServiceUtils.showErrorPage(response, FSServiceUtils.getErrorPageURL(request, hostedConfig, providerAlias), "logout-failed", "metadata-error-check");
                } else {
                    StringBuffer finalReturnURL = new StringBuffer();
                    finalReturnURL.append(retURL);
                    char delimiter = retURL.indexOf(63) < 0 ? (char)'?' : '&';
                    finalReturnURL.append(delimiter).append("logoutStatus").append('=').append("logoutFailure");
                    response.sendRedirect(finalReturnURL.toString());
                }
                return;
            }
            FSUtils.debug.error("Meta manager instance is null");
            response.sendError(500, FSUtils.bundle.getString("failedToReadDataStore"));
            return;
        }
        catch (IOException ex) {
            FSUtils.debug.error("FSSingleLogoutServlet: IOException caught:", (Throwable)ex);
            return;
        }
        catch (IDFFMetaException e) {
            FSUtils.debug.error("FSSingleLogoutServlet:IDFFMetaException:", (Throwable)((Object)e));
            return;
        }
    }

    public static void removeCurrentSessionPartner(String metaAlias, String remoteEntityId, Object ssoToken, String userID) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSLogoutUtil.removeCSP, hosted=" + metaAlias + ", remote=" + remoteEntityId + ", userID=" + userID);
        }
        FSSessionManager sessionManager = FSSessionManager.getInstance(metaAlias);
        FSSession session = sessionManager.getSession(ssoToken);
        FSLogoutUtil.cleanSessionMapPartnerList(userID, remoteEntityId, metaAlias, session);
    }

    public static boolean isIDPInitiatedProfile(String profile) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSLogoutUtil.isIDPInitiatedProfile: proto=" + profile);
        }
        return profile != null && (profile.equals("http://projectliberty.org/profiles/slo-idp-http") || profile.equals("http://projectliberty.org/profiles/slo-idp-soap") || profile.equals("http://projectliberty.org/profiles/slo-idp-http-get"));
    }

    static {
        metaManager = FSUtils.getIDFFMetaManager();
    }
}

