/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.message.FSAuthnResponseEnvelope;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.FSSOAPService;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.fednsso.FSSSOAndFedHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.encode.URLEncDec;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;

public class FSSSOLECPProfileHandler
extends FSSSOAndFedHandler {
    protected FSSSOLECPProfileHandler() {
    }

    public FSSSOLECPProfileHandler(HttpServletRequest request, HttpServletResponse response, FSAuthnRequest authnRequest, SPDescriptorType spDescriptor, BaseConfigType spConfig, String spEntityId, String relayState) {
        super(request, response, authnRequest, spDescriptor, spConfig, spEntityId, relayState);
    }

    public void processLECPAuthnRequest(FSAuthnRequest authnRequest) {
        this.processAuthnRequest(authnRequest, false);
    }

    public String formatLoginURL(String loginUrl, String authnContext) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOLECPProfileHandler.formatLoginURL: Called\nloginUrl=" + loginUrl + "\nauthnContext=" + authnContext);
        }
        try {
            int len;
            if (loginUrl == null) {
                FSUtils.debug.error("FSSSOLECPProfileHandler.formatLoginURL: ");
                return null;
            }
            String ssoUrl = this.hostedDesc.getSingleSignOnServiceURL();
            StringBuffer returnUrl = new StringBuffer(ssoUrl);
            if (ssoUrl.indexOf(63) == -1) {
                returnUrl.append("?");
            } else {
                returnUrl.append("&");
            }
            returnUrl.append("LECP").append("=").append("TRUE").append("&").append("Authn").append("=").append("true").append("&");
            if (!authnContext.equals("http://www.projectliberty.org/schemas/authctx/classes/Password")) {
                returnUrl.append("AuthnContext").append("=").append(URLEncDec.encode((String)authnContext)).append("&");
            }
            returnUrl.append("_liberty_idp").append("=").append(URLEncDec.encode((String)this.hostedEntityId)).append("&").append("realm").append("=").append(URLEncDec.encode((String)this.realm)).append("&").append("metaAlias").append("=").append(URLEncDec.encode((String)this.metaAlias)).append("&").append("RequestID").append("=").append(URLEncDec.encode((String)this.authnRequest.getRequestID()));
            StringBuffer gotoUrl = new StringBuffer("/postLogin");
            gotoUrl.append("/").append("metaAlias").append(this.metaAlias).append("/");
            FSSessionManager sessMgr = FSSessionManager.getInstance(this.metaAlias);
            String id = this.authnRequest.getRequestID();
            sessMgr.setRelayState(id, returnUrl.toString());
            gotoUrl.append("RelayState").append("/").append(URLEncDec.encode((String)id)).append("/").append("sso").append("/").append("true");
            StringBuffer redirectUrl = new StringBuffer(100);
            redirectUrl.append(loginUrl);
            if (loginUrl.indexOf(63) == -1) {
                redirectUrl.append("?");
            } else {
                redirectUrl.append("&");
            }
            redirectUrl.append("goto").append("=");
            redirectUrl.append(URLEncDec.encode((String)gotoUrl.toString())).append("&");
            String authUrl = FSUtils.getAuthDomainURL(this.realm);
            if (authUrl != null && authUrl.length() != 0) {
                redirectUrl.append("org").append("=").append(URLEncDec.encode((String)authUrl)).append("&");
            }
            if (redirectUrl.charAt(len = redirectUrl.length() - 1) == '&') {
                redirectUrl = redirectUrl.deleteCharAt(len);
            }
            return redirectUrl.toString();
        }
        catch (Exception e) {
            FSUtils.debug.error("FSSSOLECPProfileHandler.formatLoginURL: Exception: ", (Throwable)e);
            return null;
        }
    }

    protected void sendAuthnResponse(FSAuthnResponse authnResponse) {
        authnResponse.setProviderId(this.hostedEntityId);
        FSAuthnResponseEnvelope respEnvelope = new FSAuthnResponseEnvelope(authnResponse);
        respEnvelope.setMinorVersion(authnResponse.getMinorVersion());
        respEnvelope.setAssertionConsumerServiceURL(FSServiceUtils.getAssertionConsumerServiceURL(this.spDescriptor, null));
        FSSOAPService soapService = FSSOAPService.getInstance();
        SOAPMessage retMessage = null;
        try {
            retMessage = soapService.bind(respEnvelope.toXMLString(true, true));
        }
        catch (FSMsgException ex) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOLECPProfileHandler.sendAuthnResponse: ", (Throwable)((Object)ex));
            }
            this.response.setStatus(500);
            this.returnSOAPMessage(soapService.formSOAPError("Server", "cannotProcessRequest", null), this.response);
            return;
        }
        this.response.setHeader("Liberty-Enabled", this.request.getHeader("Liberty-Enabled"));
        this.response.setContentType("application/vnd.liberty-response+xml");
        if (FSServiceUtils.isSigningOn()) {
            try {
                List assList = authnResponse.getAssertion();
                Iterator iter = assList.iterator();
                while (iter.hasNext()) {
                    FSAssertion assertion = (FSAssertion)iter.next();
                    String id = assertion.getID();
                    Document doc = (Document)FSServiceUtils.createSOAPDOM(retMessage);
                    String certAlias = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostedConfig, "signingCertAlias");
                    if (certAlias == null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSSOLECPProfileHandler.sendAuthnResponse: couldn't obtain this site's cert alias.");
                        }
                        this.response.setStatus(500);
                        this.returnSOAPMessage(soapService.formSOAPError("Server", "cannotProcessRequest", null), this.response);
                        return;
                    }
                    XMLSignatureManager manager = XMLSignatureManager.getInstance();
                    int minorVersion = assertion.getMinorVersion();
                    if (minorVersion == 0) {
                        manager.signXML(doc, certAlias, SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.xmlSigAlgorithm"), "id", id, false);
                    } else if (minorVersion == 2 || minorVersion == 2) {
                        manager.signXML(doc, certAlias, SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.xmlSigAlgorithm"), "AssertionID", assertion.getAssertionID(), false);
                    } else {
                        FSUtils.debug.message("invalid minor version.");
                    }
                    retMessage = FSServiceUtils.convertDOMToSOAP(doc);
                }
            }
            catch (Exception e) {
                this.response.setStatus(500);
                this.returnSOAPMessage(soapService.formSOAPError("Server", "cannotProcessRequest", null), this.response);
                return;
            }
        }
        this.returnSOAPMessage(retMessage, this.response);
    }

    protected boolean doSingleSignOn(Object ssoToken, String inResponseTo, NameIdentifier opaqueHandle, NameIdentifier idpOpaqueHandle) {
        FSAuthnResponse authnResponse = this.createAuthnResponse(ssoToken, inResponseTo, opaqueHandle, idpOpaqueHandle);
        this.sendAuthnResponse(authnResponse);
        return true;
    }

    private void returnSOAPMessage(SOAPMessage msg, HttpServletResponse response) {
        try {
            if (msg != null) {
                response.setHeader("Liberty-Enabled", this.request.getHeader("Liberty-Enabled"));
                response.setContentType("application/vnd.liberty-response+xml");
                ServletOutputStream servletoutputstream = response.getOutputStream();
                msg.writeTo((OutputStream)servletoutputstream);
                servletoutputstream.flush();
                return;
            }
            response.flushBuffer();
            return;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSSOAPReceiver.returnSOAPMessage: Exception::", (Throwable)e);
            return;
        }
    }
}

