/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.fednsso.FSSSOAndFedHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;

public class FSSSOBrowserPostProfileHandler
extends FSSSOAndFedHandler {
    protected FSSSOBrowserPostProfileHandler() {
    }

    public FSSSOBrowserPostProfileHandler(HttpServletRequest request, HttpServletResponse response, FSAuthnRequest authnRequest, SPDescriptorType spDescriptor, BaseConfigType spConfig, String spEntityId, String relayState) {
        super(request, response, authnRequest, spDescriptor, spConfig, spEntityId, relayState);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOBrowserPostProfileHandler: Handler created to handle AuthnRequest");
        }
    }

    protected void sendAuthnResponse(FSAuthnResponse authnResponse) {
        FSUtils.debug.message("FSSSOBrowserPostProfileHandler.sendAuthnResponse: Called");
        try {
            authnResponse.setProviderId(this.hostedEntityId);
            Document doc = XMLUtils.toDOMDocument((String)authnResponse.toXMLString(true, true), (Debug)FSUtils.debug);
            if (FSServiceUtils.isSigningOn() || FSServiceUtils.isSigningOptional()) {
                List assList;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOBrowserPostProfileHandler.sendAuthnResponse: start signing assertions");
                }
                if ((assList = authnResponse.getAssertion()) != null) {
                    Iterator iter = assList.iterator();
                    while (iter.hasNext()) {
                        String certAlias;
                        FSAssertion assertion = (FSAssertion)iter.next();
                        String id = assertion.getID();
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSSOBrowserPostProfileHandler.sendAuthnResponse: id attr is" + id);
                        }
                        if ((certAlias = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostedConfig, "signingCertAlias")) == null) {
                            FSUtils.debug.error("SOAPReceiver.onMessage: couldn't obtain this site's cert alias.");
                            return;
                        }
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSSOBrowserPostProfileHandler.sendAuthnResponse: Site's certAlias is " + certAlias);
                        }
                        XMLSignatureManager manager = XMLSignatureManager.getInstance();
                        int minorVersion = assertion.getMinorVersion();
                        if (minorVersion == 0) {
                            manager.signXML(doc, certAlias, SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.xmlSigAlgorithm"), "id", id, false);
                        } else if (minorVersion == 2 || minorVersion == 2) {
                            manager.signXML(doc, certAlias, SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.xmlSigAlgorithm"), "AssertionID", assertion.getAssertionID(), false);
                        } else {
                            FSUtils.debug.message("invalid minor version.");
                        }
                        if (!FSUtils.debug.messageEnabled()) continue;
                        FSUtils.debug.message("FSSSOBrowserPostProfileHandler.sendAuthnResponse: SignatureManager finished signing ");
                    }
                }
            }
            String respStr = FSServiceUtils.printDocument(doc);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOBrowserPostProfileHandler.sendAuthnResponse: Signed AuthnResponse: " + respStr);
            }
            String b64Resp = Base64.encode((byte[])respStr.getBytes());
            String targetURL = FSServiceUtils.getAssertionConsumerServiceURL(this.spDescriptor, this.authnRequest.getAssertionConsumerServiceID());
            this.response.setContentType("text/html");
            PrintWriter out = this.response.getWriter();
            out.println("<HTML>");
            out.println("<BODY Onload=\"document.Response.submit()\">");
            out.println("<FORM NAME=\"Response\" METHOD=\"POST\" ACTION=\"" + targetURL + "\">");
            out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"LARES\" VALUE=\"" + b64Resp + "\"/>");
            out.println("</FORM>");
            out.println("</BODY></HTML>");
            out.close();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOBrowserPostProfileHandler:sendAuthnResponse: AuthnResponse sent successfully to: " + targetURL);
            }
            return;
        }
        catch (Exception ex) {
            FSUtils.debug.error("FSSSOBrowserPostProfileHandler:sendAuthnResponse:", (Throwable)ex);
            return;
        }
    }

    protected boolean doSingleSignOn(Object ssoToken, String inResponseTo, NameIdentifier spHandle, NameIdentifier idpHandle) {
        FSUtils.debug.message("FSSSOBrowserPostProfileHandler.doSingleSignOn: Called");
        FSAuthnResponse authnResponse = this.createAuthnResponse(ssoToken, inResponseTo, spHandle, idpHandle);
        try {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOBrowserPostProfileHandler.doSingleSignOn: AuthnResponse created: " + authnResponse.toXMLString());
            }
        }
        catch (FSException ex) {
            FSUtils.debug.error("FSSSOBrowserPostProfileHandler.doSingleSignOn: Created AuthnResponse is not valid: ", (Throwable)((Object)ex));
            return false;
        }
        if (authnResponse == null) {
            FSUtils.debug.error("FSSSOBrowserPostProfileHandler.doSingleSignOn: No valid AuthnResponse could be created. Sending error AuthnResponse");
            return false;
        }
        this.sendAuthnResponse(authnResponse);
        return true;
    }
}

