/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.services.fednsso.FSSSOAndFedHandler;
import com.sun.identity.federation.services.fednsso.FSSSOBrowserArtifactProfileHandler;
import com.sun.identity.federation.services.fednsso.FSSSOBrowserPostProfileHandler;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.saml.assertion.NameIdentifier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSProxyHandler
extends FSSSOAndFedHandler {
    public FSProxyHandler(HttpServletRequest request, HttpServletResponse response, FSAuthnRequest authnRequest, SPDescriptorType spDescriptor, BaseConfigType spConfig, String spEntityId, String relayState, Object ssoToken) {
        super(request, response, authnRequest, spDescriptor, spConfig, spEntityId, relayState, ssoToken);
    }

    public FSProxyHandler(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public boolean doSingleSignOn(Object ssoToken, String inResponseTo, NameIdentifier spNameIdentifier, NameIdentifier idpNameIdentifier) {
        FSUtils.debug.message("FSProxyHandler.doSingleSignOn:Init");
        String protocolProfile = this.authnRequest.getProtocolProfile();
        if (protocolProfile == null || protocolProfile.equals("http://projectliberty.org/profiles/brws-art")) {
            FSSSOBrowserArtifactProfileHandler handler = new FSSSOBrowserArtifactProfileHandler(this.request, this.response, this.authnRequest, this.spDescriptor, this.spConfig, this.spEntityId, this.relayState);
            handler.setHostedEntityId(this.hostedEntityId);
            handler.setHostedDescriptor(this.hostedDesc);
            handler.setHostedDescriptorConfig(this.hostedConfig);
            handler.setMetaAlias(this.metaAlias);
            handler.setRealm(this.realm);
            return handler.doSingleSignOn(ssoToken, inResponseTo, spNameIdentifier, idpNameIdentifier);
        }
        if (protocolProfile.equals("http://projectliberty.org/profiles/brws-post")) {
            FSSSOBrowserPostProfileHandler handler = new FSSSOBrowserPostProfileHandler(this.request, this.response, this.authnRequest, this.spDescriptor, this.spConfig, this.spEntityId, this.relayState);
            handler.setHostedEntityId(this.hostedEntityId);
            handler.setHostedDescriptor(this.hostedDesc);
            handler.setHostedDescriptorConfig(this.hostedConfig);
            handler.setMetaAlias(this.metaAlias);
            handler.setRealm(this.realm);
            return handler.doSingleSignOn(ssoToken, inResponseTo, spNameIdentifier, idpNameIdentifier);
        }
        FSUtils.debug.error("FSProxyHandler.doProxySingleSignOn:Unsupported protocol profile.");
        return false;
    }
}

