/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSRequest;
import com.sun.identity.federation.message.FSResponse;
import com.sun.identity.federation.message.FSSubject;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.plugins.FederationSPAdapter;
import com.sun.identity.federation.services.FSSOAPService;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.fednsso.FSAssertionArtifactHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.liberty.ws.meta.jaxb.IDPDescriptorType;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FSBrowserArtifactConsumerHandler
extends FSAssertionArtifactHandler {
    private FSRequest samlRequest = null;

    protected FSBrowserArtifactConsumerHandler() {
    }

    public FSBrowserArtifactConsumerHandler(HttpServletRequest request, HttpServletResponse response, IDPDescriptorType idpDescriptor, String idpEntityId, boolean doFederate, String nameIDPolicy, String relayState) {
        super(request, response, idpDescriptor, idpEntityId, doFederate, nameIDPolicy, relayState);
    }

    public FSBrowserArtifactConsumerHandler(HttpServletRequest request, HttpServletResponse response, IDPDescriptorType idpDescriptor, String idpEntityId, String relayState, FSRequest samlReq) {
        super(request, response, idpDescriptor, idpEntityId, false, null, relayState);
        this.samlRequest = samlReq;
        if (FSServiceUtils.getMinorVersion(idpDescriptor.getProtocolSupportEnumeration()) == 2) {
            this.samlRequest.setMinorVersion(1);
        } else {
            this.samlRequest.setMinorVersion(0);
        }
    }

    public void processSAMLRequest() {
        FSUtils.debug.message("FSBrowserArtifactConsumerHandler.processSAMLRequest: Called");
        String baseURL = FSServiceUtils.getBaseURL(this.request);
        String framedPageURL = FSServiceUtils.getCommonLoginPageURL(this.hostMetaAlias, this.relayState, null, this.request, baseURL);
        try {
            String[] data;
            SOAPMessage retMsg;
            FSSOAPService soapHelper = FSSOAPService.getInstance();
            this.samlRequest.setID(this.samlRequest.getRequestID());
            SOAPMessage msg = soapHelper.bind(this.samlRequest.toXMLString(true, true));
            if (FSServiceUtils.isSigningOn()) {
                Document doc = (Document)FSServiceUtils.createSOAPDOM(msg);
                IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
                if (metaManager == null) {
                    FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLRequest: could not create meta instance");
                    FSUtils.forwardRequest(this.request, this.response, framedPageURL);
                    return;
                }
                String certAlias = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostConfig, "signingCertAlias");
                if (certAlias == null) {
                    FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLRequest: couldn't obtain this site's cert alias.");
                    FSUtils.forwardRequest(this.request, this.response, framedPageURL);
                    return;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSBrowserArtifactConsumerHandler.processSAMLRequest: certAlias: " + certAlias);
                }
                XMLSignatureManager manager = XMLSignatureManager.getInstance();
                int minorVersion = this.samlRequest.getMinorVersion();
                if (minorVersion == 0) {
                    manager.signXML(doc, certAlias, SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.xmlSigAlgorithm"), "id", this.samlRequest.getID(), false);
                } else if (minorVersion == 1) {
                    manager.signXML(doc, certAlias, SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.xmlSigAlgorithm"), "RequestID", this.samlRequest.getRequestID(), false, "/Envelope/Body/Request/AssertionArtifact");
                } else {
                    FSUtils.debug.message("invalid minor version.");
                }
                msg = FSServiceUtils.convertDOMToSOAP(doc);
            }
            if ((retMsg = soapHelper.doSyncCall(this.response, msg, this.idpDescriptor, false)) == null) {
                FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLRequest: " + FSUtils.bundle.getString("invalidSOAPResponse") + " Response SOAPMessage is null");
                FSUtils.forwardRequest(this.request, this.response, framedPageURL);
                return;
            }
            this.samlResponseElt = soapHelper.parseSOAPMessage(retMsg);
            if (this.samlResponseElt != null && this.samlResponseElt.getLocalName().trim().equals("Fault")) {
                FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLRequest: " + FSUtils.bundle.getString("invalidSOAPResponse") + " SOAPFault occured");
                data = new String[]{FSUtils.bundle.getString("invalidSOAPResponse")};
                LogUtil.error(Level.INFO, "INVALID_SOAP_RESPONSE", data);
                FSUtils.forwardRequest(this.request, this.response, framedPageURL);
                return;
            }
            if (this.samlResponseElt != null && this.samlResponseElt.getLocalName().trim().equals("Response")) {
                this.samlResponse = new FSResponse(this.samlResponseElt);
                if (this.samlResponse == null) {
                    FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLRequest: " + FSUtils.bundle.getString("invalidSOAPResponse") + " Could not create SAML Response");
                    data = new String[]{FSUtils.bundle.getString("invalidSOAPResponse")};
                    LogUtil.error(Level.INFO, "INVALID_SOAP_RESPONSE", data);
                    FSUtils.forwardRequest(this.request, this.response, framedPageURL);
                    return;
                }
            } else {
                FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLRequest: " + FSUtils.bundle.getString("invalidSOAPResponse") + " SOAP response does not contain samlp:Response");
                data = new String[]{FSUtils.bundle.getString("invalidSOAPResponse")};
                LogUtil.error(Level.INFO, "INVALID_SOAP_RESPONSE", data);
                FSUtils.forwardRequest(this.request, this.response, framedPageURL);
                return;
            }
            this.processSAMLResponse(this.samlResponse);
            return;
        }
        catch (Exception e) {
            StringWriter baos = new StringWriter();
            e.printStackTrace(new PrintWriter(baos));
            FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLRequest: Exception occured: " + e.getMessage() + "\n" + baos.getBuffer().toString());
            try {
                FSUtils.forwardRequest(this.request, this.response, framedPageURL);
            }
            catch (Exception ex) {
                FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLRequest: IOException occured: ", (Throwable)e);
            }
            return;
        }
    }

    private void processSAMLResponse(FSResponse samlResponse) {
        block36: {
            FSUtils.debug.message("FSBrowserArtifactConsumerHandler.processSAMLResponse: Called");
            String baseURL = FSServiceUtils.getBaseURL(this.request);
            String framedPageURL = FSServiceUtils.getCommonLoginPageURL(this.hostMetaAlias, this.relayState, null, this.request, baseURL);
            try {
                int handleType;
                boolean valid;
                if (samlResponse == null) {
                    FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse: null input " + FSUtils.bundle.getString("missingResponse"));
                    String[] data = new String[]{FSUtils.bundle.getString("missingResponse")};
                    LogUtil.error(Level.INFO, "MISSING_RESPONSE", data);
                    FSUtils.forwardRequest(this.request, this.response, framedPageURL);
                    return;
                }
                FederationSPAdapter spAdapter = FSServiceUtils.getSPAdapter(this.hostEntityId, this.hostConfig);
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSBrowserArtifactConsumerHandler.processSAMLResponse: Received " + samlResponse.toXMLString());
                }
                if (!(valid = this.verifyResponseStatus(samlResponse))) {
                    FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse: verify Status failed " + FSUtils.bundle.getString("invalidResponse"));
                    String[] data = new String[]{samlResponse.toXMLString()};
                    LogUtil.error(Level.INFO, "INVALID_RESPONSE", data);
                    if (spAdapter == null || !spAdapter.postSSOFederationFailure(this.hostEntityId, this.request, this.response, this.authnRequest, null, samlResponse, 2)) {
                        FSUtils.forwardRequest(this.request, this.response, framedPageURL);
                    }
                    return;
                }
                List assertions = samlResponse.getAssertion();
                if (assertions == null || assertions.size() <= 0) {
                    FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse" + FSUtils.bundle.getString("invalidResponse") + ": No assertion found inside the AuthnResponse");
                    String[] data = new String[]{samlResponse.toXMLString()};
                    LogUtil.error(Level.INFO, "INVALID_RESPONSE", data);
                    FSUtils.forwardRequest(this.request, this.response, framedPageURL);
                    return;
                }
                Iterator iter = assertions.iterator();
                FSAssertion assertion = (FSAssertion)iter.next();
                FSAuthnRequest authnRequestRef = this.getInResponseToRequest(assertion.getInResponseTo());
                if (authnRequestRef == null) {
                    FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse: " + FSUtils.bundle.getString("invalidResponse") + ": Assertion does not correspond to any AuthnRequest");
                    String[] data = new String[]{samlResponse.toXMLString()};
                    LogUtil.error(Level.INFO, "INVALID_RESPONSE", data);
                    FSUtils.forwardRequest(this.request, this.response, framedPageURL);
                    return;
                }
                this.authnRequest = authnRequestRef;
                this.relayState = this.authnRequest.getRelayState();
                if (this.relayState == null || this.relayState.trim().length() == 0) {
                    this.relayState = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostConfig, "providerHomePageURL");
                    if (this.relayState == null || this.relayState.trim().length() == 0) {
                        this.relayState = baseURL + "/samples/idff/sp/index.jsp";
                    }
                }
                this.doFederate = this.authnRequest.getFederate();
                this.nameIDPolicy = this.authnRequest.getNameIDPolicy();
                if (spAdapter != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSBrowserArtifactConsumerHandler, Artifact, Invoke spAdapter.preSSOFederationProcess");
                    }
                    try {
                        spAdapter.preSSOFederationProcess(this.hostEntityId, this.request, this.response, this.authnRequest, null, samlResponse);
                    }
                    catch (Exception e) {
                        FSUtils.debug.error("FSAssertionArtifactHandler SPAdapter.preSSOFederationSuccess", (Throwable)e);
                    }
                }
                framedPageURL = FSServiceUtils.getCommonLoginPageURL(this.hostMetaAlias, this.authnRequest.getRelayState(), null, this.request, baseURL);
                String idpEntityIdRef = this.getProvider(assertion.getInResponseTo());
                if (idpEntityIdRef == null || !idpEntityIdRef.equals(this.idpEntityId)) {
                    FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse: " + FSUtils.bundle.getString("invalidAssertion") + ": Assertion does not correspond to any IDP");
                    String[] data = new String[]{FSUtils.bundle.getString("invalidAssertion")};
                    LogUtil.error(Level.INFO, "INVALID_ASSERTION", data);
                    FSUtils.forwardRequest(this.request, this.response, framedPageURL);
                    return;
                }
                FSSubject validSubject = (FSSubject)this.validateAssertions(assertions);
                if (validSubject == null) {
                    FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse: validateAssertions failed: " + FSUtils.bundle.getString("invalidAssertion"));
                    String[] data = new String[]{FSUtils.bundle.getString("invalidAssertion")};
                    LogUtil.error(Level.INFO, "INVALID_ASSERTION", data);
                    if (spAdapter == null || !spAdapter.postSSOFederationFailure(this.hostEntityId, this.request, this.response, this.authnRequest, null, samlResponse, 2)) {
                        FSUtils.forwardRequest(this.request, this.response, framedPageURL);
                    }
                    return;
                }
                if (this.doFederate) {
                    NameIdentifier ni = validSubject.getIDPProvidedNameIdentifier();
                    if (ni == null) {
                        ni = validSubject.getNameIdentifier();
                    }
                    if (ni != null) {
                        int returnCode = this.doAccountFederation(ni);
                        if (returnCode == 0) {
                            FSSessionManager sessionManager = FSSessionManager.getInstance(this.hostMetaAlias);
                            sessionManager.removeAuthnRequest(assertion.getInResponseTo());
                            return;
                        }
                        FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse: " + FSUtils.bundle.getString("AccountFederationFailed"));
                        String[] data = new String[]{FSUtils.bundle.getString("AccountFederationFailed")};
                        LogUtil.error(Level.INFO, "ACCOUNT_FEDERATION_FAILED", data);
                        if (spAdapter == null || !spAdapter.postSSOFederationFailure(this.hostEntityId, this.request, this.response, this.authnRequest, this.authnResponse, samlResponse, returnCode)) {
                            FSUtils.forwardRequest(this.request, this.response, framedPageURL);
                        }
                        break block36;
                    }
                    FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse: Single Sign-On failed. NameIdentifier of the subject is null: ");
                    String[] data = new String[]{FSUtils.bundle.getString("SingleSignOnFailed")};
                    LogUtil.error(Level.INFO, "SINGLE_SIGNON_FAILED", data);
                    throw new FSException("missingNIofSubject", null);
                }
                FSSessionManager sessionManager = FSSessionManager.getInstance(this.hostMetaAlias);
                sessionManager.removeAuthnRequest(assertion.getInResponseTo());
                NameIdentifier niIdp = validSubject.getIDPProvidedNameIdentifier();
                NameIdentifier ni = validSubject.getNameIdentifier();
                if (niIdp == null) {
                    niIdp = ni;
                }
                if (niIdp == null || ni == null) {
                    String[] data = new String[]{FSUtils.bundle.getString("invalidResponse")};
                    LogUtil.error(Level.INFO, "INVALID_RESPONSE", data);
                    FSUtils.forwardRequest(this.request, this.response, framedPageURL);
                    return;
                }
                String idpHandle = niIdp.getName();
                String spHandle = ni.getName();
                if (idpHandle == null || spHandle == null) {
                    String[] data = new String[]{FSUtils.bundle.getString("invalidResponse")};
                    LogUtil.error(Level.INFO, "INVALID_RESPONSE", data);
                    FSUtils.forwardRequest(this.request, this.response, framedPageURL);
                    return;
                }
                if (idpHandle.equals(spHandle)) {
                    ni = niIdp;
                    handleType = 1;
                } else {
                    handleType = 0;
                }
                if (ni != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSBrowserArtifactConsumerHandler.processSAMLResponse: NameIdentifier=" + ni.getName() + " securityDomain=" + ni.getNameQualifier());
                    }
                    HashMap<String, FSResponse> env = new HashMap<String, FSResponse>();
                    env.put("FSResponse", samlResponse);
                    int returnCode = this.doSingleSignOn(ni, handleType, niIdp, env);
                    if (returnCode == 0) {
                        String requestID = assertion.getInResponseTo();
                        if (this.isIDPProxyEnabled(requestID)) {
                            this.sendProxyResponse(requestID);
                            return;
                        }
                        String[] data = new String[]{this.relayState};
                        LogUtil.access(Level.INFO, "ACCESS_GRANTED_REDIRECT_TO", data);
                        if (spAdapter != null) {
                            FSUtils.debug.message("Invoke spAdapter");
                            try {
                                if (spAdapter.postSSOFederationSuccess(this.hostEntityId, this.request, this.response, this.ssoToken, this.authnRequest, null, samlResponse)) {
                                    return;
                                }
                            }
                            catch (Exception e) {
                                FSUtils.debug.error("FSAssertionArtifactHandler SPAdapter.postSSOFederationSuccess:", (Throwable)e);
                            }
                        }
                        this.redirectToResource(this.relayState);
                        return;
                    }
                    FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse: SingleSignOnFailed, ni=" + ni.getName() + "[" + ni.getNameQualifier() + "]");
                    String[] data = new String[]{ni.getName()};
                    LogUtil.error(Level.INFO, "SINGLE_SIGNON_FAILED", data);
                    if (spAdapter == null || !spAdapter.postSSOFederationFailure(this.hostEntityId, this.request, this.response, this.authnRequest, null, samlResponse, returnCode)) {
                        FSUtils.forwardRequest(this.request, this.response, framedPageURL);
                    }
                    return;
                }
                FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse: SingleSignOnFailed (null)");
                String[] data = new String[]{FSUtils.bundle.getString("SingleSignOnFailed")};
                LogUtil.error(Level.INFO, "SINGLE_SIGNON_FAILED", data);
                throw new FSException("missingNIofSubject", null);
            }
            catch (Exception e) {
                FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse: Exception occured: ", (Throwable)e);
                return;
            }
        }
    }

    protected void redirectToResource(String resourceURL) throws FSException {
        String baseURL = FSServiceUtils.getBaseURL(this.request);
        String framedPageURL = FSServiceUtils.getCommonLoginPageURL(this.hostMetaAlias, this.authnRequest.getRelayState(), null, this.request, baseURL);
        try {
            FSUtils.debug.message("FSBrowserArtifactConsumerHandler.redirectToResource: Called");
            if (resourceURL == null) {
                FSUtils.debug.error("FSBrowserArtifactConsumerHandler.redirectToResource: Resource URL is null");
                FSUtils.forwardRequest(this.request, this.response, framedPageURL);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSBrowserArtifactConsumerHandler.redirectToResource: User's Authentication Assertion verified redirecting to Resource:" + resourceURL);
            }
            this.response.setContentType("text/html");
            this.response.sendRedirect(resourceURL);
        }
        catch (IOException e) {
            throw new FSException(e.getMessage());
        }
    }

    protected FSAuthnRequest getInResponseToRequest(String requestID) {
        FSUtils.debug.message("FSBrowserArtifactConsumerHandler.getInResponseToRequest: Called");
        FSSessionManager sessionManager = FSSessionManager.getInstance(this.hostMetaAlias);
        this.authnRequest = sessionManager.getAuthnRequest(requestID);
        return this.authnRequest;
    }

    protected FSRequest signSAMLRequest(FSRequest samlRequest) throws SAMLException {
        FSUtils.debug.message("FSBrowserArtifactConsumerHandler.signSAMLRequest: Called");
        if (samlRequest.isSigned()) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSBrowserArtifactConsumerHandler.signSAMLRequest: the request is already signed.");
            }
            throw new SAMLException(FSUtils.bundle.getString("alreadySigned"));
        }
        String certAlias = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostConfig, "signingCertAlias");
        if (certAlias == null || certAlias.length() == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSBrowserArtifactConsumerHandler.signSAMLRequest: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSBrowserArtifactConsumerHandler.signSAMLRequest: Provider's certAlias is found: " + certAlias);
        }
        XMLSignatureManager manager = XMLSignatureManager.getInstance();
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSBrowserArtifactConsumerHandler.signSAMLRequest: XMLString to be signed: " + samlRequest.toString(true, true));
        }
        String signatureString = manager.signXML(samlRequest.toString(true, true), certAlias);
        Element signature = XMLUtils.toDOMDocument((String)signatureString, (Debug)FSUtils.debug).getDocumentElement();
        samlRequest.setSignature(signature);
        return samlRequest;
    }
}

