/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.jaxb.entityconfig.SPDescriptorConfigElement;
import com.sun.identity.federation.key.KeyUtil;
import com.sun.identity.federation.message.FSAssertionArtifact;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.message.FSRequest;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.fednsso.FSAssertionArtifactHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.liberty.ws.meta.jaxb.IDPDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;

public class FSAssertionConsumerService
extends HttpServlet {
    private IDFFMetaManager metaManager = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.metaManager = FSUtils.getIDFFMetaManager();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request == null || response == null) {
            response.sendError(500, FSUtils.bundle.getString("nullInputParameter"));
            return;
        }
        FSUtils.debug.message("FSAssertionConsumerService.doGet(): called");
        String relayState = request.getParameter("RelayState");
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionConsumerService.doGet():Resource URL: " + relayState);
        }
        String metaAlias = FSServiceUtils.getMetaAlias(request);
        String realm = IDFFMetaUtils.getRealmByMetaAlias(metaAlias);
        String baseURL = FSServiceUtils.getBaseURL(request);
        String framedPageURL = FSServiceUtils.getCommonLoginPageURL(metaAlias, relayState, null, request, baseURL);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionConsumerService: CommonLoginPage: " + framedPageURL);
        }
        SPDescriptorType hostDesc = null;
        SPDescriptorConfigElement hostConfig = null;
        String hostEntityId = null;
        try {
            hostEntityId = this.metaManager.getEntityIDByMetaAlias(metaAlias);
            hostDesc = this.metaManager.getSPDescriptor(realm, hostEntityId);
            hostConfig = this.metaManager.getSPDescriptorConfig(realm, hostEntityId);
        }
        catch (Exception e) {
            FSUtils.debug.error("FSAssertionConsumerService.doGet: ", (Throwable)e);
            FSUtils.forwardRequest(request, response, framedPageURL);
            return;
        }
        FSRequest samlRequest = null;
        String firstSourceID = null;
        String artifactName = "SAMLart";
        String[] arti = request.getParameterValues(artifactName);
        if (arti == null || arti.length < 0 || arti[0] == null) {
            FSUtils.debug.error("FSAssertionConsumerService.doGet: AuthnRequest Processing Failed at the IDP Redirecting to the Framed Login Page");
            FSUtils.forwardRequest(request, response, framedPageURL);
        }
        ArrayList<FSAssertionArtifact> al = new ArrayList<FSAssertionArtifact>();
        try {
            FSAssertionArtifact firstArtifact = new FSAssertionArtifact(arti[0]);
            firstSourceID = firstArtifact.getSourceID();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionConsumerService.doGet: SourceID within the Artifact is " + firstSourceID);
            }
            al.add(firstArtifact);
            for (int k = 1; k < arti.length; ++k) {
                FSAssertionArtifact assertArtifact = new FSAssertionArtifact(arti[k]);
                String dest = assertArtifact.getSourceID();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionConsumerService.doGet: SourceID within the Artifact is " + dest);
                }
                if (!dest.equals(firstSourceID)) {
                    FSUtils.debug.error("FSAssertionConsumerService.doGet: Received multiple artifacts have different source id");
                    FSUtils.forwardRequest(request, response, framedPageURL);
                    return;
                }
                al.add(assertArtifact);
            }
            samlRequest = new FSRequest(null, al);
        }
        catch (SAMLException se) {
            FSUtils.debug.error("FSAssertionConsumerService.doGet: ", (Throwable)((Object)se));
            FSUtils.forwardRequest(request, response, framedPageURL);
            return;
        }
        catch (FSMsgException se) {
            FSUtils.debug.error("FSAssertionConsumerService.doGet: ", (Throwable)((Object)se));
            FSUtils.forwardRequest(request, response, framedPageURL);
            return;
        }
        try {
            FSServiceManager sm;
            FSAssertionArtifactHandler handler;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionConsumerService.doGet: Trying to get BrowserArtifactHandler");
            }
            if ((handler = (sm = FSServiceManager.getInstance()).getBrowserArtifactHandler(request, response, realm, firstSourceID, samlRequest, relayState)) == null) {
                FSUtils.debug.error("FSAssertionConsumerService.doGet: " + FSUtils.bundle.getString("internalError"));
                FSUtils.forwardRequest(request, response, framedPageURL);
                return;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionConsumerService.doGet: BrowserArtifactHandler created");
            }
            handler.setRealm(realm);
            handler.setHostEntityId(hostEntityId);
            handler.setMetaAlias(metaAlias);
            handler.setHostDescriptor(hostDesc);
            handler.setHostDescriptorConfig(hostConfig);
            handler.processSAMLRequest();
            return;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSAssertionConsumerService.doGet: Exception occurred :", (Throwable)e);
            FSUtils.forwardRequest(request, response, framedPageURL);
            return;
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FSUtils.debug.message("FSAssertionConsumerService.doPost : called");
        Document doc = null;
        if (request == null || response == null) {
            response.sendError(500, FSUtils.bundle.getString("nullInputParameter"));
            return;
        }
        String metaAlias = FSServiceUtils.getMetaAlias(request);
        String realm = IDFFMetaUtils.getRealmByMetaAlias(metaAlias);
        String baseURL = FSServiceUtils.getBaseURL(request);
        String framedPageURL = FSServiceUtils.getCommonLoginPageURL(metaAlias, null, null, request, baseURL);
        String hostEntityId = null;
        SPDescriptorType hostDesc = null;
        SPDescriptorConfigElement hostConfig = null;
        try {
            hostEntityId = this.metaManager.getEntityIDByMetaAlias(metaAlias);
            hostDesc = this.metaManager.getSPDescriptor(realm, hostEntityId);
            hostConfig = this.metaManager.getSPDescriptorConfig(realm, hostEntityId);
        }
        catch (Exception e) {
            FSUtils.debug.error("FSAssertionConsumerService.doPost: Exception when obtain host meta data:", (Throwable)e);
            FSUtils.forwardRequest(request, response, framedPageURL);
            return;
        }
        String encodedAuthnResponse = request.getParameter("LARES");
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionConsumerService.doPost: Base64 encoded AuthnResponse: " + encodedAuthnResponse);
        }
        if (encodedAuthnResponse == null) {
            String[] data = new String[]{FSUtils.bundle.getString("missingAuthnResponse")};
            LogUtil.error(Level.INFO, "MISSING_AUTHN_RESPONSE", data);
            FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("missingAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
            FSUtils.forwardRequest(request, response, framedPageURL);
            return;
        }
        encodedAuthnResponse = encodedAuthnResponse.replace(' ', '\n');
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionConsumerService.doPost: Base64 encoded AuthnResponse2: " + encodedAuthnResponse);
        }
        FSAuthnResponse authnResponse = null;
        try {
            String decodedAuthnResponse = new String(Base64.decode((String)encodedAuthnResponse));
            FSUtils.debug.message("Decoded authnResponse" + decodedAuthnResponse);
            doc = XMLUtils.toDOMDocument((String)decodedAuthnResponse, (Debug)FSUtils.debug);
            if (doc == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionConsumerService.doPost:Error while parsing input xml string");
                }
                throw new FSMsgException("parseError", null);
            }
            authnResponse = new FSAuthnResponse(doc.getDocumentElement());
            if (authnResponse == null) {
                FSUtils.debug.error("FSAssertionConsumerService.doPost: Invalid AuthnResponse. Can't parse Base64 encoded AuthnResponse");
                String[] data = new String[]{FSUtils.bundle.getString("invalidAuthnResponse")};
                LogUtil.error(Level.INFO, "INVALID_AUTHN_RESPONSE", data);
                FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("invalidAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                FSUtils.forwardRequest(request, response, framedPageURL);
                return;
            }
        }
        catch (FSException e) {
            FSUtils.debug.error("FSAssertionConsumerService.doPost: Invalid AuthnResponse. FSException occured while parsing Base64 encoded AuthnResponse: ", (Throwable)((Object)e));
            String[] data = new String[]{FSUtils.bundle.getString("invalidAuthnResponse")};
            LogUtil.error(Level.INFO, "INVALID_AUTHN_RESPONSE", data);
            FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("invalidAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
            FSUtils.forwardRequest(request, response, framedPageURL);
            return;
        }
        catch (SAMLException e) {
            FSUtils.debug.error("FSAssertionConsumerService.doPost: Invalid AuthnResponse. SAMLException occurred while parsing Base64 encoded AuthnResponse: ", (Throwable)((Object)e));
            String[] data = new String[]{FSUtils.bundle.getString("invalidAuthnResponse")};
            LogUtil.error(Level.INFO, "INVALID_AUTHN_RESPONSE", data);
            FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("invalidAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
            FSUtils.forwardRequest(request, response, framedPageURL);
            return;
        }
        try {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionConsumerService.doPost: AuthnResponse received is valid: " + authnResponse.toXMLString());
            }
        }
        catch (FSException e) {
            FSUtils.debug.error("FSAssertionConsumerService.doPost: Invalid AuthnResponse. FSException occurred while calling AuthnResponse.toXMLString(): ", (Throwable)((Object)e));
            String[] data = new String[]{FSUtils.bundle.getString("invalidAuthnResponse")};
            LogUtil.error(Level.INFO, "INVALID_AUTHN_RESPONSE", data);
            FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("invalidAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
            FSUtils.forwardRequest(request, response, framedPageURL);
            return;
        }
        FSAuthnRequest authnRequest = null;
        String requestID = authnResponse.getInResponseTo();
        if (requestID == null) {
            FSUtils.debug.error("FSAssertionConsumerService.doPost: Invalid AuthnResponse. AuthnResponse received does not have inResponseTo attribute");
            String[] data = new String[]{FSUtils.bundle.getString("invalidAuthnResponse")};
            LogUtil.error(Level.INFO, "INVALID_AUTHN_RESPONSE", data);
            FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("invalidAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
            FSUtils.forwardRequest(request, response, framedPageURL);
            return;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionConsumerService.doPost: AuthnResponse received is against requestID: " + requestID);
        }
        if ((authnRequest = this.getInResponseToRequest(requestID, metaAlias)) == null) {
            FSUtils.debug.error("FSAssertionConsumerService.doPost: Invalid AuthnResponse. AuthnResponse received does not have an associated AuthnRequest");
            String[] data = new String[]{FSUtils.bundle.getString("invalidAuthnResponse")};
            LogUtil.error(Level.INFO, "INVALID_AUTHN_RESPONSE", data);
            FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("invalidAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
            FSUtils.forwardRequest(request, response, framedPageURL);
            return;
        }
        String framedLoginPageURL = FSServiceUtils.getCommonLoginPageURL(metaAlias, authnRequest.getRelayState(), null, request, baseURL);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionConsumerService.doPost: inResponseTo validation is successful");
        }
        try {
            FSServiceManager sm;
            FSAssertionArtifactHandler handler;
            String idpEntityId = null;
            IDPDescriptorType idpDescriptor = null;
            if (!authnRequest.getProtocolProfile().equals("http://projectliberty.org/profiles/lecp")) {
                idpEntityId = this.getProvider(authnResponse.getInResponseTo(), metaAlias);
                idpDescriptor = this.metaManager.getIDPDescriptor(realm, idpEntityId);
                if (idpEntityId == null || idpDescriptor == null) {
                    FSUtils.debug.error("FSAssertionConsumerService.doPost: Invalid AuthnResponse. Sender information not found for the received AuthnResponse");
                    String[] data = new String[]{FSUtils.bundle.getString("invalidAuthnResponse")};
                    LogUtil.error(Level.INFO, "INVALID_AUTHN_RESPONSE", data);
                    FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("invalidAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                    FSUtils.forwardRequest(request, response, framedLoginPageURL);
                    return;
                }
                if ((FSServiceUtils.isSigningOn() || FSServiceUtils.isSigningOptional() && authnRequest.getProtocolProfile().equals("http://projectliberty.org/profiles/brws-post")) && !this.verifyAuthnResponseSignature(doc, idpDescriptor, idpEntityId)) {
                    FSUtils.debug.error("FSAssertionConsumerService.doPost: Signature verification failed");
                    FSUtils.forwardRequest(request, response, framedLoginPageURL);
                    return;
                }
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionConsumerService.doPost: LECP Profile identified. IDP info is unknown so farGet providerId from the response");
                }
                idpEntityId = authnResponse.getProviderId();
                idpDescriptor = this.metaManager.getIDPDescriptor(realm, idpEntityId);
            }
            if ((handler = (sm = FSServiceManager.getInstance()).getAssertionArtifactHandler(request, response, authnRequest, authnResponse, idpDescriptor, idpEntityId)) == null) {
                FSUtils.debug.error("FSAssertionConsumerService.doPost: could not create AssertionArtifactHandler");
                String[] data = new String[]{FSUtils.bundle.getString("requestProcessingFailed")};
                LogUtil.error(Level.INFO, "AUTHN_REQUEST_PROCESSING_FAILED", data);
                FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("requestProcessingFailed") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                FSUtils.forwardRequest(request, response, framedLoginPageURL);
                return;
            }
            handler.setHostEntityId(hostEntityId);
            handler.setHostDescriptor(hostDesc);
            handler.setHostDescriptorConfig(hostConfig);
            handler.setMetaAlias(metaAlias);
            handler.setRealm(realm);
            handler.processAuthnResponse(authnResponse);
            return;
        }
        catch (Exception se) {
            FSUtils.debug.error("FSAssertionConsumerService.doPost: Exception: ", (Throwable)se);
            FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("requestProcessingFailed") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
            FSUtils.forwardRequest(request, response, framedLoginPageURL);
            return;
        }
    }

    private FSAuthnRequest getInResponseToRequest(String requestID, String metaAlias) {
        FSUtils.debug.message("FSAssertionConsumerService::getInResponseToRequest: Called");
        FSSessionManager sessionManager = FSSessionManager.getInstance(metaAlias);
        return sessionManager.getAuthnRequest(requestID);
    }

    private String getProvider(String requestID, String metaAlias) {
        FSUtils.debug.message("FSAssertionConsumerService.getProvider: Called");
        FSSessionManager sessionManager = FSSessionManager.getInstance(metaAlias);
        return sessionManager.getIDPEntityID(requestID);
    }

    private boolean verifyAuthnResponseSignature(Document doc, IDPDescriptorType idpDescriptor, String idpEntityId) {
        FSUtils.debug.message("FSAssertionConsumerService.verifyAuthnResponseSignature: Called");
        try {
            X509Certificate cert = KeyUtil.getVerificationCert(idpDescriptor, idpEntityId, true);
            if (cert == null) {
                FSUtils.debug.error("FSAssertionConsumerService.verifyAuthnResponseSignature: couldn't obtain this site's cert.");
                return false;
            }
            XMLSignatureManager manager = XMLSignatureManager.getInstance();
            return manager.verifyXMLSignature(doc, cert);
        }
        catch (Exception e) {
            FSUtils.debug.error("FSAssertionConsumerService.verifyAuthnResponseSignature: Exception occurred while verifying signature: ", (Throwable)e);
            return false;
        }
    }
}

