/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.common.SystemTimerPool;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.FSRequestCleanUpRunnable;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionMapStats;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.shared.stats.Stats;
import com.sun.identity.shared.stats.StatsListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class FSSessionManager {
    private static final String REQUEST_CLEANUP_INTERVAL = "com.sun.identity.federation.request.cleanup_interval";
    private static final long DEFAULT_REQUEST_CLEANUP_INTERVAL = 300000L;
    private static final String REQUEST_TIMEOUT = "com.sun.identity.federation.request.timeout";
    private static final long DEFAULT_REQUEST_TIMEOUT = 300000L;
    private static Map instanceMap;
    private Map userIDSessionListMap;
    private Map idAuthnRequestMap;
    private Map idLocalSessionTokenMap;
    private Map idDestnMap;
    private String hostEntityId;
    private String realm;
    private Map relayStateMap;
    private Map proxySPDescMap;
    private Map proxySPAuthnReqMap;
    private static long cleanupInterval;
    private static long requestTimeout;
    private FSRequestCleanUpRunnable cRunnable;
    private FSSessionMapStats dnStats;
    private FSSessionMapStats reqStats;
    private FSSessionMapStats tokenStats;
    private FSSessionMapStats idStats;
    private FSSessionMapStats relayStats;
    public static Stats sessStats;

    public String getRelayState(String requestID) {
        return (String)this.relayStateMap.get(requestID);
    }

    public void setRelayState(String requestID, String relayState) {
        this.relayStateMap.put(requestID, relayState);
    }

    public void removeRelayState(String requestID) {
        this.relayStateMap.remove(requestID);
    }

    public FSAuthnRequest getAuthnRequest(String requestID) {
        FSUtils.debug.message("FSSessionManager.getAuthnRequest: Called");
        return (FSAuthnRequest)this.idAuthnRequestMap.get(requestID);
    }

    public void setAuthnRequest(String requestID, FSAuthnRequest authnRequest) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSessionManager.setAuthnRequest: Called, ID=" + requestID);
        }
        this.removeAuthnRequest(requestID);
        this.idAuthnRequestMap.put(requestID, authnRequest);
        if (this.cRunnable != null) {
            this.cRunnable.addElement(requestID);
        }
    }

    public void removeAuthnRequest(String requestID) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSessionManager.removeAuthnRequest: Called, ID=" + requestID);
        }
        this.idAuthnRequestMap.remove(requestID);
        this.idDestnMap.remove(requestID);
        if (this.cRunnable != null) {
            this.cRunnable.removeElement(requestID);
        }
    }

    public Object getLocalSessionToken(String requestID) {
        FSUtils.debug.message("FSSessionManager.getLocalSessionToken: Called");
        return this.idLocalSessionTokenMap.get(requestID);
    }

    public void setLocalSessionToken(String requestID, Object localSession) {
        FSUtils.debug.message("FSSessionManager.setLocalSessionToken: Called");
        this.idLocalSessionTokenMap.put(requestID, localSession);
    }

    public void removeLocalSessionToken(String requestID) {
        FSUtils.debug.message("FSSessionManager.removeLocalSessionToken: Called");
        this.idLocalSessionTokenMap.remove(requestID);
    }

    public String getIDPEntityID(String requestID) {
        FSUtils.debug.message("FSSessionManager.getIDPEntityID: Called");
        return (String)this.idDestnMap.get(requestID);
    }

    public void setIDPEntityID(String requestID, String idpEntityId) {
        FSUtils.debug.message("FSSessionManager.setIDPEntityID");
        this.idDestnMap.put(requestID, idpEntityId);
    }

    public void setProxySPDescriptor(String requestID, SPDescriptorType spDescriptor) {
        this.proxySPDescMap.put(requestID, spDescriptor);
    }

    public SPDescriptorType getProxySPDescriptor(String requestID) {
        return (SPDescriptorType)this.proxySPDescMap.get(requestID);
    }

    public FSAuthnRequest getProxySPAuthnRequest(String requestID) {
        return (FSAuthnRequest)this.proxySPAuthnReqMap.get(requestID);
    }

    public void setProxySPAuthnRequest(String requestID, FSAuthnRequest authnRequest) {
        this.proxySPAuthnReqMap.put(requestID, authnRequest);
    }

    public List getSessionList(String userID) {
        FSUtils.debug.message("FSSessionManager.getSessionList: Called");
        return (List)this.userIDSessionListMap.get(userID.toLowerCase());
    }

    public void setSessionList(String userID, List sessionList) {
        FSUtils.debug.message("FSSessionManager.setSessionList: Called");
        this.userIDSessionListMap.put(userID.toLowerCase(), sessionList);
    }

    public void removeSessionList(String userID) {
        FSUtils.debug.message("FSSessionManager.removeSessionList: Called ");
        this.userIDSessionListMap.remove(userID.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSSession getSession(String userID, String sessionID) {
        FSUtils.debug.message("FSSessionManager.getSession: Called ");
        List sessions = this.getSessionList(userID);
        if (sessions != null) {
            List list = sessions;
            synchronized (list) {
                Iterator i = sessions.iterator();
                while (i.hasNext()) {
                    FSSession session = (FSSession)i.next();
                    if (!session.isEquals(sessionID)) continue;
                    return session;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSSession getSession(List sessions, String sessionIndex) {
        FSUtils.debug.message("FSSessionManager.getSession(sessionIndex):");
        if (sessions == null || sessionIndex == null) {
            FSUtils.debug.error("FSSessionManager.getSession(sessionIndex):sessions or sessionIndex is null");
            return null;
        }
        List list = sessions;
        synchronized (list) {
            Iterator i = sessions.iterator();
            while (i.hasNext()) {
                FSSession session = (FSSession)i.next();
                String tmpIndex = session.getSessionIndex();
                if (tmpIndex == null || !tmpIndex.equals(sessionIndex)) continue;
                return session;
            }
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSessionManager.getSession(sessionIndex):No session found for the given session index.");
        }
        return null;
    }

    public FSSession getSession(Object token) {
        FSUtils.debug.message("FSSessionManager.getSession: Called");
        if (token == null) {
            return null;
        }
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            String univId = sessionProvider.getPrincipalName(token);
            String sessionID = sessionProvider.getSessionID(token);
            return this.getSession(univId, sessionID);
        }
        catch (Exception e) {
            FSUtils.debug.error("FSSessionManager.getSession(token) : ", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProvider(String userID, String entityID, FSSession localSession) {
        FSUtils.debug.message("FSSessionManager.removeProvider: Called ");
        if (localSession != null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSessionManager.removeProvider: localSession is not null");
            }
            localSession.removeSessionPartner(entityID);
            return;
        }
        List sessions = this.getSessionList(userID);
        if (sessions != null) {
            List list = sessions;
            synchronized (list) {
                Iterator i = sessions.iterator();
                while (i.hasNext()) {
                    FSSession session = (FSSession)i.next();
                    if (session == null) continue;
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("removeSessionPartner" + entityID);
                    }
                    session.removeSessionPartner(entityID);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(String userID, FSSession session) {
        FSUtils.debug.message("FSSessionManager.removeSession: Called");
        List sessions = this.getSessionList(userID);
        if (sessions != null) {
            List list = sessions;
            synchronized (list) {
                Iterator i = sessions.iterator();
                while (i.hasNext()) {
                    FSSession oldsession = (FSSession)i.next();
                    if (!oldsession.equals(session)) continue;
                    sessions.remove(oldsession);
                    break;
                }
            }
            if (sessions.isEmpty()) {
                this.removeSessionList(userID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(String userID, FSSession session) {
        FSUtils.debug.message("FSSessionManager.addSession: Called");
        List sessions = this.getSessionList(userID);
        if (sessions != null) {
            List list = sessions;
            synchronized (list) {
                Iterator i = sessions.iterator();
                while (i.hasNext()) {
                    FSSession oldsession = (FSSession)i.next();
                    if (!oldsession.equals(session)) continue;
                    sessions.remove(oldsession);
                    break;
                }
                sessions.add(session);
                return;
            }
        }
        ArrayList<FSSession> newSessionList = new ArrayList<FSSession>();
        newSessionList.add(session);
        this.setSessionList(userID, newSessionList);
    }

    private FSSessionManager(String metaAlias) {
        block6: {
            this.userIDSessionListMap = Collections.synchronizedMap(new HashMap());
            this.idAuthnRequestMap = Collections.synchronizedMap(new HashMap());
            this.idLocalSessionTokenMap = Collections.synchronizedMap(new HashMap());
            this.idDestnMap = Collections.synchronizedMap(new HashMap());
            this.hostEntityId = null;
            this.realm = null;
            this.relayStateMap = Collections.synchronizedMap(new HashMap());
            this.proxySPDescMap = Collections.synchronizedMap(new HashMap());
            this.proxySPAuthnReqMap = Collections.synchronizedMap(new HashMap());
            this.cRunnable = null;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSessionManager(): created " + metaAlias);
            }
            this.realm = IDFFMetaUtils.getRealmByMetaAlias(metaAlias);
            try {
                IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
                this.hostEntityId = metaManager.getEntityIDByMetaAlias(metaAlias);
            }
            catch (Exception ie) {
                if (!FSUtils.debug.warningEnabled()) break block6;
                FSUtils.debug.warning("FSSessionManager constructor: couldnot obtain hosted entity ID:", (Throwable)ie);
            }
        }
        if (sessStats.isEnabled()) {
            this.dnStats = new FSSessionMapStats(this.userIDSessionListMap, "userIDSessionListMap", this.realm, this.hostEntityId);
            sessStats.addStatsListener((StatsListener)this.dnStats);
            this.reqStats = new FSSessionMapStats(this.idAuthnRequestMap, "idAuthnRequestMap", this.realm, this.hostEntityId);
            sessStats.addStatsListener((StatsListener)this.reqStats);
            this.tokenStats = new FSSessionMapStats(this.idLocalSessionTokenMap, "idLocalSessionTokenMap", this.realm, this.hostEntityId);
            sessStats.addStatsListener((StatsListener)this.tokenStats);
            this.idStats = new FSSessionMapStats(this.idDestnMap, "idDestnMap", this.realm, this.hostEntityId);
            sessStats.addStatsListener((StatsListener)this.idStats);
            this.relayStats = new FSSessionMapStats(this.relayStateMap, "relayStateMap", this.realm, this.hostEntityId);
            sessStats.addStatsListener((StatsListener)this.relayStats);
        }
        if (cleanupInterval != 0L && requestTimeout != 0L && SystemConfigurationUtil.isServerMode()) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSessionManager.getInstance: start cleanup thread for " + this.hostEntityId + " in realm " + this.realm);
            }
            this.cRunnable = new FSRequestCleanUpRunnable(this.idAuthnRequestMap, this.idDestnMap, cleanupInterval, requestTimeout);
            SystemTimerPool.getTimerPool().schedule((TaskRunnable)this.cRunnable, new Date((System.currentTimeMillis() + cleanupInterval) / 1000L * 1000L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized FSSessionManager getInstance(String metaAlias) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSessionManager.getInstance: Called " + metaAlias);
        }
        if (metaAlias == null) {
            FSUtils.debug.error("FSSessionManager.getInstance: null provider meta alias");
            return null;
        }
        FSSessionManager instance = (FSSessionManager)instanceMap.get(metaAlias);
        if (instance == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSessionManager.getInstance: new instance of FSSessionManager: " + metaAlias);
            }
            instance = new FSSessionManager(metaAlias);
            Map map = instanceMap;
            synchronized (map) {
                instanceMap.put(metaAlias, instance);
            }
        }
        return instance;
    }

    static {
        String temp;
        instanceMap = new HashMap();
        cleanupInterval = 0L;
        requestTimeout = 0L;
        sessStats = Stats.getInstance((String)"libIDFFSessionMaps");
        try {
            temp = SystemConfigurationUtil.getProperty(REQUEST_CLEANUP_INTERVAL);
            cleanupInterval = temp == null || temp.trim().length() == 0 ? 300000L : (long)(Integer.parseInt(temp) * 1000);
        }
        catch (Exception e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Unable to get fed request cleanup prop.", (Throwable)e);
            }
            cleanupInterval = 300000L;
        }
        try {
            temp = SystemConfigurationUtil.getProperty(REQUEST_TIMEOUT);
            requestTimeout = temp == null || temp.trim().length() == 0 ? 300000L : (long)(Integer.parseInt(temp) * 1000);
        }
        catch (Exception e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Unable to get fed request timeout prop.", (Throwable)e);
            }
            requestTimeout = 300000L;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSessionManager, cleanup interval=" + cleanupInterval + " ms, timeout=" + requestTimeout + " ms");
        }
    }
}

