/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.jaxb.entityconfig.SPDescriptorConfigElement;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.message.FSFederationTerminationNotification;
import com.sun.identity.federation.message.FSRequest;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.fednsso.FSAssertionArtifactHandler;
import com.sun.identity.federation.services.fednsso.FSBrowserArtifactConsumerHandler;
import com.sun.identity.federation.services.fednsso.FSBrowserPostConsumerHandler;
import com.sun.identity.federation.services.fednsso.FSLECPConsumerHandler;
import com.sun.identity.federation.services.fednsso.FSSSOAndFedHandler;
import com.sun.identity.federation.services.fednsso.FSSSOBrowserArtifactProfileHandler;
import com.sun.identity.federation.services.fednsso.FSSSOBrowserPostProfileHandler;
import com.sun.identity.federation.services.fednsso.FSSSOLECPProfileHandler;
import com.sun.identity.federation.services.fednsso.FSSSOWMLPostProfileHandler;
import com.sun.identity.federation.services.fednsso.FSWMLPostConsumerHandler;
import com.sun.identity.federation.services.logout.FSPreLogoutHandler;
import com.sun.identity.federation.services.registration.FSNameRegistrationHandler;
import com.sun.identity.federation.services.termination.FSFedTerminationHandler;
import com.sun.identity.liberty.ws.meta.jaxb.IDPDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.ProviderDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.protocol.Request;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSServiceManager {
    private static FSServiceManager instance = null;

    private FSServiceManager() {
        FSUtils.debug.message("FSServiceManager(): Called");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public FSAssertionArtifactHandler getAssertionArtifactHandler(HttpServletRequest request, HttpServletResponse response, FSAuthnRequest authnRequest, FSAuthnResponse authnResponse, IDPDescriptorType idpDescriptor, String idpEntityId) {
        void var7_11;
        FSUtils.debug.message("FSServiceManager.getAssertionArtifactHandler: Called");
        if (request == null || response == null || authnRequest == null || authnResponse == null) {
            FSUtils.debug.error("FSServiceManager.getAssertionArtifactHandler: " + FSUtils.bundle.getString("nullInputParameter"));
            return null;
        }
        Object var7_7 = null;
        String profile = authnRequest.getProtocolProfile();
        boolean doFederate = authnRequest.getFederate();
        String relayState = authnResponse.getRelayState();
        if (profile == null) {
            FSUtils.debug.error("FSServiceManager.getAssertionArtifactHandler: No protocol profile in the Request");
            return null;
        }
        if (profile.equals("http://projectliberty.org/profiles/brws-post")) {
            FSBrowserPostConsumerHandler fSBrowserPostConsumerHandler = new FSBrowserPostConsumerHandler(request, response, idpDescriptor, idpEntityId, authnRequest, doFederate, relayState);
            return var7_11;
        }
        if (profile.equals("http://projectliberty.org/profiles/wml-post")) {
            FSWMLPostConsumerHandler fSWMLPostConsumerHandler = new FSWMLPostConsumerHandler(request, response, idpDescriptor, idpEntityId, authnRequest, doFederate, relayState);
            return var7_11;
        }
        if (profile.equals("http://projectliberty.org/profiles/lecp")) {
            FSLECPConsumerHandler fSLECPConsumerHandler = new FSLECPConsumerHandler(request, response, idpDescriptor, idpEntityId, authnRequest, doFederate, relayState);
            return var7_11;
        }
        FSUtils.debug.error("FSServiceManager.getAssertionArtifactHandler: Unknown Protocol profile request");
        return null;
    }

    public FSAssertionArtifactHandler getBrowserArtifactHandler(HttpServletRequest request, HttpServletResponse response, String realm, String idpSuccinctId, FSRequest samlRequest, String relayState) {
        FSUtils.debug.message("FSServiceManager.getBrowserArtifactHandler: Called");
        if (request == null || response == null || idpSuccinctId == null || samlRequest == null) {
            FSUtils.debug.error("FSServiceManager.getBrowserArtifactHandler: " + FSUtils.bundle.getString("nullInputParameter"));
            return null;
        }
        try {
            IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
            String idpEntityId = metaManager.getEntityIDBySuccinctID(realm, idpSuccinctId);
            IDPDescriptorType idpDescriptor = metaManager.getIDPDescriptor(realm, idpEntityId);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSServiceManager.getBrowserArtifactHandler: IDP Id of the provider to communicate: " + idpEntityId);
            }
            return new FSBrowserArtifactConsumerHandler(request, response, idpDescriptor, idpEntityId, relayState, samlRequest);
        }
        catch (Exception ex) {
            FSUtils.debug.error("FSServiceManager.getBrowserArtifactHandler:Exception Occured:", (Throwable)ex);
            return null;
        }
    }

    public FSSSOAndFedHandler getSSOAndFedHandler(HttpServletRequest request, HttpServletResponse response, FSAuthnRequest authnRequest, String realm) {
        FSUtils.debug.message("FSServiceManager.getSSOAndFedHandler: Called ");
        if (request == null || response == null || authnRequest == null) {
            FSUtils.debug.error("FSServiceManager.getSSOAndFedHandler: " + FSUtils.bundle.getString("nullInputParameter"));
            return null;
        }
        try {
            FSSSOAndFedHandler returnHandler = null;
            String profile = authnRequest.getProtocolProfile();
            IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
            String spEntityId = authnRequest.getProviderId();
            SPDescriptorType spDescriptor = metaManager.getSPDescriptor(realm, spEntityId);
            SPDescriptorConfigElement spConfig = metaManager.getSPDescriptorConfig(realm, spEntityId);
            String relayState = authnRequest.getRelayState();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSServiceManager.getSSOAndFedHandler: requested profile:" + profile);
            }
            if (profile != null) {
                if (profile.equals("http://projectliberty.org/profiles/brws-art")) {
                    returnHandler = new FSSSOBrowserArtifactProfileHandler(request, response, authnRequest, spDescriptor, spConfig, spEntityId, relayState);
                } else if (profile.equals("http://projectliberty.org/profiles/brws-post")) {
                    returnHandler = new FSSSOBrowserPostProfileHandler(request, response, authnRequest, spDescriptor, spConfig, spEntityId, relayState);
                } else if (profile.equals("http://projectliberty.org/profiles/wml-post")) {
                    returnHandler = new FSSSOWMLPostProfileHandler(request, response, authnRequest, spDescriptor, spConfig, spEntityId, relayState);
                } else if (profile.equals("http://projectliberty.org/profiles/lecp")) {
                    returnHandler = new FSSSOLECPProfileHandler(request, response, authnRequest, spDescriptor, spConfig, spEntityId, relayState);
                } else {
                    FSUtils.debug.error("FSServiceManager.getSSOAndFedHandler: Unknown Protocol profile request");
                    returnHandler = new FSSSOBrowserArtifactProfileHandler(request, response, authnRequest, spDescriptor, spConfig, spEntityId, relayState);
                }
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSServiceManager.getSSOAndFedHandler: No protocol profile in the Request");
                }
                returnHandler = new FSSSOBrowserArtifactProfileHandler(request, response, authnRequest, spDescriptor, spConfig, spEntityId, relayState);
            }
            return returnHandler;
        }
        catch (IDFFMetaException ex) {
            FSUtils.debug.error("FSServiceManager.getSSOAndFedHandler: ", (Throwable)((Object)ex));
            return null;
        }
    }

    public FSSSOAndFedHandler getBrowserArtifactSSOAndFedHandler(HttpServletRequest request, HttpServletResponse response, Request samlRequest) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSServiceManager:: getBrowserArtifactSSOAndFedHandler: Called");
        }
        if (request == null || response == null || samlRequest == null) {
            FSUtils.debug.error("FSServiceManager.getSSOAndFedHandler: " + FSUtils.bundle.getString("nullInputParameter"));
            return null;
        }
        return new FSSSOBrowserArtifactProfileHandler(request, response, samlRequest);
    }

    public FSSSOLECPProfileHandler getLECPProfileHandler(HttpServletRequest request, HttpServletResponse response, FSAuthnRequest authnRequest, String realm) {
        FSUtils.debug.message("FSServiceManager.getLECPProfileHandler:Called");
        try {
            if (request == null || response == null || authnRequest == null) {
                FSUtils.debug.error("FSServiceManager.getLECPProfileHandler: " + FSUtils.bundle.getString("nullInputParameter"));
                return null;
            }
            IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
            String spEntityId = authnRequest.getProviderId();
            return new FSSSOLECPProfileHandler(request, response, authnRequest, metaManager.getSPDescriptor(realm, spEntityId), metaManager.getSPDescriptorConfig(realm, spEntityId), spEntityId, authnRequest.getRelayState());
        }
        catch (IDFFMetaException ex) {
            FSUtils.debug.error("FSServiceManager.getLECPProfileHandler: ", (Throwable)((Object)ex));
            return null;
        }
    }

    public FSNameRegistrationHandler getNameRegistrationHandler(String realm, String remoteEntityId, String remoteProviderRole) {
        FSNameRegistrationHandler handlerRegistration = new FSNameRegistrationHandler();
        if (handlerRegistration != null) {
            try {
                IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
                if (metaManager == null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSNameRegistrationHandler::getSPNameIdentifier failed to get meta Manager instance");
                    }
                    return null;
                }
                ProviderDescriptorType remoteDesc = null;
                if (remoteProviderRole == null) {
                    return null;
                }
                if (remoteProviderRole.equalsIgnoreCase("IDP")) {
                    remoteDesc = metaManager.getIDPDescriptor(realm, remoteEntityId);
                } else if (remoteProviderRole.equalsIgnoreCase("SP")) {
                    remoteDesc = metaManager.getSPDescriptor(realm, remoteEntityId);
                }
                if (remoteDesc != null) {
                    handlerRegistration.setRemoteDescriptor(remoteDesc);
                    handlerRegistration.setRemoteEntityId(remoteEntityId);
                    handlerRegistration.setRealm(realm);
                    return handlerRegistration;
                }
                return null;
            }
            catch (IDFFMetaException e) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::Failed to get remote descriptor:", (Throwable)((Object)e));
                }
                return null;
            }
        }
        return handlerRegistration;
    }

    public FSFedTerminationHandler getFedTerminationHandler(FSFederationTerminationNotification terminationRequest, BaseConfigType hostedConfig, String realm, String hostedEntityId, String hostedProviderRole, String metaAlias, String remoteEntityId) {
        try {
            FSAccountFedInfo acctInfo;
            FSUtils.debug.message("Entered FSServicemanager::getFedTerminationHandler");
            FSAccountManager managerInst = FSAccountManager.getInstance(metaAlias);
            if (managerInst == null) {
                FSUtils.debug.error("Error in retrieving account manager");
                return null;
            }
            NameIdentifier nameIdObj = terminationRequest.getNameIdentifier();
            String nameIDValue = nameIdObj.getName();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Remote provider : " + remoteEntityId + ", Name Qualifier : " + nameIdObj.getNameQualifier() + ", Name : " + nameIDValue + ", Realm : " + realm);
            }
            String nameQualifier = nameIdObj.getNameQualifier();
            String searchDomain = hostedEntityId;
            if (nameQualifier != null && !nameQualifier.equals(remoteEntityId)) {
                searchDomain = nameQualifier;
            }
            FSAccountFedInfoKey acctkey = null;
            acctkey = hostedProviderRole.equalsIgnoreCase("SP") ? new FSAccountFedInfoKey(searchDomain, nameIDValue) : new FSAccountFedInfoKey(remoteEntityId, nameIDValue);
            HashMap<String, FSFederationTerminationNotification> env = new HashMap<String, FSFederationTerminationNotification>();
            env.put("FSFederationTerminationNotification", terminationRequest);
            String userID = managerInst.getUserID(acctkey, realm, env);
            if (userID == null && (userID = managerInst.getUserID(acctkey = hostedProviderRole.equalsIgnoreCase("SP") ? new FSAccountFedInfoKey(remoteEntityId, nameIDValue) : new FSAccountFedInfoKey(hostedEntityId, nameIDValue), realm, env)) == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("UserID is null");
                }
                return null;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("user ID is " + userID);
            }
            if ((acctInfo = managerInst.readAccountFedInfo(userID, remoteEntityId, nameIDValue)) == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Account federation with provider " + remoteEntityId + " does not exist");
                }
                return null;
            }
            FSFedTerminationHandler handlerTermination = new FSFedTerminationHandler();
            if (handlerTermination != null) {
                handlerTermination.setUserID(userID);
                handlerTermination.setAccountInfo(acctInfo);
                return handlerTermination;
            }
            FSUtils.debug.message("Termination Handler is null");
            return null;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSServiceManager::getFedTerminationHandler failed to get termination handler");
            return null;
        }
    }

    public FSPreLogoutHandler getPreLogoutHandler() {
        FSUtils.debug.message("Entered FSServicemanager::getPreLogoutHandler");
        try {
            FSPreLogoutHandler handlerLogout = null;
            handlerLogout = new FSPreLogoutHandler();
            if (handlerLogout != null) {
                return handlerLogout;
            }
            FSUtils.debug.message("PreLogoutHandler is null");
        }
        catch (Exception e) {
            FSUtils.debug.error("FSServiceManager::getSingleLogoutHandler failed to get logout handler");
        }
        return null;
    }

    public FSFedTerminationHandler getFedTerminationHandler(String remoteEntityId, String remoteProviderRole, String userID, String realm, String hostEntityId, String metaAlias) {
        try {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Entered FSServicemanager:: getFedTerminationHandler");
            }
            FSFedTerminationHandler handlerTermination = null;
            IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
            FSAccountManager managerInst = FSAccountManager.getInstance(metaAlias);
            if (metaManager == null || managerInst == null) {
                FSUtils.debug.message("Error in retrieving meta, account manager");
                return null;
            }
            FSAccountFedInfo acctInfo = managerInst.readAccountFedInfo(userID, remoteEntityId);
            if (acctInfo == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Account federation with provider " + remoteEntityId + " does not exist");
                }
                return null;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSServiceManager.getFedTerminationHandler: remoteEntityID = " + remoteEntityId + " remoteProviderRole = " + remoteProviderRole);
            }
            if ((handlerTermination = new FSFedTerminationHandler()) != null) {
                ProviderDescriptorType remoteDesc = null;
                remoteDesc = remoteProviderRole.equalsIgnoreCase("IDP") ? metaManager.getIDPDescriptor(realm, remoteEntityId) : metaManager.getSPDescriptor(realm, remoteEntityId);
                handlerTermination.setRemoteDescriptor(remoteDesc);
                handlerTermination.setRemoteEntityId(remoteEntityId);
                handlerTermination.setUserID(userID);
                handlerTermination.setAccountInfo(acctInfo);
                return handlerTermination;
            }
            FSUtils.debug.message("Termination Handler is null");
            return null;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSServiceManager::getFedTerminationHandler failed to get termination handler");
            return null;
        }
    }

    public FSNameRegistrationHandler getNameRegistrationHandler(String remoteEntityId, String remoteProviderRole, String userID, String hostEntityId, String metaAlias) {
        try {
            FSUtils.debug.message("Entered FSServiceManager::getNameRegistrationHandler");
            IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
            FSAccountManager managerInst = FSAccountManager.getInstance(metaAlias);
            if (metaManager == null || managerInst == null) {
                FSUtils.debug.message("Error in retrieving meta, account manager");
                return null;
            }
            FSAccountFedInfo acctInfo = managerInst.readAccountFedInfo(userID, remoteEntityId);
            if (acctInfo == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Account federation with provider " + remoteEntityId + " does not exist");
                }
                return null;
            }
            String realm = IDFFMetaUtils.getRealmByMetaAlias(metaAlias);
            FSNameRegistrationHandler handlerRegistration = new FSNameRegistrationHandler();
            if (handlerRegistration != null) {
                ProviderDescriptorType remoteDesc = null;
                BaseConfigType remoteConfig = null;
                if (remoteProviderRole.equalsIgnoreCase("SP")) {
                    remoteDesc = metaManager.getSPDescriptor(realm, remoteEntityId);
                    remoteConfig = metaManager.getSPDescriptorConfig(realm, remoteEntityId);
                } else {
                    remoteDesc = metaManager.getIDPDescriptor(realm, remoteEntityId);
                    remoteConfig = metaManager.getIDPDescriptorConfig(realm, remoteEntityId);
                }
                handlerRegistration.setRealm(realm);
                handlerRegistration.setRemoteEntityId(remoteEntityId);
                handlerRegistration.setRemoteDescriptor(remoteDesc);
                handlerRegistration.setUserID(userID);
                handlerRegistration.setAccountInfo(acctInfo);
                return handlerRegistration;
            }
            FSUtils.debug.message("Registration Handler is null");
            return null;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSServiceManager::getNameRegistrationHandler failed to get registration handler");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSServiceManager getInstance() {
        FSUtils.debug.message("FSServiceManager.getInstance: Called ");
        if (instance == null) {
            Class clazz = FSServiceManager.class;
            synchronized (clazz) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSServiceManager.getInstance:  Creating a new instance of ServiceManager");
                }
                instance = new FSServiceManager();
            }
        }
        return instance;
    }
}

