/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.sun.identity.federation.common.FSException;
import com.sun.identity.shared.validation.PositiveIntegerValidator;
import com.sun.identity.shared.validation.ValidationException;
import java.util.StringTokenizer;

public class FSSPAuthenticationContextInfo {
    private String authenticationContext = null;
    private int authenticationLevel = -1;

    public FSSPAuthenticationContextInfo() {
    }

    public FSSPAuthenticationContextInfo(String mapping) throws FSException {
        if (mapping == null) {
            throw new FSException("nullInput", null);
        }
        StringTokenizer stk = new StringTokenizer(mapping, "|");
        while (stk.hasMoreTokens()) {
            String token = stk.nextToken();
            int equalSign = token.indexOf("=");
            if (equalSign == -1) {
                throw new FSException("wrongInput", null);
            }
            try {
                String key = token.substring(0, equalSign);
                String value = token.substring(equalSign + 1, token.length());
                if (key.equalsIgnoreCase("context")) {
                    this.authenticationContext = value;
                    continue;
                }
                if (key.equalsIgnoreCase("level")) {
                    this.authenticationLevel = Integer.parseInt(value);
                    continue;
                }
                throw new FSException("wrongInput", null);
            }
            catch (IndexOutOfBoundsException ie) {
                throw new FSException("wrongInput", null);
            }
            catch (NumberFormatException ne) {
                throw new FSException("wrongInput", null);
            }
        }
        if (this.authenticationContext == null || this.authenticationLevel == -1) {
            throw new FSException("wrongInput", null);
        }
    }

    public FSSPAuthenticationContextInfo(String authenticationContext, int authenticationLevel) throws FSException {
        this.setAuthenticationContext(authenticationContext);
        this.setAuthenticationLevel(authenticationLevel);
    }

    public FSSPAuthenticationContextInfo(String authenticationContext, String authenticationLevel) throws FSException {
        this.setAuthenticationContext(authenticationContext);
        this.setAuthenticationLevel(authenticationLevel);
    }

    public String getAuthenticationContext() {
        return this.authenticationContext;
    }

    public void setAuthenticationContext(String authenticaionContext) throws FSException {
        if (authenticaionContext == null || authenticaionContext.trim().length() == 0) {
            throw new FSException("meta_missing_auth_context", null);
        }
        this.authenticationContext = authenticaionContext;
    }

    public int getAuthenticationLevel() {
        return this.authenticationLevel;
    }

    public void setAuthenticationLevel(int authenticationLevel) throws FSException {
        if (authenticationLevel < 0) {
            throw new FSException("meta_invalid_level", null);
        }
        this.authenticationLevel = authenticationLevel;
    }

    public void setAuthenticationLevel(String authenticationLevel) throws FSException {
        PositiveIntegerValidator validator = PositiveIntegerValidator.getInstance();
        try {
            validator.validate(authenticationLevel);
            this.authenticationLevel = Integer.parseInt(authenticationLevel);
        }
        catch (ValidationException e) {
            throw new FSException("meta_invalid_level", null);
        }
    }
}

