/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.IDPDescriptorConfigElement;
import com.sun.identity.federation.message.FSSubject;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.FSRealmAttributePlugin;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.plugin.datastore.DataStoreProvider;
import com.sun.identity.plugin.datastore.DataStoreProviderException;
import com.sun.identity.plugin.datastore.DataStoreProviderManager;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.common.SAMLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FSDefaultRealmAttributePlugin
implements FSRealmAttributePlugin {
    public List getAttributeStatements(String realm, String hostEntityId, String remoteEntityID, FSSubject subject, Object token) {
        FSUtils.debug.message("FSDefaultAttributePlugin.getAttributeStatements");
        Map attributeMap = null;
        try {
            IDPDescriptorConfigElement idpConfig;
            IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
            if (metaManager != null && (idpConfig = metaManager.getIDPDescriptorConfig(realm, hostEntityId)) != null) {
                Map attributes = IDFFMetaUtils.getAttributes(idpConfig);
                attributeMap = FSServiceUtils.parseAttributeConfig((List)attributes.get("idpAttributeMap"));
            }
        }
        catch (IDFFMetaException me) {
            FSUtils.debug.error("FSDefaultAttributePlugin.getAttributeStatements: meta exception.", (Throwable)((Object)me));
            return null;
        }
        if (attributeMap == null || attributeMap.isEmpty()) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSDefaultAttributePlugin.getAttributeStatements: Attribute map configuration is empty.");
            }
            return null;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSDefaultAttributePlugin.getAttributeStatements: Attribute map configuration: " + attributeMap);
        }
        ArrayList<AttributeStatement> statements = new ArrayList<AttributeStatement>();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        try {
            Iterator iter = attributeMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String attributeName = (String)entry.getKey();
                String attributeValue = this.getAttributeValue(token, (String)entry.getValue());
                if (attributeValue == null) continue;
                Attribute attr = new Attribute(attributeName, "urn:oasis:names:tc:SAML:1.0:assertion", attributeValue);
                attributes.add(attr);
            }
            AttributeStatement statement = new AttributeStatement(subject, attributes);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSDefaultAttributePlugin.getAttributeStatements: attribute statement: " + statement.toString());
            }
            statements.add(statement);
            return statements;
        }
        catch (SAMLException ex) {
            FSUtils.debug.error("FSDefaultAttributePlugin.getAttributeStatements: SAML Exception", (Throwable)((Object)ex));
            return new ArrayList();
        }
    }

    private String getAttributeValue(Object token, String attrName) {
        if (attrName == null) {
            FSUtils.debug.error("FSDefaultAttributePlugin.getAttributeValue: attribute Name is null. Check the attribute map");
            return null;
        }
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            String userID = sessionProvider.getPrincipalName(token);
            DataStoreProvider dsProvider = DataStoreProviderManager.getInstance().getDataStoreProvider("IDFF");
            Set attrValues = dsProvider.getAttribute(userID, attrName);
            if (attrValues == null || attrValues.isEmpty()) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSDefaultAttributePlugin.getAttributeValue: values not found for : " + attrName);
                }
                return null;
            }
            return (String)attrValues.iterator().next();
        }
        catch (SessionException se) {
            FSUtils.debug.error("FSDefaultAttributePlugin.getAttributeValue: exception:", (Throwable)((Object)se));
        }
        catch (DataStoreProviderException dspe) {
            FSUtils.debug.error("FSDefaultAttributePlugin.getAttributeValue: exception: ", (Throwable)((Object)dspe));
        }
        return null;
    }
}

