/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSRemoteException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.services.FSAssertionManager;
import com.sun.identity.federation.services.FSAssertionManagerImpl;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.jaxrpc.SOAPClient;
import com.sun.identity.shared.xml.XMLUtils;
import java.net.InetAddress;
import java.net.URL;
import java.rmi.RemoteException;
import org.w3c.dom.Document;

public final class FSAssertionManagerClient {
    private static String SERVICE_NAME = "fsassertionmanager";
    private static boolean checkedForLocal;
    private static boolean isLocal;
    private boolean useLocal;
    private String hostedEntityId;
    private String metaAlias;
    private static SOAPClient remoteStub;
    private static FSAssertionManager assertionManager;
    private SOAPClient stub;

    public FSAssertionManagerClient(String metaAlias) throws FSException {
        if (!checkedForLocal) {
            try {
                this.metaAlias = metaAlias;
                this.hostedEntityId = FSUtils.getIDFFMetaManager().getEntityIDByMetaAlias(metaAlias);
                remoteStub = FSAssertionManagerClient.getServiceEndPoint(SystemConfigurationUtil.getProperty("com.iplanet.am.server.protocol"), InetAddress.getLocalHost().getHostName(), Integer.parseInt(SystemConfigurationUtil.getProperty("com.iplanet.am.server.port")), SystemConfigurationUtil.getProperty("com.iplanet.am.services.deploymentDescriptor"));
                remoteStub.send("checkForLocal", null, null);
                if (FSAssertionManagerImpl.isLocal) {
                    isLocal = true;
                    assertionManager = FSAssertionManager.getInstance(metaAlias);
                }
                checkedForLocal = true;
            }
            catch (Exception e) {
                checkedForLocal = true;
                if (FSUtils.debug.warningEnabled()) {
                    FSUtils.debug.warning("AssertionManagerClient()Exception", (Throwable)e);
                }
                throw new FSException(e.getMessage());
            }
        }
        if (isLocal) {
            this.useLocal = true;
        } else {
            this.stub = remoteStub;
        }
    }

    public FSAssertionManagerClient(String metaAlias, String url) throws FSException {
        try {
            this.metaAlias = metaAlias;
            this.hostedEntityId = FSUtils.getIDFFMetaManager().getEntityIDByMetaAlias(metaAlias);
            String[] urls = new String[]{url};
            this.stub = new SOAPClient(urls);
        }
        catch (Exception e) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("FSAssertionManagerClient() Exception", (Throwable)e);
            }
            throw new FSException(e.getMessage());
        }
    }

    private static SOAPClient getServiceEndPoint(String protocol, String hostname, int port, String uri) throws Exception {
        URL weburl = SystemConfigurationUtil.getServiceURL(SERVICE_NAME, protocol, hostname, port, uri);
        String iurl = weburl.toString();
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManagerClient with URL: " + iurl);
        }
        String[] urls = new String[]{iurl};
        return new SOAPClient(urls);
    }

    protected Assertion getAssertion(AssertionArtifact artifact, String destID) throws FSException {
        if (this.useLocal) {
            return assertionManager.getAssertion(artifact, destID);
        }
        String assertion = null;
        try {
            Object[] obj = new Object[]{this.metaAlias, artifact.getAssertionArtifact(), Base64.encode((byte[])SAMLUtils.stringToByteArray(destID))};
            assertion = (String)this.stub.send("getAssertion", obj, null, null);
            if (assertion == null && FSUtils.debug.messageEnabled()) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("AMC:getAssertion(" + artifact + ", " + destID + "): Server returned NULL");
                }
            } else if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:getAssertion: asserion:" + assertion);
            }
            return assertion == null ? null : new FSAssertion(XMLUtils.toDOMDocument((String)assertion, (Debug)FSUtils.debug).getDocumentElement());
        }
        catch (RemoteException re) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:getAssertion: " + artifact, (Throwable)re);
            }
            throw new FSException(re.getMessage());
        }
        catch (FSRemoteException re) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:getAssertion: " + artifact, (Throwable)re);
            }
            throw new FSException(re.getMessage());
        }
        catch (SAMLException re) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:getAssertion: " + artifact, (Throwable)((Object)re));
            }
            throw new FSException(re.getMessage());
        }
        catch (Exception re) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:getAssertion: " + artifact, (Throwable)re);
            }
            throw new FSException(re.getMessage());
        }
    }

    protected String getDestIdForArtifact(AssertionArtifact artifact) throws FSException {
        if (this.useLocal) {
            return assertionManager.getDestIdForArtifact(artifact);
        }
        String providerId = null;
        try {
            Object[] obj = new Object[]{this.metaAlias, artifact.getAssertionArtifact()};
            providerId = (String)this.stub.send("getDestIdForArtifact", obj, null, null);
            if (providerId == null && FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("AMC:getDestIdForArtifact(" + artifact + "): Server returned NULL");
            }
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:getDestIdForArtifact: returning" + providerId);
            }
            return providerId;
        }
        catch (RemoteException re) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:getDestIdForArtifact: " + artifact, (Throwable)re);
            }
            throw new FSException(re.getMessage());
        }
        catch (FSRemoteException re) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:getDestIdForArtifact: " + artifact, (Throwable)re);
            }
            throw new FSException(re.getMessage());
        }
        catch (Exception re) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:getDestIdForArtifact: " + artifact, (Throwable)re);
            }
            throw new FSException(re.getMessage());
        }
    }

    public boolean isUserExists(String userDN) throws FSException {
        try {
            Object[] obj = new Object[]{userDN, this.metaAlias};
            Boolean ret = (Boolean)this.stub.send("isUserExists", obj, null, null);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("AMC:isUserExists(" + userDN + ")" + " returned " + ret);
            }
            return ret;
        }
        catch (RemoteException re) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:isUserExists: " + userDN, (Throwable)re);
            }
            throw new FSException(re.getMessage());
        }
        catch (FSRemoteException re) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:isUserExists: " + userDN, (Throwable)re);
            }
            throw new FSException(re.getMessage());
        }
        catch (Exception re) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:isUserExists: " + userDN, (Throwable)re);
            }
            throw new FSException(re.getMessage());
        }
    }

    protected Status getErrorStatus(AssertionArtifact artifact) throws FSException {
        String status = null;
        try {
            Document doc;
            Object[] obj = new Object[]{this.metaAlias, artifact.getAssertionArtifact()};
            status = (String)this.stub.send("getErrorStatus", obj, null, null);
            if (status == null && FSUtils.debug.messageEnabled()) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("AMC:getErrorStatus(" + artifact + "): Server returned NULL");
                }
            } else if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("AMC:getErrorStatus: status:" + status);
            }
            if (null != status && null != (doc = XMLUtils.toDOMDocument((String)status, (Debug)FSUtils.debug))) {
                return new Status(doc.getDocumentElement());
            }
        }
        catch (RemoteException re) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:getErrorStatus: " + artifact, (Throwable)re);
            }
            throw new FSException(re.getMessage());
        }
        catch (FSRemoteException re) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:getErrorStatus: " + artifact, (Throwable)re);
            }
            throw new FSException(re.getMessage());
        }
        catch (SAMLException re) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:getErrorStatus: " + artifact, (Throwable)((Object)re));
            }
            throw new FSException(re.getMessage());
        }
        catch (Exception re) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:getErrorStatus: " + artifact, (Throwable)re);
            }
            throw new FSException(re.getMessage());
        }
        return null;
    }
}

