/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.sun.identity.common.PeriodicGroupRunnable;
import com.sun.identity.common.ScheduleableGroupAction;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.common.SystemTimerPool;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.common.TimerPool;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.jaxb.entityconfig.IDPDescriptorConfigElement;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAssertionArtifact;
import com.sun.identity.federation.message.FSAuthenticationStatement;
import com.sun.identity.federation.message.FSSubject;
import com.sun.identity.federation.message.common.AuthnContext;
import com.sun.identity.federation.message.common.IDPProvidedNameIdentifier;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.FSArtifactStats;
import com.sun.identity.federation.services.FSAssertionManagerClient;
import com.sun.identity.federation.services.FSAssertionStats;
import com.sun.identity.federation.services.FSAttributePlugin;
import com.sun.identity.federation.services.FSDiscoveryBootStrap;
import com.sun.identity.federation.services.FSRealmAttributePlugin;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.util.FSAttributeStatementHelper;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.assertion.Advice;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AudienceRestrictionCondition;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.assertion.SubjectLocality;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.stats.Stats;
import com.sun.identity.shared.stats.StatsListener;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public final class FSAssertionManager {
    public static Stats artStats = Stats.getInstance((String)"libIDFFArtifactMap");
    public static Stats assrtStats = Stats.getInstance((String)"libIDFFAssertionMap");
    private static final Integer DEFAULT_CLEANUP_INTERVAL = new Integer(180);
    private static final Integer DEFAULT_ASSERTION_TIMEOUT = new Integer(60);
    private static Map instanceMap = new HashMap();
    private Map artIdMap = null;
    private Map idEntryMap = new HashMap();
    private PeriodicGroupRunnable assertionTimeoutRunnable;
    private PeriodicGroupRunnable artifactTimeoutRunnable;
    private static String SERVICE_NAMING = "fsassertionmanager";
    private int cleanupInterval;
    private int assertionTimeout;
    private int artifactTimeout;
    private FSArtifactStats artIdStats;
    private FSAssertionStats assrtIdStats;
    private String hostEntityId = null;
    private String realm = null;
    private String metaAlias = null;

    private FSAssertionManager(String metaAlias) throws FSException {
        this.artIdMap = new HashMap();
        this.metaAlias = metaAlias;
        this.realm = IDFFMetaUtils.getRealmByMetaAlias(metaAlias);
        try {
            IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
            if (metaManager != null) {
                this.hostEntityId = metaManager.getEntityIDByMetaAlias(metaAlias);
            }
        }
        catch (IDFFMetaException ie) {
            throw new FSException((Exception)((Object)ie));
        }
        if (this.hostEntityId == null) {
            throw new FSException("nullProviderID", null);
        }
        this.cleanupInterval = 180000;
        this.assertionTimeout = 60000;
        this.artifactTimeout = 120000;
        try {
            IDPDescriptorConfigElement idpConfig = FSUtils.getIDFFMetaManager().getIDPDescriptorConfig(this.realm, this.hostEntityId);
            Map attributes = IDFFMetaUtils.getAttributes(idpConfig);
            try {
                this.cleanupInterval = Integer.parseInt(IDFFMetaUtils.getFirstAttributeValue(attributes, "cleanupInterval")) * 1000;
            }
            catch (Exception e) {
                FSUtils.debug.error("FSAssertionManager: Exception while parsing interval", (Throwable)e);
            }
            try {
                this.assertionTimeout = Integer.parseInt(IDFFMetaUtils.getFirstAttributeValue(attributes, "assertionInterval")) * 1000;
            }
            catch (Exception e) {
                FSUtils.debug.error("AssertionManager: Exception while parsing timeout", (Throwable)e);
            }
            if (this.assertionTimeout < 60000) {
                this.assertionTimeout = 60000;
            }
            try {
                this.artifactTimeout = Integer.parseInt(IDFFMetaUtils.getFirstAttributeValue(attributes, "artifactTimeout")) * 1000;
            }
            catch (Exception ex) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionManager: ArtifactTimeOut configuration not found in FSConfig. Using Default");
                }
            }
        }
        catch (Exception e) {
            FSUtils.debug.error("FSAssertionManager: Exception while parsing cleanup assertion :", (Throwable)e);
        }
        ScheduleableGroupAction timeoutAction = new ScheduleableGroupAction(){

            public void doGroupAction(Object obj) {
                String artString;
                Entry entry = (Entry)FSAssertionManager.this.idEntryMap.remove(obj);
                if (entry != null && (artString = entry.getArtifactString()) != null) {
                    FSAssertionManager.this.artIdMap.remove(artString);
                }
            }
        };
        this.assertionTimeoutRunnable = new PeriodicGroupRunnable(timeoutAction, (long)this.cleanupInterval, (long)this.assertionTimeout, true);
        this.artifactTimeoutRunnable = new PeriodicGroupRunnable(timeoutAction, (long)this.cleanupInterval, (long)this.artifactTimeout, true);
        TimerPool pool = SystemTimerPool.getTimerPool();
        pool.schedule((TaskRunnable)this.assertionTimeoutRunnable, new Date((System.currentTimeMillis() + (long)this.cleanupInterval) / 1000L * 1000L));
        pool.schedule((TaskRunnable)this.artifactTimeoutRunnable, new Date((System.currentTimeMillis() + (long)this.cleanupInterval) / 1000L * 1000L));
        if (assrtStats.isEnabled()) {
            this.assrtIdStats = new FSAssertionStats(this.idEntryMap, this.realm, this.hostEntityId);
            assrtStats.addStatsListener((StatsListener)this.assrtIdStats);
            this.artIdStats = new FSArtifactStats(this.artIdMap, this.realm, this.hostEntityId);
            artStats.addStatsListener((StatsListener)this.artIdStats);
        }
    }

    public String getMetaAlias() {
        return this.metaAlias;
    }

    public void setMetaAlias(String metaAlias) {
        this.metaAlias = metaAlias;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getEntityId() {
        return this.hostEntityId;
    }

    public void setEntityId(String entityId) {
        this.hostEntityId = entityId;
    }

    public Map getArtIdMap() {
        return this.artIdMap;
    }

    public Map getIdEntryMap() {
        return this.idEntryMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized FSAssertionManager getInstance(String metaAlias) throws FSException {
        FSUtils.debug.message("FSAssertionManager.getInstance: Called");
        FSAssertionManager instance = (FSAssertionManager)instanceMap.get(metaAlias);
        if (instance == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getInstance: Constructing a new instance of FSAssertionManager");
            }
            instance = new FSAssertionManager(metaAlias);
            Map map = instanceMap;
            synchronized (map) {
                instanceMap.put(metaAlias, instance);
            }
        }
        return instance;
    }

    public AssertionArtifact createFSAssertionArtifact(String id, String realm, String spEntityID, NameIdentifier spHandle, NameIdentifier idpHandle, String inResponseTo, int minorVersion) throws FSException, SAMLException {
        if (id == null || spEntityID == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager: null input for method createFSAssertionArtifact.");
            }
            throw new FSException("nullInput", null);
        }
        String handle = SAMLUtils.generateAssertionHandle();
        if (handle == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.createFSAssertionArtifact: couldn't generate assertion handle.");
            }
            throw new FSException("errorCreateArtifact", null);
        }
        String sourceSuccinctID = FSUtils.generateSourceID(this.hostEntityId);
        byte[] bytesSourceId = SAMLUtils.stringToByteArray(sourceSuccinctID);
        byte[] bytesHandle = null;
        try {
            bytesHandle = handle.getBytes("ISO-8859-1");
        }
        catch (Exception e) {
            FSUtils.debug.error("FSAssertionManager.createFSAssertionArt: ", (Throwable)e);
            return null;
        }
        FSAssertionArtifact art = new FSAssertionArtifact(bytesSourceId, bytesHandle);
        int assertionMinorVersion = 0;
        if (minorVersion == 2) {
            assertionMinorVersion = 2;
        }
        FSAssertion assertion = this.createFSAssertion(id, art, realm, spEntityID, spHandle, idpHandle, inResponseTo, assertionMinorVersion);
        return art;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSAssertion createFSAssertion(String id, AssertionArtifact artifact, String realm, String spEntityID, NameIdentifier spHandle, NameIdentifier idpHandle, String inResponseTo, int assertionMinorVersion) throws FSException, SAMLException {
        Object data;
        int maxValue;
        String attributePluginImpl;
        FSUtils.debug.message("FSAssertionManager.createFSAssertion(id): Called");
        if (id == null || spEntityID == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager: null input for method createFSAssertion.");
            }
            throw new FSException("nullInput", null);
        }
        String destID = spEntityID;
        String authMethod = null;
        String authnContextStatementRef = null;
        String authnContextClassRef = null;
        Date authInstant = null;
        String securityDomain = null;
        Object token = null;
        String univId = null;
        SubjectLocality authLocality = null;
        FSSessionManager sessionManager = FSSessionManager.getInstance(this.metaAlias);
        IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
        Map attributes = new HashMap();
        if (metaManager != null) {
            IDPDescriptorConfigElement idpConfig = null;
            try {
                idpConfig = metaManager.getIDPDescriptorConfig(realm, this.hostEntityId);
            }
            catch (IDFFMetaException e) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionManager.createFSAssertion: exception while obtaining idp extended meta:", (Throwable)((Object)e));
                }
                idpConfig = null;
            }
            if (idpConfig != null) {
                attributes = IDFFMetaUtils.getAttributes(idpConfig);
            }
        }
        try {
            SessionProvider sessionProvider;
            block84: {
                String[] strAuthInst;
                block83: {
                    sessionProvider = SessionManager.getProvider();
                    token = sessionProvider.getSession(id);
                    strAuthInst = null;
                    try {
                        strAuthInst = sessionProvider.getProperty(token, "authInstant");
                    }
                    catch (UnsupportedOperationException ue) {
                        if (FSUtils.debug.warningEnabled()) {
                            FSUtils.debug.warning("FSAssertionManager.createFSAssertion(id):", (Throwable)ue);
                        }
                    }
                    catch (SessionException se) {
                        if (!FSUtils.debug.warningEnabled()) break block83;
                        FSUtils.debug.warning("FSAssertionManager.createFSAssertion(id):", (Throwable)((Object)se));
                    }
                }
                if (strAuthInst != null && strAuthInst.length >= 1) {
                    try {
                        authInstant = DateUtils.stringToDate((String)strAuthInst[0]);
                    }
                    catch (ParseException ex) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSAssertionManager.createFSAssertion(id): AuthInstant not foundin the Token");
                        }
                    }
                } else {
                    authInstant = new Date();
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionManager.createFSAssertion(id):AuthInstant = " + authInstant);
                }
                try {
                    String[] strAuthMethod = sessionProvider.getProperty(token, "authMethod");
                    if (strAuthMethod != null && strAuthMethod.length >= 1) {
                        authMethod = strAuthMethod[0];
                    }
                }
                catch (UnsupportedOperationException ue) {
                    if (FSUtils.debug.warningEnabled()) {
                        FSUtils.debug.warning("FSAssertionManager.createFSAssertion(id):", (Throwable)ue);
                    }
                }
                catch (SessionException se) {
                    if (!FSUtils.debug.warningEnabled()) break block84;
                    FSUtils.debug.warning("FSAssertionManager.createFSAssertion(id):", (Throwable)((Object)se));
                }
            }
            String assertionIssuer = IDFFMetaUtils.getFirstAttributeValue(attributes, "assertionIssuer");
            if (assertionIssuer == null) {
                assertionIssuer = SystemConfigurationUtil.getProperty("com.iplanet.am.server.host");
            }
            try {
                String ipAddress = InetAddress.getByName(assertionIssuer).getHostAddress();
                authLocality = new SubjectLocality(ipAddress, assertionIssuer);
            }
            catch (UnknownHostException uhe) {
                FSUtils.debug.error("FSAssertionManager.constructor: couldn't obtain the localhost's ipaddress:", (Throwable)uhe);
            }
            try {
                FSSession session = sessionManager.getSession(token);
                authnContextStatementRef = authnContextClassRef = session.getAuthnContext();
            }
            catch (Exception ex) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionManager.createFSAssertion(id): AuthnContextStatement for the token is null Assertion will not contain any  AuthenticationStatement");
                }
                authnContextStatementRef = null;
            }
            if (authnContextStatementRef != null) {
                authMethod = assertionMinorVersion == 0 ? "http://projectliberty.org/schemas/authctx/2002/05" : "urn:liberty:ac:2003-08";
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.createFSAssertion(id):AuthnContextStatement used for authenticating the user: " + authnContextStatementRef);
            }
            univId = sessionProvider.getPrincipalName(token);
            securityDomain = this.hostEntityId;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSAssertionManager.createAssertion(id): exception retrieving info from the session: ", (Throwable)e);
            throw new FSException("alliance_manager_no_local_descriptor", null, e);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.createAssertion(id): Creating Authentication Assertion for user withopaqueHandle= " + spHandle.getName() + " And SecurityDomain= " + securityDomain);
        }
        SubjectConfirmation subConfirmation = null;
        String artString = null;
        if (artifact != null) {
            artString = artifact.getAssertionArtifact();
            subConfirmation = assertionMinorVersion == 0 ? new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:artifact-01") : new SubjectConfirmation(SAMLConstants.CONFIRMATION_METHOD_ARTIFACT);
            subConfirmation.setSubjectConfirmationData(artString);
        } else {
            subConfirmation = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:bearer");
        }
        IDPProvidedNameIdentifier idpNi = null;
        if (assertionMinorVersion == 2 || assertionMinorVersion == 2) {
            idpNi = new IDPProvidedNameIdentifier(idpHandle.getName(), idpHandle.getNameQualifier(), spHandle.getFormat());
            idpNi.setMinorVersion(2);
        } else {
            idpNi = new IDPProvidedNameIdentifier(idpHandle.getNameQualifier(), idpHandle.getName());
        }
        FSSubject sub = new FSSubject(spHandle, subConfirmation, idpNi);
        AuthnContext authnContext = new AuthnContext(authnContextClassRef, authnContextStatementRef);
        authnContext.setMinorVersion(assertionMinorVersion);
        FSAuthenticationStatement statement = new FSAuthenticationStatement(authMethod, authInstant, sub, authLocality, null, authnContext);
        FSSession session = sessionManager.getSession(univId, id);
        if (session == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.createAssertion(id): AssertionManager could not find a valid Session foruserId: " + univId + " SessionID: " + id);
            }
            return null;
        }
        String sessionIndex = session.getSessionIndex();
        if (sessionIndex == null) {
            sessionIndex = SAMLUtils.generateID();
            session.setSessionIndex(sessionIndex);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.createAssertion(id): SessionIndex: " + sessionIndex);
        }
        statement.setSessionIndex(sessionIndex);
        Date issueInstant = new Date();
        FSUtils.debug.message("here before date");
        Date notAfter = artifact != null ? new Date(issueInstant.getTime() + (long)this.artifactTimeout) : new Date(issueInstant.getTime() + (long)this.assertionTimeout);
        FSUtils.debug.message("here after date");
        statement.setReauthenticateOnOrAfter(notAfter);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.createAssertion(id): Authentication Statement: " + statement.toXMLString());
        }
        Conditions cond = new Conditions(null, notAfter);
        if (destID != null && destID.length() != 0) {
            ArrayList<String> targets = new ArrayList<String>();
            targets.add(destID);
            cond.addAudienceRestrictionCondition(new AudienceRestrictionCondition(targets));
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.createAssertion(id): Authentication Statement: " + statement.toXMLString());
        }
        AttributeStatement attribStatement = null;
        Advice advice = null;
        String generateBootstrapping = IDFFMetaUtils.getFirstAttributeValue(attributes, "generateBootstrapping");
        if (assertionMinorVersion != 0 && generateBootstrapping != null && generateBootstrapping.equals("true")) {
            AuthnContext authContext = new AuthnContext(null, authnContextStatementRef);
            authContext.setMinorVersion(2);
            try {
                FSDiscoveryBootStrap bootStrap = new FSDiscoveryBootStrap(token, authContext, sub, univId, destID, realm);
                attribStatement = bootStrap.getBootStrapStatement();
                if (bootStrap.hasCredentials()) {
                    advice = bootStrap.getCredentials();
                }
            }
            catch (Exception e) {
                FSUtils.debug.error("FSAssertionManager.createAssertion(id):exception when generating bootstrapping resource offering:", (Throwable)e);
            }
        }
        AssertionIDReference aID = new AssertionIDReference();
        HashSet<SubjectStatement> statements = new HashSet<SubjectStatement>();
        statements.add(statement);
        if (attribStatement != null) {
            statements.add(attribStatement);
        }
        if ((attributePluginImpl = IDFFMetaUtils.getFirstAttributeValue(attributes, "attributePlugin")) != null && attributePluginImpl.length() != 0) {
            try {
                Object attributePlugin;
                Object pluginClass = Thread.currentThread().getContextClassLoader().loadClass(attributePluginImpl).newInstance();
                List attribStatements = null;
                if (pluginClass instanceof FSRealmAttributePlugin) {
                    attributePlugin = (FSRealmAttributePlugin)pluginClass;
                    attribStatements = attributePlugin.getAttributeStatements(realm, this.hostEntityId, destID, sub, token);
                } else if (pluginClass instanceof FSAttributePlugin) {
                    attributePlugin = (FSAttributePlugin)pluginClass;
                    attribStatements = attributePlugin.getAttributeStatements(this.hostEntityId, destID, sub, token);
                }
                if (attribStatements != null && attribStatements.size() != 0) {
                    Iterator iter = attribStatements.iterator();
                    while (iter.hasNext()) {
                        statements.add((AttributeStatement)iter.next());
                    }
                }
            }
            catch (Exception ex) {
                FSUtils.debug.error("FSAssertion.createAssertion(id):getAttributePlugin:", (Throwable)ex);
            }
        }
        if (IDFFMetaUtils.isAutoFedEnabled(attributes)) {
            AttributeStatement autoFedStatement = FSAttributeStatementHelper.getAutoFedAttributeStatement(realm, this.hostEntityId, sub, token);
            statements.add(autoFedStatement);
        }
        FSAssertion assertion = new FSAssertion(aID.getAssertionIDReference(), this.hostEntityId, issueInstant, cond, advice, statements, inResponseTo);
        assertion.setMinorVersion(assertionMinorVersion);
        assertion.setID(aID.getAssertionIDReference());
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.createAssertion(id): Assertion created successfully: " + assertion.toXMLString());
        }
        String aIDString = assertion.getAssertionID();
        Entry entry = new Entry(assertion, destID, artString, token);
        Integer maxNumber = null;
        try {
            int temp = Integer.parseInt(IDFFMetaUtils.getFirstAttributeValue(attributes, "assertionLimit"));
            maxNumber = new Integer(temp);
        }
        catch (Exception ex) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.createAssertion(id): Assertion MAX number configuration not found in FSConfig. Using Default");
            }
            maxNumber = null;
        }
        if (maxNumber == null) {
            maxNumber = new Integer(10);
        }
        if ((maxValue = maxNumber.intValue()) != 0 && this.idEntryMap.size() > maxValue) {
            FSUtils.debug.error("FSAssertionManager.createAssertion: reached maxNumber of assertions.");
            throw new FSException("errorCreateAssertion", null);
        }
        Object oldEntry = null;
        try {
            Map map = this.idEntryMap;
            synchronized (map) {
                oldEntry = this.idEntryMap.put(aIDString, entry);
            }
        }
        catch (Exception e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager: couldn't add to idEntryMap.", (Throwable)e);
            }
            throw new FSException("errorCreateAssertion", null);
        }
        if (LogUtil.isAccessLoggable(Level.FINER)) {
            data = new String[]{assertion.toString()};
            LogUtil.access(Level.FINER, "CREATE_ASSERTION", data);
        } else {
            data = new String[]{assertion.getAssertionID()};
            LogUtil.access(Level.INFO, "CREATE_ASSERTION", data);
        }
        if (artString != null) {
            try {
                data = this.artIdMap;
                synchronized (data) {
                    oldEntry = this.artIdMap.put(artString, aIDString);
                }
            }
            catch (Exception e) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionManager: couldn't add artifact to the artIdMap.", (Throwable)e);
                }
                throw new FSException("errorCreateArtifact", null);
            }
            if (oldEntry != null) {
                this.artifactTimeoutRunnable.removeElement((Object)aIDString);
            }
            this.artifactTimeoutRunnable.addElement((Object)aIDString);
        } else {
            if (oldEntry != null) {
                this.assertionTimeoutRunnable.removeElement((Object)aIDString);
            }
            this.assertionTimeoutRunnable.addElement((Object)aIDString);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.createAssertion(id): Returning Assertion: " + assertion.toXMLString());
        }
        return assertion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Assertion getAssertion(AssertionArtifact artifact, String destID) throws FSException {
        if (artifact == null || destID == null || destID.length() == 0) {
            FSUtils.debug.message("FSAssertionManager: input is null.");
            throw new FSException("nullInput", null);
        }
        String artString = artifact.getAssertionArtifact();
        String remoteUrl = SAMLUtils.getServerURL(artifact.getAssertionHandle());
        if (remoteUrl != null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("AssertionManager.getAssertion(art, destid: calling another server in lb site:" + remoteUrl);
            }
            FSAssertionManagerClient amc = new FSAssertionManagerClient(this.metaAlias, this.getFullServiceURL(remoteUrl));
            return amc.getAssertion(artifact, destID);
        }
        String aIDString = null;
        try {
            aIDString = (String)this.artIdMap.get(artString);
            if (aIDString == null) {
                throw new FSException("nullInput", null);
            }
        }
        catch (Exception e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getAssertion(art, destid): no AssertionID found corresponding to artifact.");
            }
            throw new FSException("noMatchingAssertion", null);
        }
        Entry entry = null;
        try {
            entry = (Entry)this.idEntryMap.get(aIDString);
            if (entry == null) {
                throw new FSException("nullEntry", null);
            }
        }
        catch (Exception e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getAssertion(art, destid): no Entry found corresponding to artifact.");
            }
            throw new FSException("noMatchingAssertion", null);
        }
        String dest = entry.getDestID();
        if (dest == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getAssertion(art, destid): no destID found corresponding to artifact.");
            }
            throw new FSException("noDestIDMatchingArtifact", null);
        }
        if (!dest.equals(destID)) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getAssertion(art, destid): destinationID doesn't match.");
            }
            throw new FSException("destIDNotMatch", null);
        }
        Map map = this.artIdMap;
        synchronized (map) {
            this.artIdMap.remove(artString);
        }
        this.artifactTimeoutRunnable.removeElement((Object)aIDString);
        map = this.idEntryMap;
        synchronized (map) {
            this.idEntryMap.remove(aIDString);
        }
        this.assertionTimeoutRunnable.removeElement((Object)aIDString);
        Assertion assertion = entry.getAssertion();
        if (assertion == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getAssertion(art, destid): no Assertion found corresponding to aID.");
            }
            throw new FSException("noMatchingAssertion", null);
        }
        if (!assertion.isTimeValid()) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager: assertion " + aIDString + " is expired.");
            }
            throw new FSException("assertionTimeNotValid", null);
        }
        return assertion;
    }

    public String getDestIdForArtifact(AssertionArtifact artifact) throws FSException {
        FSUtils.debug.message("FSAssertionManager.getDestIdForArtifact: Called");
        String artString = artifact.getAssertionArtifact();
        String remoteUrl = SAMLUtils.getServerURL(artifact.getAssertionHandle());
        if (remoteUrl != null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("AssertionManager.getDestIdForArtifact(art, destid: calling another server in lb site:" + remoteUrl);
            }
            FSAssertionManagerClient amc = new FSAssertionManagerClient(this.metaAlias, this.getFullServiceURL(remoteUrl));
            return amc.getDestIdForArtifact(artifact);
        }
        String aIDString = null;
        try {
            aIDString = (String)this.artIdMap.get(artString);
            if (aIDString == null) {
                throw new FSException("nullInput", null);
            }
        }
        catch (Exception e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getDestIdForArtifact :no AssertionID found corresponding to artifact.");
            }
            throw new FSException("noMatchingAssertion", null);
        }
        Entry entry = null;
        try {
            entry = (Entry)this.idEntryMap.get(aIDString);
            if (entry == null) {
                throw new FSException("nullEntry", null);
            }
        }
        catch (Exception e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getDestIdForArtifact: no Entry found corresponding to artifact.");
            }
            throw new FSException("noMatchingAssertion", null);
        }
        String dest = entry.getDestID();
        if (dest == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getDestIdForArtifact: no destID found corresponding to artifact.");
            }
            throw new FSException("noDestIDMatchingArtifact", null);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.getDestIdForArtifact: Destination ProviderID found for Artifact: " + dest);
        }
        return dest;
    }

    private String getFullServiceURL(String shortUrl) {
        String result;
        block3: {
            result = null;
            try {
                URL u = new URL(shortUrl);
                URL weburl = SystemConfigurationUtil.getServiceURL(SERVICE_NAMING, u.getProtocol(), u.getHost(), u.getPort(), u.getPath());
                result = weburl.toString();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("AssertionManager.getFullServiceURL:full remote URL is: " + result);
                }
            }
            catch (Exception e) {
                if (!FSUtils.debug.warningEnabled()) break block3;
                FSUtils.debug.warning("AssertionManager.getFullServiceURL:Exception:", (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrStatus(AssertionArtifact aa, Status s) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("setErrStatus( " + aa + ", " + s + " )");
        }
        String artString = aa.getAssertionArtifact();
        ErrorAssertion assertion = new ErrorAssertion(new Date(), s);
        Entry e = new Entry(assertion, null, artString, null);
        Entry oldEntry = null;
        Map map = this.idEntryMap;
        synchronized (map) {
            oldEntry = this.idEntryMap.put(artString, e);
        }
        if (oldEntry != null) {
            this.assertionTimeoutRunnable.removeElement((Object)artString);
        }
        this.assertionTimeoutRunnable.addElement((Object)artString);
    }

    public Status getErrorStatus(AssertionArtifact aa) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("getErrorStatus( " + aa + " )");
        }
        Entry e = null;
        Status s = null;
        String remoteUrl = SAMLUtils.getServerURL(aa.getAssertionHandle());
        if (remoteUrl != null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("AssertionManager.getAssertion(art, destid: calling another server in lb site:" + remoteUrl);
            }
            try {
                FSAssertionManagerClient amc = new FSAssertionManagerClient(this.metaAlias, this.getFullServiceURL(remoteUrl));
                s = amc.getErrorStatus(aa);
            }
            catch (FSException fse) {
                FSUtils.debug.error(fse.getMessage());
            }
        } else {
            Assertion assertion;
            e = (Entry)this.idEntryMap.get(aa.getAssertionArtifact());
            if (null != e && (assertion = e.getAssertion()) instanceof ErrorAssertion) {
                ErrorAssertion eassert = (ErrorAssertion)assertion;
                s = eassert.getStatus();
            }
        }
        return s;
    }

    class ErrorAssertion
    extends Assertion {
        private Status _status;

        public ErrorAssertion(Date issue, Status status) {
            this._issueInstant = issue;
            this._status = status;
        }

        public Status getStatus() {
            return this._status;
        }
    }

    private class Entry {
        private String destID = null;
        private String artString = null;
        private Object token = null;
        private Assertion assertion = null;

        public Entry(Assertion assertion, String destID, String artString, Object token) {
            this.assertion = assertion;
            this.destID = destID;
            this.artString = artString;
            this.token = token;
        }

        public Assertion getAssertion() {
            return this.assertion;
        }

        public String getDestID() {
            return this.destID;
        }

        public String getArtifactString() {
            return this.artString;
        }

        public Object getSessionToken() {
            return this.token;
        }
    }
}

