/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.meta;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.AttributeType;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.jaxb.entityconfig.EntityConfigElement;
import com.sun.identity.federation.jaxb.entityconfig.IDPDescriptorConfigElement;
import com.sun.identity.federation.jaxb.entityconfig.ObjectFactory;
import com.sun.identity.federation.jaxb.entityconfig.SPDescriptorConfigElement;
import com.sun.identity.federation.key.KeyUtil;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.liberty.ws.meta.jaxb.EntityDescriptorElement;
import com.sun.identity.liberty.ws.meta.jaxb.IDPDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.KeyDescriptorElement;
import com.sun.identity.liberty.ws.meta.jaxb.ProviderDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.saml.xmlsig.JKSKeyProvider;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.org.apache.xml.internal.security.Init;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBException;

public final class IDFFMetaSecurityUtils {
    public static final String NS_XMLSIG = "http://www.w3.org/2000/09/xmldsig#";
    public static final String NS_XMLENC = "http://www.w3.org/2001/04/xmlenc#";
    public static final String NS_META = "urn:liberty:metadata:2003-08";
    private static Debug debug = IDFFMetaUtils.debug;
    private static KeyProvider keyProvider = null;
    private static KeyStore keyStore = null;
    private static boolean keyProviderInitialized = false;

    private IDFFMetaSecurityUtils() {
    }

    private static synchronized void initializeKeyStore() {
        if (keyProviderInitialized) {
            return;
        }
        Init.init();
        keyProvider = KeyUtil.getKeyProviderInstance();
        if (keyProvider instanceof JKSKeyProvider) {
            keyStore = ((JKSKeyProvider)keyProvider).getKeyStore();
        }
        keyProviderInitialized = true;
    }

    public static String buildX509Certificate(String certAlias) throws IDFFMetaException {
        block5: {
            X509Certificate cert;
            if (certAlias == null || certAlias.trim().length() == 0) {
                return null;
            }
            if (!keyProviderInitialized) {
                IDFFMetaSecurityUtils.initializeKeyStore();
            }
            if ((cert = keyProvider.getX509Certificate(certAlias)) != null) {
                try {
                    return Base64.encode((byte[])cert.getEncoded(), (int)76);
                }
                catch (Exception ex) {
                    if (!debug.messageEnabled()) break block5;
                    debug.message("IDFFMetaSecurityUtils.buildX509Certificate:", (Throwable)ex);
                }
            }
        }
        Object[] objs = new Object[]{certAlias};
        throw new IDFFMetaException("invalid_cert_alias", objs);
    }

    public static void updateProviderKeyInfo(String realm, String entityID, String certAlias, boolean isSigning, boolean isIDP, String encAlgo, int keySize) throws IDFFMetaException {
        IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
        EntityConfigElement config = metaManager.getEntityConfig(realm, entityID);
        if (!config.isHosted()) {
            Object[] args = new String[]{entityID, realm};
            throw new IDFFMetaException("entityNotHosted", args);
        }
        EntityDescriptorElement desp = metaManager.getEntityDescriptor(realm, entityID);
        if (isIDP) {
            IDPDescriptorConfigElement idpConfig = IDFFMetaUtils.getIDPDescriptorConfig(config);
            IDPDescriptorType idpDesp = IDFFMetaUtils.getIDPDescriptor(desp);
            if (idpConfig == null || idpDesp == null) {
                Object[] args = new String[]{entityID, realm};
                throw new IDFFMetaException("entityNotIDP", args);
            }
            if (certAlias == null || certAlias.length() == 0) {
                IDFFMetaSecurityUtils.removeKeyDescriptor(idpDesp, isSigning);
                if (isSigning) {
                    IDFFMetaSecurityUtils.setExtendedAttributeValue(idpConfig, "signingCertAlias", null);
                } else {
                    IDFFMetaSecurityUtils.setExtendedAttributeValue(idpConfig, "encryptionCertAlias", null);
                }
            } else {
                KeyDescriptorElement kde = IDFFMetaSecurityUtils.getKeyDescriptor(certAlias, isSigning, encAlgo, keySize);
                IDFFMetaSecurityUtils.updateKeyDescriptor(idpDesp, kde);
                HashSet<String> value = new HashSet<String>();
                value.add(certAlias);
                if (isSigning) {
                    IDFFMetaSecurityUtils.setExtendedAttributeValue(idpConfig, "signingCertAlias", value);
                } else {
                    IDFFMetaSecurityUtils.setExtendedAttributeValue(idpConfig, "encryptionCertAlias", value);
                }
            }
            metaManager.setEntityDescriptor(realm, desp);
            metaManager.setEntityConfig(realm, config);
        } else {
            SPDescriptorConfigElement spConfig = IDFFMetaUtils.getSPDescriptorConfig(config);
            SPDescriptorType spDesp = IDFFMetaUtils.getSPDescriptor(desp);
            if (spConfig == null || spDesp == null) {
                Object[] args = new String[]{entityID, realm};
                throw new IDFFMetaException("entityNotSP", args);
            }
            if (certAlias == null || certAlias.length() == 0) {
                IDFFMetaSecurityUtils.removeKeyDescriptor(spDesp, isSigning);
                if (isSigning) {
                    IDFFMetaSecurityUtils.setExtendedAttributeValue(spConfig, "signingCertAlias", null);
                } else {
                    IDFFMetaSecurityUtils.setExtendedAttributeValue(spConfig, "encryptionCertAlias", null);
                }
            } else {
                KeyDescriptorElement kde = IDFFMetaSecurityUtils.getKeyDescriptor(certAlias, isSigning, encAlgo, keySize);
                IDFFMetaSecurityUtils.updateKeyDescriptor(spDesp, kde);
                HashSet<String> value = new HashSet<String>();
                value.add(certAlias);
                if (isSigning) {
                    IDFFMetaSecurityUtils.setExtendedAttributeValue(spConfig, "signingCertAlias", value);
                } else {
                    IDFFMetaSecurityUtils.setExtendedAttributeValue(spConfig, "encryptionCertAlias", value);
                }
            }
            metaManager.setEntityDescriptor(realm, desp);
            metaManager.setEntityConfig(realm, config);
        }
    }

    private static void updateKeyDescriptor(ProviderDescriptorType desp, KeyDescriptorElement newKey) {
        List keys = desp.getKeyDescriptor();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            KeyDescriptorElement key = (KeyDescriptorElement)iter.next();
            if (!key.getUse().equalsIgnoreCase(newKey.getUse())) continue;
            iter.remove();
        }
        desp.getKeyDescriptor().add(newKey);
    }

    private static void removeKeyDescriptor(ProviderDescriptorType desp, boolean isSigningUse) {
        List keys = desp.getKeyDescriptor();
        String keyUse = "encryption";
        if (isSigningUse) {
            keyUse = "signing";
        }
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            KeyDescriptorElement key = (KeyDescriptorElement)iter.next();
            if (!key.getUse().equalsIgnoreCase(keyUse)) continue;
            iter.remove();
        }
    }

    private static void setExtendedAttributeValue(BaseConfigType config, String attrName, Set attrVal) throws IDFFMetaException {
        try {
            List attributes = config.getAttribute();
            Iterator iter = attributes.iterator();
            while (iter.hasNext()) {
                AttributeType avp = (AttributeType)iter.next();
                if (!avp.getName().trim().equalsIgnoreCase(attrName)) continue;
                iter.remove();
            }
            if (attrVal != null) {
                ObjectFactory factory = new ObjectFactory();
                AttributeType atype = factory.createAttributeType();
                atype.setName(attrName);
                atype.getValue().addAll(attrVal);
                config.getAttribute().add(atype);
            }
        }
        catch (JAXBException e) {
            throw new IDFFMetaException((Exception)((Object)e));
        }
    }

    private static KeyDescriptorElement getKeyDescriptor(String certAlias, boolean isSigning, String encAlgo, int keySize) throws IDFFMetaException {
        try {
            String certString = IDFFMetaSecurityUtils.buildX509Certificate(certAlias);
            StringBuffer sb = new StringBuffer(4000);
            sb.append("<KeyDescriptor xmlns=\"").append(NS_META).append("\" use=\"");
            if (isSigning) {
                sb.append("signing");
            } else {
                sb.append("encryption");
            }
            sb.append("\">\n");
            if (!isSigning && encAlgo != null) {
                sb.append("<EncryptionMethod>").append(encAlgo).append("</EncryptionMethod>\n");
                sb.append("<KeySize>").append(keySize).append("</KeySize>\n");
            }
            sb.append("<KeyInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n").append("<X509Data>\n").append("<X509Certificate>\n").append(certString).append("</X509Certificate>\n").append("</X509Data>\n").append("</KeyInfo>\n");
            sb.append("</KeyDescriptor>\n");
            return (KeyDescriptorElement)IDFFMetaUtils.convertStringToJAXB(sb.toString());
        }
        catch (JAXBException e) {
            throw new IDFFMetaException((Exception)((Object)e));
        }
    }
}

