/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.meta;

import com.sun.identity.federation.jaxb.entityconfig.AttributeType;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.jaxb.entityconfig.EntityConfigElement;
import com.sun.identity.federation.jaxb.entityconfig.ObjectFactory;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.liberty.ws.meta.jaxb.EntityDescriptorElement;
import com.sun.identity.shared.debug.Debug;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;

public class IDFFCOTUtils {
    static final Debug debug = IDFFMetaUtils.debug;
    static final String COT_LIST = "cotlist";

    public void updateEntityConfig(String realm, String cotName, String entityID) throws IDFFMetaException, JAXBException {
        String classMethod = "IDFFCOTUtils.updateEntityConfig: ";
        IDFFMetaManager idffMetaMgr = new IDFFMetaManager(null);
        ObjectFactory objFactory = new ObjectFactory();
        EntityDescriptorElement entityDesc = idffMetaMgr.getEntityDescriptor(realm, entityID);
        if (entityDesc == null) {
            debug.error(classMethod + " No such entity: " + entityID);
            Object[] data = new String[]{entityID};
            throw new IDFFMetaException("invalidEntityID", data);
        }
        EntityConfigElement entityConfig = idffMetaMgr.getEntityConfig(realm, entityID);
        if (entityConfig == null) {
            BaseConfigType IDFFCOTUtils2 = null;
            AttributeType atype = objFactory.createAttributeType();
            atype.setName(COT_LIST);
            atype.getValue().add(cotName);
            entityConfig = objFactory.createEntityConfigElement();
            entityConfig.setEntityID(entityID);
            entityConfig.setHosted(false);
            if (IDFFMetaUtils.getSPDescriptor(entityDesc) != null) {
                IDFFCOTUtils2 = objFactory.createSPDescriptorConfigElement();
                IDFFCOTUtils2.getAttribute().add(atype);
                entityConfig.getSPDescriptorConfig().add(IDFFCOTUtils2);
            }
            if (IDFFMetaUtils.getIDPDescriptor(entityDesc) != null) {
                IDFFCOTUtils2 = objFactory.createIDPDescriptorConfigElement();
                IDFFCOTUtils2.getAttribute().add(atype);
                entityConfig.getIDPDescriptorConfig().add(IDFFCOTUtils2);
            }
            idffMetaMgr.setEntityConfig(realm, entityConfig);
        } else {
            List spConfigList = entityConfig.getSPDescriptorConfig();
            List idpConfigList = entityConfig.getIDPDescriptorConfig();
            this.updateCOTAttrInConfig(realm, spConfigList, cotName, entityConfig, objFactory, idffMetaMgr);
            this.updateCOTAttrInConfig(realm, idpConfigList, cotName, entityConfig, objFactory, idffMetaMgr);
        }
    }

    public void removeFromEntityConfig(String realm, String cotName, String entityID) throws IDFFMetaException, JAXBException {
        String classMethod = "IDFFCOTUtils.removeFromEntityConfig: ";
        IDFFMetaManager idffMetaMgr = new IDFFMetaManager(null);
        EntityDescriptorElement entityDesc = idffMetaMgr.getEntityDescriptor(realm, entityID);
        if (entityDesc == null) {
            debug.error(classMethod + "No such entity: " + entityID);
            Object[] data = new String[]{entityID};
            throw new IDFFMetaException("invalidEntityID", data);
        }
        EntityConfigElement entityConfig = idffMetaMgr.getEntityConfig(realm, entityID);
        if (entityConfig != null) {
            List spConfigList = entityConfig.getSPDescriptorConfig();
            List idpConfigList = entityConfig.getIDPDescriptorConfig();
            this.removeCOTNameFromConfig(realm, spConfigList, cotName, entityConfig, idffMetaMgr);
            this.removeCOTNameFromConfig(realm, idpConfigList, cotName, entityConfig, idffMetaMgr);
        }
    }

    private boolean containsValue(List list, String name) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (!((String)iter.next()).trim().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private void updateCOTAttrInConfig(String realm, List configList, String cotName, EntityConfigElement entityConfig, ObjectFactory objFactory, IDFFMetaManager idffMetaMgr) throws IDFFMetaException, JAXBException {
        boolean foundCOT = false;
        Iterator iter = configList.iterator();
        while (iter.hasNext()) {
            BaseConfigType bConfig = (BaseConfigType)iter.next();
            List list = bConfig.getAttribute();
            Iterator iter2 = list.iterator();
            while (iter2.hasNext()) {
                AttributeType avp = (AttributeType)iter2.next();
                if (!avp.getName().trim().equalsIgnoreCase(COT_LIST)) continue;
                foundCOT = true;
                List avpl = avp.getValue();
                if (!avpl.isEmpty() && this.containsValue(avpl, cotName)) continue;
                avpl.add(cotName);
                idffMetaMgr.setEntityConfig(realm, entityConfig);
                break;
            }
            if (foundCOT) continue;
            AttributeType atype = objFactory.createAttributeType();
            atype.setName(COT_LIST);
            atype.getValue().add(cotName);
            list.add(atype);
            idffMetaMgr.setEntityConfig(realm, entityConfig);
        }
    }

    private void removeCOTNameFromConfig(String realm, List configList, String cotName, EntityConfigElement entityConfig, IDFFMetaManager idffMetaMgr) throws IDFFMetaException {
        Iterator iter = configList.iterator();
        block0: while (iter.hasNext()) {
            BaseConfigType bConfig = (BaseConfigType)iter.next();
            List list = bConfig.getAttribute();
            Iterator iter2 = list.iterator();
            while (iter2.hasNext()) {
                List avpl;
                AttributeType avp = (AttributeType)iter2.next();
                if (!avp.getName().trim().equalsIgnoreCase(COT_LIST) || (avpl = avp.getValue()) == null || avpl.isEmpty() || !this.containsValue(avpl, cotName)) continue;
                avpl.remove(cotName);
                idffMetaMgr.setEntityConfig(realm, entityConfig);
                continue block0;
            }
        }
    }
}

