/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSIDPList;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.message.common.IDPEntries;
import com.sun.identity.federation.message.common.IDPEntry;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSScoping {
    private int proxyCount = -1;
    private FSIDPList idpList = null;

    public FSScoping() {
    }

    public FSScoping(FSIDPList idpList, int proxyCount) {
        this.idpList = idpList;
        this.proxyCount = proxyCount;
    }

    public FSScoping(Element root) throws FSMsgException {
        if (root == null) {
            FSUtils.debug.error("FSScoping(Element): null input");
            throw new FSMsgException("nullInput", null);
        }
        String tagName = root.getLocalName();
        if (tagName == null || !tagName.equals("Scoping")) {
            FSUtils.debug.error("FSScoping(Element): wrong input");
            throw new FSMsgException("wrongInput", null);
        }
        NodeList childNodes = root.getChildNodes();
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = childNodes.item(i);
            String nodeName = child.getLocalName();
            if (nodeName == null) continue;
            if (nodeName.equals("ProxyCount")) {
                String count = XMLUtils.getElementValue((Element)((Element)child));
                try {
                    this.proxyCount = Integer.parseInt(count);
                    continue;
                }
                catch (NumberFormatException ne) {
                    FSUtils.debug.error("FSScoping(Element): invalid proxyCount", (Throwable)ne);
                    throw new FSMsgException("wrongInput", null);
                }
            }
            if (!nodeName.equals("IDPList")) continue;
            this.idpList = new FSIDPList((Element)child);
        }
    }

    public void setProxyCount(int count) {
        this.proxyCount = count;
    }

    public int getProxyCount() {
        return this.proxyCount;
    }

    public void setIDPList(FSIDPList idpList) {
        this.idpList = idpList;
    }

    public FSIDPList getIDPList() {
        return this.idpList;
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        StringBuffer xml = new StringBuffer(300);
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "lib:";
        }
        if (declareNS) {
            uri = " xmlns:lib=\"urn:liberty:iff:2003-08\"";
        }
        xml.append("<").append(prefix).append("Scoping").append(uri).append(">\n");
        if (this.proxyCount >= 0) {
            xml.append("<").append(prefix).append("ProxyCount").append(">").append(this.proxyCount).append("</").append(prefix).append("ProxyCount").append(">\n");
        }
        if (this.idpList != null) {
            xml.append(this.idpList.toXMLString(true, false));
        }
        xml.append("</").append(prefix).append("Scoping").append(">\n");
        return xml.toString();
    }

    public String toURLEncodedQueryString() throws FSMsgException {
        List idps;
        IDPEntries entries;
        if (this.proxyCount == -1) {
            FSUtils.debug.error("FSScoping.toURLEncodedQueryString: proxyCount is not defined.");
            throw new FSMsgException("proxyCountNotDefined", null);
        }
        StringBuffer sb = new StringBuffer(100);
        sb.append("ProxyCount=").append(this.proxyCount).append("&");
        if (this.idpList != null && (entries = this.idpList.getIDPEntries()) != null && (idps = entries.getIDPEntryList()) != null && idps.size() != 0) {
            Iterator iter = idps.iterator();
            StringBuffer strProviders = new StringBuffer(100);
            String space = "";
            while (iter.hasNext()) {
                IDPEntry entry = (IDPEntry)iter.next();
                String providerID = entry.getProviderID();
                strProviders.append(space).append(providerID);
                space = " ";
            }
            sb.append("IDPEntries=").append(URLEncDec.encode((String)strProviders.toString()));
        }
        sb.append('&');
        return sb.toString();
    }

    public static FSScoping parseURLEncodedRequest(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String count = request.getParameter("ProxyCount");
        if (count == null) {
            return null;
        }
        int proxyCount = -1;
        try {
            proxyCount = Integer.parseInt(count);
        }
        catch (NumberFormatException ne) {
            FSUtils.debug.error("FSScoping.parseURLEncodedRequest:proxyCount can not be parsed.");
            return null;
        }
        FSScoping scoping = new FSScoping();
        scoping.setProxyCount(proxyCount);
        String[] idps = request.getParameterValues("IDPEntries");
        if (idps == null || idps.length == 0) {
            return scoping;
        }
        ArrayList<IDPEntry> list = new ArrayList<IDPEntry>();
        for (int i = 0; i < idps.length; ++i) {
            String providerID = idps[i];
            IDPEntry entry = new IDPEntry(providerID, null, null);
            list.add(entry);
        }
        IDPEntries entries = new IDPEntries(list);
        FSIDPList idpsList = new FSIDPList(entries, null);
        scoping.setIDPList(idpsList);
        return scoping;
    }
}

