/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLVersionMismatchException;
import com.sun.identity.saml.protocol.Response;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSResponse
extends Response {
    protected String id = null;

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getSignatureString() {
        return this.signatureString;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int version) {
        this.minorVersion = version;
    }

    public FSResponse(String responseID, String inResponseTo, Status status, List contents) throws SAMLException, FSMsgException {
        super(responseID, inResponseTo, status, contents);
    }

    public static FSResponse parseResponseXML(String xml) throws SAMLException, FSMsgException {
        FSUtils.debug.message("FSResponse.parseResponseXML: Called");
        Document doc = XMLUtils.toDOMDocument((String)xml, (Debug)FSUtils.debug);
        if (doc == null) {
            FSUtils.debug.error("FSResponse.parseXML:Error while parsing input xml string");
            throw new FSMsgException("parseError", null);
        }
        Element root = doc.getDocumentElement();
        return new FSResponse(root);
    }

    public FSResponse(Element root) throws SAMLException, FSMsgException {
        FSUtils.debug.message("FSResponse(Element): Called");
        if (root == null) {
            FSUtils.debug.message("FSResponse(Element): Input paramenter (root) is null");
            throw new FSMsgException("nullInput", null);
        }
        String tag = null;
        tag = root.getLocalName();
        if (tag == null || !tag.equals("Response")) {
            FSUtils.debug.message("FSResponse(Element): Root element name is not Response");
            throw new FSMsgException("wrongInput", null);
        }
        this.id = root.getAttribute("id");
        this.responseID = root.getAttribute("ResponseID");
        if (this.responseID == null || this.responseID.length() == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSResponse(Element): Response doesn't have ResponseID attribute");
            }
            Object[] args = new String[]{"ResponseID"};
            throw new FSMsgException("missingAttribute", args);
        }
        this.inResponseTo = root.getAttribute("InResponseTo");
        if (this.inResponseTo == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSResponse(Element): Response doesn't have InResponseTo attribute");
            }
            Object[] args = new String[]{"InResponseTo"};
            throw new FSMsgException("missingAttribute", args);
        }
        String instantString = root.getAttribute("IssueInstant");
        if (instantString == null || instantString.length() == 0) {
            FSUtils.debug.message("FSResponse(Element): missing IssueInstant");
            Object[] args = new String[]{"IssueInstant"};
            throw new FSMsgException("missingAttribute", args);
        }
        try {
            this.issueInstant = DateUtils.stringToDate((String)instantString);
        }
        catch (ParseException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSResponse(Element): could not parse IssueInstant:", (Throwable)e);
            }
            throw new FSMsgException("wrongInput", null);
        }
        this.parseMajorVersion(root.getAttribute("MajorVersion"));
        this.parseMinorVersion(root.getAttribute("MinorVersion"));
        this.setRecipient(root.getAttribute("Recipient"));
        NodeList nl = root.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            String childName = child.getLocalName();
            if (childName == null) continue;
            if (childName.equals("Status")) {
                if (this.status != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSResponse(Element): included more than one <Status>");
                    }
                    throw new FSMsgException("moreElement", null);
                }
                this.status = new Status((Element)child);
                continue;
            }
            if (childName.equals("Assertion")) {
                if (this.assertions == Collections.EMPTY_LIST) {
                    this.assertions = new ArrayList();
                }
                this.assertions.add(new FSAssertion((Element)child));
                continue;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSResponse(Element): included wrong element: " + childName);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.status == null) {
            FSUtils.debug.message("FSResponse(Element): missing element <Status>.");
            throw new FSMsgException("missingElement", null);
        }
        List signs = XMLUtils.getElementsByTagNameNS1((Element)root, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        int signsSize = signs.size();
        if (signsSize == 1) {
            Element elem = (Element)signs.get(0);
            this.setSignature(elem);
            this.xmlString = XMLUtils.print((Node)root);
            this.signed = true;
        } else if (signsSize != 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSResponse(Element): included more than one Signature element.");
            }
            throw new FSMsgException("moreElement", null);
        }
    }

    private void parseMajorVersion(String majorVer) throws SAMLException, FSMsgException {
        try {
            this.majorVersion = Integer.parseInt(majorVer);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSResponse(Element): invalid MajorVersion", (Throwable)e);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSResponse(Element):MajorVersion of the Response is too high.");
                }
                throw new SAMLVersionMismatchException("libIDFF", "responseVersionTooHigh", null);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSResponse(Element):MajorVersion of the Response is too low.");
            }
            throw new SAMLVersionMismatchException("libIDFF", "responseVersionTooLow", null);
        }
    }

    private void parseMinorVersion(String minorVer) throws SAMLException, FSMsgException {
        try {
            this.minorVersion = Integer.parseInt(minorVer);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSResponse(Element): invalid MinorVersion", (Throwable)e);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.minorVersion > 1) {
            FSUtils.debug.error("FSResponse(Element):MinorVersion of the Response is too high.");
            throw new SAMLVersionMismatchException("libIDFF", "responseVersionTooHigh", null);
        }
        if (this.minorVersion < 0) {
            FSUtils.debug.error("FSResponse(Element):MinorVersion of the Response is too low.");
            throw new SAMLVersionMismatchException("libIDFF", "responseVersionTooLow", null);
        }
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        return this.toXMLString(includeNS, declareNS, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS, boolean includeHeader) throws FSMsgException {
        FSUtils.debug.message("FSResponse.toXMLString(3): Called");
        StringBuffer xml = new StringBuffer(500);
        if (includeHeader) {
            xml.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>");
        }
        String prefixSAML = null;
        String prefixLIB = null;
        String prefixSAML_PROTOCOL = "";
        String uriSAML_PROTOCOL = "";
        String uriSAML = "";
        String uriLIB = "";
        String uriDS = "";
        String uriXSI = "";
        if (includeNS) {
            prefixLIB = "lib:";
            prefixSAML = "saml:";
            prefixSAML_PROTOCOL = "samlp:";
        }
        if (declareNS) {
            uriLIB = this.minorVersion == 1 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
            uriSAML = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
            uriSAML_PROTOCOL = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
            uriDS = "xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"";
            uriXSI = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
        }
        String instantString = DateUtils.toUTCDateFormat((Date)this.issueInstant);
        if (this.responseID != null && this.inResponseTo != null) {
            xml.append("<").append(prefixSAML_PROTOCOL).append("Response").append(uriLIB).append(uriSAML).append(uriSAML_PROTOCOL).append(" ").append(uriDS).append(" ").append(uriXSI).append(" ResponseID=\"").append(this.responseID).append("\" ");
            if (this.inResponseTo != null && this.inResponseTo.length() != 0) {
                xml.append(" InResponseTo=\"").append(this.inResponseTo).append("\" ");
            }
            if (this.minorVersion == 0 && this.id != null && this.id.length() != 0) {
                xml.append(" id=\"").append(this.id).append("\"");
            }
            xml.append(" MajorVersion=\"").append(this.majorVersion).append("\" ").append(" MinorVersion=\"").append(this.minorVersion).append("\" ").append(" IssueInstant=\"").append(instantString).append("\"");
            if (this.recipient != null && this.recipient.length() != 0) {
                xml.append(" Recipient=\"").append(this.recipient).append("\" ");
            }
            xml.append(">");
        }
        if (this.signed) {
            if (this.signatureString != null) {
                xml.append(this.signatureString);
            } else if (this.signature != null) {
                this.signatureString = XMLUtils.print((Node)this.signature);
                xml.append(this.signatureString);
            }
        }
        if (this.status != null) {
            xml.append(this.status.toString(includeNS, false));
        }
        if (this.assertions != null && this.assertions != Collections.EMPTY_LIST) {
            Iterator j = this.assertions.iterator();
            while (j.hasNext()) {
                xml.append(((FSAssertion)j.next()).toXMLString(true, declareNS));
            }
        }
        xml.append("</").append(prefixSAML_PROTOCOL).append("Response>");
        return xml.toString();
    }

    public static FSResponse parseBASE64EncodedString(String encodedRes) throws FSMsgException, SAMLException {
        FSUtils.debug.message("FSResponse.parseBASE64EncodedString:Called new");
        if (encodedRes != null) {
            String decodedAuthnRes = new String(Base64.decode((String)encodedRes));
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSResponse.parseBASE64EncodedString:Decoded AuthnResponse message: " + decodedAuthnRes);
            }
            return FSResponse.parseResponseXML(decodedAuthnRes);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSResponse.parseBASE64EncodedString:null String passed in as argument.");
        }
        throw new FSMsgException("nullInput", null);
    }

    public String toBASE64EncodedString() throws FSMsgException {
        FSUtils.debug.message("FSResponse.toBASE64EncodedString: Called");
        if (this.responseID == null || this.responseID.length() == 0) {
            this.responseID = FSUtils.generateID();
            if (this.responseID == null) {
                FSUtils.debug.error("FSResponse.toBASE64EncodedString: couldn't generate ResponseID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        return Base64.encode((byte[])this.toXMLString().getBytes());
    }

    public void signXML(String certAlias) throws SAMLException {
        FSUtils.debug.message("FSResponse.signXML: Called");
        if (this.signed) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSResponse.signXML: the assertion is already signed.");
            }
            throw new SAMLResponderException("libIDFF", "alreadySigned", null);
        }
        if (certAlias == null || certAlias.length() == 0) {
            throw new SAMLResponderException("libIDFF", "cannotFindCertAlias", null);
        }
        try {
            XMLSignatureManager manager = XMLSignatureManager.getInstance();
            if (this.minorVersion == 0) {
                this.signatureString = manager.signXML(this.toXMLString(true, true), certAlias, "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "id", this.id, false);
            } else if (this.minorVersion == 2) {
                this.signatureString = manager.signXML(this.toXMLString(true, true), certAlias, "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "ResponseID", this.getResponseID(), false);
            } else if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("invalid minor version.");
            }
            this.signature = XMLUtils.toDOMDocument((String)this.signatureString, (Debug)FSUtils.debug).getDocumentElement();
            this.signed = true;
            this.xmlString = this.toXMLString(true, true);
        }
        catch (Exception e) {
            throw new SAMLResponderException("libIDFF", "signFailed", null);
        }
    }

    public void signXML() throws SAMLException {
        throw new SAMLException("libIDFF", "unsupportedOperation", null);
    }
}

