/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSSubject;
import com.sun.identity.federation.message.common.AuthnContext;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.AuthorityBinding;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectLocality;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.shared.DateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSAuthenticationStatement
extends AuthenticationStatement {
    protected Date reauthenticateOnOrAfter;
    protected String sessionIndex = null;
    protected AuthnContext _authnContext;
    protected int minorVersion = 0;

    public FSAuthenticationStatement() {
    }

    public FSAuthenticationStatement(String authMethod, Date authInstant, Subject subject, AuthnContext authnContext) throws FSMsgException, SAMLException {
        super(authMethod, authInstant, subject);
        if (authnContext == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthenticationStatement: missingAuthnContext");
            }
        } else {
            this._authnContext = authnContext;
        }
    }

    public FSAuthenticationStatement(String authMethod, Date authInstant, Subject subject, SubjectLocality subjectLocality, List authorityBinding, AuthnContext authnContext) throws FSMsgException, SAMLException {
        super(authMethod, authInstant, subject, subjectLocality, authorityBinding);
        if (authnContext == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthenticationStatement: missingAuthnContext.");
            }
        } else {
            this._authnContext = authnContext;
        }
    }

    public FSAuthenticationStatement(Element element) throws FSMsgException, SAMLException {
        FSUtils.debug.message("FSAuthenticationStatement(Element):  Called");
        if (element == null) {
            FSUtils.debug.message("FSAuthenticationStatement: null input.");
            throw new FSMsgException("nullInput", null);
        }
        int i = 0;
        NamedNodeMap atts = element.getAttributes();
        int attCount = atts.getLength();
        for (i = 0; i < attCount; ++i) {
            Node att = atts.item(i);
            if (att.getNodeType() != 2) continue;
            String attName = att.getLocalName();
            if (attName == null || attName.length() == 0) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAuthenticationStatement:Attribute name is either null or empty.");
                }
                throw new FSMsgException("nullInput", null);
            }
            if (attName.equals("AuthenticationMethod")) {
                this._authenticationMethod = ((Attr)att).getValue().trim();
                continue;
            }
            if (attName.equals("AuthenticationInstant")) {
                try {
                    this._authenticationInstant = DateUtils.stringToDate((String)((Attr)att).getValue());
                    continue;
                }
                catch (ParseException pe) {
                    FSUtils.debug.error("FSAuthenticationStatement:StringToDate: ", (Throwable)pe);
                    throw new FSMsgException("wrongDateFormat", null);
                }
            }
            if (attName.equals("ReauthenticateOnOrAfter")) {
                try {
                    this.reauthenticateOnOrAfter = DateUtils.stringToDate((String)((Attr)att).getValue());
                    continue;
                }
                catch (ParseException pe) {
                    FSUtils.debug.error("FSAuthenticationStatement:StringToDate: ", (Throwable)pe);
                    throw new FSMsgException("wrongDateFormat", null);
                }
            }
            if (!attName.equals("SessionIndex")) continue;
            this.sessionIndex = ((Attr)att).getValue().trim();
        }
        NodeList nodes = element.getChildNodes();
        int nodeCount = nodes.getLength();
        if (nodeCount > 0) {
            for (i = 0; i < nodeCount; ++i) {
                Node currentNode = nodes.item(i);
                if (currentNode.getNodeType() != 1) continue;
                String tagName = currentNode.getLocalName();
                String tagNS = currentNode.getNamespaceURI();
                if (tagName == null || tagName.length() == 0 || tagNS == null || tagNS.length() == 0) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAuthenticationStatement: The  tag name or tag namespace of child element is either null or empty.");
                    }
                    throw new FSMsgException("nullInput", null);
                }
                if (tagName.equals("Subject")) {
                    if (this._subject != null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSAuthenticationStatement:should only contain one subject");
                        }
                        throw new FSMsgException("oneElement", null);
                    }
                    this._subject = new FSSubject((Element)currentNode);
                    continue;
                }
                if (tagName.equals("SubjectLocality")) {
                    if (this._subjectLocality != null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSAuthenticationStatementStatement: should at most contain one SubjectLocality.");
                        }
                        throw new FSMsgException("oneElement", null);
                    }
                    this._subjectLocality = new SubjectLocality((Element)currentNode);
                    continue;
                }
                if (tagName.equals("AuthnContext") && (tagNS.equals("http://projectliberty.org/schemas/core/2002/12") || tagNS.equals("urn:liberty:iff:2003-08"))) {
                    if (this._authnContext != null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSAuthenticationStatement: should not contain more than  one AuthnContext element.");
                        }
                        throw new FSMsgException("oneElement", null);
                    }
                    this._authnContext = new AuthnContext((Element)currentNode);
                    continue;
                }
                if (tagName.equals("AuthorityBinding")) {
                    if (this._authorityBinding == null) {
                        this._authorityBinding = new ArrayList();
                    }
                    if (this._authorityBinding.add(new AuthorityBinding((Element)currentNode))) continue;
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAuthenticationStatement: failed to add to the AuthorityBinding list.");
                    }
                    throw new FSMsgException("addListError", null);
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAuthenticationStatement:Wrong element " + tagName + "included.");
                }
                throw new FSMsgException("wrongInput", null);
            }
        }
        if (this._subject == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthenticationStatement should contain one subject.");
            }
            throw new FSMsgException("missingElement", null);
        }
        FSUtils.debug.message("FSAuthenticationStatement(Element): leaving");
    }

    public String getSessionIndex() {
        return this.sessionIndex;
    }

    public void setSessionIndex(String sessionIndex) {
        this.sessionIndex = sessionIndex;
    }

    public Date getReauthenticateOnOrAfter() {
        return this.reauthenticateOnOrAfter;
    }

    public void setReauthenticateOnOrAfter(Date reauthenticateOnOrAfter) {
        this.reauthenticateOnOrAfter = reauthenticateOnOrAfter;
    }

    public AuthnContext getAuthnContext() {
        return this._authnContext;
    }

    public void setAuthnContext(AuthnContext authnContext) {
        this._authnContext = authnContext;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int version) {
        this.minorVersion = version;
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        StringBuffer result = new StringBuffer(1000);
        String prefix = "";
        String libprefix = "";
        String uri = "";
        String liburi = "";
        if (includeNS) {
            prefix = "saml:";
            libprefix = "lib:";
        }
        if (declareNS) {
            liburi = this.minorVersion == 2 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
            uri = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        result.append("<").append(prefix).append("AuthenticationStatement").append(uri).append(" ").append(liburi).append(" ");
        if (this._authenticationMethod != null && this._authenticationMethod.length() != 0) {
            result.append("AuthenticationMethod").append("=\"").append(this._authenticationMethod).append("\" ");
        }
        if (this._authenticationInstant != null) {
            result.append("AuthenticationInstant").append("=\"").append(DateUtils.toUTCDateFormat((Date)this._authenticationInstant)).append("\" ");
        }
        if (this.reauthenticateOnOrAfter != null) {
            result.append("ReauthenticateOnOrAfter").append("=\"").append(DateUtils.toUTCDateFormat((Date)this.reauthenticateOnOrAfter)).append("\" ");
        }
        if (this.sessionIndex != null) {
            result.append("SessionIndex").append("=\"").append(this.sessionIndex).append("\" ");
        }
        result.append("xsi:type").append("=\"").append(libprefix).append("AuthenticationStatementType").append("\"").append(">");
        if (this.getSubject() != null) {
            result.append(((FSSubject)this.getSubject()).toXMLString(includeNS, false));
        }
        if (this._subjectLocality != null) {
            result.append(this._subjectLocality.toString(includeNS, false));
        }
        if (this._authorityBinding != null && !this._authorityBinding.isEmpty()) {
            Iterator iter = this.getAuthorityBinding().iterator();
            while (iter.hasNext()) {
                AuthorityBinding authBinding = (AuthorityBinding)iter.next();
                result.append(authBinding.toString(includeNS, false));
            }
        }
        if (this._authnContext != null) {
            result.append(this._authnContext.toXMLString(includeNS, false));
        }
        result.append("</").append(prefix).append("AuthenticationStatement").append(">");
        return result.toString();
    }
}

