/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.shared.encode.Base64;

public class FSAssertionArtifact
extends AssertionArtifact {
    public static final int ARTIFACT_1_LENGTH = 42;
    public static final byte ARTIFACT_1_TYPE_CODE_0 = 0;
    public static final byte ARTIFACT_1_TYPE_CODE_1 = 3;
    public static final byte[] ARTIFACT_1_TYPE_CODE = new byte[]{0, 3};

    protected FSAssertionArtifact() {
    }

    public FSAssertionArtifact(String theArtifact) throws FSMsgException {
        if (theArtifact == null || theArtifact.length() == 0) {
            FSUtils.debug.message("FSAssertionArtifact: empty input.");
            throw new FSMsgException("nullInput", null);
        }
        byte[] raw = Base64.decode((String)theArtifact);
        if (raw == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifact: decode error");
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (raw.length != 42) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifact: the length is not 42:" + raw.length);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (raw[0] != 0 || raw[1] != 3) {
            FSUtils.debug.message("FSAssertionArtifact: wrong typecode.");
            throw new FSMsgException("wrongInput", null);
        }
        this.typeCode = ARTIFACT_1_TYPE_CODE;
        this.artifact = theArtifact;
        byte[] sBytes = new byte[20];
        byte[] aBytes = new byte[20];
        System.arraycopy(raw, 2, sBytes, 0, 20);
        System.arraycopy(raw, 22, aBytes, 0, 20);
        this.sourceID = SAMLUtils.byteArrayToString(sBytes);
        this.assertionHandle = SAMLUtils.byteArrayToString(aBytes);
    }

    public FSAssertionArtifact(byte[] idBytes, byte[] handleBytes) throws FSMsgException {
        if (idBytes == null || handleBytes == null) {
            FSUtils.debug.message("FSAssertionArtifact: null input.");
            throw new FSMsgException("nullInput", null);
        }
        if (idBytes.length != 20 || handleBytes.length != 20) {
            FSUtils.debug.message("FSAssertionArtifact: wrong input length.");
            throw new FSMsgException("wrongInput", null);
        }
        this.sourceID = SAMLUtils.byteArrayToString(idBytes);
        this.assertionHandle = SAMLUtils.byteArrayToString(handleBytes);
        byte[] raw = new byte[42];
        raw[0] = 0;
        raw[1] = 3;
        for (int i = 0; i < 20; ++i) {
            raw[2 + i] = idBytes[i];
            raw[22 + i] = handleBytes[i];
        }
        try {
            this.artifact = Base64.encode((byte[])raw).trim();
        }
        catch (Exception e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifact: exception encode input:", (Throwable)e);
            }
            throw new FSMsgException("errorCreateArtifact", null);
        }
        this.typeCode = ARTIFACT_1_TYPE_CODE;
    }
}

