/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.accountmgmt;

import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.accountmgmt.FSAccountUtils;
import com.sun.identity.federation.accountmgmt.FSUserProvider;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.plugin.datastore.DataStoreProvider;
import com.sun.identity.plugin.datastore.DataStoreProviderException;
import com.sun.identity.plugin.datastore.DataStoreProviderManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class FSAccountManager {
    private static Map instanceMap = new HashMap();
    private String SP_FILTER = null;
    private String SP_PROVIDER_ID;
    private IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
    private DataStoreProvider provider = null;
    private FSUserProvider userProvider = null;

    private FSAccountManager(String metaAlias) throws FSAccountMgmtException {
        try {
            this.provider = DataStoreProviderManager.getInstance().getDataStoreProvider("IDFF");
            String role = this.metaManager.getProviderRoleByMetaAlias(metaAlias);
            String realm = IDFFMetaUtils.getRealmByMetaAlias(metaAlias);
            String hostedEntityID = this.metaManager.getEntityIDByMetaAlias(metaAlias);
            BaseConfigType hostedConfig = null;
            if (role != null && role.equalsIgnoreCase("IDP")) {
                hostedConfig = this.metaManager.getIDPDescriptorConfig(realm, hostedEntityID);
            } else if (role != null && role.equalsIgnoreCase("SP")) {
                hostedConfig = this.metaManager.getSPDescriptorConfig(realm, hostedEntityID);
                this.SP_PROVIDER_ID = hostedEntityID;
                this.SP_FILTER = "|" + this.SP_PROVIDER_ID + "|";
            }
            if (hostedConfig == null) {
                throw new FSAccountMgmtException("actmgmt-hosted-config-is-null", null);
            }
            String userPClass = IDFFMetaUtils.getFirstAttributeValueFromConfig(hostedConfig, "userProviderClass");
            if (userPClass == null || userPClass.length() == 0) {
                userPClass = "com.sun.identity.federation.accountmgmt.DefaultFSUserProvider";
            }
            this.userProvider = (FSUserProvider)Class.forName(userPClass).newInstance();
            this.userProvider.init(hostedEntityID);
        }
        catch (Exception de) {
            FSUtils.debug.error("FSAccountManager.getInstance() : Exception: ", (Throwable)de);
            throw new FSAccountMgmtException(de.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSAccountManager getInstance(String metaAlias) throws FSAccountMgmtException {
        if (metaAlias == null || metaAlias.length() == 0) {
            FSUtils.debug.error("FSAccountManager.getInstance: meta aliasis null.");
            throw new FSAccountMgmtException("actmgmt-meta-alias-is-null", null);
        }
        FSAccountManager manager = (FSAccountManager)instanceMap.get(metaAlias);
        if (manager == null) {
            Map map = instanceMap;
            synchronized (map) {
                manager = (FSAccountManager)instanceMap.get(metaAlias);
                if (manager == null) {
                    manager = new FSAccountManager(metaAlias);
                    instanceMap.put(metaAlias, manager);
                }
            }
        }
        return manager;
    }

    public void writeAccountFedInfo(String userID, FSAccountFedInfoKey fedInfoKey, FSAccountFedInfo fedInfo) throws FSAccountMgmtException {
        FSUtils.debug.message("FSAccountManager.writeAccountFedInfo() : called");
        if (userID == null) {
            FSUtils.debug.error("FSAccountManager.writeAccountFedInfo():Invalid Argument : user ID is NULL");
            throw new FSAccountMgmtException("actmgmt-user-dn-is-null", null);
        }
        if (fedInfoKey == null) {
            FSUtils.debug.error("FSAccountManager.writeAccountFedInfo():Invalid Argument : FedInfo key is NULL");
            throw new FSAccountMgmtException("actmgmt-account-fed-info-key-object-is-null", null);
        }
        if (fedInfo == null) {
            FSUtils.debug.error("FSAccountManager.writeAccountFedInfo():Invalid Argument : FedInfo is NULL");
            throw new FSAccountMgmtException("actmgmt-account-fed-info-object-is-null", null);
        }
        try {
            HashSet<String> existFedInfoKeySet;
            HashSet<String> attrNames = new HashSet<String>();
            attrNames.add("iplanet-am-user-federation-info-key");
            attrNames.add("iplanet-am-user-federation-info");
            HashMap attrsMap = this.provider.getAttributes(userID, attrNames);
            if (attrsMap == null) {
                attrsMap = new HashMap();
            }
            if ((existFedInfoKeySet = (HashSet<String>)attrsMap.get("iplanet-am-user-federation-info-key")) == null) {
                existFedInfoKeySet = new HashSet<String>();
            } else if (!existFedInfoKeySet.isEmpty()) {
                Iterator i = existFedInfoKeySet.iterator();
                String existFedInfoKeyStr = "";
                String filter = FSAccountUtils.createFilter(fedInfoKey);
                while (i.hasNext()) {
                    existFedInfoKeyStr = (String)i.next();
                    if (existFedInfoKeyStr.indexOf(filter) < 0) continue;
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAccountManager.writeAccountFedInfo():AccountFedInfo Key Already Exists, will overwrite.");
                    }
                    existFedInfoKeySet.remove(existFedInfoKeyStr);
                    break;
                }
            }
            String fedInfoKeyStr = FSAccountUtils.objectToKeyString(fedInfoKey);
            existFedInfoKeySet.add(fedInfoKeyStr);
            HashMap attrMap = new HashMap();
            attrMap.put("iplanet-am-user-federation-info-key", existFedInfoKeySet);
            HashSet<String> existFedInfoSet = (HashSet<String>)attrsMap.get("iplanet-am-user-federation-info");
            if (existFedInfoSet == null) {
                existFedInfoSet = new HashSet<String>();
            } else if (!existFedInfoSet.isEmpty()) {
                Iterator i = existFedInfoSet.iterator();
                String existFedInfoStr = "";
                String filter = FSAccountUtils.createFilter(fedInfoKey);
                while (i.hasNext()) {
                    existFedInfoStr = (String)i.next();
                    if (existFedInfoStr.indexOf(filter) < 0) continue;
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAccountManager.writeAccountFedInfo(): AccountFedInfo Already Exists, will overwrite");
                    }
                    existFedInfoSet.remove(existFedInfoStr);
                    break;
                }
            }
            String fedInfoStr = FSAccountUtils.objectToInfoString(fedInfo);
            existFedInfoSet.add(fedInfoStr);
            attrMap.put("iplanet-am-user-federation-info", existFedInfoSet);
            this.provider.setAttributes(userID, attrMap);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAccountManager.writeAccountFedInfo(): Key : " + fedInfoKeyStr + ", Value : " + fedInfoStr + " : Added ");
            }
            String[] args = new String[]{userID, fedInfoStr, fedInfoKeyStr};
            LogUtil.access(Level.INFO, "WRITE_ACCOUNT_FED_INFO", args);
        }
        catch (DataStoreProviderException de) {
            FSUtils.debug.error("FSAccountManager.writeAccountFedInfo(): Exception: ", (Throwable)((Object)de));
            throw new FSAccountMgmtException(de.getMessage());
        }
    }

    public void removeAccountFedInfo(String userID, FSAccountFedInfo fedInfo) throws FSAccountMgmtException {
        if (fedInfo == null) {
            FSUtils.debug.error("FSAccountManager.removeAccountFedInfo():Invalid Argument : FedInfo is NULL");
            throw new FSAccountMgmtException("actmgmt-account-fed-info-object-is-null", null);
        }
        try {
            HashSet existFedInfoSet = this.provider.getAttribute(userID, "iplanet-am-user-federation-info");
            if (existFedInfoSet == null) {
                existFedInfoSet = new HashSet();
            } else if (!existFedInfoSet.isEmpty()) {
                String fedInfoStr = FSAccountUtils.objectToInfoString(fedInfo);
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Account Info to be removed:" + fedInfoStr);
                }
                if (fedInfoStr != null && existFedInfoSet.contains(fedInfoStr)) {
                    existFedInfoSet.remove(fedInfoStr);
                }
                HashMap attrMap = new HashMap();
                attrMap.put("iplanet-am-user-federation-info", existFedInfoSet);
                this.provider.setAttributes(userID, attrMap);
            }
        }
        catch (Exception se) {
            FSUtils.debug.error("FSAccountManager.removeAccountFedInfo(): Exception: ", (Throwable)se);
            throw new FSAccountMgmtException(se.getMessage());
        }
    }

    public void writeAccountFedInfo(String userID, FSAccountFedInfoKey fedInfoKey, FSAccountFedInfo fedInfo, FSAccountFedInfoKey oldFedInfoKey) throws FSAccountMgmtException {
        this.writeAccountFedInfo(userID, fedInfoKey, fedInfo);
    }

    public void removeAccountFedInfoKey(String userID, FSAccountFedInfoKey fedInfoKey) throws FSAccountMgmtException {
        block6: {
            FSUtils.debug.message("FSAccountManager.removeAccountFedInfoKey():called");
            if (userID == null) {
                FSUtils.debug.error("FSAccountManager.removeAccountFedInfoKey():Invalid Argument : user ID is NULL");
                throw new FSAccountMgmtException("actmgmt-user-dn-is-null", null);
            }
            if (fedInfoKey == null) {
                FSUtils.debug.error("FSAccountManager.removeAccountFedInfoKey():Invalid Argument : FedInfo key is NULL");
                throw new FSAccountMgmtException("actmgmt-account-fed-info-key-object-is-null", null);
            }
            try {
                HashMap<String, Set> attrMap = new HashMap<String, Set>();
                Set existFedInfoKeySet = this.provider.getAttribute(userID, "iplanet-am-user-federation-info-key");
                if (existFedInfoKeySet == null || existFedInfoKeySet.isEmpty()) break block6;
                Iterator i = existFedInfoKeySet.iterator();
                String existFedInfoKeyStr = "";
                String filter = FSAccountUtils.createFilter(fedInfoKey);
                while (i.hasNext()) {
                    existFedInfoKeyStr = (String)i.next();
                    if (existFedInfoKeyStr.indexOf(filter) < 0) continue;
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAccountManager.removeAccountFedInfoKey():Account Fed Info Key Exists, will remove it");
                    }
                    existFedInfoKeySet.remove(existFedInfoKeyStr);
                    attrMap.put("iplanet-am-user-federation-info-key", existFedInfoKeySet);
                    this.provider.setAttributes(userID, attrMap);
                    break;
                }
            }
            catch (DataStoreProviderException ame) {
                FSUtils.debug.error("FSAccountManager.removeAccountFedInfoKey():Exception:", (Throwable)((Object)ame));
                throw new FSAccountMgmtException(ame.getMessage());
            }
        }
    }

    public void removeAccountFedInfo(String userID, FSAccountFedInfoKey fedInfoKey, String providerID) throws FSAccountMgmtException {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAccountManager.removeAccountFedInfo(): userID=" + userID + ", infoKey=" + FSAccountUtils.createFilter(fedInfoKey) + ", providerID=" + providerID);
        }
        if (fedInfoKey == null) {
            FSUtils.debug.error("FSAccountManager.removeAccountFedInfo():Invalid Argument : FedInfo key is NULL");
            throw new FSAccountMgmtException("actmgmt-account-fed-info-key-object-is-null", null);
        }
        if (providerID == null || providerID.length() <= 0) {
            FSUtils.debug.error("FSAccountManager.removeAccountFedInfo():Invalid Argument : providerID is NULL");
            throw new FSAccountMgmtException("actmgmt-provider-id-is-null", null);
        }
        if (userID == null) {
            FSUtils.debug.error("FSAccountManager.removeAccountFedInfo():Invalid Argument : user ID is NULL");
            throw new FSAccountMgmtException("actmgmt-user-dn-is-null", null);
        }
        try {
            HashMap<String, Set> attrMap = new HashMap<String, Set>();
            boolean found = false;
            Set existFedInfoKeySet = this.provider.getAttribute(userID, "iplanet-am-user-federation-info-key");
            String existFedInfoKeyStr = "";
            if (existFedInfoKeySet != null && !existFedInfoKeySet.isEmpty()) {
                String filter = FSAccountUtils.createFilter(fedInfoKey);
                Iterator i = existFedInfoKeySet.iterator();
                while (i.hasNext()) {
                    existFedInfoKeyStr = (String)i.next();
                    if (existFedInfoKeyStr.indexOf(filter) < 0) continue;
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAccountManager.removeAccountFedInfo():Account Fed Info Key Exists, will remove it");
                    }
                    existFedInfoKeySet.remove(existFedInfoKeyStr);
                    attrMap.put("iplanet-am-user-federation-info-key", existFedInfoKeySet);
                    found = true;
                    break;
                }
            }
            String nameIDValue = fedInfoKey.getName();
            Set existFedInfoSet = this.provider.getAttribute(userID, "iplanet-am-user-federation-info");
            if (existFedInfoSet != null && !existFedInfoSet.isEmpty()) {
                Iterator i = existFedInfoSet.iterator();
                String existFedInfoStr = "";
                String filter = FSAccountUtils.createFilter(providerID);
                while (i.hasNext()) {
                    existFedInfoStr = (String)i.next();
                    if (existFedInfoStr.indexOf(filter) < 0 || existFedInfoStr.indexOf(nameIDValue) < 0) continue;
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAccountManager.removeAccountFedInfo():Account Fed Info Exists, will remove it");
                    }
                    existFedInfoSet.remove(existFedInfoStr);
                    attrMap.put("iplanet-am-user-federation-info", existFedInfoSet);
                    found = true;
                    break;
                }
            }
            if (!found) {
                FSUtils.debug.error("FSAccountManager.removeAccountFedInfo():Account Federation Info not Found");
                throw new FSAccountMgmtException("actmgmt-fed-info-not-found", null);
            }
            this.provider.setAttributes(userID, attrMap);
            String[] args = new String[]{userID, providerID, existFedInfoKeyStr};
            LogUtil.access(Level.INFO, "REMOVE_ACCOUNT_FED_INFO", args);
        }
        catch (DataStoreProviderException ame) {
            FSUtils.debug.error("FSAccountManager.removeAccountFedInfo():Exception:", (Throwable)((Object)ame));
            throw new FSAccountMgmtException(ame.getMessage());
        }
    }

    public FSAccountFedInfo readAccountFedInfo(String userID, String providerID) throws FSAccountMgmtException {
        return this.readAccountFedInfo(userID, providerID, null);
    }

    public FSAccountFedInfo readAccountFedInfo(String userID, String providerID, String nameIDValue) throws FSAccountMgmtException {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAccountManager.readAccountFedInfo() : user=" + userID + ", providerID=" + providerID + ", nameIDValue=" + nameIDValue);
        }
        if (userID == null) {
            FSUtils.debug.error("FSAccountManager.readAccountFedInfo():Invalid Argument : user ID is NULL");
            throw new FSAccountMgmtException("actmgmt-user-dn-is-null", null);
        }
        if (providerID == null || providerID.length() <= 0) {
            FSUtils.debug.error("FSAccountManager.readAccountFedInfo():Invalid Argument : providerID is NULL");
            throw new FSAccountMgmtException("actmgmt-provider-id-is-null", null);
        }
        Set existFedInfoSet = null;
        try {
            existFedInfoSet = this.provider.getAttribute(userID, "iplanet-am-user-federation-info");
        }
        catch (DataStoreProviderException ame) {
            FSUtils.debug.error("FSAccountManager.readAccountFedInfo():Exception:", (Throwable)((Object)ame));
            throw new FSAccountMgmtException(ame.getMessage());
        }
        if (existFedInfoSet != null && !existFedInfoSet.isEmpty()) {
            String filter = FSAccountUtils.createFilter(providerID);
            Iterator i = existFedInfoSet.iterator();
            while (i.hasNext()) {
                FSAccountFedInfo afi;
                String existFedInfoStr = (String)i.next();
                if (existFedInfoStr.indexOf(filter) < 0 || this.SP_FILTER != null && existFedInfoStr.indexOf(this.SP_FILTER) < 0 || nameIDValue != null && existFedInfoStr.indexOf(nameIDValue) < 0) continue;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAccountManager.readAccountFedInfo():  value found: " + existFedInfoStr);
                }
                if (!(afi = FSAccountUtils.stringToObject(existFedInfoStr)).isFedStatusActive()) {
                    return null;
                }
                return afi;
            }
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAccountManager.readAccountFedInfo(): value with user: " + userID + " and providerID : " + providerID + " not found");
        }
        return null;
    }

    public Set readAllFederatedProviderID(String userID) throws FSAccountMgmtException {
        if (this.SP_PROVIDER_ID != null && this.SP_PROVIDER_ID.length() != 0) {
            return this.readAllFederatedProviderID(this.SP_PROVIDER_ID, userID);
        }
        return this.readAllFederatedProviderID(null, userID);
    }

    public Set readAllFederatedProviderID(String providerID, String userID) throws FSAccountMgmtException {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAccountManager.readAllFedProviderID() : userID=" + userID + ", providerID=" + providerID);
        }
        if (userID == null) {
            FSUtils.debug.error("FSAccountManager.readAllFederatedProviderID():Invalid Argument : user ID is NULL");
            throw new FSAccountMgmtException("actmgmt-user-dn-is-null", null);
        }
        Set existFedInfoSet = null;
        try {
            existFedInfoSet = this.provider.getAttribute(userID, "iplanet-am-user-federation-info");
        }
        catch (DataStoreProviderException ame) {
            FSUtils.debug.error("FSAccountManager.readAllFederatedProviderID():Exception:", (Throwable)((Object)ame));
            throw new FSAccountMgmtException(ame.getMessage());
        }
        HashSet<String> providerIDSet = new HashSet<String>();
        if (existFedInfoSet != null && !existFedInfoSet.isEmpty()) {
            Iterator i = existFedInfoSet.iterator();
            String existFedInfoStr = "";
            while (i.hasNext()) {
                existFedInfoStr = (String)i.next();
                FSAccountFedInfo afi = FSAccountUtils.stringToObject(existFedInfoStr);
                if (!afi.isFedStatusActive()) continue;
                if (providerID == null) {
                    providerIDSet.add(afi.getProviderID());
                    continue;
                }
                if (existFedInfoStr.indexOf("|" + providerID + "|") == -1) continue;
                providerIDSet.add(afi.getProviderID());
            }
        }
        return providerIDSet;
    }

    public boolean isFederationActive(String userID, String providerID) throws FSAccountMgmtException {
        FSUtils.debug.message("FSAccountManager.isFederationActive() : called");
        if (userID == null) {
            FSUtils.debug.error("FSAccountManager.isFederationActive():Invalid Argument : user ID is NULL");
            throw new FSAccountMgmtException("actmgmt-user-dn-is-null", null);
        }
        if (providerID == null || providerID.length() <= 0) {
            FSUtils.debug.error("FSAccountManager.isFederationActive() : Invalid Argument : ProviderID is NULL");
            throw new FSAccountMgmtException("actmgmt-provider-id-is-null", null);
        }
        Set existFedInfoSet = null;
        try {
            existFedInfoSet = this.provider.getAttribute(userID, "iplanet-am-user-federation-info");
        }
        catch (DataStoreProviderException ame) {
            FSUtils.debug.error("FSAccountManager.isFederationActive() :Exception: ", (Throwable)((Object)ame));
            throw new FSAccountMgmtException(ame.getMessage());
        }
        if (existFedInfoSet != null && !existFedInfoSet.isEmpty()) {
            String filter = FSAccountUtils.createFilter(providerID);
            Iterator i = existFedInfoSet.iterator();
            while (i.hasNext()) {
                FSAccountFedInfo afi;
                String existFedInfoStr = (String)i.next();
                if (existFedInfoStr.indexOf(filter) < 0) continue;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAccountManager.isFederationActive(): value found: " + existFedInfoStr);
                }
                return (afi = FSAccountUtils.stringToObject(existFedInfoStr)).isFedStatusActive();
            }
        }
        FSUtils.debug.error("FSAccountManager.isFederationActive() : Account Federation Info not Found");
        throw new FSAccountMgmtException("actmgmt-fed-info-not-found", null);
    }

    public boolean hasAnyActiveFederation(String userID) throws FSAccountMgmtException {
        FSUtils.debug.message("FSAccountManager.hasAnyActiveFederation():called");
        if (userID == null) {
            FSUtils.debug.error("FSAccountManager.hasAnyActiveFederation():Invalid Argument : user ID is NULL");
            throw new FSAccountMgmtException("actmgmt-user-dn-is-null", null);
        }
        Set existFedInfoSet = null;
        try {
            existFedInfoSet = this.provider.getAttribute(userID, "iplanet-am-user-federation-info");
        }
        catch (DataStoreProviderException ame) {
            FSUtils.debug.error("FSAccountManager.hasAnyActiveFederation():Exception: ", (Throwable)((Object)ame));
            throw new FSAccountMgmtException(ame.getMessage());
        }
        if (existFedInfoSet != null && !existFedInfoSet.isEmpty()) {
            Iterator i = existFedInfoSet.iterator();
            String existFedInfoStr = "";
            while (i.hasNext()) {
                existFedInfoStr = (String)i.next();
                FSAccountFedInfo afi = FSAccountUtils.stringToObject(existFedInfoStr);
                if (!afi.isFedStatusActive() || !afi.isRoleIDP()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public String getUserID(FSAccountFedInfoKey fedInfoKey, Map env) throws FSAccountMgmtException {
        return this.getUserID(fedInfoKey, null, env);
    }

    public String getUserID(FSAccountFedInfoKey fedInfoKey, String orgDN, Map env) throws FSAccountMgmtException {
        FSUtils.debug.message("FSAccountManager.getUserID() : called");
        if (fedInfoKey == null) {
            FSUtils.debug.error("FSAccountManager.getUserID():Invalid Argument : fedInfoKey is NULL");
            throw new FSAccountMgmtException("actmgmt-account-fed-info-key-object-is-null", null);
        }
        HashMap avPairs = new HashMap();
        HashSet<String> valueSet = new HashSet<String>();
        valueSet.add(FSAccountUtils.objectToKeyString(fedInfoKey));
        avPairs.put("iplanet-am-user-federation-info-key", valueSet);
        return this.userProvider.getUserID(orgDN, avPairs, env);
    }

    public String getUserID(Map avPair, String orgDN, Map env) throws FSAccountMgmtException {
        return this.userProvider.getUserID(orgDN, avPair, env);
    }
}

