/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.accountmgmt;

import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.saml.assertion.NameIdentifier;

public class FSAccountFedInfo {
    private String providerID = "";
    private NameIdentifier localNameIdentifier = null;
    private NameIdentifier remoteNameIdentifier = null;
    private boolean isActive = true;
    private boolean isAffiliationFed = false;
    private boolean isRoleIDP = true;

    FSAccountFedInfo() {
    }

    public FSAccountFedInfo(String providerID, NameIdentifier nameIdentifier, int nameIdentifierType, boolean isRoleIDP) throws FSAccountMgmtException {
        if (nameIdentifierType == 0) {
            this.init(providerID, nameIdentifier, null, isRoleIDP);
        } else if (nameIdentifierType == 1) {
            this.init(providerID, null, nameIdentifier, isRoleIDP);
        } else {
            FSUtils.debug.error("FSAccountFedInfo.Constructor() : Invalid Argument : Invalid Name Identifier Type");
            throw new FSAccountMgmtException("actmgmt-nameIdentifierType-invalid", null);
        }
    }

    public FSAccountFedInfo(String providerID, NameIdentifier localNameIdentifier, NameIdentifier remoteNameIdentifier, boolean isRoleIDP) throws FSAccountMgmtException {
        this.init(providerID, localNameIdentifier, remoteNameIdentifier, isRoleIDP);
    }

    private void init(String providerID, NameIdentifier localNameIdentifier, NameIdentifier remoteNameIdentifier, boolean isRoleIDP) throws FSAccountMgmtException {
        if (providerID == null || providerID.length() <= 0) {
            FSUtils.debug.error("FSAccountFedInfo.init(): Invalid Argument: providerID is " + providerID);
            throw new FSAccountMgmtException("actmgmt-provider-id-is-null", null);
        }
        if (localNameIdentifier == null && remoteNameIdentifier == null) {
            FSUtils.debug.error("FSAccountFedInfo.Constructor(): Invalid Argument: both NameIdentifiers are null");
            throw new FSAccountMgmtException("actmgmt-name-identifier-is-null", null);
        }
        this.providerID = providerID;
        this.localNameIdentifier = localNameIdentifier;
        this.remoteNameIdentifier = remoteNameIdentifier;
        this.isRoleIDP = isRoleIDP;
        this.isActive = true;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAccountFedInfo.init() : providerID :: " + this.providerID + ", isRoleIDP :: " + this.isRoleIDP);
            if (localNameIdentifier != null) {
                FSUtils.debug.message("FSAccountFedInfo.init() : localNameIdentifier" + this.localNameIdentifier.toString());
            }
            if (remoteNameIdentifier != null) {
                FSUtils.debug.message("FSAccountFedInfo.init() : remoteNameIdentifier" + this.remoteNameIdentifier.toString());
            }
        }
    }

    public String getProviderID() {
        return this.providerID;
    }

    void setProviderID(String providerID) {
        this.providerID = providerID;
    }

    public void setLocalNameIdentifier(NameIdentifier localNameIdentifier) {
        this.localNameIdentifier = localNameIdentifier;
    }

    public NameIdentifier getLocalNameIdentifier() {
        return this.localNameIdentifier;
    }

    public void setRemoteNameIdentifier(NameIdentifier remoteNameIdentifier) {
        this.remoteNameIdentifier = remoteNameIdentifier;
    }

    public NameIdentifier getRemoteNameIdentifier() {
        return this.remoteNameIdentifier;
    }

    public void activateFedStatus() {
        this.isActive = true;
    }

    public void deActivateFedStatus() {
        this.isActive = false;
    }

    public boolean isFedStatusActive() {
        return this.isActive;
    }

    public boolean isRoleIDP() {
        return this.isRoleIDP;
    }

    void setRole(boolean isRoleIDP) {
        this.isRoleIDP = isRoleIDP;
    }

    public void setAffiliation(boolean isAffiliationFed) {
        this.isAffiliationFed = isAffiliationFed;
    }

    public boolean getAffiliation() {
        return this.isAffiliationFed;
    }
}

