/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cot;

import com.sun.identity.cot.COTException;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.cot.LogUtil;
import com.sun.identity.shared.debug.Debug;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class COTUtils {
    public static final String RESOURCE_BUNDLE_NAME = "libCOT";
    public static Debug debug = Debug.getInstance((String)"fmCOT");
    static String WSFED_DELIM = "|wsfed";
    static String SAML2_DELIM = "|saml2";
    static String IDFF_DELIM = "|idff";

    public static String getFirstEntry(Map attrMap, String key) {
        Set valueSet;
        String retValue = null;
        if (attrMap != null && !attrMap.isEmpty() && (valueSet = (Set)attrMap.get(key)) != null && !valueSet.isEmpty()) {
            retValue = (String)valueSet.iterator().next();
        }
        return retValue;
    }

    public static void fillEntriesInSet(Map attrMap, String key, String value) {
        if (key != null && value != null && attrMap != null) {
            HashSet<String> valueSet = new HashSet<String>();
            valueSet.add(value);
            attrMap.put(key, valueSet);
        }
    }

    public static boolean isValidProtocolType(String protocolType) {
        boolean isValid;
        boolean bl = isValid = protocolType != null && protocolType.trim().length() > 0 && (protocolType.equalsIgnoreCase("idff") || protocolType.equalsIgnoreCase("saml2") || protocolType.equalsIgnoreCase("wsfed"));
        if (!isValid) {
            String[] data = new String[]{protocolType};
            LogUtil.error(Level.INFO, "INVALID_COT_TYPE", data);
        }
        return isValid;
    }

    static Map trustedProviderSetToEntityIDMap(Set providerSet, String realm) {
        if (providerSet == null || providerSet.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Set> map = new HashMap<String, Set>();
        Iterator it = providerSet.iterator();
        while (it.hasNext()) {
            HashSet<String> set;
            String val = (String)it.next();
            if (debug.messageEnabled()) {
                debug.message("COTUtils.setToEntityIDMap: check " + val);
            }
            if (val.endsWith(SAML2_DELIM)) {
                set = new HashSet<String>();
                set.add("saml2");
                map.put(val.substring(0, val.length() - SAML2_DELIM.length()), set);
                continue;
            }
            if (val.endsWith(IDFF_DELIM)) {
                set = new HashSet();
                set.add("idff");
                map.put(val.substring(0, val.length() - IDFF_DELIM.length()), set);
                continue;
            }
            if (val.endsWith(WSFED_DELIM)) {
                set = new HashSet();
                set.add("wsfed");
                map.put(val.substring(0, val.length() - WSFED_DELIM.length()), set);
                continue;
            }
            Set protocolSet = COTUtils.findProtocolsForEntity(val, realm);
            if (protocolSet == null || protocolSet.isEmpty()) continue;
            map.put(val, protocolSet);
        }
        if (debug.messageEnabled()) {
            debug.message("COTUtils.setToEntityIDMap: return " + map);
        }
        return map;
    }

    static Map trustedProviderSetToProtocolMap(Set providerSet, String realm) {
        if (providerSet == null || providerSet.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap map = new HashMap();
        HashSet<String> wsfedSet = new HashSet<String>();
        HashSet<String> saml2Set = new HashSet<String>();
        HashSet<String> idffSet = new HashSet<String>();
        Iterator it = providerSet.iterator();
        while (it.hasNext()) {
            String val = (String)it.next();
            if (debug.messageEnabled()) {
                debug.message("COTUtils.setToPrototolMap: check " + val);
            }
            if (val.endsWith(SAML2_DELIM)) {
                saml2Set.add(val.substring(0, val.length() - SAML2_DELIM.length()));
                continue;
            }
            if (val.endsWith(IDFF_DELIM)) {
                idffSet.add(val.substring(0, val.length() - IDFF_DELIM.length()));
                continue;
            }
            if (val.endsWith(WSFED_DELIM)) {
                wsfedSet.add(val.substring(0, val.length() - WSFED_DELIM.length()));
                continue;
            }
            Set protocolSet = COTUtils.findProtocolsForEntity(val, realm);
            if (protocolSet == null || protocolSet.isEmpty()) continue;
            Iterator pIt = protocolSet.iterator();
            while (pIt.hasNext()) {
                String proto = (String)pIt.next();
                if (proto.equals("saml2")) {
                    saml2Set.add(val);
                    continue;
                }
                if (proto.equals("idff")) {
                    idffSet.add(val);
                    continue;
                }
                if (!proto.equals("wsfed")) continue;
                wsfedSet.add(val);
            }
        }
        map.put("saml2", saml2Set);
        map.put("idff", idffSet);
        map.put("wsfed", wsfedSet);
        if (debug.messageEnabled()) {
            debug.message("COTUtils.setToProtocolMap: return " + map);
        }
        return map;
    }

    public static Set findProtocolsForEntity(String entityId, String realm) {
        try {
            Set saml2Set;
            HashSet<String> retSet = new HashSet<String>();
            CircleOfTrustManager manager = new CircleOfTrustManager();
            Set idffSet = manager.getAllEntities(realm, "idff");
            if (idffSet.contains(entityId)) {
                retSet.add("idff");
            }
            if ((saml2Set = manager.getAllEntities(realm, "saml2")) != null && saml2Set.contains(entityId)) {
                retSet.add("saml2");
            }
            return retSet;
        }
        catch (COTException e) {
            debug.error("COTUtils.findProtocolsForEntity", (Throwable)((Object)e));
            return null;
        }
    }

    static Set trustedProviderProtocolMapToSet(Map providerMap) {
        if (providerMap == null || providerMap.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> retSet = new HashSet<String>();
        Set keys = providerMap.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String suffix = null;
            if (key.equals("saml2")) {
                suffix = SAML2_DELIM;
            } else if (key.equals("idff")) {
                suffix = IDFF_DELIM;
            } else if (key.equals("wsfed")) {
                suffix = WSFED_DELIM;
            } else {
                if (!debug.warningEnabled()) continue;
                debug.warning("COTUtils.protocolMapToSet: invalid protocol " + key);
                continue;
            }
            Set vals = (Set)providerMap.get(key);
            Iterator it2 = vals.iterator();
            while (it2.hasNext()) {
                String val = (String)it2.next();
                retSet.add(val + suffix);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("COTUtils.protocolMapToSet: return" + retSet);
        }
        return retSet;
    }
}

