/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Iterator;
import java.util.LinkedList;
import javax.sql.DataSource;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.AbstractTransactionalSpringContextTests;
import org.springframework.util.StringUtils;

public abstract class AbstractTransactionalDataSourceSpringContextTests
extends AbstractTransactionalSpringContextTests {
    protected JdbcTemplate jdbcTemplate;
    private boolean zappedTables;

    public AbstractTransactionalDataSourceSpringContextTests() {
    }

    public AbstractTransactionalDataSourceSpringContextTests(String name) {
        super(name);
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public final JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    protected void deleteFromTables(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            int rowCount = this.jdbcTemplate.update("DELETE FROM " + names[i]);
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info((Object)("Deleted " + rowCount + " rows from table " + names[i]));
        }
        this.zappedTables = true;
    }

    protected final void setComplete() {
        if (this.zappedTables) {
            throw new IllegalStateException("Cannot set complete after deleting tables");
        }
        super.setComplete();
    }

    protected int countRowsInTable(String tableName) {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(0) FROM " + tableName);
    }

    protected void executeSqlScript(String sqlResourcePath, boolean continueOnError) throws DataAccessException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Executing SQL script '" + sqlResourcePath + "'"));
        }
        long startTime = System.currentTimeMillis();
        LinkedList<String> statements = new LinkedList<String>();
        Resource res = this.getApplicationContext().getResource(sqlResourcePath);
        try {
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(res.getInputStream()));
            String currentStatement = lnr.readLine();
            while (currentStatement != null) {
                currentStatement = StringUtils.replace((String)currentStatement, (String)";", (String)"");
                statements.add(currentStatement);
                currentStatement = lnr.readLine();
            }
            Iterator itr = statements.iterator();
            while (itr.hasNext()) {
                String statement = (String)itr.next();
                try {
                    int rowsAffected = this.jdbcTemplate.update(statement);
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)(rowsAffected + " rows affected by SQL: " + statement));
                }
                catch (DataAccessException ex) {
                    if (continueOnError) {
                        if (!this.logger.isWarnEnabled()) continue;
                        this.logger.warn((Object)("SQL: " + statement + " failed"), (Throwable)ex);
                        continue;
                    }
                    throw ex;
                }
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            this.logger.info((Object)("Done executing SQL script '" + sqlResourcePath + "' in " + elapsedTime + " ms"));
        }
        catch (IOException ex) {
            throw new DataAccessResourceFailureException("Failed to open SQL script '" + sqlResourcePath + "'", (Throwable)ex);
        }
    }
}

