/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.springframework.core.CollectionFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class MockPortletURL
implements PortletURL {
    public static final String URL_TYPE_RENDER = "render";
    public static final String URL_TYPE_ACTION = "action";
    private static final String ENCODING = "UTF-8";
    private final PortalContext portalContext;
    private final String urlType;
    private WindowState windowState;
    private PortletMode portletMode;
    private final Map parameters = CollectionFactory.createLinkedMapIfPossible((int)16);
    private boolean secure = false;

    public MockPortletURL(PortalContext portalContext, String urlType) {
        Assert.notNull((Object)portalContext, (String)"PortalContext is required");
        this.portalContext = portalContext;
        this.urlType = urlType;
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (!CollectionUtils.contains((Enumeration)this.portalContext.getSupportedWindowStates(), (Object)windowState)) {
            throw new WindowStateException("WindowState not supported", windowState);
        }
        this.windowState = windowState;
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (!CollectionUtils.contains((Enumeration)this.portalContext.getSupportedPortletModes(), (Object)portletMode)) {
            throw new PortletModeException("PortletMode not supported", portletMode);
        }
        this.portletMode = portletMode;
    }

    public void setParameter(String key, String value) {
        Assert.notNull((Object)key, (String)"Parameter key must be null");
        Assert.notNull((Object)value, (String)"Parameter value must not be null");
        this.parameters.put(key, new String[]{value});
    }

    public void setParameter(String key, String[] values) {
        Assert.notNull((Object)key, (String)"Parameter key must be null");
        Assert.notNull((Object)values, (String)"Parameter values must not be null");
        this.parameters.put(key, values);
    }

    public void setParameters(Map parameters) {
        Assert.notNull((Object)parameters, (String)"Parameters Map must not be null");
        this.parameters.clear();
        Iterator it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Assert.isTrue((boolean)(entry.getKey() instanceof String), (String)"Key must be of type String");
            Assert.isTrue((boolean)(entry.getValue() instanceof String[]), (String)"Value must be of type String[]");
            this.parameters.put(entry.getKey(), entry.getValue());
        }
    }

    public Set getParameterNames() {
        return this.parameters.keySet();
    }

    public String getParameter(String name) {
        String[] arr = (String[])this.parameters.get(name);
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameters.get(name);
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public void setSecure(boolean secure) throws PortletSecurityException {
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String toString() {
        StringBuffer query = new StringBuffer();
        query.append(this.encodeParameter("urlType", this.urlType));
        if (this.windowState != null) {
            query.append(";" + this.encodeParameter("windowState", this.windowState.toString()));
        }
        if (this.portletMode != null) {
            query.append(";" + this.encodeParameter("portletMode", this.portletMode.toString()));
        }
        Iterator it = this.parameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            query.append(";" + this.encodeParameter("param_" + name, values));
        }
        return (this.secure ? "https:" : "http:") + "//localhost/mockportlet?" + query.toString();
    }

    private String encodeParameter(String name, String value) {
        try {
            return URLEncoder.encode(name, ENCODING) + "=" + URLEncoder.encode(value, ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    private String encodeParameter(String name, String[] values) {
        try {
            StringBuffer buf = new StringBuffer();
            int n = values.length;
            for (int i = 0; i < n; ++i) {
                buf.append((i > 0 ? ";" : "") + URLEncoder.encode(name, ENCODING) + "=" + URLEncoder.encode(values[i], ENCODING));
            }
            return buf.toString();
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }
}

