/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.portlet.PortalContext;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.WindowState;
import org.springframework.core.CollectionFactory;
import org.springframework.mock.web.portlet.MockPortalContext;
import org.springframework.mock.web.portlet.MockPortletContext;
import org.springframework.mock.web.portlet.MockPortletPreferences;
import org.springframework.mock.web.portlet.MockPortletSession;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class MockPortletRequest
implements PortletRequest {
    private boolean active = true;
    private final PortalContext portalContext;
    private final PortletContext portletContext;
    private PortletSession session = null;
    private WindowState windowState = WindowState.NORMAL;
    private PortletMode portletMode = PortletMode.VIEW;
    private PortletPreferences portletPreferences = new MockPortletPreferences();
    private final Map properties = CollectionFactory.createLinkedMapIfPossible((int)16);
    private final Hashtable attributes = new Hashtable();
    private final Map parameters = CollectionFactory.createLinkedMapIfPossible((int)16);
    private String authType = null;
    private String contextPath = "";
    private String remoteUser = null;
    private Principal userPrincipal = null;
    private final Set userRoles = new HashSet();
    private boolean secure = false;
    private boolean requestedSessionIdValid = true;
    private final Vector responseContentTypes = new Vector();
    private final Vector locales = new Vector();
    private String scheme = "http";
    private String serverName = "localhost";
    private int serverPort = 80;

    public MockPortletRequest() {
        this(null, null);
    }

    public MockPortletRequest(PortletContext portletContext) {
        this(null, portletContext);
    }

    public MockPortletRequest(PortalContext portalContext, PortletContext portletContext) {
        this.portalContext = portalContext != null ? portalContext : new MockPortalContext();
        this.portletContext = portletContext != null ? portletContext : new MockPortletContext();
        this.responseContentTypes.add("text/html");
        this.locales.add(Locale.ENGLISH);
    }

    public boolean isActive() {
        return this.active;
    }

    public void close() {
        this.active = false;
    }

    protected void checkActive() throws IllegalStateException {
        if (!this.active) {
            throw new IllegalStateException("Request is not active anymore");
        }
    }

    public boolean isWindowStateAllowed(WindowState windowState) {
        return CollectionUtils.contains((Enumeration)this.portalContext.getSupportedWindowStates(), (Object)windowState);
    }

    public boolean isPortletModeAllowed(PortletMode portletMode) {
        return CollectionUtils.contains((Enumeration)this.portalContext.getSupportedPortletModes(), (Object)portletMode);
    }

    public void setPortletMode(PortletMode portletMode) {
        this.portletMode = portletMode;
    }

    public PortletMode getPortletMode() {
        return this.portletMode;
    }

    public void setWindowState(WindowState windowState) {
        this.windowState = windowState;
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    public void setPreferences(PortletPreferences preferences) {
        this.portletPreferences = preferences;
    }

    public PortletPreferences getPreferences() {
        return this.portletPreferences;
    }

    public void setSession(PortletSession session) {
        this.session = session;
        if (session instanceof MockPortletSession) {
            MockPortletSession mockSession = (MockPortletSession)session;
            mockSession.access();
        }
    }

    public PortletSession getPortletSession() {
        return this.getPortletSession(true);
    }

    public PortletSession getPortletSession(boolean create) {
        this.checkActive();
        if (this.session instanceof MockPortletSession && ((MockPortletSession)this.session).isInvalid()) {
            this.session = null;
        }
        if (this.session == null && create) {
            this.session = new MockPortletSession(this.portletContext);
        }
        return this.session;
    }

    public void setProperty(String key, String value) {
        Assert.notNull((Object)key, (String)"Property key must not be null");
        LinkedList<String> list = new LinkedList<String>();
        list.add(value);
        this.properties.put(key, list);
    }

    public void addProperty(String key, String value) {
        Assert.notNull((Object)key, (String)"Property key must not be null");
        List oldList = (List)this.properties.get(key);
        if (oldList != null) {
            oldList.add(value);
        } else {
            LinkedList<String> list = new LinkedList<String>();
            list.add(value);
            this.properties.put(key, list);
        }
    }

    public String getProperty(String key) {
        Assert.notNull((Object)key, (String)"Property key must not be null");
        List list = (List)this.properties.get(key);
        return list != null && list.size() > 0 ? (String)list.get(0) : null;
    }

    public Enumeration getProperties(String key) {
        Assert.notNull((Object)key, (String)"property key must not be null");
        return Collections.enumeration((List)this.properties.get(key));
    }

    public Enumeration getPropertyNames() {
        return Collections.enumeration(this.properties.keySet());
    }

    public PortalContext getPortalContext() {
        return this.portalContext;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void setUserPrincipal(Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public void addUserRole(String role) {
        this.userRoles.add(role);
    }

    public boolean isUserInRole(String role) {
        return this.userRoles.contains(role);
    }

    public Object getAttribute(String name) {
        this.checkActive();
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        this.checkActive();
        return this.attributes.keys();
    }

    public void setParameters(Map parameters) {
        Assert.notNull((Object)parameters, (String)"Parameters Map must not be null");
        this.parameters.clear();
        Iterator it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Assert.isTrue((boolean)(entry.getKey() instanceof String), (String)"Key must be of type String");
            Assert.isTrue((boolean)(entry.getValue() instanceof String[]), (String)"Value must be of type String[]");
            this.parameters.put(entry.getKey(), entry.getValue());
        }
    }

    public void setParameter(String key, String value) {
        Assert.notNull((Object)key, (String)"Parameter key must be null");
        Assert.notNull((Object)value, (String)"Parameter value must not be null");
        this.parameters.put(key, new String[]{value});
    }

    public void setParameter(String key, String[] values) {
        Assert.notNull((Object)key, (String)"Parameter key must be null");
        Assert.notNull((Object)values, (String)"Parameter values must not be null");
        this.parameters.put(key, values);
    }

    public void addParameter(String name, String value) {
        this.addParameter(name, new String[]{value});
    }

    public void addParameter(String name, String[] values) {
        String[] oldArr = (String[])this.parameters.get(name);
        if (oldArr != null) {
            String[] newArr = new String[oldArr.length + values.length];
            System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
            System.arraycopy(values, 0, newArr, oldArr.length, values.length);
            this.parameters.put(name, newArr);
        } else {
            this.parameters.put(name, values);
        }
    }

    public String getParameter(String name) {
        String[] arr = (String[])this.parameters.get(name);
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameters.get(name);
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setAttribute(String name, Object value) {
        this.checkActive();
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void removeAttribute(String name) {
        this.checkActive();
        this.attributes.remove(name);
    }

    public String getRequestedSessionId() {
        PortletSession session = this.getPortletSession();
        return session != null ? session.getId() : null;
    }

    public void setRequestedSessionIdValid(boolean requestedSessionIdValid) {
        this.requestedSessionIdValid = requestedSessionIdValid;
    }

    public boolean isRequestedSessionIdValid() {
        return this.requestedSessionIdValid;
    }

    public void addResponseContentType(String responseContentType) {
        this.responseContentTypes.add(responseContentType);
    }

    public void addPreferredResponseContentType(String responseContentType) {
        this.responseContentTypes.add(0, responseContentType);
    }

    public String getResponseContentType() {
        return (String)this.responseContentTypes.get(0);
    }

    public Enumeration getResponseContentTypes() {
        return this.responseContentTypes.elements();
    }

    public void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    public void addPreferredLocale(Locale locale) {
        this.locales.add(0, locale);
    }

    public Locale getLocale() {
        return (Locale)this.locales.get(0);
    }

    public Enumeration getLocales() {
        return this.locales.elements();
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public int getServerPort() {
        return this.serverPort;
    }
}

