/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.mock;

import java.io.IOException;
import org.apache.activemq.transport.DefaultTransportListener;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.ResponseCallback;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.transport.TransportListener;

public class MockTransport
extends DefaultTransportListener
implements Transport {
    protected Transport next;
    protected TransportListener transportListener;

    public MockTransport(Transport next) {
        this.next = next;
    }

    public synchronized void setTransportListener(TransportListener channelListener) {
        this.transportListener = channelListener;
        if (channelListener == null) {
            this.getNext().setTransportListener(null);
        } else {
            this.getNext().setTransportListener(this);
        }
    }

    public void start() throws Exception {
        if (this.getNext() == null) {
            throw new IOException("The next channel has not been set.");
        }
        if (this.transportListener == null) {
            throw new IOException("The command listener has not been set.");
        }
        this.getNext().start();
    }

    public void stop() throws Exception {
        this.getNext().stop();
    }

    public void onCommand(Object command) {
        this.getTransportListener().onCommand(command);
    }

    public synchronized Transport getNext() {
        return this.next;
    }

    public synchronized TransportListener getTransportListener() {
        return this.transportListener;
    }

    public String toString() {
        return this.getNext().toString();
    }

    public void oneway(Object command) throws IOException {
        this.getNext().oneway(command);
    }

    public FutureResponse asyncRequest(Object command, ResponseCallback responseCallback) throws IOException {
        return this.getNext().asyncRequest(command, null);
    }

    public Object request(Object command) throws IOException {
        return this.getNext().request(command);
    }

    public Object request(Object command, int timeout) throws IOException {
        return this.getNext().request(command, timeout);
    }

    public void onException(IOException error) {
        this.getTransportListener().onException(error);
    }

    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return this.getNext().narrow(target);
    }

    public synchronized void setNext(Transport next) {
        this.next = next;
    }

    public void install(TransportFilter filter) {
        filter.setTransportListener(this);
        this.getNext().setTransportListener(filter);
        this.setNext(filter);
    }

    public String getRemoteAddress() {
        return this.getNext().getRemoteAddress();
    }
}

