/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.policy;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import javax.jms.MessageListener;
import org.apache.activemq.ActiveMQMessageTransformation;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.policy.MessageQuery;
import org.apache.activemq.broker.region.policy.SubscriptionRecoveryPolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.util.IdGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryBasedSubscriptionRecoveryPolicy
implements SubscriptionRecoveryPolicy {
    private static final Log log = LogFactory.getLog((Class)QueryBasedSubscriptionRecoveryPolicy.class);
    private MessageQuery query;
    private AtomicLong messageSequence = new AtomicLong(0L);
    private IdGenerator idGenerator = new IdGenerator();
    private ProducerId producerId = this.createProducerId();

    public SubscriptionRecoveryPolicy copy() {
        QueryBasedSubscriptionRecoveryPolicy rc = new QueryBasedSubscriptionRecoveryPolicy();
        rc.setQuery(this.query);
        return rc;
    }

    public boolean add(ConnectionContext context, MessageReference message) throws Exception {
        return this.query.validateUpdate(message.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(ConnectionContext context, final Topic topic, final Subscription sub) throws Exception {
        if (this.query != null) {
            final MessageEvaluationContext msgContext = context.getMessageEvaluationContext();
            try {
                ActiveMQDestination destination = sub.getConsumerInfo().getDestination();
                this.query.execute(destination, new MessageListener(){

                    public void onMessage(javax.jms.Message message) {
                        QueryBasedSubscriptionRecoveryPolicy.this.dispatchInitialMessage(message, topic, msgContext, sub);
                    }
                });
            }
            finally {
                msgContext.clear();
            }
        }
    }

    public void start() throws Exception {
        if (this.query == null) {
            throw new IllegalArgumentException("No query property configured");
        }
    }

    public void stop() throws Exception {
    }

    public MessageQuery getQuery() {
        return this.query;
    }

    public void setQuery(MessageQuery query) {
        this.query = query;
    }

    public Message[] browse(ActiveMQDestination dest) throws Exception {
        return new Message[0];
    }

    protected void dispatchInitialMessage(javax.jms.Message message, Destination regionDestination, MessageEvaluationContext msgContext, Subscription sub) {
        try {
            ActiveMQMessage activeMessage = ActiveMQMessageTransformation.transformMessage(message, null);
            ActiveMQDestination destination = activeMessage.getDestination();
            if (destination == null) {
                destination = sub.getConsumerInfo().getDestination();
                activeMessage.setDestination(destination);
            }
            activeMessage.setRegionDestination(regionDestination);
            this.configure(activeMessage);
            msgContext.setDestination(destination);
            msgContext.setMessageReference(activeMessage);
            if (sub.matches(activeMessage, msgContext)) {
                sub.add(activeMessage);
            }
        }
        catch (Throwable e) {
            log.warn((Object)("Failed to dispatch initial message: " + message + " into subscription. Reason: " + e), e);
        }
    }

    protected void configure(ActiveMQMessage msg) {
        long sequenceNumber = this.messageSequence.incrementAndGet();
        msg.setMessageId(new MessageId(this.producerId, sequenceNumber));
        msg.onSend();
        msg.setProducerId(this.producerId);
    }

    protected ProducerId createProducerId() {
        String id = this.idGenerator.generateId();
        ConnectionId connectionId = new ConnectionId(id);
        SessionId sessionId = new SessionId(connectionId, 1L);
        return new ProducerId(sessionId, 1L);
    }
}

