/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workflow.core.node;

import java.util.List;
import org.drools.definition.process.Connection;
import org.drools.workflow.core.impl.ExtendedNodeImpl;

public abstract class SequenceNode
extends ExtendedNodeImpl {
    private static final long serialVersionUID = 4L;

    public Connection getFrom() {
        List<Connection> list = this.getIncomingConnections("DROOLS_DEFAULT");
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public Connection getTo() {
        List<Connection> list = this.getOutgoingConnections("DROOLS_DEFAULT");
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public void validateAddIncomingConnection(String type, Connection connection) {
        super.validateAddIncomingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node only accepts default incoming connection type!");
        }
        if (this.getIncomingConnections("DROOLS_DEFAULT") != null && !this.getIncomingConnections("DROOLS_DEFAULT").isEmpty()) {
            throw new IllegalArgumentException("This type of node cannot have more than one incoming connection!");
        }
    }

    public void validateAddOutgoingConnection(String type, Connection connection) {
        super.validateAddOutgoingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node only accepts default outgoing connection type!");
        }
        if (this.getOutgoingConnections("DROOLS_DEFAULT") != null && !this.getOutgoingConnections("DROOLS_DEFAULT").isEmpty()) {
            throw new IllegalArgumentException("This type of node cannot have more than one outgoing connection!");
        }
    }
}

