/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.instance.impl.humantask;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.drools.process.instance.impl.humantask.HumanTaskDialog;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HumanTaskHandler
extends JFrame
implements WorkItemHandler {
    private static final long serialVersionUID = 400L;
    private Map<WorkItem, WorkItemManager> workItems = new HashMap<WorkItem, WorkItemManager>();
    private JTextField actorTextField;
    private JList workItemsList;
    private JButton selectButton;

    public HumanTaskHandler() {
        this.setSize(new Dimension(400, 300));
        this.setTitle("Work Items");
        this.setDefaultCloseOperation(2);
        this.initializeComponent();
    }

    private void initializeComponent() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.getRootPane().setLayout(new BorderLayout());
        this.getRootPane().add((Component)panel, "Center");
        JLabel label = new JLabel("Actor");
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)label, c);
        this.actorTextField = new JTextField();
        c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.actorTextField, c);
        JButton updateButton = new JButton("Update");
        updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                HumanTaskHandler.this.update();
            }
        });
        c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)updateButton, c);
        this.workItemsList = new JList();
        this.workItemsList.setSelectionMode(0);
        this.workItemsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    HumanTaskHandler.this.select();
                }
            }
        });
        this.workItemsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                HumanTaskHandler.this.selectButton.setEnabled(HumanTaskHandler.this.getSelectedWorkItem() != null);
            }
        });
        c = new GridBagConstraints();
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.workItemsList, c);
        this.selectButton = new JButton("Select");
        this.selectButton.setEnabled(false);
        this.selectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                HumanTaskHandler.this.select();
            }
        });
        c = new GridBagConstraints();
        c.gridy = 2;
        c.weightx = 1.0;
        c.gridwidth = 3;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.selectButton, c);
    }

    private void update() {
        String actor = this.actorTextField.getText();
        if ("".equals(actor)) {
            actor = null;
        }
        this.reloadWorkItemsList(actor);
    }

    private void select() {
        WorkItem workItem = this.getSelectedWorkItem();
        if (workItem != null) {
            HumanTaskDialog dialog = new HumanTaskDialog(this, workItem);
            dialog.setVisible(true);
        }
    }

    public WorkItem getSelectedWorkItem() {
        Object selected;
        int index = this.workItemsList.getSelectedIndex();
        if (index != -1 && (selected = this.workItemsList.getModel().getElementAt(index)) instanceof WorkItemWrapper) {
            return ((WorkItemWrapper)selected).getWorkItem();
        }
        return null;
    }

    private void reloadWorkItemsList(String actor) {
        ArrayList<WorkItemWrapper> result = new ArrayList<WorkItemWrapper>();
        for (WorkItem workItem : this.workItems.keySet()) {
            if (actor != null && workItem.getParameter("ActorId") != null && !actor.equals(workItem.getParameter("ActorId"))) continue;
            result.add(new WorkItemWrapper(workItem));
        }
        this.workItemsList.setListData(result.toArray());
    }

    public void complete(WorkItem workItem, Map<String, Object> results) {
        WorkItemManager manager = this.workItems.get(workItem);
        if (manager != null) {
            manager.completeWorkItem(workItem.getId(), results);
        }
        this.workItems.remove(workItem);
        this.update();
        this.selectButton.setEnabled(this.getSelectedWorkItem() != null);
    }

    public void abort(WorkItem workItem) {
        WorkItemManager manager = this.workItems.get(workItem);
        if (manager != null) {
            manager.abortWorkItem(workItem.getId());
        }
        this.workItems.remove(workItem);
        this.update();
        this.selectButton.setEnabled(this.getSelectedWorkItem() != null);
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        this.workItems.remove(workItem);
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        this.workItems.put(workItem, manager);
    }

    private class WorkItemWrapper {
        private WorkItem workItem;

        public WorkItemWrapper(WorkItem workItem) {
            this.workItem = workItem;
        }

        public WorkItem getWorkItem() {
            return this.workItem;
        }

        public String toString() {
            return "[" + this.workItem.getId() + "] " + this.workItem.getParameter("TaskName");
        }
    }
}

