/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap.impl;

import com.sun.xml.fastinfoset.dom.DOMDocumentSerializer;
import com.sun.xml.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.messaging.saaj.soap.Envelope;
import com.sun.xml.messaging.saaj.soap.SOAPDocumentImpl;
import com.sun.xml.messaging.saaj.soap.impl.BodyImpl;
import com.sun.xml.messaging.saaj.soap.impl.ElementImpl;
import com.sun.xml.messaging.saaj.soap.impl.HeaderImpl;
import com.sun.xml.messaging.saaj.soap.name.NameImpl;
import com.sun.xml.messaging.saaj.util.transform.EfficientStreamingTransformer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.logging.Level;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jvnet.fastinfoset.FastInfosetResult;
import org.w3c.dom.Document;

public abstract class EnvelopeImpl
extends ElementImpl
implements Envelope {
    HeaderImpl header;
    BodyImpl body;
    String omitXmlDecl = "yes";
    String charset = "utf-8";

    protected void lookForBody() throws SOAPException {
        BodyImpl bodyChildElement;
        NameImpl bodyName = this.getBodyName(null);
        this.body = bodyChildElement = (BodyImpl)this.findChild(bodyName);
    }

    protected void lookForHeader() throws SOAPException {
        HeaderImpl hdr;
        NameImpl headerName = this.getHeaderName(null);
        this.header = hdr = (HeaderImpl)this.findChild(headerName);
    }

    public void output(OutputStream out) throws IOException {
        try {
            Transformer transformer = EfficientStreamingTransformer.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", this.omitXmlDecl);
            transformer.setOutputProperty("encoding", this.charset);
            ElementImpl.log.log(Level.FINE, "SAAJ0190.impl.set.xml.declaration", new String[]{this.omitXmlDecl});
            ElementImpl.log.log(Level.FINE, "SAAJ0191.impl.set.encoding", new String[]{this.charset});
            StreamResult result = new StreamResult(out);
            transformer.transform(this.getContent(), result);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void output(OutputStream out, boolean isFastInfoset) throws IOException {
        if (!isFastInfoset) {
            this.output(out);
        } else {
            try {
                Source source = this.getContent();
                if (source instanceof DOMSource) {
                    DOMDocumentSerializer ds = new DOMDocumentSerializer();
                    ds.setOutputStream(out);
                    ds.serialize((Document)((DOMSource)source).getNode());
                } else {
                    Transformer transformer = EfficientStreamingTransformer.newTransformer();
                    transformer.transform(source, (Result)new FastInfosetResult(out));
                }
            }
            catch (Exception ex) {
                throw new IOException(ex.getMessage());
            }
        }
    }

    private String getOmitXmlDecl() {
        return this.omitXmlDecl;
    }

    public void setCharsetEncoding(String value) {
        this.charset = value;
    }

    public void setOmitXmlDecl(String value) {
        this.omitXmlDecl = value;
    }

    public SOAPBody addBody() throws SOAPException {
        return this.addBody(null);
    }

    public SOAPBody getBody() throws SOAPException {
        this.lookForBody();
        return this.body;
    }

    public SOAPHeader addHeader() throws SOAPException {
        return this.addHeader(null);
    }

    public SOAPHeader getHeader() throws SOAPException {
        this.lookForHeader();
        return this.header;
    }

    public Source getContent() {
        return new DOMSource(this.getOwnerDocument());
    }

    protected EnvelopeImpl(SOAPDocumentImpl ownerDoc, NameImpl name, boolean createHeader, boolean createBody) throws SOAPException {
        this(ownerDoc, name);
        this.ensureNamespaceIsDeclared(this.getElementName());
        if (createHeader) {
            this.addHeader();
        }
        if (createBody) {
            this.addBody();
        }
    }

    protected abstract NameImpl getBodyName(String var1);

    protected abstract NameImpl getHeaderName(String var1);

    protected EnvelopeImpl(SOAPDocumentImpl ownerDoc, Name name) {
        super(ownerDoc, name);
    }

    public Name createName(String localName) throws SOAPException {
        return NameImpl.createFromUnqualifiedName(localName);
    }

    public SOAPBody addBody(String prefix) throws SOAPException {
        this.lookForBody();
        if (prefix == null || prefix.equals("")) {
            prefix = this.getPrefix();
        }
        if (this.body != null) {
            ElementImpl.log.severe("SAAJ0122.impl.body.already.exists");
            throw new SOAPExceptionImpl("Can't add a body when one is already present.");
        }
        NameImpl bodyName = this.getBodyName(prefix);
        this.body = (BodyImpl)this.createElement(bodyName);
        this.insertBefore(this.body, null);
        this.body.ensureNamespaceIsDeclared(bodyName);
        return this.body;
    }

    protected SOAPElement addElement(Name name) throws SOAPException {
        if (this.getBodyName(null).equals(name)) {
            return this.addBody(name.getPrefix());
        }
        if (this.getHeaderName(null).equals(name)) {
            return this.addHeader(name.getPrefix());
        }
        return super.addElement(name);
    }

    public SOAPHeader addHeader(String prefix) throws SOAPException {
        if (prefix == null || prefix.equals("")) {
            prefix = this.getPrefix();
        }
        NameImpl headerName = this.getHeaderName(prefix);
        NameImpl bodyName = this.getBodyName(prefix);
        HeaderImpl header = null;
        SOAPElement firstChild = null;
        Iterator eachChild = this.getChildElementNodes();
        if (eachChild.hasNext()) {
            firstChild = (SOAPElement)eachChild.next();
            if (firstChild.getElementName().equals(headerName)) {
                ElementImpl.log.severe("SAAJ0120.impl.header.already.exists");
                throw new SOAPExceptionImpl("Can't add a header when one is already present.");
            }
            if (!firstChild.getElementName().equals(bodyName)) {
                ElementImpl.log.severe("SAAJ0121.impl.invalid.first.child.of.envelope");
                throw new SOAPExceptionImpl("First child of Envelope must be either a Header or Body");
            }
        }
        header = (HeaderImpl)this.createElement(headerName);
        this.insertBefore(header, firstChild);
        header.ensureNamespaceIsDeclared(headerName);
        return header;
    }

    public Name createName(String localName, String prefix) throws SOAPException {
        String namespace = this.getNamespaceURI(prefix);
        if (namespace == null) {
            ElementImpl.log.log(Level.SEVERE, "SAAJ0126.impl.cannot.locate.ns", new String[]{prefix});
            throw new SOAPExceptionImpl("Unable to locate namespace for prefix " + prefix);
        }
        return NameImpl.create(localName, prefix, namespace);
    }

    public Name createName(String localName, String prefix, String uri) throws SOAPException {
        if ("xmlns".equals(prefix)) {
            ElementImpl.log.severe("SAAJ0123.impl.no.reserved.xmlns");
            throw new SOAPExceptionImpl("Cannot declare reserved xmlns prefix");
        }
        if (prefix == null && "xmlns".equals(localName)) {
            ElementImpl.log.severe("SAAJ0124.impl.qualified.name.cannot.be.xmlns");
            throw new SOAPExceptionImpl("Qualified name cannot be xmlns");
        }
        return NameImpl.create(localName, prefix, uri);
    }
}

