/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap;

import com.sun.xml.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.messaging.saaj.soap.AttachmentPartImpl;
import com.sun.xml.messaging.saaj.soap.Envelope;
import com.sun.xml.messaging.saaj.soap.MessageImpl;
import com.sun.xml.messaging.saaj.soap.SOAPDocument;
import com.sun.xml.messaging.saaj.soap.SOAPDocumentImpl;
import com.sun.xml.messaging.saaj.soap.SOAPIOException;
import com.sun.xml.messaging.saaj.soap.SOAPVersionMismatchException;
import com.sun.xml.messaging.saaj.soap.impl.ElementImpl;
import com.sun.xml.messaging.saaj.soap.impl.EnvelopeImpl;
import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.messaging.saaj.util.JAXMStreamSource;
import com.sun.xml.messaging.saaj.util.MimeHeadersUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.internet.MimeBodyPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jvnet.fastinfoset.FastInfosetSource;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public abstract class SOAPPartImpl
extends SOAPPart
implements SOAPDocument {
    protected static Logger log = Logger.getLogger("javax.xml.messaging.saaj.soap", "com.sun.xml.messaging.saaj.soap.LocalStrings");
    protected MimeHeaders headers;
    protected Envelope envelope;
    protected Source source;
    protected SOAPDocumentImpl document = new SOAPDocumentImpl(this);
    private boolean sourceWasSet = false;
    protected MessageImpl message;

    public short getNodeType() {
        return this.document.getNodeType();
    }

    protected SOAPPartImpl() {
        this(null);
    }

    public void detachNode() {
    }

    protected void doGetDocumentElement() {
        this.handleNewSource();
        try {
            this.lookForEnvelope();
        }
        catch (SOAPException e) {}
    }

    private void handleNewSource() {
        block2: {
            if (!this.sourceWasSet) break block2;
            try {
                this.getEnvelope();
            }
            catch (SOAPException e) {}
        }
    }

    protected void lookForEnvelope() throws SOAPException {
        Element envelopeChildElement = this.document.doGetDocumentElement();
        if (envelopeChildElement == null || envelopeChildElement instanceof Envelope) {
            this.envelope = (EnvelopeImpl)envelopeChildElement;
        } else {
            if (!(envelopeChildElement instanceof ElementImpl)) {
                log.severe("SAAJ0512.soap.incorrect.factory.used");
                throw new SOAPExceptionImpl("Unable to create envelope: incorrect factory used during tree construction");
            }
            ElementImpl soapElement = (ElementImpl)envelopeChildElement;
            if (soapElement.getLocalName().equalsIgnoreCase("Envelope")) {
                String uri;
                String prefix = soapElement.getPrefix();
                String string = uri = prefix == null ? soapElement.getNamespaceURI() : soapElement.getNamespaceURI(prefix);
                if (!uri.equals("http://schemas.xmlsoap.org/soap/envelope/") && !uri.equals("http://www.w3.org/2002/06/soap-envelope")) {
                    log.severe("SAAJ0513.soap.unknown.ns");
                    throw new SOAPVersionMismatchException("Unable to create envelope from given source because the namespace was not recognized");
                }
            } else {
                log.severe("SAAJ0514.soap.root.elem.not.named.envelope");
                throw new SOAPExceptionImpl("Unable to create envelope from given source because the root element is not named \"Envelope\"");
            }
        }
    }

    public void normalize() {
        this.handleNewSource();
        this.document.normalize();
    }

    public void normalizeDocument() {
        throw new UnsupportedOperationException("normalizeDocument Not Supported");
    }

    public void recycleNode() {
    }

    public void removeAllMimeHeaders() {
        this.headers.removeAllHeaders();
    }

    public boolean getStrictErrorChecking() {
        throw new UnsupportedOperationException("getStrictErrorChecking Not Supported");
    }

    public boolean getXmlStandalone() {
        throw new UnsupportedOperationException("getXmlStandalone Not Supported");
    }

    public boolean hasAttributes() {
        return this.document.hasAttributes();
    }

    public boolean hasChildNodes() {
        this.handleNewSource();
        return this.document.hasChildNodes();
    }

    public boolean isFastInfoset() {
        return this.message != null ? this.message.isFastInfoset() : false;
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new UnsupportedOperationException("setStrictErrorChecking Not Supported");
    }

    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        throw new UnsupportedOperationException("setXmlStandalone Not Supported");
    }

    protected abstract Envelope createEnvelopeFromSource() throws SOAPException;

    protected SOAPPartImpl(MessageImpl message) {
        this.headers = new MimeHeaders();
        this.message = message;
        this.headers.setHeader("Content-Type", this.getContentType());
    }

    public SOAPDocumentImpl getDocument() {
        this.handleNewSource();
        return this.document;
    }

    protected SOAPPartImpl doCloneNode() {
        this.handleNewSource();
        SOAPPartImpl newSoapPart = this.duplicateType();
        newSoapPart.headers = MimeHeadersUtil.copy(this.headers);
        newSoapPart.source = this.source;
        return newSoapPart;
    }

    protected abstract SOAPPartImpl duplicateType();

    public SOAPPartImpl getSOAPPart() {
        return this;
    }

    public ByteInputStream getContentAsStream() throws IOException {
        if (this.source != null) {
            InputStream is = null;
            if (this.source instanceof StreamSource) {
                is = ((StreamSource)this.source).getInputStream();
            } else if (this.source instanceof FastInfosetSource) {
                is = ((FastInfosetSource)this.source).getInputStream();
            }
            if (is != null) {
                if (!(is instanceof ByteInputStream)) {
                    log.severe("SAAJ0546.soap.stream.incorrect.type");
                    throw new IOException("Internal error: stream not of the right type");
                }
                return (ByteInputStream)is;
            }
        }
        ByteOutputStream b = new ByteOutputStream();
        Envelope env = null;
        try {
            env = (Envelope)this.getEnvelope();
            env.output(b, this.isFastInfoset());
        }
        catch (SOAPException soapException) {
            log.severe("SAAJ0547.soap.cannot.externalize");
            throw new SOAPIOException("SOAP exception while trying to externalize: ", soapException);
        }
        return new ByteInputStream(b.getBytes(), b.getCount());
    }

    public String getBaseURI() {
        return this.document.getBaseURI();
    }

    protected abstract String getContentType();

    public String getDocumentURI() {
        throw new UnsupportedOperationException("getDocumentURI Not Supported");
    }

    public String getInputEncoding() {
        throw new UnsupportedOperationException("getInputEncoding Not Supported");
    }

    public String getLocalName() {
        return this.document.getLocalName();
    }

    public String getNamespaceURI() {
        return this.document.getNamespaceURI();
    }

    public String getNodeName() {
        return this.document.getNodeName();
    }

    public String getNodeValue() throws DOMException {
        return this.document.getNodeValue();
    }

    public String getPrefix() {
        return this.document.getPrefix();
    }

    public String getTextContent() throws DOMException {
        return this.document.getTextContent();
    }

    public String getValue() {
        return null;
    }

    public String getXmlEncoding() {
        throw new UnsupportedOperationException("getXmlEncoding Not Supported");
    }

    public String getXmlVersion() {
        throw new UnsupportedOperationException("getXmlVersion Not Supported");
    }

    public void removeMimeHeader(String header) {
        this.headers.removeHeader(header);
    }

    public void setDocumentURI(String documentURI) {
        throw new UnsupportedOperationException("setDocumentURI Not Supported");
    }

    public void setNodeValue(String arg0) throws DOMException {
        this.document.setNodeValue(arg0);
    }

    public void setPrefix(String arg0) throws DOMException {
        this.document.setPrefix(arg0);
    }

    public void setTextContent(String textContent) throws DOMException {
        this.document.setTextContent(textContent);
    }

    public void setValue(String value) {
        throw new IllegalStateException("Setting value of a soap part is not defined");
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
        throw new UnsupportedOperationException("setXmlVersion Not Supported");
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        return this.document.isDefaultNamespace(namespaceURI);
    }

    public Iterator getAllMimeHeaders() {
        return this.headers.getAllHeaders();
    }

    DataHandler getDataHandler() {
        DataSource ds = new DataSource(){

            public InputStream getInputStream() throws IOException {
                return SOAPPartImpl.this.getContentAsStream();
            }

            public OutputStream getOutputStream() throws IOException {
                throw new IOException("Illegal Operation");
            }

            public String getContentType() {
                return this.getContentType();
            }

            public String getName() {
                return SOAPPartImpl.this.getContentId();
            }
        };
        return new DataHandler(ds);
    }

    MimeBodyPart getMimePart() throws SOAPException {
        try {
            MimeBodyPart headerEnvelope = new MimeBodyPart();
            headerEnvelope.setDataHandler(this.getDataHandler());
            AttachmentPartImpl.copyMimeHeaders(this.headers, headerEnvelope);
            return headerEnvelope;
        }
        catch (SOAPException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.severe("SAAJ0548.soap.cannot.externalize.hdr");
            throw new SOAPExceptionImpl("Unable to externalize header", ex);
        }
    }

    MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    public SOAPElement getParentElement() {
        return null;
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        throw new SOAPExceptionImpl("The parent element of a soap part is not defined");
    }

    public SOAPEnvelope getEnvelope() throws SOAPException {
        if (this.sourceWasSet) {
            this.sourceWasSet = false;
        }
        this.lookForEnvelope();
        if (this.envelope != null) {
            if (this.source != null) {
                this.document.removeChild(this.envelope);
                this.envelope = this.createEnvelopeFromSource();
            }
            return this.envelope;
        }
        if (this.source != null) {
            this.envelope = this.createEnvelopeFromSource();
            this.source = null;
        } else {
            this.envelope = this.createEmptyEnvelope(null);
            this.document.insertBefore(this.envelope, null);
        }
        return this.envelope;
    }

    public Source getContent() throws SOAPException {
        if (this.source != null) {
            return this.source;
        }
        return ((Envelope)this.getEnvelope()).getContent();
    }

    /*
     * Unable to fully structure code
     */
    public void setContent(Source source) throws SOAPException {
        try {
            if (!(source instanceof StreamSource)) ** GOTO lbl13
            is = ((StreamSource)source).getInputStream();
            rdr = ((StreamSource)source).getReader();
            if (is != null) {
                this.source = new JAXMStreamSource(is);
            } else if (rdr != null) {
                this.source = new JAXMStreamSource(rdr);
            } else {
                SOAPPartImpl.log.severe("SAAJ0544.soap.no.valid.reader.for.src");
                throw new SOAPExceptionImpl("Source does not have a valid Reader or InputStream");
lbl13:
                // 1 sources

                if (source instanceof FastInfosetSource) {
                    fiSource = (FastInfosetSource)source;
                    is = fiSource.getInputStream();
                    if (!(is instanceof ByteInputStream)) {
                        bout = new ByteOutputStream();
                        temp = new byte[1024];
                        while ((len = is.read(temp)) != -1) {
                            bout.write(temp, 0, (int)var4_9);
                        }
                        fiSource.setInputStream((InputStream)new ByteInputStream(bout.getBytes(), bout.getCount()));
                    }
                    this.source = fiSource;
                } else {
                    this.source = source;
                }
            }
            this.sourceWasSet = true;
        }
        catch (Exception ex) {
            SOAPPartImpl.log.severe("SAAJ0545.soap.cannot.set.src.for.part");
            throw new SOAPExceptionImpl("Error setting the source for SOAPPart: " + ex.getMessage());
        }
    }

    public DOMConfiguration getDomConfig() {
        throw new UnsupportedOperationException("getDomConfig Not Supported");
    }

    public DOMImplementation getImplementation() {
        return this.document.getImplementation();
    }

    public Document getOwnerDocument() {
        return this.document.getOwnerDocument();
    }

    public DocumentFragment createDocumentFragment() {
        return this.document.createDocumentFragment();
    }

    public DocumentType getDoctype() {
        return this.document.getDoctype();
    }

    public Element getDocumentElement() {
        try {
            this.getEnvelope();
        }
        catch (SOAPException e) {}
        return this.document.getDocumentElement();
    }

    public NamedNodeMap getAttributes() {
        return this.document.getAttributes();
    }

    public Node getFirstChild() {
        this.handleNewSource();
        return this.document.getFirstChild();
    }

    public Node getLastChild() {
        this.handleNewSource();
        return this.document.getLastChild();
    }

    public Node getNextSibling() {
        this.handleNewSource();
        return this.document.getNextSibling();
    }

    public Node getParentNode() {
        return this.document.getParentNode();
    }

    public Node getPreviousSibling() {
        return this.document.getPreviousSibling();
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        return this.document.compareDocumentPosition(other);
    }

    public boolean isEqualNode(Node arg) {
        return this.document.isEqualNode(arg);
    }

    public boolean isSameNode(Node other) {
        return this.document.isSameNode(other);
    }

    public Node cloneNode(boolean deep) {
        this.handleNewSource();
        return this.document.cloneNode(deep);
    }

    public NodeList getChildNodes() {
        this.handleNewSource();
        return this.document.getChildNodes();
    }

    protected abstract Envelope createEmptyEnvelope(String var1) throws SOAPException;

    public Object getUserData(String key) {
        return this.document.getUserData(key);
    }

    public String lookupNamespaceURI(String prefix) {
        return this.document.lookupNamespaceURI(prefix);
    }

    public String lookupPrefix(String namespaceURI) {
        return this.document.lookupPrefix(namespaceURI);
    }

    public String[] getMimeHeader(String name) {
        return this.headers.getHeader(name);
    }

    public void addMimeHeader(String name, String value) {
        this.headers.addHeader(name, value);
    }

    public void setMimeHeader(String name, String value) {
        this.headers.setHeader(name, value);
    }

    public boolean isSupported(String arg0, String arg1) {
        return this.document.isSupported(arg0, arg1);
    }

    public Iterator getMatchingMimeHeaders(String[] names) {
        return this.headers.getMatchingHeaders(names);
    }

    public Iterator getNonMatchingMimeHeaders(String[] names) {
        return this.headers.getNonMatchingHeaders(names);
    }

    public Attr createAttribute(String name) throws DOMException {
        return this.document.createAttribute(name);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return this.document.createCDATASection(data);
    }

    public Comment createComment(String data) {
        return this.document.createComment(data);
    }

    public Element createElement(String tagName) throws DOMException {
        return this.document.createElement(tagName);
    }

    public Element getElementById(String elementId) {
        this.handleNewSource();
        return this.document.getElementById(elementId);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        return this.document.createEntityReference(name);
    }

    public Node adoptNode(Node source) throws DOMException {
        throw new UnsupportedOperationException("adoptNode Not Supported");
    }

    public Node appendChild(Node newChild) throws DOMException {
        this.handleNewSource();
        return this.document.appendChild(newChild);
    }

    public Node removeChild(Node arg0) throws DOMException {
        this.handleNewSource();
        return this.document.removeChild(arg0);
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        this.handleNewSource();
        return this.document.importNode(importedNode, deep);
    }

    public NodeList getElementsByTagName(String tagname) {
        this.handleNewSource();
        return this.document.getElementsByTagName(tagname);
    }

    public Text createTextNode(String data) {
        return this.document.createTextNode(data);
    }

    public Object getFeature(String feature, String version) {
        return this.document.getFeature(feature, version);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.createAttributeNS(namespaceURI, qualifiedName);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.createElementNS(namespaceURI, qualifiedName);
    }

    public Node insertBefore(Node arg0, Node arg1) throws DOMException {
        this.handleNewSource();
        return this.document.insertBefore(arg0, arg1);
    }

    public Node replaceChild(Node arg0, Node arg1) throws DOMException {
        this.handleNewSource();
        return this.document.replaceChild(arg0, arg1);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        this.handleNewSource();
        return this.document.getElementsByTagNameNS(namespaceURI, localName);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return this.document.createProcessingInstruction(target, data);
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.document.setUserData(key, data, handler);
    }

    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw new UnsupportedOperationException("renameNode Not Supported");
    }
}

