/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.util.RDN;

public final class DN
implements Serializable {
    private Vector m_rdns = new Vector();
    public static int RFC = 0;
    public static int OSF = 1;
    private int m_dnType = RFC;
    static final long serialVersionUID = -8867457218975952548L;
    public static final char[] ESCAPED_CHAR = new char[]{',', '+', '\"', '\\', '<', '>', ';'};

    public DN() {
    }

    public DN(String string) {
        String string2 = this.neutralizeEscapes(string);
        if (string2 == null) {
            return;
        }
        if (string2.indexOf(44) != -1 || string2.indexOf(59) != -1) {
            this.parseRDNs(string2, string, ",;");
        } else if (string.indexOf(47) != -1) {
            this.m_dnType = OSF;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            Vector<RDN> vector = new Vector<RDN>();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (RDN.isRDN(string3)) {
                    vector.addElement(new RDN(string3));
                    continue;
                }
                return;
            }
            for (int i = vector.size() - 1; i >= 0; --i) {
                this.m_rdns.addElement(vector.elementAt(i));
            }
        } else if (RDN.isRDN(string)) {
            this.m_rdns.addElement(new RDN(string));
        }
    }

    private String neutralizeEscapes(String string) {
        String string2 = RDN.neutralizeEscapes(string);
        if (string2 == null) {
            return null;
        }
        String string3 = string2.trim();
        if (string3.length() == 0) {
            return string2;
        }
        if (string3.charAt(0) == ';' || string3.charAt(0) == ',') {
            return null;
        }
        int n = string3.length() - 1;
        if (string3.charAt(n) == ';' || string3.charAt(n) == ',') {
            return null;
        }
        return string2;
    }

    private void parseRDNs(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        RDN rDN = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        while (stringTokenizer.hasMoreElements()) {
            String string4 = stringTokenizer.nextToken();
            n2 = n + string4.length();
            rDN = new RDN(string2.substring(n, n2));
            if (rDN.getTypes() == null) {
                this.m_rdns.removeAllElements();
                return;
            }
            this.m_rdns.addElement(rDN);
            n = n2 + 1;
        }
    }

    public void addRDNToFront(RDN rDN) {
        this.m_rdns.insertElementAt(rDN, 0);
    }

    public void addRDNToBack(RDN rDN) {
        this.m_rdns.addElement(rDN);
    }

    public void addRDN(RDN rDN) {
        if (this.m_dnType == RFC) {
            this.addRDNToFront(rDN);
        } else {
            this.addRDNToBack(rDN);
        }
    }

    public void setDNType(int n) {
        this.m_dnType = n;
    }

    public int getDNType() {
        return this.m_dnType;
    }

    public int countRDNs() {
        return this.m_rdns.size();
    }

    public Vector getRDNs() {
        return this.m_rdns;
    }

    public String[] explodeDN(boolean bl) {
        if (this.m_rdns.size() == 0) {
            return null;
        }
        String[] stringArray = new String[this.m_rdns.size()];
        for (int i = 0; i < this.m_rdns.size(); ++i) {
            stringArray[i] = bl ? ((RDN)this.m_rdns.elementAt(i)).getValue() : ((RDN)this.m_rdns.elementAt(i)).toString();
        }
        return stringArray;
    }

    public boolean isRFC() {
        return this.m_dnType == RFC;
    }

    public String toRFCString() {
        String string = "";
        for (int i = 0; i < this.m_rdns.size(); ++i) {
            if (i != 0) {
                string = string + ",";
            }
            string = string + ((RDN)this.m_rdns.elementAt(i)).toString();
        }
        return string;
    }

    public String toOSFString() {
        String string = "";
        for (int i = 0; i < this.m_rdns.size(); ++i) {
            if (i != 0) {
                string = "/" + string;
            }
            RDN rDN = (RDN)this.m_rdns.elementAt(i);
            string = rDN.toString() + string;
        }
        return string;
    }

    public String toString() {
        if (this.m_dnType == RFC) {
            return this.toRFCString();
        }
        return this.toOSFString();
    }

    public static boolean isDN(String string) {
        if (string.equals("")) {
            return true;
        }
        DN dN = new DN(string);
        return dN.countRDNs() > 0;
    }

    public boolean equals(DN dN) {
        return dN.toRFCString().toUpperCase().equals(this.toRFCString().toUpperCase());
    }

    public DN getParent() {
        DN dN = new DN();
        for (int i = this.m_rdns.size() - 1; i > 0; --i) {
            dN.addRDN((RDN)this.m_rdns.elementAt(i));
        }
        return dN;
    }

    public boolean contains(DN dN) {
        return this.isDescendantOf(dN);
    }

    public boolean isDescendantOf(DN dN) {
        int n;
        Vector vector = dN.m_rdns;
        Vector vector2 = this.m_rdns;
        int n2 = vector2.size() - 1;
        if (n2 < n || this.equals(dN)) {
            return false;
        }
        for (n = vector.size() - 1; n >= 0 && n2 >= 0; --n, --n2) {
            RDN rDN = (RDN)vector.elementAt(n);
            RDN rDN2 = (RDN)vector2.elementAt(n2);
            if (rDN2.equals(rDN)) continue;
            return false;
        }
        return true;
    }
}

