/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client;

import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.client.JDAPAVA;
import netscape.ldap.client.JDAPFilterAnd;
import netscape.ldap.client.JDAPFilterApproxMatch;
import netscape.ldap.client.JDAPFilterEqualityMatch;
import netscape.ldap.client.JDAPFilterExtensible;
import netscape.ldap.client.JDAPFilterGreaterOrEqual;
import netscape.ldap.client.JDAPFilterLessOrEqual;
import netscape.ldap.client.JDAPFilterNot;
import netscape.ldap.client.JDAPFilterOr;
import netscape.ldap.client.JDAPFilterPresent;
import netscape.ldap.client.JDAPFilterSubString;

public abstract class JDAPFilter {
    public static JDAPFilter getFilter(String string) {
        String string2 = new String(string);
        string2.trim();
        if (string2.startsWith("(") && string2.endsWith(")")) {
            return JDAPFilter.getFilterComp(string2.substring(1, string2.length() - 1));
        }
        return JDAPFilter.getFilterComp(string);
    }

    public static JDAPFilter getFilterComp(String string) {
        string.trim();
        if (string.startsWith("&")) {
            JDAPFilter[] jDAPFilterArray = JDAPFilter.getFilterList(string.substring(1, string.length()));
            if (jDAPFilterArray == null) {
                throw new IllegalArgumentException("Bad search filter");
            }
            JDAPFilterAnd jDAPFilterAnd = new JDAPFilterAnd();
            for (int i = 0; i < jDAPFilterArray.length; ++i) {
                jDAPFilterAnd.addElement(jDAPFilterArray[i]);
            }
            return jDAPFilterAnd;
        }
        if (string.startsWith("|")) {
            JDAPFilter[] jDAPFilterArray = JDAPFilter.getFilterList(string.substring(1, string.length()));
            if (jDAPFilterArray == null) {
                throw new IllegalArgumentException("Bad search filter");
            }
            JDAPFilterOr jDAPFilterOr = new JDAPFilterOr();
            for (int i = 0; i < jDAPFilterArray.length; ++i) {
                jDAPFilterOr.addElement(jDAPFilterArray[i]);
            }
            return jDAPFilterOr;
        }
        if (string.startsWith("!")) {
            JDAPFilter jDAPFilter = JDAPFilter.getFilter(string.substring(1, string.length()));
            if (jDAPFilter == null) {
                throw new IllegalArgumentException("Bad search filter");
            }
            return new JDAPFilterNot(jDAPFilter);
        }
        return JDAPFilter.getFilterItem(string.substring(0, string.length()));
    }

    public static JDAPFilter[] getFilterList(String string) {
        string.trim();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Vector<JDAPFilter> vector = new Vector<JDAPFilter>();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '(') {
                if (n == 0) {
                    n2 = i;
                }
                ++n;
            }
            if (string.charAt(i) != ')' || --n != 0) continue;
            n3 = i;
            vector.addElement(JDAPFilter.getFilter(string.substring(n2, n3 + 1)));
        }
        if (vector.size() == 0) {
            return null;
        }
        JDAPFilter[] jDAPFilterArray = new JDAPFilter[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            jDAPFilterArray[i] = (JDAPFilter)vector.elementAt(i);
        }
        return jDAPFilterArray;
    }

    public static JDAPFilter getFilterItem(String string) {
        string.trim();
        int n = string.indexOf(61);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        if (string2.indexOf(92) >= 0) {
            throw new IllegalArgumentException("Bad search filter");
        }
        string2.trim();
        if (string2.endsWith("~")) {
            JDAPAVA jDAPAVA = new JDAPAVA(string2.substring(0, string2.length() - 1), string3);
            return new JDAPFilterApproxMatch(jDAPAVA);
        }
        if (string2.endsWith(">")) {
            JDAPAVA jDAPAVA = new JDAPAVA(string2.substring(0, string2.length() - 1), string3);
            return new JDAPFilterGreaterOrEqual(jDAPAVA);
        }
        if (string2.endsWith("<")) {
            JDAPAVA jDAPAVA = new JDAPAVA(string2.substring(0, string2.length() - 1), string3);
            return new JDAPFilterLessOrEqual(jDAPAVA);
        }
        if (string2.endsWith(":")) {
            return new JDAPFilterExtensible(string2.substring(0, string2.length() - 1), string3);
        }
        if (string3.startsWith("*") && string3.length() == 1) {
            return new JDAPFilterPresent(string2);
        }
        if (string3.indexOf(42) == -1) {
            JDAPAVA jDAPAVA = new JDAPAVA(string2, string3);
            return new JDAPFilterEqualityMatch(jDAPAVA);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "*");
        JDAPFilterSubString jDAPFilterSubString = new JDAPFilterSubString(string2);
        String string4 = null;
        if (!string3.startsWith("*")) {
            string4 = stringTokenizer.nextToken();
            string4.trim();
        }
        jDAPFilterSubString.addInitial(string4);
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            string5.trim();
            if (stringTokenizer.hasMoreTokens()) {
                jDAPFilterSubString.addAny(string5);
                continue;
            }
            if (string3.endsWith("*")) {
                jDAPFilterSubString.addAny(string5);
                jDAPFilterSubString.addFinal(null);
                continue;
            }
            jDAPFilterSubString.addFinal(string5);
        }
        return jDAPFilterSubString;
    }

    public abstract BERElement getBERElement();

    public abstract String toString();
}

