/*
 * Decompiled with CFR 0.152.
 */
package org.drools.visualize;

import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.VertexFontFunction;
import edu.uci.ics.jung.graph.decorators.VertexPaintFunction;
import edu.uci.ics.jung.graph.decorators.VertexShapeFunction;
import edu.uci.ics.jung.graph.decorators.VertexStringer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import org.drools.visualize.VertexColorSet;
import org.drools.visualize.VertexLabelPaintFunction;

public class VertexFunctions
implements VertexStringer,
VertexFontFunction,
VertexShapeFunction,
VertexPaintFunction,
VertexLabelPaintFunction {
    private VertexColorSet defaultColors;
    private Graphics graphics;
    private Font font;

    public VertexFunctions() {
        BufferedImage bufferedImage = new BufferedImage(100, 100, 1);
        this.graphics = bufferedImage.createGraphics();
        this.defaultColors = new VertexColorSet();
        this.font = new Font("Verdana", 1, 10);
    }

    public void setDefaultColors(Color color, Color color2, Color color3) {
        this.defaultColors = new VertexColorSet(color, color2, color3);
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Paint getLabelDrawPaint(Vertex vertex) {
        return this.defaultColors.getText();
    }

    public Font getFont(Vertex vertex) {
        return this.font;
    }

    public Shape getShape(Vertex vertex) {
        Dimension dimension = this.getShapeDimension(vertex);
        return new RoundRectangle2D.Double(0 - dimension.width / 2, 0 - dimension.height / 2, dimension.width, dimension.height, 10.0, 10.0);
    }

    public Dimension getShapeDimension(Vertex vertex) {
        String string = this.getLabel((ArchetypeVertex)vertex);
        Font font = this.getFont(vertex);
        FontMetrics fontMetrics = this.graphics.getFontMetrics(this.getFont(vertex));
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        return new Dimension(n += font.getSize(), n2 += font.getSize());
    }

    public Paint getFillPaint(Vertex vertex) {
        return this.defaultColors.getFill();
    }

    public Paint getDrawPaint(Vertex vertex) {
        return this.defaultColors.getStroke();
    }

    public String getLabel(ArchetypeVertex archetypeVertex) {
        return "node";
    }
}

