/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.query;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.juddi.query.BusinessEntityQuery;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.query.util.FindQualifiers;
import org.apache.log4j.Logger;
import org.uddi.api_v3.DiscoveryURL;
import org.uddi.api_v3.DiscoveryURLs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBusinessByDiscoveryURLQuery
extends BusinessEntityQuery {
    private static Logger log = Logger.getLogger(FindBusinessByDiscoveryURLQuery.class);
    private static final String ENTITY_NAME_CHILD = "DiscoveryUrl";
    private static String entityAliasChild = FindBusinessByDiscoveryURLQuery.buildAlias("DiscoveryUrl");

    public static List<?> select(EntityManager em, FindQualifiers fq, DiscoveryURLs discURLs, List<?> keysIn, DynamicQuery.Parameter ... restrictions) {
        if (keysIn != null && keysIn.size() == 0) {
            return keysIn;
        }
        if (discURLs == null) {
            return keysIn;
        }
        List discURLlist = discURLs.getDiscoveryURL();
        if (discURLlist == null || discURLlist.size() == 0) {
            return keysIn;
        }
        DynamicQuery dynamicQry = new DynamicQuery(selectSQL);
        FindBusinessByDiscoveryURLQuery.appendConditions(dynamicQry, fq, discURLlist);
        if (restrictions != null && restrictions.length > 0) {
            dynamicQry.AND().pad().appendGroupedAnd(restrictions);
        }
        return FindBusinessByDiscoveryURLQuery.getQueryResult(em, dynamicQry, keysIn, "be.entityKey");
    }

    public static void appendConditions(DynamicQuery qry, FindQualifiers fq, List<DiscoveryURL> discURLs) {
        FindBusinessByDiscoveryURLQuery.appendJoinTables(qry, fq, discURLs);
        qry.AND().pad().openParen().pad();
        int count = 0;
        for (DiscoveryURL discURL : discURLs) {
            String urlTerm = entityAliasChild + ".url";
            String urlValue = discURL.getValue();
            if (discURL.getUseType() == null || discURL.getUseType().length() == 0) {
                qry.appendGroupedAnd(new DynamicQuery.Parameter(urlTerm, urlValue, DynamicQuery.PREDICATE_EQUALS));
            } else {
                qry.appendGroupedAnd(new DynamicQuery.Parameter(urlTerm, urlValue, DynamicQuery.PREDICATE_EQUALS), new DynamicQuery.Parameter(entityAliasChild + ".useType", discURL.getUseType(), DynamicQuery.PREDICATE_EQUALS));
            }
            if (count + 1 < discURLs.size()) {
                qry.OR().pad();
            }
            ++count;
        }
        qry.closeParen().pad();
    }

    public static void appendJoinTables(DynamicQuery qry, FindQualifiers fq, List<DiscoveryURL> discURLs) {
        qry.comma().pad().append("DiscoveryUrl " + entityAliasChild).pad();
        qry.WHERE().pad().openParen().pad();
        qry.append("be.entityKey = " + entityAliasChild + "." + "businessEntity" + "." + "entityKey" + " ");
        qry.closeParen().pad();
    }
}

