/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.model;

import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Query;
import javax.persistence.Transient;
import org.apache.juddi.model.UddiEntity;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.validation.ValidateUDDIKey;
import org.uddi.v3_service.DispositionReportFaultMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MappedSuperclass
public class UddiEntityPublisher {
    protected String authorizedName;
    private List<String> keyGeneratorKeys = null;

    public UddiEntityPublisher() {
    }

    public UddiEntityPublisher(String authorizedName) {
        this.authorizedName = authorizedName;
    }

    @Id
    @Column(name="authorized_name", nullable=false, length=255)
    public String getAuthorizedName() {
        return this.authorizedName;
    }

    public void setAuthorizedName(String authorizedName) {
        this.authorizedName = authorizedName;
    }

    @Transient
    public List<String> getKeyGeneratorKeys() {
        return this.keyGeneratorKeys;
    }

    public void setKeyGeneratorKeys(List<String> keyGeneratorKeys) {
        this.keyGeneratorKeys = keyGeneratorKeys;
    }

    public void populateKeyGeneratorKeys(EntityManager em) {
        DynamicQuery getKeysQuery = new DynamicQuery();
        getKeysQuery.append("select t.entityKey from Tmodel t").pad().WHERE().pad();
        DynamicQuery.Parameter pubParam = new DynamicQuery.Parameter("t.authorizedName", this.getAuthorizedName(), DynamicQuery.PREDICATE_EQUALS);
        DynamicQuery.Parameter keyParam = new DynamicQuery.Parameter("UPPER(t.entityKey)", (DynamicQuery.WILDCARD + "keygenerator").toUpperCase(), DynamicQuery.PREDICATE_LIKE);
        getKeysQuery.appendGroupedAnd(pubParam, keyParam);
        Query qry = getKeysQuery.buildJPAQuery(em);
        this.keyGeneratorKeys = qry.getResultList();
    }

    public boolean isOwner(UddiEntity entity) {
        boolean ret = false;
        if (entity != null && entity.getAuthorizedName().equals(this.getAuthorizedName())) {
            ret = true;
        }
        return ret;
    }

    public boolean isValidPublisherKey(EntityManager em, String key) {
        if (key == null) {
            return false;
        }
        if (this.keyGeneratorKeys == null) {
            this.populateKeyGeneratorKeys(em);
        }
        String keyPartition = key.substring(0, key.lastIndexOf(":"));
        for (String keyGenKey : this.keyGeneratorKeys) {
            String keyGenPartition = keyGenKey.substring(0, keyGenKey.lastIndexOf(":"));
            if (!keyGenPartition.equalsIgnoreCase(keyPartition)) continue;
            return true;
        }
        return false;
    }

    public boolean isKeyGeneratorAvailable(EntityManager em, String keygenKey) throws DispositionReportFaultMessage {
        ValidateUDDIKey.validateUDDIv3KeyGeneratorKey(keygenKey);
        String partition = keygenKey.toUpperCase().substring(0, keygenKey.lastIndexOf(":"));
        StringTokenizer tokenizer = new StringTokenizer(partition, ":");
        int tokenCount = tokenizer.countTokens();
        if (tokenCount < 2) {
            return false;
        }
        String domainPartition = (String)tokenizer.nextElement() + ":" + (String)tokenizer.nextElement();
        if (tokenCount > 2) {
            Vector<DynamicQuery.Parameter> params = new Vector<DynamicQuery.Parameter>(0);
            DynamicQuery.Parameter pubParam = new DynamicQuery.Parameter("t.authorizedName", this.getAuthorizedName(), DynamicQuery.PREDICATE_EQUALS);
            int requiredCount = 0;
            params.add(new DynamicQuery.Parameter("UPPER(t.entityKey)", (domainPartition + ":" + "keygenerator").toUpperCase(), DynamicQuery.PREDICATE_EQUALS));
            ++requiredCount;
            String subPartition = domainPartition;
            while (tokenizer.hasMoreElements() && tokenizer.countTokens() != 1) {
                String nextToken = (String)tokenizer.nextElement();
                subPartition = subPartition + ":" + nextToken;
                DynamicQuery.Parameter param = new DynamicQuery.Parameter("UPPER(t.entityKey)", (subPartition + ":" + "keygenerator").toUpperCase(), DynamicQuery.PREDICATE_EQUALS);
                params.add(param);
                ++requiredCount;
            }
            DynamicQuery checkParentKeyQry = new DynamicQuery();
            checkParentKeyQry.append("select COUNT(t.entityKey) from Tmodel t").pad();
            checkParentKeyQry.WHERE().pad().appendGroupedAnd(pubParam);
            checkParentKeyQry.AND().pad().appendGroupedOr(params.toArray(new DynamicQuery.Parameter[0]));
            Query qry = checkParentKeyQry.buildJPAQuery(em);
            Number resultCount = (Number)qry.getSingleResult();
            if (resultCount.longValue() != (long)requiredCount) {
                return false;
            }
        } else {
            DynamicQuery.Parameter notPubParam = new DynamicQuery.Parameter("t.authorizedName", this.getAuthorizedName(), DynamicQuery.PREDICATE_NOTEQUALS);
            DynamicQuery.Parameter keyParam = new DynamicQuery.Parameter("UPPER(t.entityKey)", (domainPartition + ":" + "keygenerator").toUpperCase(), DynamicQuery.PREDICATE_EQUALS);
            DynamicQuery checkDomainKeyQry = new DynamicQuery();
            checkDomainKeyQry.append("select t.entityKey from Tmodel t").pad();
            checkDomainKeyQry.WHERE().pad().appendGroupedAnd(notPubParam, keyParam);
            Query qry = checkDomainKeyQry.buildJPAQuery(em);
            List obj = qry.getResultList();
            if (obj != null && obj.size() > 0) {
                return false;
            }
        }
        return true;
    }
}

