/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.juddi.model.SubscriptionMatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="j3_subscription")
public class Subscription
implements Serializable,
Comparable<Subscription> {
    private static final long serialVersionUID = -2271361594186854662L;
    private String subscriptionKey;
    private String authorizedName;
    private String subscriptionFilter;
    private String bindingKey;
    private String notificationInterval;
    private Integer maxEntities;
    private Date expiresAfter;
    private Boolean brief;
    private Date lastNotified;
    private Date createDate;
    private List<SubscriptionMatch> subscriptionMatches = new ArrayList<SubscriptionMatch>(0);

    public Subscription() {
    }

    public Subscription(String subscriptionKey, String bindingKey, String notificationInterval) {
        this.subscriptionKey = subscriptionKey;
        this.bindingKey = bindingKey;
        this.notificationInterval = notificationInterval;
    }

    @Id
    @Column(name="subscription_key", nullable=false, length=255)
    public String getSubscriptionKey() {
        return this.subscriptionKey;
    }

    public void setSubscriptionKey(String subscriptionKey) {
        this.subscriptionKey = subscriptionKey;
    }

    @Column(name="authorized_name", nullable=false, length=255)
    public String getAuthorizedName() {
        return this.authorizedName;
    }

    public void setAuthorizedName(String authorizedName) {
        this.authorizedName = authorizedName;
    }

    @Lob
    @Column(name="subscription_filter", nullable=false, length=65636)
    public String getSubscriptionFilter() {
        return this.subscriptionFilter;
    }

    public void setSubscriptionFilter(String subscriptionFilter) {
        this.subscriptionFilter = subscriptionFilter;
    }

    @Column(name="binding_key", length=255)
    public String getBindingKey() {
        return this.bindingKey;
    }

    public void setBindingKey(String bindingKey) {
        this.bindingKey = bindingKey;
    }

    @Column(name="notification_interval")
    public String getNotificationInterval() {
        return this.notificationInterval;
    }

    public void setNotificationInterval(String notificationInterval) {
        this.notificationInterval = notificationInterval;
    }

    @Column(name="max_entities")
    public Integer getMaxEntities() {
        return this.maxEntities;
    }

    public void setMaxEntities(Integer maxEntities) {
        this.maxEntities = maxEntities;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="expires_after", length=29)
    public Date getExpiresAfter() {
        return this.expiresAfter;
    }

    public void setExpiresAfter(Date expiresAfter) {
        this.expiresAfter = expiresAfter;
    }

    @Column(name="brief")
    public Boolean isBrief() {
        return this.brief;
    }

    public void setBrief(Boolean brief) {
        this.brief = brief;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="subscription")
    public List<SubscriptionMatch> getSubscriptionMatches() {
        return this.subscriptionMatches;
    }

    public void setSubscriptionMatches(List<SubscriptionMatch> subscriptionMatches) {
        this.subscriptionMatches = subscriptionMatches;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_notified", length=29)
    public Date getLastNotified() {
        return this.lastNotified;
    }

    public void setLastNotified(Date lastNotified) {
        this.lastNotified = lastNotified;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="create_date", length=29, nullable=false)
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @Override
    public int compareTo(Subscription o) {
        if (o == null || o.getSubscriptionKey() == null) {
            return 0;
        }
        if (o.getSubscriptionKey().equals(this.subscriptionKey)) {
            return 1;
        }
        return 0;
    }
}

